/*
 * Decompiled with CFR 0.152.
 */
package javasoft.sqe.javatest.lib;

import com.sun.javatest.JavaTestError;
import com.sun.javatest.Script;
import com.sun.javatest.Status;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestResult;
import com.sun.javatest.util.StringArray;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class KeywordScript
extends Script {
    private static boolean debug = false;

    public void run() {
        String s;
        String envName;
        PrintWriter trOut = this.getTestResult().getTestCommentWriter();
        TestDescription td = this.getTestDescription();
        for (int i = 0; i < this.scriptArgs.length; ++i) {
            if (!this.scriptArgs[i].equals("-debug")) {
                this.setStatus(Status.error("bad args for script: " + this.scriptArgs[i]));
                return;
            }
            debug = true;
        }
        String prefix = "script.";
        Set testKeys = td.getKeywordTable();
        Vector<String> choices = new Vector<String>();
        Vector<String> matches = new Vector<String>();
        int wordsMatchingInMatches = 0;
        Iterator iter = this.env.keys().iterator();
        block7: while (iter.hasNext()) {
            String key = (String)iter.next();
            if (!key.startsWith(prefix)) continue;
            if (debug) {
                trOut.println("CHECKING " + key);
            }
            String keyList = key.substring(prefix.length()).replace('_', ' ').toLowerCase();
            String[] keys = StringArray.split(keyList);
            choices.addElement(keyList);
            if (debug) {
                trOut.println("keys: " + StringArray.join(keys));
            }
            if (keys == null || keys.length < wordsMatchingInMatches) continue;
            for (int i = 0; i < keys.length; ++i) {
                if (testKeys.contains(keys[i])) continue;
                if (!debug) continue block7;
                trOut.println("discarding, because of " + keys[i]);
                continue block7;
            }
            if (keys.length > wordsMatchingInMatches) {
                if (debug) {
                    trOut.println("new best match, " + keys.length + " keys");
                }
                matches = new Vector();
                wordsMatchingInMatches = keys.length;
            }
            matches.addElement(key);
        }
        String name = this.env.getName();
        String string = envName = name.length() == 0 ? "The anonymous environment" : "Environment `" + this.env.getName() + "'";
        if (matches.size() == 0) {
            if (choices.size() == 0) {
                s = envName + " has no `script' entries";
                trOut.println(s);
                this.setStatus(Status.error(s));
                return;
            }
            s = envName + " has no suitable `script' entry";
            trOut.println(s);
            trOut.println("The keyword combinations for scripts in this environment are: ");
            for (int i = 0; i < choices.size(); ++i) {
                trOut.println((String)choices.elementAt(i));
            }
            this.setStatus(Status.error(s));
            return;
        }
        if (matches.size() > 1) {
            s = envName + " has ambiguous `script' entries";
            trOut.println(s);
            for (int i = 0; i < matches.size(); ++i) {
                trOut.println(i + ": " + matches.elementAt(i));
            }
            this.setStatus(Status.error(s));
            return;
        }
        String bestScript = (String)matches.elementAt(0);
        try {
            String[] command = this.env.lookup(bestScript);
            if (command.length == 0) {
                String s2 = "INTERNAL ERROR: failed to lookup key: " + bestScript;
                trOut.println(s2);
                this.setStatus(Status.error(s2));
                return;
            }
            trOut.println("test: " + td.getRootRelativeURL());
            trOut.println("script: " + this.getClass().getName() + " " + StringArray.join(this.scriptArgs));
            String[] msgs = new String[]{"Based on these keywords:    " + bestScript.substring(prefix.length()).replace('_', ' ').toLowerCase(), "this script has now been selected:    " + StringArray.join(command)};
            KeywordScript.printStrArr(trOut, msgs);
            try {
                Class<?> c = Class.forName(command[0]);
                Script script = (Script)c.newInstance();
                String[] scriptArgs = new String[command.length - 1];
                System.arraycopy(command, 1, scriptArgs, 0, scriptArgs.length);
                this.initDelegate(script, scriptArgs);
                script.run();
            }
            catch (ClassNotFoundException ex) {
                this.setStatus(Status.error("Can't find class `" + command[0] + "' for `" + this.env.getName() + "'"));
            }
            catch (IllegalAccessException ex) {
                this.setStatus(Status.error("Illegal access to class `" + command[0] + "' for `" + this.env.getName() + "'"));
            }
            catch (InstantiationException ex) {
                this.setStatus(Status.error("Can't instantiate class`" + command[0] + "' for `" + this.env.getName() + "'"));
            }
        }
        catch (TestEnvironment.Fault ex) {
            this.setStatus(Status.error("environment `" + this.env.getName() + "' has bad `script' entry for `" + bestScript + "'"));
        }
    }

    public Status run(String[] args, TestDescription td, TestEnvironment env) {
        throw new Error("Method not applicable.");
    }

    private static void printStrArr(PrintWriter pw, String[] data) {
        if (data == null) {
            return;
        }
        for (int i = 0; i < data.length; ++i) {
            pw.println(data[i]);
        }
    }

    private void setStatus(Status s) {
        TestResult tr = this.getTestResult();
        tr.setEnvironment(this.env);
        tr.setStatus(s);
        try {
            tr.writeResults(this.workDir, this.backupPolicy);
        }
        catch (IOException e) {
            if (debug) {
                e.printStackTrace();
            }
            throw new JavaTestError("Unable to write test result to " + this.workDir.getPath());
        }
    }
}

