/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.lib.scriptgen;

import com.sun.javatest.Status;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.util.StringArray;
import com.sun.jck.lib.IntermediateScript;
import com.sun.jck.lib.scriptgen.ScriptModel;
import com.sun.jck.lib.scriptgen.ShellModel;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptGen {
    protected static String scriptOutputDir = null;
    protected static boolean optimizedMode = false;
    protected int product = 0;
    protected static ResourceBundle adjustedContext;
    protected static Properties adjustedEnv;
    protected static List<String> depsOnWorkDir;
    protected Properties pathToTools;
    protected static String workDirPath;
    protected static final String RELATIVE_DIR = "relativeDir";
    protected static final String RELATIVE_URL = "relativeURL";
    private TestDescription td = null;
    private TestEnvironment env = null;
    protected Properties testContext;
    private Status status = null;
    private boolean isNegative = false;
    private boolean runJTScript = false;
    private boolean supportedTestType = false;
    private ScriptModel model = null;
    private File scriptDir = null;

    public void start(String[] stringArray, TestDescription testDescription, TestEnvironment testEnvironment) {
        String string;
        Object object;
        this.td = testDescription;
        this.env = testEnvironment;
        this.pathToTools = this.findPaths(testEnvironment);
        this.isNegative = testDescription.getKeywordTable().contains("negative");
        this.testContext = this.initTestContext();
        this.checkTestType();
        String string2 = null;
        if (this.isSupportedTestType()) {
            try {
                object = testEnvironment.lookup("testSuiteRootDir");
                string2 = object[0];
                string = scriptOutputDir != null ? scriptOutputDir : string2;
                this.scriptDir = new File(string + File.separator + "tests", testDescription.getRootRelativeFile().getParentFile().getPath());
            }
            catch (TestEnvironment.Fault fault) {
                fault.printStackTrace();
            }
            object = testDescription.getRootRelativeFile().getPath();
            if (testDescription.getId() != null) {
                object = (String)object + "#" + testDescription.getId();
            }
        } else {
            Status status = this.isNegative ? Status.failed("skipped") : Status.passed("skipped");
            throw new IntermediateScript.SkipTestException(status);
        }
        this.model = this.createModel();
        this.model.setTCKRootDir(string2);
        this.model.setNegative(this.isNegative);
        this.model.setOptimizationMode(optimizedMode);
        this.model.setTestURL((String)object);
        this.model.setPathToTools(this.pathToTools);
        this.model.setContext(this.testContext);
        this.model.setProduct(this.product);
        this.model.setToolsJarRequired(this.detectToolsJar());
        string = "Generated: " + testDescription.getName() + this.model.extention();
        this.status = this.isNegative ? Status.failed(string + " negative") : Status.passed(string + " positive");
        this.adjustTestEnv();
    }

    public void finish(String[] stringArray, TestDescription testDescription, TestEnvironment testEnvironment) {
        if (this.isSupportedTestType()) {
            this.outputScript(testDescription.getName() + this.model.extention());
        }
    }

    public void setWorkDirPath(String string) {
        workDirPath = string;
    }

    protected void outputScript(String string) {
        try {
            if (!this.scriptDir.exists() && !this.scriptDir.mkdirs()) {
                throw new IOException("cannot create dir: " + this.scriptDir);
            }
            File file = new File(this.scriptDir, string);
            PrintStream printStream = new PrintStream(new FileOutputStream(file));
            printStream.print(this.model.getContent());
            printStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected ScriptModel createModel() {
        return new ShellModel();
    }

    private static ResourceBundle initBundle(String string) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(string);
        return resourceBundle;
    }

    private void adjustTestEnv() {
        String string = this.td.getParameter("selectIf");
        for (String string2 : this.testContext.stringPropertyNames()) {
            if (string != null && string.indexOf(string2) >= 0) continue;
            this.env.put(string2, "{{" + string2 + "}}");
        }
        for (String string2 : adjustedEnv.stringPropertyNames()) {
            this.env.put(string2, "{{" + string2 + "}}");
        }
    }

    private Properties initTestContext() {
        String[] stringArray = StringArray.split(this.td.getParameter("context"));
        Properties properties = new Properties();
        if (stringArray != null) {
            String[] stringArray2 = stringArray;
            int n = stringArray2.length;
            for (int i = 0; i < n; ++i) {
                String string;
                String string2 = string = stringArray2[i];
                if (adjustedContext.containsKey(string)) {
                    string2 = adjustedContext.getString(string);
                } else {
                    try {
                        String[] stringArray3 = this.env.lookup(string);
                        if (stringArray3 != null && stringArray3.length == 1) {
                            string2 = stringArray3[0];
                        } else {
                            System.err.println("Bad context value: " + string);
                            string2 = string;
                        }
                    }
                    catch (TestEnvironment.Fault fault) {
                        fault.printStackTrace();
                        System.err.println("Bad context value: " + string + ": " + fault);
                        string2 = string;
                    }
                }
                properties.setProperty(string, string2);
            }
        }
        return properties;
    }

    protected void checkTestType() {
        if (this.td.getParameter("remote") == null) {
            this.supportedTestType = true;
        }
    }

    protected boolean isSupportedTestType() {
        return this.supportedTestType;
    }

    protected boolean detectToolsJar() {
        Set set = this.td.getKeywordTable();
        return set.contains("jvmtilivephase") || set.contains("jplislivephase");
    }

    public static List<String> asList(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray) {
            arrayList.add(string);
        }
        return arrayList;
    }

    public static String merge(ArrayList<String> arrayList, String string) {
        if (arrayList == null) {
            return null;
        }
        if (arrayList.size() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (String string2 : arrayList) {
            stringBuffer.append(string2);
            stringBuffer.append(string);
        }
        String string3 = stringBuffer.toString();
        return string3.substring(0, string3.length() - string.length());
    }

    public static String convertScriptName(String string) {
        return string.replaceAll("\\(", "_").replaceAll("\\)", "_");
    }

    public Status invokeCommand(String string) {
        try {
            String[] stringArray = this.env.lookup("command." + string);
            this.model.invokeCommand(stringArray);
        }
        catch (TestEnvironment.Fault fault) {
            this.runJTScript = false;
            fault.printStackTrace();
            return Status.error("NOT FOUND: command." + string);
        }
        this.runJTScript = false;
        return this.status;
    }

    public boolean mkdirs(File file) {
        this.model.mkdirs(file);
        return true;
    }

    public String filesInDir(File file, String string, String string2, boolean bl) {
        this.model.filesInDir(file, string, string2, bl);
        return "{{LST}}";
    }

    public boolean runJTScript() {
        return this.runJTScript;
    }

    private static Properties initAdjustedEnv() {
        Properties properties = new Properties();
        properties.setProperty("annoProcPrecompileClassDir", "{{testWorkDir}}/anno");
        properties.setProperty("precompileClassDir", "{{tck.home}}/classes");
        properties.setProperty("testWorkDir", "{{testWorkDir}}");
        properties.setProperty("testWorkDirURL", "file://{{testWorkDir}}/");
        properties.setProperty("testSuiteRootDir", "{{tck.home}}");
        properties.setProperty("testSuiteRootURL", "file://{{tck.home}}/");
        properties.setProperty("testURL", "file:///{{tck.home}}/tests/{{relativeURL}}");
        properties.setProperty("testDir", "{{tck.home}}/{{relativeDir}}");
        properties.setProperty("javatestClassDir", "{{tck.home}}/lib/javatest.jar");
        properties.setProperty("LST", "{{LST}}");
        return properties;
    }

    private static List<String> getDepsOnWorkDir() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : adjustedEnv.stringPropertyNames()) {
            String string2 = adjustedEnv.getProperty(string);
            if (string2.indexOf("{{testWorkDir}}") < 0) continue;
            arrayList.add("{{" + string + "}}");
        }
        return arrayList;
    }

    private Properties findPaths(TestEnvironment testEnvironment) {
        Properties properties = new Properties();
        if (!optimizedMode) {
            return properties;
        }
        properties.setProperty("/bin/ksh", "shell");
        properties.setProperty("{{shell}}", "shell");
        for (Object e : testEnvironment.keys()) {
            String string = (String)e;
            if (!string.startsWith("pathTo.")) continue;
            try {
                String string2 = testEnvironment.lookup(string)[0];
                properties.setProperty(string2, string.substring("pathTo.".length()));
                properties.setProperty("{{" + string2 + "}}", string2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return properties;
    }

    private static void init() {
        scriptOutputDir = System.getProperty("scriptgen.output");
        optimizedMode = false;
        String string = System.getProperty("scriptgen.optmode");
        if (string != null && ((string = string.trim().toLowerCase()).equals("true") || string.equals("on") || string.equals("yes"))) {
            optimizedMode = true;
        }
    }

    public void setProduct(int n) {
        this.product = n;
    }

    public int getProduct() {
        return this.product;
    }

    static {
        ScriptGen.init();
        adjustedContext = ScriptGen.initBundle("com.sun.jck.lib.scriptgen.context");
        adjustedEnv = ScriptGen.initAdjustedEnv();
        depsOnWorkDir = ScriptGen.getDepsOnWorkDir();
        workDirPath = null;
    }
}

