/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.lib.multijvm.group;

import com.sun.javatest.Status;
import com.sun.javatest.agent.AgentManager;
import com.sun.javatest.agent.Connection;
import com.sun.jck.lib.JCovRemoteSupport;
import com.sun.jck.lib.multijvm.group.ExecCmd;
import com.sun.jck.lib.multijvm.group.TaskManager;
import com.sun.jck.lib.multijvm.group.util.ArgMap;
import com.sun.jck.lib.multijvm.group.util.StreamsCopier;
import com.sun.jck.lib.multijvm.group.util.Util;
import com.sun.jck.lib.multijvm.group.wrapper.ActiveMain;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentTask
implements Runnable,
Comparable<AgentTask>,
Util.ArgHandler,
Closeable {
    protected volatile Connection connection;
    protected final String id;
    private volatile int testCount;
    protected volatile boolean closed = false;
    private TaskManager manager;
    private File execDir = null;
    private Map<String, String> cmdEnv;
    private List<String> cmd;
    private List<String> agentArgs;
    private long testTimeout = 60000L;
    private boolean closeIfFail = false;
    private boolean keepIfError = false;
    private int groupSize = 100;
    private StreamsCopier copier;
    private final CountDownLatch processStarted = new CountDownLatch(1);
    private volatile Thread waitThread;
    protected volatile Process process;
    private volatile Throwable exception;
    protected volatile ScheduledFuture closeFuture;
    private final Semaphore connectionSync = new Semaphore(0);
    private final List<String> key;
    private int rc = -1;
    private String tag;
    private JCovRemoteSupport jcovSupport;

    public AgentTask(TaskManager taskManager, List<String> list) {
        ArgMap argMap = new ArgMap(list, (Enum[])new ExecCmd.Key[]{ExecCmd.Key.AGENT, ExecCmd.Key.ENV, ExecCmd.Key.CMD});
        Util.decodeAllArgs(argMap.getUnmapped(), this);
        this.agentArgs = argMap.get(ExecCmd.Key.AGENT);
        this.cmdEnv = Util.parseVariables(argMap.get(ExecCmd.Key.ENV));
        this.cmd = argMap.get(ExecCmd.Key.CMD);
        this.manager = taskManager;
        this.id = taskManager.generarateUID();
        this.key = list;
    }

    public String getId() {
        return this.id;
    }

    public void scheduleClose() {
        this.closeFuture = Util.scheduleClose(this, this.manager.getTimeout());
    }

    private void adjustEnviroment(Map<String, String> map) {
        for (String string : map.keySet()) {
            if (!"SystemRoot".equalsIgnoreCase(string) && !"SystemDrive".equalsIgnoreCase(string) && !"windir".equalsIgnoreCase(string) || this.containsVarIgnoreCase(string)) continue;
            this.cmdEnv.put(string, map.get(string));
        }
        map.clear();
        map.putAll(this.cmdEnv);
    }

    private boolean containsVarIgnoreCase(String string) {
        if (this.cmdEnv != null) {
            for (String string2 : this.cmdEnv.keySet()) {
                if (!string2.equalsIgnoreCase(string)) continue;
                return true;
            }
        }
        return false;
    }

    private void log(String string) {
        if (this.manager.isDebug()) {
            Util.printLog(this, string);
        }
    }

    public void setConnection(Connection connection) throws InterruptedException {
        this.log("got conneciton");
        this.connection = connection;
        this.connectionSync.release();
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.manager.removeAgent(this);
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.process != null) {
                if (this.jcovSupport != null) {
                    if (this.manager.isDebug()) {
                        this.copier.connectTo(new PrintWriter(System.out), new PrintWriter(System.err));
                    }
                    this.log("sending save command to JCov");
                    this.jcovSupport.sendSaveAndExitCommands(this.manager.getHost());
                }
                this.process.destroy();
                this.log("process destroyed");
            }
            this.log("closed");
        }
    }

    public Status runTest(List<String> list, PrintWriter printWriter, PrintWriter printWriter2) throws IOException {
        this.log("run test");
        AgentManager.Task task = AgentManager.access().connect(this.connection);
        String string = list.get(0);
        String[] stringArray = list.subList(1, list.size()).toArray(new String[0]);
        this.copier.connectTo(printWriter, printWriter2);
        printWriter2.println("MultiJVM group agent ID: " + this.id);
        Status status = task.executeCommand(string, string, stringArray, true, printWriter, printWriter2);
        ++this.testCount;
        this.copier.disconnect();
        this.log("test done: " + status);
        return status;
    }

    public void cancelClose() {
        Util.cancelClose(this.closeFuture);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean waitForConnection(long l) throws Throwable {
        this.waitThread = Thread.currentThread();
        try {
            boolean bl = this.connectionSync.tryAcquire(l, TimeUnit.MILLISECONDS);
            return bl;
        }
        catch (InterruptedException interruptedException) {
            if (this.exception != null) {
                throw this.exception;
            }
            throw interruptedException;
        }
        finally {
            this.waitThread = null;
        }
    }

    public void start(PrintWriter printWriter, PrintWriter printWriter2) throws Throwable {
        this.log("start");
        this.manager.addAgent(this);
        this.copier = new StreamsCopier(printWriter, printWriter2);
        this.manager.getExecutor().execute(this);
        this.processStarted.await();
        if (this.exception != null) {
            throw this.exception;
        }
    }

    @Override
    public int compareTo(AgentTask agentTask) {
        return this.testCount - agentTask.testCount;
    }

    @Override
    public int decodeArg(List<String> list, int n) {
        if ("-groupSize".equals(list.get(n))) {
            this.groupSize = Integer.parseInt(list.get(++n));
            return 2;
        }
        if ("-testTimeout".equals(list.get(n))) {
            float f = Float.parseFloat(list.get(++n));
            this.testTimeout = Math.round(f * 1000.0f);
            return 2;
        }
        if ("-keepIfError".equals(list.get(n))) {
            this.keepIfError = true;
            return 1;
        }
        if ("-closeIfFail".equals(list.get(n))) {
            this.closeIfFail = true;
            return 1;
        }
        if ("-execDir".equals(list.get(n))) {
            this.execDir = new File(list.get(++n));
            return 2;
        }
        if ("-tag".equals(list.get(n))) {
            this.tag = list.get(++n);
            return 2;
        }
        return 0;
    }

    public List<String> getAgentArgs() {
        return this.agentArgs;
    }

    public List<String> getCmd() {
        return this.cmd;
    }

    public Map<String, String> getCmdEnv() {
        return this.cmdEnv;
    }

    public File getExecDir() {
        return this.execDir;
    }

    public long getTestTimeout() {
        return this.testTimeout;
    }

    public int getGroupSize() {
        return this.groupSize;
    }

    public int getTestCount() {
        return this.testCount;
    }

    public boolean isCloseIfFail() {
        return this.closeIfFail;
    }

    public boolean isKeepIfError() {
        return this.keepIfError;
    }

    public List<String> getKey() {
        return this.key;
    }

    public String getTag() {
        return this.tag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.process = this.buildProcess().start();
            this.copier.start(this.manager.getExecutor(), this.process);
            this.processStarted.countDown();
            this.rc = this.process.waitFor();
            if (this.rc != 0 && !this.closed) {
                throw new IOException("Agent process finished with invalid exit code: " + this.rc);
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            this.exception = throwable;
            this.processStarted.countDown();
            if (this.waitThread != null) {
                this.waitThread.interrupt();
            }
        }
        finally {
            this.close();
            this.copier.waitUntilDone();
            this.log("process done");
        }
    }

    public boolean checkReady() {
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(this.connection.getOutputStream()));
            dataOutputStream.writeUTF("ping");
            dataOutputStream.flush();
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(this.connection.getInputStream()));
            "ping".equals(dataInputStream.readUTF());
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public String toString() {
        return "AgentTask(id=" + this.id + ",tcount=" + this.testCount + ",closed=" + this.closed + ",rc=" + this.rc + ")";
    }

    protected ProcessBuilder buildProcess() {
        ArrayList<String> arrayList = new ArrayList<String>(this.cmd);
        arrayList.addAll(Util.listOf(ActiveMain.class.getName(), "-id", this.id, "-host", this.manager.getHost(), "-port", String.valueOf(this.manager.getServerPort()), "-idleTimeout", String.valueOf(this.manager.getTimeout() * 2L), "-testTimeout", String.valueOf(this.testTimeout)));
        if (this.manager.isDebug()) {
            arrayList.add("-debug");
        }
        if (this.agentArgs != null && this.agentArgs.size() > 0) {
            arrayList.add("-agentArgs");
            arrayList.addAll(this.agentArgs);
        }
        this.jcovSupport = JCovRemoteSupport.getInstance(arrayList);
        if (this.jcovSupport != null && this.jcovSupport.wasCommandAdjusted()) {
            this.copier.getOut().println("Adjusted for JCov: " + arrayList);
        }
        ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
        processBuilder.directory(this.execDir);
        this.adjustEnviroment(processBuilder.environment());
        return processBuilder;
    }

    protected boolean needClose(Status status) {
        if (status.isError() && !this.keepIfError) {
            return true;
        }
        if (status.isFailed() && this.closeIfFail) {
            return true;
        }
        return this.groupSize != 0 && this.groupSize <= this.testCount;
    }
}

