/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.lib.jck4jdk;

import com.sun.javatest.util.I18NResourceBundle;
import com.sun.jck.lib.jck4jdk.BadArgs;
import com.sun.jck.lib.jck4jdk.Main;
import com.sun.jck.lib.jck4jdk.Option;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class OptionDecoder {
    private Map<String, Option> simpleOptions = new HashMap<String, Option>();
    private List<Option> matchOptions = new ArrayList<Option>();
    private Option fileOption;
    private Map<String, String> locks = new HashMap<String, String>();
    private boolean inFiles;
    protected static boolean debugOptions = Boolean.getBoolean("javatest.jtjck.debugOptions");
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(Main.class);

    public OptionDecoder(Option[] options) {
        block4: for (Option o : options) {
            switch (o.argType) {
                case WILDCARD: {
                    this.matchOptions.add(o);
                    continue block4;
                }
                case FILE: {
                    this.fileOption = o;
                    continue block4;
                }
                default: {
                    for (String n : o.names) {
                        this.simpleOptions.put(n.toLowerCase(), o);
                    }
                }
            }
        }
    }

    public void decodeArgs(String[] args) throws BadArgs {
        this.decodeArgs(Arrays.asList(args));
    }

    public void decodeArgs(List<String> args) throws BadArgs {
        Iterator<String> iter = args.iterator();
        while (iter.hasNext()) {
            String arg = iter.next();
            if (arg.length() == 0) {
                throw new BadArgs(i18n, "opt.empty", new Object[0]);
            }
            if (!arg.startsWith("-")) {
                this.inFiles = true;
            }
            if (this.inFiles) {
                this.fileOption.process(null, arg);
                continue;
            }
            this.decodeArg(arg, iter);
        }
    }

    private void decodeArg(String arg, Iterator<String> iter) throws BadArgs {
        String value;
        String name;
        int sep = arg.indexOf(":");
        if (sep == -1) {
            name = arg;
            value = null;
        } else {
            name = arg.substring(0, sep);
            value = arg.substring(sep + 1);
        }
        Option o = this.getOption(name);
        if (o == null) {
            throw new BadArgs(i18n, "opt.unknown", name);
        }
        switch (o.argType) {
            case NONE: {
                if (value == null) break;
                throw new BadArgs(i18n, "opt.unexpected.value", arg);
            }
            case STD: {
                if (value != null) break;
                throw new BadArgs(i18n, "opt.missing.value", arg);
            }
            case OLD: {
                if (value == null && iter.hasNext()) {
                    value = iter.next();
                }
                if (value != null) break;
                throw new BadArgs(i18n, "opt.missing.value", arg);
            }
            case OPT: {
                break;
            }
            case WILDCARD: {
                value = o.getValue(arg);
                break;
            }
            case REST: {
                value = OptionDecoder.join(iter, " ");
            }
        }
        this.checkConflicts(o, name);
        if (debugOptions) {
            System.err.println("OptionDecoder.decodeArg: " + name + " " + value);
        }
        o.process(arg, value);
    }

    public void addFile(File file) throws BadArgs {
        this.fileOption.process(null, file.getPath());
    }

    public void addFile(String path) throws BadArgs {
        this.fileOption.process(null, path);
    }

    protected Option getOption(String name) {
        Option s;
        if (name.startsWith("-")) {
            name = name.substring(1);
        }
        if ((s = this.simpleOptions.get(name.toLowerCase())) != null) {
            return s;
        }
        for (Option m : this.matchOptions) {
            if (!m.matches(name)) continue;
            return m;
        }
        return null;
    }

    protected void checkConflicts(Option o, String name) throws BadArgs {
        if (o.lockName != null) {
            String prev = this.locks.get(o.lockName);
            if (prev != null) {
                if (prev.equals(name)) {
                    throw new BadArgs(i18n, "opt.duplicate", name);
                }
                throw new BadArgs(i18n, "opt.conflict", prev, name);
            }
            this.locks.put(o.lockName, name);
        }
    }

    private static String join(Iterator<?> iter, String sep) {
        StringBuilder sb = new StringBuilder();
        while (iter.hasNext()) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(iter.next());
        }
        return sb.toString();
    }
}

