/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.lib;

import com.sun.javatest.util.StringArray;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Vector;

public class MessageSwitch {
    private static final int DEFAULT_BACKLOG = 5;
    private Thread listener;
    private ServerSocket serverSocket;
    private boolean stopping = false;
    private Vector taskList = new Vector();
    private PrintWriter debugTrace = DEFAULT_OUTPUT;
    private static final PrintWriter DEFAULT_OUTPUT = new PrintWriter(System.err);

    public MessageSwitch() throws IOException {
        this(5);
    }

    public MessageSwitch(int n) throws IOException {
        this.serverSocket = new ServerSocket(0, n);
        this.listener = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    MessageSwitch.this.listen();
                }
                catch (IOException iOException) {
                    MessageSwitch messageSwitch = MessageSwitch.this;
                    synchronized (messageSwitch) {
                        MessageSwitch.this.listener = null;
                    }
                }
                finally {
                    MessageSwitch messageSwitch = MessageSwitch.this;
                    synchronized (messageSwitch) {
                        MessageSwitch.this.listener = null;
                    }
                }
            }
        };
        this.listener.setName("MessageSwitch.listener");
        this.listener.start();
    }

    public void setTraceOutput(PrintWriter printWriter) {
        this.debugTrace = printWriter != null ? printWriter : DEFAULT_OUTPUT;
    }

    public String getHostAndPort() throws UnknownHostException {
        InetAddress inetAddress = InetAddress.getLocalHost();
        return inetAddress.getHostName() + ":" + String.valueOf(this.serverSocket.getLocalPort());
    }

    public int getPort() {
        return this.serverSocket.getLocalPort();
    }

    private synchronized void broadcast(Task task, String[] stringArray) {
        for (int i = 0; i < this.taskList.size(); ++i) {
            Task task2 = (Task)this.taskList.elementAt(i);
            if (task2 == task) continue;
            task2.send(task, stringArray);
        }
    }

    /*
     * Exception decompiling
     */
    private synchronized void send(Task var1_1, String var2_2, String[] var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public synchronized boolean waitForRemoteClients(int n, long l) throws InterruptedException {
        this.debugTrace.println("MessageSwitch.waitForRemoteClients: wait for " + n + " remote clients");
        if (n <= 0) {
            return true;
        }
        long l2 = System.currentTimeMillis();
        long l3 = l2 + l * 1000L;
        while (this.taskList.size() < n && (l == 0L || l3 > l2)) {
            this.debugTrace.println("clients count is " + this.taskList.size() + ". wait ...");
            this.wait(l3 > l2 ? l3 - l2 : 1000L);
            this.debugTrace.println(" OK");
            l2 = System.currentTimeMillis();
        }
        this.debugTrace.println("waiting for remote clients " + (this.taskList.size() >= n ? "succeeded" : "failed"));
        return this.taskList.size() >= n;
    }

    public synchronized void close() {
        this.stopping = true;
        try {
            this.serverSocket.close();
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
        if (this.listener != null) {
            this.listener.interrupt();
        }
        for (int i = 0; i < this.taskList.size(); ++i) {
            Task task = (Task)this.taskList.elementAt(i);
            task.stop();
        }
    }

    protected void handleException(Exception exception) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listen() throws IOException {
        while (!this.stopping) {
            Socket socket = this.serverSocket.accept();
            Task task = new Task(socket);
            new Thread(task).start();
            MessageSwitch messageSwitch = this;
            synchronized (messageSwitch) {
                this.taskList.addElement(task);
                this.debugTrace.println("[" + this.taskList.size() + "]: " + task + " started.");
                this.notifyAll();
            }
        }
    }

    private class Task
    implements Runnable {
        String name;
        Socket socket;
        DataInputStream in;
        DataOutputStream out;

        Task(Socket socket) throws IOException {
            this.socket = socket;
            this.in = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
            this.out = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
            MessageSwitch.this.debugTrace.println("open to " + socket.getInetAddress());
        }

        public synchronized void send(Task task, String[] stringArray) {
            String string = task == null || task.name == null ? "" : task.name;
            try {
                this.out.writeByte(100);
                this.out.writeUTF(string);
                this.out.writeShort(stringArray.length);
                for (int i = 0; i < stringArray.length; ++i) {
                    this.out.writeUTF(stringArray[i]);
                }
                this.out.flush();
            }
            catch (IOException iOException) {
                MessageSwitch.this.handleException(iOException);
            }
        }

        public void stop() {
            this.closeAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            try {
                block12: while (!MessageSwitch.this.stopping) {
                    byte by = this.in.readByte();
                    MessageSwitch.this.debugTrace.println(this + ": received " + by);
                    switch (by) {
                        case 1: {
                            String[] stringArray = MessageSwitch.this;
                            // MONITORENTER : MessageSwitch.this
                            this.name = this.in.readUTF();
                            MessageSwitch.this.debugTrace.println(this + ": got name " + this.name);
                            MessageSwitch.this.notifyAll();
                            // MONITOREXIT : stringArray
                            break;
                        }
                        case 2: {
                            String[] stringArray = new String[this.in.readShort()];
                            for (int i = 0; i < stringArray.length; ++i) {
                                stringArray[i] = this.in.readUTF();
                            }
                            MessageSwitch.this.debugTrace.println(this + ": got broadcast " + StringArray.join(stringArray));
                            MessageSwitch.this.broadcast(this, stringArray);
                            break;
                        }
                        case 3: {
                            String string = this.in.readUTF();
                            String[] stringArray = new String[this.in.readShort()];
                            for (int i = 0; i < stringArray.length; ++i) {
                                stringArray[i] = this.in.readUTF();
                            }
                            MessageSwitch.this.debugTrace.println(this + ": got send " + string + ": " + StringArray.join(stringArray));
                            MessageSwitch.this.send(this, string, stringArray);
                            continue block12;
                        }
                    }
                }
                return;
            }
            catch (IOException iOException) {
                MessageSwitch.this.handleException(iOException);
                return;
            }
            finally {
                if (this.name != null) {
                    MessageSwitch.this.taskList.removeElement(this.name);
                }
                this.closeAll();
            }
        }

        private void closeAll() {
            try {
                this.in.close();
            }
            catch (IOException iOException) {
                MessageSwitch.this.handleException(iOException);
            }
            try {
                this.out.close();
            }
            catch (IOException iOException) {
                MessageSwitch.this.handleException(iOException);
            }
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                MessageSwitch.this.handleException(iOException);
            }
        }
    }
}

