/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.lib;

import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestFinder;
import com.sun.javatest.finder.JavaCommentStream;
import com.sun.javatest.finder.TagTestFinder;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.StringArray;
import com.sun.jck.lib.JCKTestSuite;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class JCKTagTestFinder
extends TagTestFinder {
    private boolean verify;
    private Map validEntries = JCKTagTestFinder.initTable(JCKTestSuite.getValidEntries());
    private Map validKeywords = JCKTagTestFinder.initTable(JCKTestSuite.getValidKeywords());
    private static final String TESTSUITE_HTML = "testsuite.html";
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(JCKTagTestFinder.class);

    public JCKTagTestFinder() {
        this.addExtension(".jasm", JavaCommentStream.class);
        this.addExtension(".jcod", JavaCommentStream.class);
    }

    public void init(String[] stringArray, File file, TestEnvironment testEnvironment) throws TestFinder.Fault {
        if (file.isDirectory()) {
            File file2 = new File(file, TESTSUITE_HTML);
            if (!file2.exists() || file2.isDirectory() || !file2.canRead()) {
                throw new TestFinder.Fault(i18n, "jckFinder.badRootDir", new Object[]{TESTSUITE_HTML, file.getPath()});
            }
        } else {
            String string = file.getName();
            if (!string.equals(TESTSUITE_HTML)) {
                throw new TestFinder.Fault(i18n, "jckFinder.badRootFile");
            }
            file = new File(file.getParent());
        }
        super.init(stringArray, file, testEnvironment);
    }

    protected int decodeArg(String[] stringArray, int n) throws TestFinder.Fault {
        if (stringArray[n].equals("-verify")) {
            this.verify = true;
            return 1;
        }
        if (stringArray[n].equals("-allowEntry")) {
            String string = stringArray[n + 1];
            this.validEntries.put(string.toLowerCase(), string);
            return 2;
        }
        if (stringArray[n].equals("-allowKeyword")) {
            String string = stringArray[n + 1];
            this.validKeywords.put(string.toLowerCase(), string);
            return 2;
        }
        return super.decodeArg(stringArray, n);
    }

    protected void processEntry(Map map, String string, String string2) {
        boolean bl;
        boolean bl2 = bl = this.validEntries.get(string.toLowerCase()) != null;
        if (this.verify) {
            String[] stringArray;
            if (!bl) {
                this.error(i18n, "jckFinder.unknownEntry", new Object[]{string, this.getCurrentFile()});
            }
            if (string.equalsIgnoreCase("keywords") && (stringArray = StringArray.split(string2)) != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    String string3 = stringArray[i];
                    if (this.validKeywords.get(string3.toLowerCase()) != null) continue;
                    this.error(i18n, "jckFinder.unknownKeyword", new Object[]{string3, this.getCurrentFile()});
                }
            }
        }
        if (bl) {
            super.processEntry(map, string, string2);
        }
    }

    private static Map initTable(String[] stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < stringArray.length; ++i) {
            hashMap.put(stringArray[i].toLowerCase(), stringArray[i]);
        }
        return hashMap;
    }
}

