/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.lib;

import com.sun.javatest.TestEnvironment;
import com.sun.jck.lib.AddExpr;
import com.sun.jck.lib.AndExpr;
import com.sun.jck.lib.DivideExpr;
import com.sun.jck.lib.EqualExpr;
import com.sun.jck.lib.GreaterEqualExpr;
import com.sun.jck.lib.GreaterExpr;
import com.sun.jck.lib.LessEqualExpr;
import com.sun.jck.lib.LessExpr;
import com.sun.jck.lib.MultiplyExpr;
import com.sun.jck.lib.NameExpr;
import com.sun.jck.lib.NotEqualExpr;
import com.sun.jck.lib.NotExpr;
import com.sun.jck.lib.NumberExpr;
import com.sun.jck.lib.OrExpr;
import com.sun.jck.lib.ParenExpr;
import com.sun.jck.lib.RemainderExpr;
import com.sun.jck.lib.StringExpr;
import com.sun.jck.lib.SubtractExpr;

public abstract class Expr {
    protected static final int ADD = 0;
    protected static final int AND = 1;
    protected static final int DIV = 2;
    protected static final int END = 3;
    protected static final int ERROR = 4;
    protected static final int EQ = 5;
    protected static final int FALSE = 6;
    protected static final int GE = 7;
    protected static final int GT = 8;
    protected static final int LE = 9;
    protected static final int LPAREN = 10;
    protected static final int LT = 11;
    protected static final int MUL = 12;
    protected static final int NAME = 13;
    protected static final int NE = 14;
    protected static final int NOT = 15;
    protected static final int NUMBER = 16;
    protected static final int OR = 17;
    protected static final int REM = 18;
    protected static final int RPAREN = 19;
    protected static final int STRING = 20;
    protected static final int SUB = 21;
    protected static final int TRUE = 22;
    protected static final int PREC_LIT = 6;
    protected static final int PREC_NOT = 6;
    protected static final int PREC_NUM = 6;
    protected static final int PREC_PRN = 6;
    protected static final int PREC_TRM = 6;
    protected static final int PREC_DIV = 5;
    protected static final int PREC_MUL = 5;
    protected static final int PREC_REM = 5;
    protected static final int PREC_ADD = 4;
    protected static final int PREC_SUB = 4;
    protected static final int PREC_GE = 3;
    protected static final int PREC_GT = 3;
    protected static final int PREC_LE = 3;
    protected static final int PREC_LT = 3;
    protected static final int PREC_EQ = 2;
    protected static final int PREC_NE = 2;
    protected static final int PREC_AND = 1;
    protected static final int PREC_OR = 0;

    public static Expr parse(String string) throws Fault {
        Parser parser = new Parser(string);
        return parser.parse();
    }

    public abstract String eval(TestEnvironment var1) throws Fault;

    public boolean evalBoolean(TestEnvironment testEnvironment) throws Fault {
        String string = this.eval(testEnvironment);
        if (string.equals("true")) {
            return true;
        }
        if (string.equals("false")) {
            return false;
        }
        throw new Fault("invalid boolean value: `" + string + "' for expression `" + this + "'");
    }

    public int evalInt(TestEnvironment testEnvironment) throws Fault {
        String string = this.eval(testEnvironment);
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new Fault("invalid integer value: " + string);
        }
    }

    abstract int precedence();

    Expr order() {
        return this;
    }

    static class Parser {
        private String text;
        private int index;
        private int token;
        private String idValue;

        Parser(String string) throws Fault {
            this.text = string;
            this.nextToken();
        }

        Expr parse() throws Fault {
            Expr expr = this.parseExpr();
            this.expect(3);
            return expr;
        }

        Expr parseExpr() throws Fault {
            block15: for (Expr expr = this.parseTerm(); expr != null; expr = expr.order()) {
                switch (this.token) {
                    case 0: {
                        this.nextToken();
                        expr = new AddExpr(expr, this.parseTerm());
                        continue block15;
                    }
                    case 1: {
                        this.nextToken();
                        expr = new AndExpr(expr, this.parseTerm());
                        continue block15;
                    }
                    case 2: {
                        this.nextToken();
                        expr = new DivideExpr(expr, this.parseTerm());
                        continue block15;
                    }
                    case 5: {
                        this.nextToken();
                        expr = new EqualExpr(expr, this.parseTerm());
                        continue block15;
                    }
                    case 7: {
                        this.nextToken();
                        expr = new GreaterEqualExpr(expr, this.parseTerm());
                        continue block15;
                    }
                    case 8: {
                        this.nextToken();
                        expr = new GreaterExpr(expr, this.parseTerm());
                        continue block15;
                    }
                    case 9: {
                        this.nextToken();
                        expr = new LessEqualExpr(expr, this.parseTerm());
                        continue block15;
                    }
                    case 11: {
                        this.nextToken();
                        expr = new LessExpr(expr, this.parseTerm());
                        continue block15;
                    }
                    case 12: {
                        this.nextToken();
                        expr = new MultiplyExpr(expr, this.parseTerm());
                        continue block15;
                    }
                    case 14: {
                        this.nextToken();
                        expr = new NotEqualExpr(expr, this.parseTerm());
                        continue block15;
                    }
                    case 17: {
                        this.nextToken();
                        expr = new OrExpr(expr, this.parseTerm());
                        continue block15;
                    }
                    case 18: {
                        this.nextToken();
                        expr = new RemainderExpr(expr, this.parseTerm());
                        continue block15;
                    }
                    case 21: {
                        this.nextToken();
                        expr = new SubtractExpr(expr, this.parseTerm());
                        continue block15;
                    }
                    default: {
                        return expr;
                    }
                }
            }
            return null;
        }

        Expr parseTerm() throws Fault {
            switch (this.token) {
                case 13: {
                    String string = this.idValue;
                    this.nextToken();
                    return new NameExpr(string);
                }
                case 15: {
                    this.nextToken();
                    return new NotExpr(this.parseTerm());
                }
                case 6: 
                case 16: 
                case 22: {
                    String string = this.idValue;
                    this.nextToken();
                    return new NumberExpr(string);
                }
                case 10: {
                    this.nextToken();
                    Expr expr = this.parseExpr();
                    this.expect(19);
                    return new ParenExpr(expr);
                }
                case 20: {
                    String string = this.idValue;
                    this.nextToken();
                    return new StringExpr(string);
                }
            }
            throw new Fault("Syntax error in expression");
        }

        private void expect(int n) throws Fault {
            if (n != this.token) {
                throw new Fault("Syntax error in expression");
            }
            this.nextToken();
        }

        private void nextToken() throws Fault {
            block17: while (this.index < this.text.length()) {
                char c = this.text.charAt(this.index++);
                switch (c) {
                    case '\t': 
                    case ' ': {
                        continue block17;
                    }
                    case '&': {
                        this.token = 1;
                        return;
                    }
                    case '|': {
                        this.token = 17;
                        return;
                    }
                    case '+': {
                        this.token = 0;
                        return;
                    }
                    case '-': {
                        this.token = 21;
                        return;
                    }
                    case '*': {
                        this.token = 12;
                        return;
                    }
                    case '/': {
                        this.token = 2;
                        return;
                    }
                    case '%': {
                        this.token = 18;
                        return;
                    }
                    case '(': {
                        this.token = 10;
                        return;
                    }
                    case ')': {
                        this.token = 19;
                        return;
                    }
                    case '<': {
                        if (this.index < this.text.length() && this.text.charAt(this.index) == '=') {
                            this.token = 9;
                            ++this.index;
                        } else {
                            this.token = 11;
                        }
                        return;
                    }
                    case '>': {
                        if (this.index < this.text.length() && this.text.charAt(this.index) == '=') {
                            this.token = 7;
                            ++this.index;
                        } else {
                            this.token = 8;
                        }
                        return;
                    }
                    case '=': {
                        if (this.index < this.text.length() && this.text.charAt(this.index) == '=') {
                            this.token = 5;
                            ++this.index;
                        } else {
                            throw new Fault("unexpected character after `='");
                        }
                        return;
                    }
                    case '!': {
                        if (this.index < this.text.length() && this.text.charAt(this.index) == '=') {
                            this.token = 14;
                            ++this.index;
                        } else {
                            this.token = 15;
                        }
                        return;
                    }
                    case '\"': {
                        StringBuffer stringBuffer = new StringBuffer();
                        if (this.index < this.text.length()) {
                            c = this.text.charAt(this.index);
                            ++this.index;
                        } else {
                            throw new Fault("invalid string constant");
                        }
                        while (c != '\"') {
                            stringBuffer.append(c);
                            if (this.index >= this.text.length()) break;
                            c = this.text.charAt(this.index);
                            ++this.index;
                        }
                        if (c != '\"') {
                            throw new Fault("invalid string constant");
                        }
                        this.token = 20;
                        this.idValue = String.valueOf(stringBuffer);
                        return;
                    }
                }
                if (Character.isUnicodeIdentifierStart(c)) {
                    this.idValue = String.valueOf(c);
                    while (this.index < this.text.length() && (Character.isUnicodeIdentifierPart(c = this.text.charAt(this.index)) || c == '.')) {
                        if (!Character.isIdentifierIgnorable(c)) {
                            this.idValue = this.idValue + c;
                        }
                        ++this.index;
                    }
                    this.token = this.idValue.equalsIgnoreCase("true") ? 22 : (this.idValue.equalsIgnoreCase("false") ? 6 : 13);
                    return;
                }
                if (Character.isDigit(c)) {
                    int n = Character.digit(c, 10);
                    while (this.index < this.text.length() && Character.isDigit(c = this.text.charAt(this.index))) {
                        n = n * 10 + Character.digit(c, 10);
                        ++this.index;
                    }
                    this.token = 16;
                    this.idValue = String.valueOf(n);
                    return;
                }
                throw new Fault("unrecognized character: `" + c + "'");
            }
            this.token = 3;
        }
    }

    public static class Fault
    extends Exception {
        Fault(String string) {
            super(string);
        }
    }
}

