/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.interview;

import com.sun.interview.ChoiceQuestion;
import com.sun.interview.FinalQuestion;
import com.sun.interview.NullQuestion;
import com.sun.interview.Question;
import com.sun.interview.StringQuestion;
import com.sun.interview.YesNoQuestion;
import com.sun.jck.interview.EnvironmentInterview;
import com.sun.jck.interview.JCKChoiceQuestion;
import com.sun.jck.interview.JCKEnvInterview;
import com.sun.jck.interview.JCKExportedQuestion;
import com.sun.jck.interview.JCKYesNoQuestion;
import java.util.Map;

class TestPlatformInterview
extends JCKEnvInterview {
    private Question qIntro = new NullQuestion(this, "intro"){

        protected Question getNext() {
            if (TestPlatformInterview.this.parent.isRuntime()) {
                return TestPlatformInterview.this.qNativeCode;
            }
            return TestPlatformInterview.this.qMultiJVM;
        }

        public boolean isHidden() {
            return TestPlatformInterview.this.parent.isSimple();
        }
    };
    private JCKYesNoQuestion qNativeCode = new JCKYesNoQuestion(this, "nativeCode"){

        public void export(Map map) {
            if (this.value == "Yes") {
                map.put("nativeCodeSupported", "true");
                map.put("context.nativeCodeSupported", "true");
                map.put("resource.nativeCodeSupported", "true");
                map.put("platform.nativeCodeSupported", "true");
                map.put("jniTestArgs", "-loadLibraryAllowed");
            } else {
                map.put("nativeCodeSupported", "false");
                map.put("context.nativeCodeSupported", "false");
                map.put("resource.nativeCodeSupported", "false");
                map.put("platform.nativeCodeSupported", "false");
                map.put("jniTestArgs", "");
                map.put("platform.jvmtiSupported", "false");
                map.put("platform.jvmtiLivePhaseSupported", "false");
            }
        }

        public boolean isHidden() {
            boolean bl = TestPlatformInterview.this.parent.isSimple();
            if (bl) {
                this.setValue(this.getDefValue());
            }
            return bl;
        }

        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            if (this.value == "No") {
                return TestPlatformInterview.this.qTypeCheckerTest;
            }
            return TestPlatformInterview.this.qJVMTI;
        }

        private String getDefValue() {
            return "Yes";
        }
    };
    private JCKYesNoQuestion qJVMTI = new JCKYesNoQuestion(this, "jvmti"){

        protected Question getNext() {
            JCKYesNoQuestion jCKYesNoQuestion = TestPlatformInterview.this.qTypeCheckerTest;
            if (this.value == "No" || this.value == "Yes") {
                return jCKYesNoQuestion;
            }
            return null;
        }

        public void export(Map map) {
            if (this.value == "Yes") {
                map.put("platform.jvmtiSupported", "true");
            } else {
                map.put("platform.jvmtiSupported", "false");
                map.put("platform.jvmtiLivePhaseSupported", "false");
            }
        }

        public boolean isHidden() {
            if (!TestPlatformInterview.this.isNativeCodeSupported()) {
                return true;
            }
            boolean bl = TestPlatformInterview.this.parent.isSimple();
            if (bl) {
                this.setValue(this.getDefValue());
            }
            return bl;
        }

        private String getDefValue() {
            return "Yes";
        }
    };
    private JCKYesNoQuestion qTypeCheckerTest = new JCKYesNoQuestion(this, "typecheckerSpecific"){

        protected Question getNext() {
            JCKYesNoQuestion jCKYesNoQuestion = TestPlatformInterview.this.qHeadless;
            if (this.value == "No" || this.value == "Yes") {
                return jCKYesNoQuestion;
            }
            return null;
        }

        public void export(Map map) {
            boolean bl = this.value == "Yes";
            map.put("platform.isFallbackSupported", String.valueOf(bl));
        }

        public boolean isHidden() {
            boolean bl = TestPlatformInterview.this.parent.isSimple();
            if (bl) {
                this.setValue(this.getDefValue());
            }
            return bl;
        }

        private String getDefValue() {
            return "Yes";
        }
    };
    private JCKYesNoQuestion qHeadless = new JCKYesNoQuestion(this, "headless"){

        public void export(Map map) {
            boolean bl = this.value == "Yes";
            map.put("platform.isHeadless", String.valueOf(bl));
            if (bl) {
                map.put("platform.robotAvailable", "false");
                map.put("platform.splashScreenSupported", "false");
            }
        }

        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            return TestPlatformInterview.this.qMultiJVM;
        }

        public boolean isHidden() {
            boolean bl = TestPlatformInterview.this.parent.isSimple();
            if (bl) {
                this.setValue(this.getDefValue());
            }
            return bl;
        }

        private String getDefValue() {
            return "No";
        }
    };
    private JCKChoiceQuestion qMultiJVM = new JCKChoiceQuestion(this, "multiJVM"){
        final String YES = "Yes";
        final String NO = "No";
        final String GROUP = "Yes_group";
        {
            this.YES = "Yes";
            this.NO = "No";
            this.GROUP = "Yes_group";
            this.setChoices(new String[]{"Yes", "No", "Yes_group"}, new String[]{"MultiJVM", "SingleJVM", "MultiJVM group"});
        }

        public void export(Map map) {
            map.put("platform.multiJVM", String.valueOf(TestPlatformInterview.this.isMultiJVM()));
            map.put("platform.groupMode", String.valueOf(TestPlatformInterview.this.isGroupMode()));
        }

        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            if (TestPlatformInterview.this.isMultiJVM()) {
                return TestPlatformInterview.this.qOS;
            }
            return TestPlatformInterview.this.qFileSep;
        }

        public boolean isHidden() {
            boolean bl = TestPlatformInterview.this.parent.isSimple();
            if (bl) {
                this.setValue(this.getDefValue());
            }
            return bl;
        }

        private String getDefValue() {
            return "Yes";
        }
    };
    private ChoiceQuestion qOS = new ChoiceQuestion(this, "os"){
        {
            this.setChoices(EnvironmentInterview.allOSChoices);
        }

        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            if ("other".equals(this.value)) {
                return TestPlatformInterview.this.parent.isRuntime() ? TestPlatformInterview.this.qXWindows : TestPlatformInterview.this.qFileSep;
            }
            return TestPlatformInterview.this.qUseAgent;
        }

        public boolean isHidden() {
            boolean bl = TestPlatformInterview.this.parent.isSimple();
            if (bl) {
                this.setValue(this.getDefValue());
            }
            return bl;
        }

        private String getDefValue() {
            return "Current system";
        }
    };
    private YesNoQuestion qXWindows = new YesNoQuestion(this, "xWindows"){

        protected Question getNext() {
            if (this.isHidden()) {
                return TestPlatformInterview.this.qFileSep;
            }
            if (this.value == null) {
                return null;
            }
            return TestPlatformInterview.this.qFileSep;
        }

        public boolean isHidden() {
            return TestPlatformInterview.this.isHeadless();
        }
    };
    private StringQuestion qFileSep = new StringQuestion(this, "fileSep"){
        {
            this.setSuggestions(new String[]{"", "/", "\\"});
            this.setNominalMaxLength(1);
        }

        protected Question getNext() {
            if (this.value == null || this.value.length() != 1) {
                return null;
            }
            return TestPlatformInterview.this.qPathSep;
        }
    };
    private StringQuestion qPathSep = new StringQuestion(this, "pathSep"){
        {
            this.setSuggestions(new String[]{"", ":", ";"});
            this.setNominalMaxLength(1);
        }

        protected Question getNext() {
            if (this.value == null || this.value.length() != 1) {
                return null;
            }
            return TestPlatformInterview.this.qUseAgent;
        }
    };
    private EnvironmentInterview parent;
    private Question qEnd = new FinalQuestion(this);
    private YesNoQuestion qUseAgent = new YesNoQuestion(this, "useAgent"){

        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            return TestPlatformInterview.this.qEnd;
        }

        public boolean isHidden() {
            boolean bl = TestPlatformInterview.this.parent.isSimple();
            if (bl) {
                this.setValue(this.getDefValue());
            } else if (!TestPlatformInterview.this.isMultiJVM()) {
                this.setValue("Yes");
                return true;
            }
            return bl;
        }

        private String getDefValue() {
            return "No";
        }

        public void export(Map map) {
            boolean bl = "Yes".equals(this.value);
            map.put("use.agent", Boolean.toString(bl));
        }
    };

    TestPlatformInterview(EnvironmentInterview environmentInterview) {
        super(environmentInterview, "testPlatform");
        this.parent = environmentInterview;
        this.setFirstQuestion(this.qIntro);
    }

    public void export(Map map) {
        if (this.parent.isSimple()) {
            JCKExportedQuestion[] jCKExportedQuestionArray = new JCKExportedQuestion[]{this.qMultiJVM, this.qNativeCode, this.qJVMTI, this.qTypeCheckerTest, this.qHeadless};
            for (int i = 0; i < jCKExportedQuestionArray.length; ++i) {
                JCKExportedQuestion jCKExportedQuestion = jCKExportedQuestionArray[i];
                if (!jCKExportedQuestion.isHidden()) continue;
                jCKExportedQuestion.export(map);
            }
        }
    }

    public boolean isGroupMode() {
        return this.qMultiJVM.getValue().endsWith("_group");
    }

    boolean isNativeCodeSupported() {
        return this.qNativeCode.getValue() == "Yes";
    }

    boolean isJVMTISupported() {
        return this.qJVMTI.getValue() == "Yes" && this.isNativeCodeSupported();
    }

    boolean isHeadless() {
        String string = this.qHeadless.getValue();
        return string == "Yes";
    }

    public boolean isMultiJVM() {
        return this.qMultiJVM.getValue().startsWith("Yes");
    }

    boolean isLocal() {
        return !this.isUseAgent() && "Current system".equals(this.getOS());
    }

    String getOS() {
        return this.qOS.getValue();
    }

    boolean isXWindows() {
        if (!this.isMultiJVM() || this.isHeadless()) {
            return false;
        }
        String string = this.getOS();
        return EnvironmentInterview.isUnixlike(string) || string.equals("other") && this.qXWindows.getValue() == "Yes";
    }

    char getFileSep() {
        String string = this.getOS();
        if (this.isMultiJVM() && !"other".equals(string)) {
            return EnvironmentInterview.getFileSep(string);
        }
        String string2 = this.qFileSep.getValue();
        return string2 == null ? (char)'/' : string2.charAt(0);
    }

    char getPathSep() {
        String string = this.getOS();
        if (this.isMultiJVM() && !"other".equals(string)) {
            string = this.getOS();
            return EnvironmentInterview.getPathSep(string);
        }
        String string2 = this.qPathSep.getValue();
        return string2 == null ? (char)':' : string2.charAt(0);
    }

    boolean isUseAgent() {
        return "Yes".equals(this.qUseAgent.getValue()) || !this.isMultiJVM();
    }
}

