/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.interview;

import com.sun.interview.Checklist;
import com.sun.interview.FinalQuestion;
import com.sun.interview.IntQuestion;
import com.sun.interview.NullQuestion;
import com.sun.interview.Question;
import com.sun.interview.StringQuestion;
import com.sun.interview.YesNoQuestion;
import com.sun.jck.interview.JCKEnvInterview;
import com.sun.jck.interview.JCKYesNoQuestion;
import com.sun.jck.interview.RuntimeInterview;
import com.sun.jck.interview.RuntimeNetworkInterview;
import com.sun.jck.interview.ServicesInterview;
import com.sun.jck.interview.Utils;
import java.io.File;
import java.util.Map;

class RuntimeRemoteAgentInterview
extends JCKEnvInterview {
    private Question qDistributedIntro = new NullQuestion(this, "distributedIntro"){

        protected Question getNext() {
            return RuntimeRemoteAgentInterview.this.qPassiveHost;
        }
    };
    private StringQuestion qPassiveHost = new StringQuestion(this, "passiveHost"){

        public void setValue(String string) {
            super.setValue(string);
        }

        protected Question getNext() {
            if (this.value == null || this.value.length() == 0) {
                return null;
            }
            return RuntimeRemoteAgentInterview.this.qPassivePortDefault;
        }

        public String[] getSuggestions() {
            String string;
            String[] stringArray = super.getSuggestions();
            boolean bl = RuntimeRemoteAgentInterview.this.iRuntime.isSimple();
            if (stringArray == null && bl && !this.isHidden() && (string = this.getDefValue()) != null) {
                return new String[]{string};
            }
            return null;
        }

        public void export(Map map) {
            map.put("remote.agent.host", this.getValue());
        }

        private String getDefValue() {
            return RuntimeNetworkInterview.getLocalhostName();
        }
    };
    private YesNoQuestion qPassivePortDefault = new YesNoQuestion(this, "passivePortDefault"){

        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            if (this.value == "Yes") {
                return RuntimeRemoteAgentInterview.this.qLoadClasses;
            }
            return RuntimeRemoteAgentInterview.this.qPassivePort;
        }

        public Checklist.Item[] getChecklistItems() {
            Checklist.Item[] itemArray = null;
            if (this.value == "Yes") {
                Checklist.Item item;
                itemArray = new Checklist.Item[1];
                Object[] objectArray = new Object[]{"1907", RuntimeRemoteAgentInterview.this.qPassiveHost.getValue()};
                itemArray[0] = item = RuntimeRemoteAgentInterview.this.createChecklistItem("distributedSection", "distributedResource", objectArray);
            }
            return itemArray;
        }

        public boolean isHidden() {
            boolean bl = RuntimeRemoteAgentInterview.this.iRuntime.isSimple();
            if (bl) {
                this.setValue(this.getDefValue());
            }
            return bl;
        }

        private String getDefValue() {
            return "Yes";
        }

        public void export(Map map) {
            map.put("remote.agent.port", "1908");
        }
    };
    private IntQuestion qPassivePort = new IntQuestion(this, "passivePort", 0, 65535){

        protected Question getNext() {
            if (this.isValid()) {
                return RuntimeRemoteAgentInterview.this.qLoadClasses;
            }
            return null;
        }

        public Checklist.Item[] getChecklistItems() {
            Checklist.Item item;
            Checklist.Item[] itemArray = null;
            itemArray = new Checklist.Item[1];
            Object[] objectArray = new Object[]{Integer.toString(this.value), RuntimeRemoteAgentInterview.this.qPassiveHost.getValue()};
            itemArray[0] = item = RuntimeRemoteAgentInterview.this.createChecklistItem("distributedSection", "distributedResource", objectArray);
            return itemArray;
        }

        public void export(Map map) {
            map.put("remote.agent.port", Integer.toString(this.value));
        }
    };
    private JCKYesNoQuestion qLoadClasses = new JCKYesNoQuestion(this, "loadClasses"){

        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            if (!RuntimeRemoteAgentInterview.this.qServiceCommand.isHidden()) {
                return RuntimeRemoteAgentInterview.this.qServiceCommand;
            }
            return RuntimeRemoteAgentInterview.this.qEnd;
        }

        public void export(Map map) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("-host ");
            stringBuffer.append(RuntimeRemoteAgentInterview.this.qPassiveHost.getValue());
            stringBuffer.append(' ');
            if (RuntimeRemoteAgentInterview.this.qPassivePortDefault.getValue() == "No") {
                stringBuffer.append("-port ");
                stringBuffer.append(String.valueOf(RuntimeRemoteAgentInterview.this.qPassivePort.getValue()));
                stringBuffer.append(' ');
            }
            if (RuntimeRemoteAgentInterview.this.qLoadClasses.getValue() == "Yes") {
                char c = File.separatorChar;
                char c2 = File.pathSeparatorChar;
                String string = "$testClassDir" + c2 + "$testSuiteRootDir" + c + "classes" + "$jdwpTransportClasspathElem";
                stringBuffer.append("-classpath " + string);
            }
            map.put("remote.networkAgent", stringBuffer.toString());
        }

        public boolean isHidden() {
            boolean bl = RuntimeRemoteAgentInterview.this.iRuntime.isSimple();
            if (bl) {
                this.setValue(this.getDefValue());
            }
            return bl;
        }

        private String getDefValue() {
            return "No";
        }
    };
    private StringQuestion qServiceCommand = new StringQuestion(this, "serviceCommand"){

        public void setValue(String string) {
            super.setValue(string);
        }

        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            return RuntimeRemoteAgentInterview.this.qEnd;
        }

        public String[] getSuggestions() {
            String string = String.format("java  -cp %1$s/classes:%1$s/lib/javatest.jar:%1$s/lib/jtjck.jar  -Djava.security.policy=%1$s/lib/jck.policy  -Djavatest.security.allowPropertiesAccess=true com.sun.javatest.agent.AgentMain -passivePort %2$s", "@{testsuite}", "@{port}");
            return new String[]{"", string};
        }

        public void export(Map map) {
            if (this.getValue() == null) {
                return;
            }
            String string = Utils.adjustForSpace(this.getValue());
            map.put("remote.agent.command", string);
        }

        public boolean isHidden() {
            ServicesInterview servicesInterview = RuntimeRemoteAgentInterview.this.iRuntime.getServicesInterview();
            if (!servicesInterview.areServicesOn()) {
                return true;
            }
            return !servicesInterview.needDistr();
        }
    };
    private Question qEnd = new FinalQuestion(this);
    private RuntimeInterview iRuntime;

    RuntimeRemoteAgentInterview(RuntimeInterview runtimeInterview) {
        super(runtimeInterview, "remoteAgent");
        this.iRuntime = runtimeInterview;
        this.setFirstQuestion(this.qDistributedIntro);
    }

    String getPassiveHost() {
        return this.qPassiveHost.getValue();
    }

    public void export(Map map) {
        super.export(map);
        if (this.iRuntime.isSimple() && this.qLoadClasses.isHidden()) {
            this.qLoadClasses.export(map);
        }
    }

    public boolean isLoadClasses() {
        return this.qLoadClasses.getValue() == "Yes";
    }
}

