/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.interview;

import com.sun.interview.FinalQuestion;
import com.sun.interview.Question;
import com.sun.interview.StringQuestion;
import com.sun.jck.interview.JCKEnvInterview;
import com.sun.jck.interview.JCKYesNoQuestion;
import com.sun.jck.interview.RuntimeInterview;
import java.util.Map;

class RuntimeMemoryInterview
extends JCKEnvInterview {
    private JCKYesNoQuestion qExpectOutOfMemory = new JCKYesNoQuestion(this, "expectOutOfMemory"){

        public void export(Map map) {
            boolean bl = this.value == "Yes";
            map.put("platform.expectOutOfMemory", String.valueOf(bl));
        }

        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            if (this.value == "Yes") {
                return RuntimeMemoryInterview.this.qMemoryAllocation;
            }
            return RuntimeMemoryInterview.this.qMaxMemoryNoError;
        }

        public boolean isHidden() {
            boolean bl = RuntimeMemoryInterview.this.parent.isSimple();
            if (bl) {
                this.setValue(this.getDefValue());
            }
            return bl;
        }

        private String getDefValue() {
            return "Yes";
        }
    };
    private JCKYesNoQuestion qMemoryAllocation = new JCKYesNoQuestion(this, "memoryAllocation"){

        public void export(Map map) {
            if (this.value == "Yes") {
                map.put("platform.maxMemory", "0");
            }
        }

        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            if (this.value == "Yes") {
                return RuntimeMemoryInterview.this.qEnd;
            }
            return RuntimeMemoryInterview.this.qMaxMemory;
        }

        public boolean isHidden() {
            boolean bl = RuntimeMemoryInterview.this.parent.isSimple();
            if (bl) {
                this.setValue(this.getDefValue());
            }
            return bl;
        }

        private String getDefValue() {
            return "Yes";
        }
    };
    private StringQuestion qMaxMemory = new StringQuestion(this, "maxMemory"){

        protected Question getNext() {
            if (this.isValid()) {
                return RuntimeMemoryInterview.this.qEnd;
            }
            return null;
        }

        protected boolean isValid() {
            String string = this.getValue();
            if (string == null || string.length() == 0) {
                return false;
            }
            char c = string.charAt(string.length() - 1);
            if (c == 'k' || c == 'K' || c == 'm' || c == 'M') {
                string = string.substring(0, string.length() - 1);
            }
            if (string.length() == 0) {
                return false;
            }
            try {
                Float.parseFloat(string);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            return string.charAt(0) != '-';
        }

        protected void export(Map map) {
            map.put("platform.maxMemory", this.value);
        }
    };
    private StringQuestion qMaxMemoryNoError = new StringQuestion(this, "maxMemoryNoError"){

        protected Question getNext() {
            if (this.isValid()) {
                return RuntimeMemoryInterview.this.qEnd;
            }
            return null;
        }

        protected boolean isValid() {
            String string = this.getValue();
            if (string == null || string.length() == 0) {
                return false;
            }
            char c = string.charAt(string.length() - 1);
            if (c == 'k' || c == 'K' || c == 'm' || c == 'M') {
                string = string.substring(0, string.length() - 1);
            }
            if (string.length() == 0) {
                return false;
            }
            try {
                Float.parseFloat(string);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            return string.charAt(0) != '-';
        }

        protected void export(Map map) {
            map.put("platform.maxMemory", this.value);
        }
    };
    private Question qEnd = new FinalQuestion(this);
    private RuntimeInterview parent;

    RuntimeMemoryInterview(RuntimeInterview runtimeInterview) {
        super(runtimeInterview, "memory");
        this.parent = runtimeInterview;
        this.setFirstQuestion(this.qExpectOutOfMemory);
    }

    public void export(Map map) {
        super.export(map);
        if (this.parent.isSimple()) {
            if (this.qExpectOutOfMemory.isHidden()) {
                this.qExpectOutOfMemory.export(map);
            }
            if (this.qMemoryAllocation.isHidden()) {
                this.qMemoryAllocation.export(map);
            }
        }
    }
}

