/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.model;

import com.sun.tdk.signaturetest.model.MemberDescription;
import com.sun.tdk.signaturetest.util.SwissKnife;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class AnnotationItem
implements Comparable {
    public static final String ANNOTATION_PREFIX = "anno";
    public static final String ANNOTATION_INHERITED = "java.lang.annotation.Inherited";
    public static final String ANNOTATION_DOCUMENTED = "java.lang.annotation.Documented";
    public static final String ANNOTATION_REPEATABLE = "java.lang.annotation.Repeatable";
    private static final String INTF = "interface ";
    public static final AnnotationItem[] EMPTY_ANNOTATIONITEM_ARRAY = new AnnotationItem[0];
    private int target;
    private boolean inheritable = false;
    private String name;
    private SortedSet members = null;

    public AnnotationItem(int target) {
        this.setTarget(target);
    }

    public AnnotationItem(int target, String name) {
        this.setTarget(target);
        this.setName(name);
    }

    public AnnotationItem() {
    }

    public int compareTo(Object o) {
        AnnotationItem that = (AnnotationItem)o;
        int diff = this.getSpecificData().compareTo(that.getSpecificData());
        if (diff == 0 && (diff = this.name.compareTo(that.name)) == 0) {
            if (this.members == that.members) {
                return 0;
            }
            if (this.members == null) {
                return -1;
            }
            if (that.members == null) {
                return 1;
            }
            diff = this.members.size() - that.members.size();
            if (diff == 0) {
                Iterator it = this.members.iterator();
                Iterator that_it = that.members.iterator();
                while (it.hasNext() && diff == 0) {
                    Member m = (Member)it.next();
                    diff = m.compareTo(that_it.next());
                }
            }
        }
        return diff;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnnotationItem other = (AnnotationItem)obj;
        return this.compareTo(other) == 0;
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + this.target;
        hash = 79 * hash + (this.inheritable ? 1 : 0);
        hash = 79 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 79 * hash + (this.members != null ? this.members.hashCode() : 0);
        return hash;
    }

    protected Set getMembers() {
        return this.members;
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name.intern();
    }

    public final int getTarget() {
        return this.target;
    }

    public final void setTarget(int t) {
        this.target = t;
    }

    public void addMember(Member m) {
        if (this.members == null) {
            this.members = new TreeSet();
        }
        this.members.add(m);
    }

    public boolean isInheritable() {
        return this.inheritable;
    }

    public void removeMember(Member m) {
        this.members.remove(m);
    }

    public static void normaliazeAnnotation(AnnotationItem an, Set orderImportant) {
        if (orderImportant != null && !orderImportant.contains(an.name) && an.members != null) {
            Iterator it = an.members.iterator();
            while (it.hasNext()) {
                AnnotationItem.normAnnMember((Member)it.next());
            }
        }
    }

    private static Member normAnnMember(Member m) {
        if (m.value.startsWith("[") && m.value.endsWith("]")) {
            String sValues = m.value.substring(1, m.value.length() - 1);
            StringTokenizer st = new StringTokenizer(sValues, ",");
            ArrayList<String> ts = new ArrayList<String>();
            while (st.hasMoreTokens()) {
                ts.add(st.nextToken().trim());
            }
            StringBuffer newV = new StringBuffer("[");
            Collections.sort(ts);
            Iterator it = ts.iterator();
            while (it.hasNext()) {
                newV.append((String)it.next());
                if (!it.hasNext()) continue;
                newV.append(",");
            }
            newV.append(']');
            m.value = newV.toString();
        }
        return m;
    }

    public Member findByName(String name) {
        if (this.members != null) {
            for (Member m : this.members) {
                if (!m.name.equals(name)) continue;
                return m;
            }
        }
        return null;
    }

    protected String getSpecificData() {
        return "" + this.target;
    }

    protected String getPrefix() {
        return ANNOTATION_PREFIX;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getPrefix()).append(" ");
        if (!"".equals(this.getSpecificData())) {
            sb.append(this.getSpecificData()).append(" ");
        }
        sb.append(this.name).append('(');
        int i = 0;
        if (this.members != null) {
            for (Member m : this.members) {
                if (i++ != 0) {
                    sb.append(", ");
                }
                sb.append(m.type).append(' ').append(m.name).append("=");
                sb.append(m.value);
            }
        }
        sb.append(')');
        return sb.toString();
    }

    public void setInheritable(boolean inh) {
        this.inheritable = inh;
    }

    public static AnnotationItem[] toArray(List alist) {
        if (alist == null || alist.size() == 0) {
            return EMPTY_ANNOTATIONITEM_ARRAY;
        }
        int asize = alist.size();
        AnnotationItem[] tmp = new AnnotationItem[asize];
        for (int i = 0; i < asize; ++i) {
            tmp[i] = (AnnotationItem)alist.get(i);
        }
        return tmp;
    }

    public static class ValueWrap {
        String value;

        public ValueWrap(String s) {
            this.value = s;
        }

        public String toString() {
            return this.value;
        }
    }

    public static class Member
    implements Comparable {
        public String type;
        public String name;
        public String value;

        public Member(String type, String name, Object value) {
            this.type = type;
            this.name = name;
            this.setValue(value);
        }

        public Member(String name, Object value) {
            this.name = name;
            this.setValue(value);
        }

        public Member() {
        }

        public int compareTo(Object x) {
            Member that = (Member)x;
            int result = 0;
            if (this.type != null && that.type != null) {
                result = this.type.compareTo(that.type);
            } else if (this.type != null || that.type != null) {
                result = this.type == null ? -1 : 1;
            }
            if (result == 0 && (result = this.name.compareTo(that.name)) == 0) {
                result = this.value.compareTo(that.value);
            }
            return result;
        }

        public int hashCode() {
            int hash = 7;
            hash = 37 * hash + (this.type == null ? 0 : this.type.hashCode());
            hash = 37 * hash + (this.name == null ? 0 : this.name.hashCode());
            hash = 37 * hash + (this.value == null ? 0 : this.value.hashCode());
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Member other = (Member)obj;
            if (!SwissKnife.equals(this.type, other.type)) {
                return false;
            }
            if (!SwissKnife.equals(this.name, other.name)) {
                return false;
            }
            return SwissKnife.equals(this.value, other.value);
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setValue(Object value) {
            String string = this.value = value == null ? null : MemberDescription.valueToString(value);
            if (value instanceof Class && this.value.startsWith(AnnotationItem.INTF)) {
                this.value = "class " + this.value.substring(AnnotationItem.INTF.length());
            }
        }
    }
}

