/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

/*
 * $Id: TCKFunctionMapper.java 67177 2012-08-17 13:59:21Z dougd $
 */

package com.sun.ts.tests.el.common.functionmapper;

import com.sun.ts.lib.util.TestUtil;
import java.lang.reflect.Method;
import javax.el.FunctionMapper;

import java.util.HashMap;

/* A simple implementation of FunctionMapper that maps only
   a single function to Integer.valueOf(String).
*/

public class TCKFunctionMapper extends FunctionMapper {
    
    private static final String KEY = "Int:val";
    private final Class clazz = Integer.class;
    private final HashMap<String,Method> fMap;
    
    public TCKFunctionMapper() {
      
        fMap = new HashMap<String,Method>();    
	try {
	    fMap.put(KEY, clazz.getMethod("valueOf", String.class));
	} catch (NoSuchMethodException nsme) {
            TestUtil.logErr("CONSTRUCTOR: Can't find method!");
	    TestUtil.printStackTrace(nsme);
	}
    }	
    
    public Method resolveFunction(String prefix, String localName) {

        String key = prefix + ":" + localName;
	return fMap.get(key);
    }
    
    public void update() {
	    
        fMap.remove(KEY);
	try {
            fMap.put(KEY, clazz.getMethod("toString", int.class));
	} catch (NoSuchMethodException nsme) {
            TestUtil.logErr("UPDATE: Can't find method!");
	    TestUtil.printStackTrace(nsme);
	}
    }
}
