/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

/*
 * $Id: BarELContext.java 67177 2012-08-17 13:59:21Z dougd $
 */

package com.sun.ts.tests.el.common.elcontext;

import com.sun.ts.tests.common.el.api.resolver.BarELResolver;

import javax.el.ELResolver;
import javax.el.ELContext;
import javax.el.FunctionMapper;
import javax.el.VariableMapper;

/* This ELContext contains only a simple EL resolver used to
   resolve expressions handled by the BarELResolver.
*/

public class BarELContext extends ELContext {

    private final ELResolver elResolver;

    /*
     * Constructor.
     */
    public BarELContext() {
           this.elResolver = new BarELResolver();
    }

    public ELResolver getELResolver() {
        return (ELResolver) elResolver;
    }
                                                                                
    public ELContext getELContext() {
        return (ELContext) (this);
    }

    public VariableMapper getVariableMapper() {
	return null;
    }

    public FunctionMapper getFunctionMapper() {
	return null;
    }

}
