/*
* Copyright (c) 2007, 2011, Oracle and/or its affiliates. All rights reserved.
* ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
*/

/*
 * $Id: WorkImpl.java 62543 2011-04-15 16:55:11Z phendley $
 */

package com.sun.ts.tests.common.connector.whitebox;

import javax.resource.spi.work.WorkManager;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import com.sun.ts.tests.common.connector.util.*;


public class WorkImpl implements Work
{
    protected WorkManager wm;
    protected   String	  callingClassName = "WorkImpl";

    public WorkImpl(WorkManager wm)
    {
        this.wm = wm;

        String str = callingClassName + ".constructor";
        ConnectorStatus.getConnectorStatus().logAPI(str, "", "");
        debug(str);
    }


    public WorkImpl(WorkManager wm, String strCallingClassName)
    {
        this.wm = wm;
        callingClassName = strCallingClassName;

        String str = callingClassName + ".constructor";
        ConnectorStatus.getConnectorStatus().logAPI(str, "", "");
        debug(str);
    }


    public void release()
    {
        String str = callingClassName + ".release";
        ConnectorStatus.getConnectorStatus().logAPI(str, "", "");
        debug(str);
    }


    public void run()
    {
        try {
            String str = callingClassName + ".run";
            ConnectorStatus.getConnectorStatus().logAPI(str, "", "");
            debug(str);
            NestWork nw = new NestWork();
            wm.doWork(nw);
        } catch (WorkException we) {
            debug("got WorkException in  WorkImpl.run(): " + we.getMessage());
        }
    }


    /*
     * this sets the name of the calling class so that we can
     * be sure proper logging info is dumped out.
     *
     */
    public void setCallingClassName(String str)  {
        this.callingClassName = str;
    }


    public String getCallingClassName() {
        return this.callingClassName;
    }

    private void debug (String str) {
        Debug.trace(str);
    }

}
