/*
* Copyright (c) 2008, 2010, Oracle and/or its affiliates. All rights reserved.
* ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
*/


package com.sun.ts.tests.common.connector.whitebox;



import javax.resource.spi.work.WorkContextLifecycleListener;
import com.sun.ts.tests.common.connector.util.ConnectorStatus;


public class TSSecurityContextWithListener 
                 extends TSSecurityContext 
                 implements WorkContextLifecycleListener {

    public TSSecurityContextWithListener(String userName, 
                                               String password,
                                               String principalName, 
                                               boolean translationRequired) {
        super(userName, password, principalName, translationRequired);
        debug("TSSecurityContextWithListener:  constructor");
    }

    
    @Override
    public void contextSetupComplete() {
        debug("Context setup completed " + this.toString() );
        ConnectorStatus.getConnectorStatus().logState("Context setup completed");
    }

    @Override
    public void contextSetupFailed(String string) {
        debug("Context setup failed with the following message : " + 
               string + " for security-inflow-context " + "   errorCode=" + this.toString());
    }

    public void debug(String message){
        Debug.trace(message);
    }

}
