/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.lib;

import com.sun.javatest.Script;
import com.sun.javatest.Status;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.util.StringArray;
import java.io.File;

public class StdTestScript
extends Script {
    public static final int UNKNOWN = 0;
    public static final int CERTIFY = 1;
    public static final int PRECOMPILE = 2;
    public static final int DEVELOPER = 3;
    private int mode = StdTestScript.getDefaultMode();

    public Status run(String[] args, TestDescription td, TestEnvironment env) {
        try {
            String[] m = env.lookup("script.mode");
            if (m != null && m.length == 1) {
                this.setMode(m[0]);
            }
        }
        catch (TestEnvironment.Fault e) {
            return Status.failed("error determining script mode: " + e.getMessage());
        }
        boolean compile = false;
        boolean execute = false;
        boolean expectFail = false;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-certify")) {
                compile = false;
                execute = true;
                continue;
            }
            if (arg.equals("-precompile")) {
                compile = true;
                execute = false;
                continue;
            }
            if (arg.equals("-developer")) {
                compile = true;
                execute = true;
                continue;
            }
            if (arg.equals("-compile")) {
                compile = true;
                continue;
            }
            if (arg.equals("-execute")) {
                execute = true;
                continue;
            }
            if (arg.equals("-expectFail")) {
                expectFail = true;
                continue;
            }
            return Status.failed("bad arg for script: `" + arg + "'");
        }
        if (!compile && !execute) {
            compile = this.mode == 3 || this.mode == 2;
            boolean bl = execute = this.mode == 3 || this.mode == 1;
        }
        if (compile) {
            String srcsParameter = td.getParameter("sources");
            if (srcsParameter == null) {
                srcsParameter = td.getParameter("source");
            }
            String[] srcs = StringArray.split(srcsParameter);
            File[] files = new File[srcs.length];
            File tdDir = td.getDir();
            for (int i = 0; i < files.length; ++i) {
                files[i] = new File(tdDir, srcs[i].replace('/', File.separatorChar));
            }
            Status compileStatus = this.compileTogether(files);
            if (!execute) {
                if (expectFail) {
                    if (compileStatus.getType() == 1) {
                        return Script.pass_compFailExp.augment(compileStatus);
                    }
                    return Script.fail_compSuccUnexp.augment(compileStatus);
                }
                return compileStatus;
            }
            if (compileStatus.isFailed()) {
                return Script.fail_compFailUnexp.augment(compileStatus);
            }
        }
        if (execute) {
            String executeClass = td.getParameter("executeClass");
            if (executeClass == null) {
                return Script.error_noExecuteClass;
            }
            Status executeStatus = this.execute(executeClass, td.getParameter("executeArgs"));
            if (expectFail) {
                if (executeStatus.getType() == 1) {
                    return Script.pass_execFailExp.augment(executeStatus);
                }
                return Script.fail_execSuccUnexp.augment(executeStatus);
            }
            return executeStatus;
        }
        return Script.error_noActionSpecified;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        switch (mode) {
            case 1: 
            case 2: 
            case 3: {
                this.mode = mode;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private void setMode(String mode) {
        this.setMode(StdTestScript.parseMode(mode));
    }

    private static int parseMode(String m) {
        if (m == null || m.equals("certify")) {
            return 1;
        }
        if (m.equals("precompile")) {
            return 2;
        }
        if (m.equals("developer")) {
            return 3;
        }
        return 0;
    }

    private static int getDefaultMode() {
        return StdTestScript.parseMode(System.getProperty("javatest.stdTestScript.defaultMode"));
    }
}

