/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.loaders;

import com.sun.tdk.signaturetest.core.ClassDescriptionLoader;
import com.sun.tdk.signaturetest.core.PrimitiveTypes;
import com.sun.tdk.signaturetest.loaders.LoadingHints;
import com.sun.tdk.signaturetest.model.ClassDescription;
import com.sun.tdk.signaturetest.model.ConstructorDescr;
import com.sun.tdk.signaturetest.model.ExoticCharTools;
import com.sun.tdk.signaturetest.model.FieldDescr;
import com.sun.tdk.signaturetest.model.InnerDescr;
import com.sun.tdk.signaturetest.model.MemberDescription;
import com.sun.tdk.signaturetest.model.MethodDescr;
import com.sun.tdk.signaturetest.model.SuperClass;
import com.sun.tdk.signaturetest.model.SuperInterface;
import com.sun.tdk.signaturetest.util.SwissKnife;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.HashSet;

public class ReflClassDescrLoader
implements ClassDescriptionLoader,
LoadingHints {
    public static final boolean debug = false;
    private Method forName;
    private Object[] args;
    private HashSet hints = new HashSet();
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$java$lang$Class;

    public ReflClassDescrLoader() {
        this.args = new Object[]{"", Boolean.FALSE, this.getClass().getClassLoader()};
        Class[] param = new Class[]{class$java$lang$String == null ? (class$java$lang$String = ReflClassDescrLoader.class$("java.lang.String")) : class$java$lang$String, Boolean.TYPE, class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = ReflClassDescrLoader.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader};
        try {
            this.forName = (class$java$lang$Class == null ? (class$java$lang$Class = ReflClassDescrLoader.class$("java.lang.Class")) : class$java$lang$Class).getDeclaredMethod("forName", param);
        }
        catch (NoSuchMethodException e) {
            this.forName = null;
        }
    }

    public ClassDescription load(String name) throws ClassNotFoundException {
        String name2 = ExoticCharTools.decodeExotic(name);
        this.args[0] = name2;
        return this.load2(name2);
    }

    private final ClassDescription load2(final String name2) throws ClassNotFoundException {
        try {
            return (ClassDescription)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    try {
                        if (ReflClassDescrLoader.this.forName == null) {
                            return ReflClassDescrLoader.this.loadClass(Class.forName(name2));
                        }
                        return ReflClassDescrLoader.this.loadClass((Class)ReflClassDescrLoader.this.forName.invoke(null, ReflClassDescrLoader.this.args));
                    }
                    catch (IllegalAccessException e) {
                        return ReflClassDescrLoader.this.loadClass(Class.forName(name2));
                    }
                    catch (InvocationTargetException e) {
                        Throwable t = e.getTargetException();
                        if (t instanceof LinkageError) {
                            throw (LinkageError)t;
                        }
                        if (t instanceof ClassNotFoundException) {
                            throw (ClassNotFoundException)t;
                        }
                        return null;
                    }
                }
            });
        }
        catch (PrivilegedActionException pae) {
            if (pae.getException() instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)pae.getException();
            }
            SwissKnife.reportThrowable(pae);
            throw new ClassNotFoundException(name2, pae);
        }
    }

    private ClassDescription loadClass(Class classObject) {
        ClassDescription c = new ClassDescription();
        c.setTiger(false);
        c.setModifiers(classObject.getModifiers());
        c.setupClassName(classObject.getName());
        this.setupMethods(c, classObject);
        this.setupFields(c, classObject);
        this.setupConstructors(c, classObject);
        this.setupInterfaces(c, classObject);
        this.setupNested(c, classObject);
        this.setupSuperClass(c, classObject);
        return c;
    }

    private void setupMethods(ClassDescription cd, Class classObject) {
        Method[] methods = classObject.getDeclaredMethods();
        cd.createMethods(methods.length);
        int i = 0;
        while (i < methods.length) {
            cd.setMethod(i, ReflClassDescrLoader.createMember(methods[i]));
            ++i;
        }
    }

    private void setupFields(ClassDescription cd, Class classObject) {
        Field[] fields = classObject.getDeclaredFields();
        cd.createFields(fields.length);
        int i = 0;
        while (i < fields.length) {
            FieldDescr fld = ReflClassDescrLoader.createMember(fields[i]);
            cd.setField(i, fld);
            String type = fld.getType();
            if (fld.isFinal() && (PrimitiveTypes.isPrimitive(type) || "java.lang.String".equals(type)) && !this.hasHint(LoadingHints.DONT_READ_VALUES)) {
                try {
                    fields[i].setAccessible(true);
                    Object v = fields[i].get(null);
                    String val = MemberDescription.valueToString(v);
                    fld.setConstantValue(val);
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            ++i;
        }
    }

    private void setupNested(ClassDescription cd, Class classObject) {
        Class<?>[] nested = classObject.getDeclaredClasses();
        cd.createNested(nested.length);
        int i = 0;
        while (i < nested.length) {
            InnerDescr m = new InnerDescr();
            cd.setNested(i, m);
            m.setModifiers(nested[i].getModifiers());
            m.setupInnerClassName(cd.getQualifiedName(), nested[i].getName());
            m.setupClassName(nested[i].getName());
            ++i;
        }
    }

    private void setupConstructors(ClassDescription cd, Class classObject) {
        Constructor<?>[] ctors = classObject.getDeclaredConstructors();
        cd.createConstructors(ctors.length);
        int i = 0;
        while (i < ctors.length) {
            cd.setConstructor(i, ReflClassDescrLoader.createMember(ctors[i]));
            ++i;
        }
    }

    private void setupInterfaces(ClassDescription cd, Class classObject) {
        Class<?>[] interfaces = classObject.getInterfaces();
        cd.createInterfaces(interfaces.length);
        int i = 0;
        while (i < interfaces.length) {
            SuperInterface intf = new SuperInterface();
            cd.setInterface(i, intf);
            intf.setupClassName(interfaces[i].getName());
            ++i;
        }
    }

    private void setupSuperClass(ClassDescription cd, Class classObject) {
        Class spr = classObject.getSuperclass();
        if (spr != null) {
            SuperClass sc = new SuperClass();
            sc.setupClassName(spr.getName());
            cd.setSuperClass(sc);
        }
    }

    private static FieldDescr createMember(Field field) {
        FieldDescr member = new FieldDescr(field.getName(), field.getDeclaringClass().getName(), field.getModifiers());
        member.setType(MemberDescription.getTypeName(field.getType()));
        return member;
    }

    private static MethodDescr createMember(Method meth) {
        MethodDescr member = new MethodDescr(meth.getName(), meth.getDeclaringClass().getName(), meth.getModifiers());
        member.setType(MemberDescription.getTypeName(meth.getReturnType()));
        member.setArgs(ReflClassDescrLoader.getArgs(meth.getParameterTypes()));
        member.setThrowables(ReflClassDescrLoader.getThrows(meth.getExceptionTypes()));
        return member;
    }

    private static ConstructorDescr createMember(Constructor ctor) {
        ConstructorDescr member = new ConstructorDescr(ctor.getDeclaringClass(), ctor.getModifiers());
        member.setArgs(ReflClassDescrLoader.getArgs(ctor.getParameterTypes()));
        member.setThrowables(ReflClassDescrLoader.getThrows(ctor.getExceptionTypes()));
        return member;
    }

    private static String getThrows(Class[] exceptionClasses) {
        if (exceptionClasses.length == 0) {
            return "";
        }
        Object[] exceptionNames = new String[exceptionClasses.length];
        int j = 0;
        while (j < exceptionClasses.length) {
            exceptionNames[j] = exceptionClasses[j].getName();
            ++j;
        }
        if (exceptionClasses.length > 1) {
            Arrays.sort(exceptionNames);
        }
        StringBuffer throwables = new StringBuffer((String)exceptionNames[0]);
        int i = 1;
        while (i < exceptionNames.length) {
            throwables.append(",").append((String)exceptionNames[i]);
            ++i;
        }
        return throwables.toString();
    }

    private static String getArgs(Class[] args) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < args.length) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(MemberDescription.getTypeName(args[i]));
            ++i;
        }
        return sb.toString();
    }

    public void addLoadingHint(LoadingHints.Hint hint) {
        this.hints.add(hint);
    }

    private boolean hasHint(LoadingHints.Hint hint) {
        return this.hints.contains(hint);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        debug = false;
    }
}

