/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jstl.common.tags;

import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.jstl.core.Config;
import javax.servlet.jsp.tagext.TagSupport;

public class ScopeCheckTag
extends TagSupport {
    private static final String PAGE = "page";
    private static final String REQUEST = "request";
    private static final String SESSION = "session";
    private String _varName = null;
    private String _inScope = "page";
    private boolean _useConfig = false;

    public void setVarName(String varName) {
        this._varName = varName;
    }

    public void setInScope(String inScope) {
        this._inScope = inScope;
    }

    public void setUseConfig(boolean useConfig) {
        this._useConfig = useConfig;
    }

    public int doEndTag() throws JspException {
        Object attribute = null;
        try {
            attribute = this.getAttribute();
            if (attribute != null) {
                this.pageContext.getOut().println("<strong>" + this._varName + "</strong> found in <strong>" + this._inScope + "</strong> scope.<br>");
            } else {
                this.pageContext.getOut().println("<strong>" + this._varName + "</strong> not found in specified scope:<strong>" + this._inScope + "</strong>.<br>");
            }
        }
        catch (IOException ioe) {
            try {
                this.pageContext.getOut().println("<strong>Error:</strong> Unexpected Exception: " + ioe.toString());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return 6;
    }

    public void release() {
        this._varName = null;
        this._inScope = PAGE;
        this._useConfig = false;
    }

    private Object getAttribute() {
        int targetScope = this.getScopeFromName(this._inScope);
        if (this._useConfig) {
            return Config.get((PageContext)this.pageContext, (String)this._varName, (int)targetScope);
        }
        return this.pageContext.getAttribute(this._varName, targetScope);
    }

    private int getScopeFromName(String scope) {
        if (scope.equals(PAGE)) {
            return 1;
        }
        if (scope.equals(REQUEST)) {
            return 2;
        }
        if (scope.equals(SESSION)) {
            return 3;
        }
        return 4;
    }
}

