/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxrpc.api.javax_xml_rpc.Call;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.porting.TSURL;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxrpc.api.javax_xml_rpc.Call.JavaBean;
import com.sun.ts.tests.jaxrpc.common.JAXRPC_Data;
import com.sun.ts.tests.jaxrpc.common.JAXRPC_Util;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.xml.namespace.QName;
import javax.xml.rpc.Call;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.ParameterMode;
import javax.xml.rpc.Service;

public class Client
extends ServiceEETest {
    private static final String PROTOCOL = "http";
    private static final String HOSTNAME = "localhost";
    private static final int PORTNUM = 8000;
    private static final String WEBSERVERHOSTPROP = "webServerHost";
    private static final String WEBSERVERPORTPROP = "webServerPort";
    private static final String MODEPROP = "platform.mode";
    String modeProperty = null;
    private static final String PKG_NAME = "com.sun.ts.tests.jaxrpc.api.javax_xml_rpc.Call.";
    private final String NAMESPACEURI = "http://helloservice.org/wsdl";
    private final String TYPESNAMESPACEURI = "http://helloservice.org/types";
    private QName SERVICE_QNAME;
    private QName PORT_QNAME;
    private QName PORTTYPE_QNAME;
    private QName QNAME_TYPE_STRING;
    private Service service = null;
    private Call call = null;
    private TSURL ctsurl = new TSURL();
    private Properties props = null;
    private String hostname = "localhost";
    private int portnum = 8000;
    private static final String ENDPOINT_URL = "helloservice.endpoint.1";
    private static final String WSDLLOC_URL = "helloservice.wsdlloc.1";
    private String url = null;
    private URL wsdlurl = null;

    private void getTestURLs() throws Exception {
        TestUtil.logMsg((String)"Get URL's used by the test");
        String file = JAXRPC_Util.getURLFromProp(ENDPOINT_URL);
        this.url = this.ctsurl.getURLString(PROTOCOL, this.hostname, this.portnum, file);
        file = JAXRPC_Util.getURLFromProp(WSDLLOC_URL);
        this.wsdlurl = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, file);
        TestUtil.logMsg((String)("Service Endpoint URL: " + this.url));
        TestUtil.logMsg((String)("WSDL Location URL:    " + this.wsdlurl));
    }

    private void getTestDIIURLs() throws Exception {
        TestUtil.logMsg((String)"Get URL's used by the test");
        String file = JAXRPC_Util.getURLFromProp(ENDPOINT_URL);
        this.url = this.ctsurl.getURLString(PROTOCOL, this.hostname, this.portnum, file);
        TestUtil.logMsg((String)("Service Endpoint URL: " + this.url));
    }

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        boolean pass = true;
        this.SERVICE_QNAME = new QName("http://helloservice.org/wsdl", "HelloService");
        this.PORT_QNAME = new QName("http://helloservice.org/wsdl", "HelloPort");
        this.PORTTYPE_QNAME = new QName("http://helloservice.org/wsdl", "Hello");
        this.QNAME_TYPE_STRING = new QName("http://www.w3.org/2001/XMLSchema", "string");
        try {
            this.hostname = p.getProperty(WEBSERVERHOSTPROP);
            if (this.hostname == null) {
                pass = false;
            } else if (this.hostname.equals("")) {
                pass = false;
            }
            try {
                this.portnum = Integer.parseInt(p.getProperty(WEBSERVERPORTPROP));
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"Create Service and Call objects");
            TestUtil.logMsg((String)("SERVICE_QNAME=" + this.SERVICE_QNAME));
            TestUtil.logMsg((String)("PORT_QNAME=" + this.PORT_QNAME));
            this.modeProperty = p.getProperty(MODEPROP);
            if (this.modeProperty.equals("standalone")) {
                this.getTestURLs();
                this.service = JAXRPC_Util.getService(this.SERVICE_QNAME);
            } else {
                this.getTestDIIURLs();
                TestUtil.logMsg((String)"Get Initial Context");
                InitialContext ctx = new InitialContext();
                TestUtil.logMsg((String)"Get JAXRPC service instance");
                this.service = (Service)ctx.lookup("java:comp/env/service/call");
            }
            this.call = this.service.createCall(this.PORT_QNAME);
            this.call = JAXRPC_Util.setCallProperties(this.call, " ");
        }
        catch (Exception e) {
            throw new EETest.Fault("setup failed:", e);
        }
        if (!pass) {
            TestUtil.logErr((String)"Please specify host & port of web server in config properties: webServerHost, webServerPort");
            throw new EETest.Fault("setup failed:");
        }
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public void InvokeTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"InvokeTest1");
        boolean pass = true;
        String expected = "passed";
        try {
            TestUtil.logMsg((String)"InvokeTest1: using primitive wrapper type parameters");
            TestUtil.logMsg((String)"Initialize rest of Call object");
            this.call.setOperationName(new QName("http://helloservice.org/wsdl", "invokeTest1"));
            this.call.setTargetEndpointAddress(this.url);
            boolean b = this.call.isParameterAndReturnSpecRequired(new QName("http://helloservice.org/wsdl", "invokeTest1"));
            if (b) {
                this.call.setReturnType(this.QNAME_TYPE_STRING);
                this.call.addParameter("Boolean_1", new QName("http://schemas.xmlsoap.org/soap/encoding/", "boolean"), ParameterMode.IN);
                this.call.addParameter("Byte_2", new QName("http://schemas.xmlsoap.org/soap/encoding/", "byte"), ParameterMode.IN);
                this.call.addParameter("Short_3", new QName("http://schemas.xmlsoap.org/soap/encoding/", "short"), ParameterMode.IN);
                this.call.addParameter("Integer_4", new QName("http://schemas.xmlsoap.org/soap/encoding/", "int"), ParameterMode.IN);
                this.call.addParameter("Long_5", new QName("http://schemas.xmlsoap.org/soap/encoding/", "long"), ParameterMode.IN);
                this.call.addParameter("Float_6", new QName("http://schemas.xmlsoap.org/soap/encoding/", "float"), ParameterMode.IN);
                this.call.addParameter("Double_7", new QName("http://schemas.xmlsoap.org/soap/encoding/", "double"), ParameterMode.IN);
            }
            Object[] params = new Object[]{JAXRPC_Data.Boolean_data[0], JAXRPC_Data.Byte_data[0], JAXRPC_Data.Short_data[0], JAXRPC_Data.Integer_data[0], JAXRPC_Data.Long_data[0], JAXRPC_Data.Float_data[0], JAXRPC_Data.Double_data[0]};
            TestUtil.logMsg((String)"InvokeTest1 RPC method Tests(\"invokeTest1\")");
            String response = (String)this.call.invoke(params);
            if (!response.equals(expected)) {
                TestUtil.logErr((String)("RPC failed - expected \"" + expected + "\", received: " + response));
                pass = false;
            } else {
                TestUtil.logMsg((String)("RPC passed - received expected response: " + response));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("InvokeTest1 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("InvokeTest1 failed");
        }
    }

    public void InvokeTest2() throws EETest.Fault {
        TestUtil.logTrace((String)"InvokeTest2");
        boolean pass = true;
        String expected = "passed";
        try {
            TestUtil.logMsg((String)"InvokeTest2: using supported value type parameters");
            TestUtil.logMsg((String)"Initialize rest of Call object");
            this.call.setTargetEndpointAddress(this.url);
            this.call.setOperationName(new QName("http://helloservice.org/wsdl", "invokeTest2"));
            boolean b = this.call.isParameterAndReturnSpecRequired(new QName("http://helloservice.org/wsdl", "invokeTest2"));
            if (b) {
                this.call.setReturnType(this.QNAME_TYPE_STRING);
                this.call.addParameter("BigInteger_1", new QName("http://www.w3.org/2001/XMLSchema", "integer"), ParameterMode.IN);
                this.call.addParameter("BigDecimal_2", new QName("http://www.w3.org/2001/XMLSchema", "decimal"), ParameterMode.IN);
                this.call.addParameter("QName_3", new QName("http://www.w3.org/2001/XMLSchema", "QName"), ParameterMode.IN);
                this.call.addParameter("String_4", new QName("http://www.w3.org/2001/XMLSchema", "string"), ParameterMode.IN);
            }
            Object[] params = new Object[]{JAXRPC_Data.BigInteger_data[0], JAXRPC_Data.BigDecimal_data[0], JAXRPC_Data.QName_data[0], JAXRPC_Data.String_data[0]};
            TestUtil.logMsg((String)"InvokeTest2 RPC method Tests(\"invokeTest2\")");
            String response = (String)this.call.invoke(params);
            if (!response.equals(expected)) {
                TestUtil.logErr((String)("RPC failed - expected \"" + expected + "\", received: " + response));
                pass = false;
            } else {
                TestUtil.logMsg((String)("RPC passed - received expected response: " + response));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("InvokeTest2 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("InvokeTest2 failed");
        }
    }

    public void InvokeTest3a() throws EETest.Fault {
        TestUtil.logTrace((String)"InvokeTest3a");
        String expected = "Hello";
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"InvokeTest3a: with no parameters");
            TestUtil.logMsg((String)"Initialize rest of Call object");
            this.call.setTargetEndpointAddress(this.url);
            this.call.setOperationName(new QName("http://helloservice.org/wsdl", "invokeTest3"));
            boolean b = this.call.isParameterAndReturnSpecRequired(new QName("http://helloservice.org/wsdl", "invokeTest3"));
            if (b) {
                this.call.setReturnType(this.QNAME_TYPE_STRING);
            }
            TestUtil.logMsg((String)"InvokeTest3a RPC method Tests(\"invokeTest3\")");
            String response = (String)this.call.invoke(new Object[0]);
            if (!response.equals(expected)) {
                TestUtil.logErr((String)("RPC failed - expected \"" + expected + "\", received: " + response));
                pass = false;
            } else {
                TestUtil.logMsg((String)("RPC passed - received expected response: " + response));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("InvokeTest3a failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("InvokeTest3a failed");
        }
    }

    public void InvokeTest3b() throws EETest.Fault {
        TestUtil.logTrace((String)"InvokeTest3b");
        String expected = "Hello";
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"InvokeTest3b: with no parameters");
            TestUtil.logMsg((String)"Initialize rest of Call object");
            this.call.setTargetEndpointAddress(this.url);
            boolean b = this.call.isParameterAndReturnSpecRequired(new QName("http://helloservice.org/wsdl", "invokeTest3"));
            if (b) {
                this.call.setReturnType(this.QNAME_TYPE_STRING);
            }
            TestUtil.logMsg((String)"InvokeTest3b RPC method Tests(\"invokeTest3\")");
            String response = (String)this.call.invoke(new QName("http://helloservice.org/wsdl", "invokeTest3"), new Object[0]);
            if (!response.equals(expected)) {
                TestUtil.logErr((String)("RPC failed - expected \"" + expected + "\", received: " + response));
                pass = false;
            } else {
                TestUtil.logMsg((String)("RPC passed - received expected response: " + response));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("InvokeTest3b failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("InvokeTest3b failed");
        }
    }

    public void InvokeTest4() throws EETest.Fault {
        TestUtil.logTrace((String)"InvokeTest4");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"InvokeTest4: throws a user defined service exception");
            TestUtil.logMsg((String)"Initialize rest of Call object");
            this.call.setTargetEndpointAddress(this.url);
            this.call.setOperationName(new QName("http://helloservice.org/wsdl", "invokeTest4"));
            TestUtil.logMsg((String)"InvokeTest4 RPC method Tests(\"invokeTest4\")");
            try {
                this.call.invoke(new Object[0]);
                TestUtil.logErr((String)"RPC method did not throw expected Exception");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.logMsg((String)"RPC method did throw expected Exception");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("InvokeTest4 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("InvokeTest4 failed");
        }
    }

    public void InvokeOneWayTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"InvokeOneWayTest1");
        boolean pass = true;
        String expected = "passed";
        try {
            TestUtil.logMsg((String)"InvokeOneWayTest1: using primitive wrapper type parameters");
            TestUtil.logMsg((String)"Initialize rest of Call object");
            this.call.setTargetEndpointAddress(this.url);
            this.call.setOperationName(new QName("http://helloservice.org/wsdl", "invokeOneWayTest1"));
            boolean b = this.call.isParameterAndReturnSpecRequired(new QName("http://helloservice.org/wsdl", "invokeOneWayTest1"));
            if (b) {
                this.call.addParameter("Boolean_1", new QName("http://schemas.xmlsoap.org/soap/encoding/", "boolean"), ParameterMode.IN);
                this.call.addParameter("Byte_2", new QName("http://schemas.xmlsoap.org/soap/encoding/", "byte"), ParameterMode.IN);
                this.call.addParameter("Short_3", new QName("http://schemas.xmlsoap.org/soap/encoding/", "short"), ParameterMode.IN);
                this.call.addParameter("Integer_4", new QName("http://schemas.xmlsoap.org/soap/encoding/", "int"), ParameterMode.IN);
                this.call.addParameter("Long_5", new QName("http://schemas.xmlsoap.org/soap/encoding/", "long"), ParameterMode.IN);
                this.call.addParameter("Float_6", new QName("http://schemas.xmlsoap.org/soap/encoding/", "float"), ParameterMode.IN);
                this.call.addParameter("Double_7", new QName("http://schemas.xmlsoap.org/soap/encoding/", "double"), ParameterMode.IN);
            }
            Object[] params = new Object[]{JAXRPC_Data.Boolean_data[0], JAXRPC_Data.Byte_data[0], JAXRPC_Data.Short_data[0], JAXRPC_Data.Integer_data[0], JAXRPC_Data.Long_data[0], JAXRPC_Data.Float_data[0], JAXRPC_Data.Double_data[0]};
            TestUtil.logMsg((String)"InvokeOneWayTest1 RPC method Tests(\"invokeOneWayTest1\")");
            this.call.invokeOneWay(params);
            TestUtil.logMsg((String)"RPC passed - invokeOneWay call successful");
        }
        catch (Exception e) {
            TestUtil.logErr((String)"RPC failed - invokeOneWay call unsucessful");
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("InvokeOneWayTest1 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("InvokeOneWayTest1 failed");
        }
    }

    public void InvokeOneWayTest2() throws EETest.Fault {
        TestUtil.logTrace((String)"InvokeOneWayTest2");
        boolean pass = true;
        String expected = "passed";
        try {
            TestUtil.logMsg((String)"InvokeOneWayTest2: using supported value type parameters");
            TestUtil.logMsg((String)"Initialize rest of Call object");
            this.call.setTargetEndpointAddress(this.url);
            this.call.setOperationName(new QName("http://helloservice.org/wsdl", "invokeOneWayTest2"));
            boolean b = this.call.isParameterAndReturnSpecRequired(new QName("http://helloservice.org/wsdl", "invokeOneWayTest2"));
            if (b) {
                this.call.addParameter("BigInteger_1", new QName("http://www.w3.org/2001/XMLSchema", "integer"), ParameterMode.IN);
                this.call.addParameter("BigDecimal_2", new QName("http://www.w3.org/2001/XMLSchema", "decimal"), ParameterMode.IN);
                this.call.addParameter("QName_3", new QName("http://www.w3.org/2001/XMLSchema", "QName"), ParameterMode.IN);
                this.call.addParameter("String_4", new QName("http://www.w3.org/2001/XMLSchema", "string"), ParameterMode.IN);
            }
            Object[] params = new Object[]{JAXRPC_Data.BigInteger_data[0], JAXRPC_Data.BigDecimal_data[0], JAXRPC_Data.QName_data[0], JAXRPC_Data.String_data[0]};
            TestUtil.logMsg((String)"InvokeOneWayTest2 RPC method Tests(\"invokeOneWayTest2\")");
            this.call.invokeOneWay(params);
            TestUtil.logMsg((String)"RPC passed - invokeOneWay call successful");
        }
        catch (Exception e) {
            TestUtil.logErr((String)"RPC failed - invokeOneWay call unsuccessful");
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("InvokeOneWayTest2 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("InvokeOneWayTest2 failed");
        }
    }

    public void InvokeOneWayTest3() throws EETest.Fault {
        TestUtil.logTrace((String)"InvokeOneWayTest3");
        boolean pass = true;
        String expected = "passed";
        try {
            TestUtil.logMsg((String)"InvokeOneWayTest3: with no parameters");
            TestUtil.logMsg((String)"Initialize rest of Call object");
            this.call.setTargetEndpointAddress(this.url);
            this.call.setOperationName(new QName("http://helloservice.org/wsdl", "invokeOneWayTest3"));
            TestUtil.logMsg((String)"InvokeOneWayTest3 RPC method Tests(\"invokeOneWayTest3\")");
            this.call.invokeOneWay(new Object[0]);
            TestUtil.logMsg((String)"RPC passed - invokeOneWay call successful");
        }
        catch (Exception e) {
            TestUtil.logErr((String)"RPC failed - invokeOneWay call unsuccessful");
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("InvokeOneWayTest3 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("InvokeOneWayTest3 failed");
        }
    }

    public void InvokeNoSuchMethodTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"InvokeNoSuchMethodTest1");
        boolean pass = true;
        String expected = "passed";
        try {
            TestUtil.logMsg((String)"InvokeNoSuchMethodTest1: no such method exists");
            TestUtil.logMsg((String)"Initialize rest of Call object");
            this.call.setTargetEndpointAddress(this.url);
            this.call.setOperationName(new QName("http://helloservice.org/wsdl", "invokeNoSuchMethodTest1"));
            TestUtil.logMsg((String)"InvokeNoSuchMethodTest1 RPC method Tests(\"invokeNoSuchMethodTest1\")");
            this.call.invoke(new Object[0]);
            TestUtil.logErr((String)"Test failed - did not receive expected Exception");
            pass = false;
        }
        catch (Exception e) {
            TestUtil.logMsg((String)"Test passed  - did receive expected Exception");
        }
        if (!pass) {
            throw new EETest.Fault("InvokeNoSuchMethodTest1 failed");
        }
    }

    public void InvokeOneWayNoSuchMethodTest2() throws EETest.Fault {
        TestUtil.logTrace((String)"InvokeOneWayNoSuchMethodTest2");
        boolean pass = true;
        String expected = "passed";
        try {
            TestUtil.logMsg((String)"InvokeOneWayNoSuchMethodTest2: no such method exists");
            TestUtil.logMsg((String)"Initialize rest of Call object");
            this.call.setTargetEndpointAddress(this.url);
            this.call.setOperationName(new QName("http://helloservice.org/wsdl", "invokeOneWayNoSuchMethodTest2"));
            TestUtil.logMsg((String)"InvokeOneWayNoSuchMethodTest2 RPC method Tests(\"invokeOneWayNoSuchMethodTest2\")");
            this.call.invoke(new Object[0]);
            TestUtil.logErr((String)"Test failed - did not receive expected Exception");
            pass = false;
        }
        catch (Exception e) {
            TestUtil.logMsg((String)"Test passed  - did receive expected Exception");
        }
        if (!pass) {
            throw new EETest.Fault("InvokeOneWayNoSuchMethodTest2 failed");
        }
    }

    public void SetGetOperationNameTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"SetGetOperationNameTest1");
        boolean pass = true;
        String expected = "passed";
        try {
            TestUtil.logMsg((String)"Don't set any operation name");
            QName name = this.call.getOperationName();
            TestUtil.logMsg((String)"Get operation name (expect null string)");
            if (name == null) {
                TestUtil.logMsg((String)"getOperationName() passed - received expected null");
            } else if (!name.getLocalPart().equals("")) {
                TestUtil.logErr((String)("getOperationName() failed - expected: \"\", received: " + name));
                pass = false;
            } else {
                TestUtil.logMsg((String)"getOperationName() passed - received expected name: \"\"");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("SetGetOperationNameTest1 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("SetGetOperationNameTest1 failed");
        }
    }

    public void SetGetOperationNameTest2() throws EETest.Fault {
        TestUtil.logTrace((String)"SetGetOperationNameTest2");
        boolean pass = true;
        String expected = "passed";
        try {
            TestUtil.logMsg((String)"Set operation name to invokeTest3");
            this.call.setOperationName(new QName("invokeTest3"));
            TestUtil.logMsg((String)"Get operation name (expect invokeTest3)");
            QName name = this.call.getOperationName();
            if (name == null) {
                TestUtil.logErr((String)"getOperationName() returned null");
                pass = false;
            } else if (!name.getLocalPart().equals("invokeTest3")) {
                TestUtil.logErr((String)("getOperationName() failed - expected: invokeTest3, received: " + name));
                pass = false;
            } else {
                TestUtil.logMsg((String)("getOperationName() passed - received expected name: " + name));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("SetGetOperationNameTest2 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("SetGetOperationNameTest2 failed");
        }
    }

    public void SetInvalidOperationNameTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"SetInvalidOperationNameTest1");
        boolean pass = true;
        String expected = "passed";
        try {
            TestUtil.logMsg((String)"Set operation name to InvalidOperationName (expect Exception)");
            this.call.setOperationName(new QName("InvalidOperationName"));
            TestUtil.logMsg((String)"Did not catch expected JAXRPCException");
        }
        catch (JAXRPCException e) {
            TestUtil.logMsg((String)"Caught expected JAXRPCException");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("SetGetReturnTypeTest1 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("SetInvalidOperationNameTest1 failed");
        }
    }

    public void SetGetReturnTypeTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"SetGetReturnTypeTest1");
        boolean pass = true;
        String expected = "passed";
        try {
            TestUtil.logMsg((String)"Don't set any return type");
            QName type = this.call.getReturnType();
            TestUtil.logMsg((String)"Get return type (expect null)");
            if (type == null) {
                TestUtil.logMsg((String)"getReturnType() passed - received expected null");
            } else if (!type.getLocalPart().equals("")) {
                TestUtil.logErr((String)("getReturnType() failed - expected: \"\", received: " + type));
                pass = false;
            } else {
                TestUtil.logMsg((String)"getReturnType() passed - received null");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("SetGetReturnTypeTest1 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("SetGetReturnTypeTest1 failed");
        }
    }

    public void SetGetReturnTypeTest2() throws EETest.Fault {
        TestUtil.logTrace((String)"SetGetReturnTypeTest2");
        boolean pass = true;
        String expected = "passed";
        try {
            boolean b = this.call.isParameterAndReturnSpecRequired(new QName("http://helloservice.org/wsdl", "invokeTest1"));
            if (b) {
                TestUtil.logMsg((String)"Set return type to xml string type");
                this.call.setReturnType(this.QNAME_TYPE_STRING);
                TestUtil.logMsg((String)"Get return type (expect xml string type)");
                QName type = this.call.getReturnType();
                if (type == null) {
                    TestUtil.logErr((String)"getReturnType() returned null");
                    pass = false;
                } else if (!type.getLocalPart().equals("string")) {
                    TestUtil.logErr((String)("getReturnType() failed - expected: string, received: " + type.getLocalPart()));
                    pass = false;
                } else {
                    TestUtil.logMsg((String)("getReturnType() passed - received expected type: " + type.getLocalPart()));
                }
            } else {
                TestUtil.logMsg((String)"Call object does not support setting return type");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("SetGetReturnTypeTest2 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("SetGetReturnTypeTest2 failed");
        }
    }

    public void SetGetReturnTypeTest3() throws EETest.Fault {
        TestUtil.logTrace((String)"SetGetReturnTypeTest3");
        boolean pass = true;
        String expected = "passed";
        try {
            boolean b = this.call.isParameterAndReturnSpecRequired(new QName("http://helloservice.org/wsdl", "invokeTest1"));
            if (b) {
                TestUtil.logMsg((String)"Set return type to complex xml JavaBean type");
                this.call.setReturnType(new QName("http://helloservice.org/types", "JavaBean"), JavaBean.class);
                TestUtil.logMsg((String)"Get return type (expect complex xml JavaBean type)");
                QName type = this.call.getReturnType();
                if (type == null) {
                    TestUtil.logErr((String)"getReturnType() returned null");
                    pass = false;
                } else if (!type.getLocalPart().equals("JavaBean")) {
                    TestUtil.logErr((String)("getReturnType() failed - expected: string, received: " + type.getLocalPart()));
                    pass = false;
                } else {
                    TestUtil.logMsg((String)("getReturnType() passed - received expected type: " + type.getLocalPart()));
                }
            } else {
                TestUtil.logMsg((String)"Call object does not support setting return type");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("SetGetReturnTypeTest3 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("SetGetReturnTypeTest3 failed");
        }
    }

    public void SetGetPropertyTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"SetGetPropertyTest1");
        boolean pass = true;
        boolean skiprest = false;
        String expected = "passed";
        try {
            TestUtil.logMsg((String)"Set a supported property");
            try {
                TestUtil.logMsg((String)"Setting property javax.xml.rpc.encodingstyle.namespace.uri");
                this.call.setProperty("javax.xml.rpc.encodingstyle.namespace.uri", (Object)"http://schemas.xmlsoap.org/soap/encoding/");
            }
            catch (JAXRPCException e1) {
                skiprest = true;
                TestUtil.logMsg((String)"JAXRPC implementation does not support setting properties");
            }
            catch (Exception e2) {
                TestUtil.logErr((String)"Caught unexpected exception: ", (Throwable)e2);
                pass = false;
            }
            if (!skiprest) {
                TestUtil.logMsg((String)"Get a supported property");
                TestUtil.logMsg((String)"Getting property javax.xml.rpc.encodingstyle.namespace.uri");
                String pvalue = (String)this.call.getProperty("javax.xml.rpc.encodingstyle.namespace.uri");
                if (!pvalue.equals("http://schemas.xmlsoap.org/soap/encoding/")) {
                    TestUtil.logErr((String)("getProperty() failed - expected: http://schemas.xmlsoap.org/soap/encoding/, received: " + pvalue));
                    pass = false;
                } else {
                    TestUtil.logMsg((String)("getProperty() passed - received expected property value: " + pvalue));
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("SetGetPropertyTest1 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("SetGetPropertyTest1 failed");
        }
    }

    public void SetGetPropertyTest2() throws EETest.Fault {
        TestUtil.logTrace((String)"SetGetPropertyTest2");
        boolean pass = true;
        String expected = "passed";
        TestUtil.logMsg((String)"Attempt to set invalid property");
        try {
            this.call.setProperty("javax.xml.rpc.foo.bar", new Object());
            TestUtil.logErr((String)"setProperty() did not throw expected exception");
            pass = false;
        }
        catch (JAXRPCException e) {
            TestUtil.logMsg((String)"setProperty() caught expected JAXRPCException");
        }
        catch (RuntimeException e) {
            TestUtil.logMsg((String)"setProperty() caught expected RuntimeException");
        }
        TestUtil.logMsg((String)"Attempt to get invalid property");
        try {
            this.call.getProperty("javax.xml.rpc.foo.bar");
            TestUtil.logErr((String)"getProperty() did not throw expected exception");
            pass = false;
        }
        catch (JAXRPCException e) {
            TestUtil.logMsg((String)"getProperty() caught expected JAXRPCException");
        }
        catch (RuntimeException e) {
            TestUtil.logMsg((String)"getProperty() caught expected RuntimeException");
        }
        if (!pass) {
            throw new EETest.Fault("SetGetPropertyTest2 failed");
        }
    }

    public void RemovePropertyTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"RemovePropertyTest1");
        boolean pass = true;
        boolean skiprest = false;
        String expected = "passed";
        try {
            TestUtil.logMsg((String)"Set some properties");
            try {
                TestUtil.logMsg((String)"Set property javax.xml.rpc.soap.http.soapaction.use");
                this.call.setProperty("javax.xml.rpc.soap.http.soapaction.use", (Object)new Boolean(true));
            }
            catch (JAXRPCException e2) {
                skiprest = true;
                TestUtil.logMsg((String)"JAXRPC implementation does not support setting properties");
            }
            if (!skiprest) {
                TestUtil.logMsg((String)"Remove property javax.xml.rpc.soap.http.soapaction.use");
                this.call.removeProperty("javax.xml.rpc.soap.http.soapaction.use");
                TestUtil.logMsg((String)"Get property javax.xml.rpc.soap.http.soapaction.use");
                String pvalue = (String)this.call.getProperty("javax.xml.rpc.soap.http.soapaction.use");
                if (pvalue != null) {
                    TestUtil.logErr((String)"Property not removed javax.xml.rpc.soap.http.soapaction.use");
                    pass = false;
                } else {
                    TestUtil.logMsg((String)"Property was removed javax.xml.rpc.soap.http.soapaction.use");
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("RemovePropertyTest1 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("RemovePropertyTest1 failed");
        }
    }

    public void RemovePropertyTest2() throws EETest.Fault {
        TestUtil.logTrace((String)"RemovePropertyTest2");
        boolean pass = true;
        String expected = "passed";
        TestUtil.logMsg((String)"Attempt to remove invalid property");
        try {
            this.call.removeProperty("javax.xml.rpc.foo.bar");
            TestUtil.logMsg((String)"removeProperty() did not throw exception");
        }
        catch (JAXRPCException e) {
            TestUtil.logMsg((String)"removeProperty() caught expected JAXRPCException");
        }
        catch (RuntimeException e) {
            TestUtil.logMsg((String)"removeProperty() caught expected RuntimeException");
        }
        if (!pass) {
            throw new EETest.Fault("RemovePropertyTest2 failed");
        }
    }

    public void SetGetPortTypeNameTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"SetGetPortTypeNameTest1");
        boolean pass = true;
        String expected = "passed";
        try {
            try {
                TestUtil.logMsg((String)"Create Call object");
                this.call = this.service.createCall();
                TestUtil.logMsg((String)"Set port type name");
                TestUtil.logMsg((String)("portTypeName = " + this.PORTTYPE_QNAME));
                this.call.setPortTypeName(this.PORTTYPE_QNAME);
                TestUtil.logMsg((String)"setPortTypeName() passed");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Caught unexpected exception: ", (Throwable)e);
                TestUtil.logErr((String)"setPortTypeName() failed");
                pass = false;
            }
            if (pass) {
                TestUtil.logMsg((String)"Get port type name");
                QName value = this.call.getPortTypeName();
                if (!value.equals(this.PORTTYPE_QNAME)) {
                    TestUtil.logErr((String)("getPortTypeName() failed - expected: " + this.PORTTYPE_QNAME + ", received: " + value));
                    pass = false;
                } else {
                    TestUtil.logMsg((String)("getPortTypeName() passed - received expected value: " + value));
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("SetGetPortTypeNameTest1 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("SetGetPortTypeNameTest1 failed");
        }
    }

    public void SetGetPortTypeNameTest2() throws EETest.Fault {
        TestUtil.logTrace((String)"SetGetPortTypeNameTest2");
        boolean pass = true;
        String expected = "passed";
        try {
            TestUtil.logMsg((String)"Create Call object");
            this.call = this.service.createCall();
            TestUtil.logMsg((String)"Don't set port type name");
            TestUtil.logMsg((String)"portTypeName =");
            TestUtil.logMsg((String)"Get port type name");
            QName value = this.call.getPortTypeName();
            if (!value.equals(new QName(""))) {
                TestUtil.logErr((String)("getPortTypeName() failed - expected: " + new QName("") + ", received: " + value));
                pass = false;
            } else {
                TestUtil.logMsg((String)("getPortTypeName() passed - received expected value: " + value));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("SetGetPortTypeNameTest2 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("SetGetPortTypeNameTest2 failed");
        }
    }

    public void SetGetTargetEndpointAddressTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"SetGetTargetEndpointAddressTest1");
        boolean pass = true;
        String expected = "passed";
        try {
            TestUtil.logMsg((String)"Set target endpoint address");
            try {
                TestUtil.logMsg((String)("url = " + this.url));
                this.call.setTargetEndpointAddress(this.url);
                TestUtil.logMsg((String)"setTargetEndpointAddress() passed");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Caught unexpected exception: ", (Throwable)e);
                TestUtil.logErr((String)"setTargetEndpointAddress() failed");
                pass = false;
            }
            if (pass) {
                TestUtil.logMsg((String)"Get target endpoint address");
                String value = this.call.getTargetEndpointAddress();
                if (!value.equals(this.url)) {
                    TestUtil.logErr((String)("getTargetEndpointAddress() failed\nexpected: " + this.url + ", received: " + value));
                    pass = false;
                } else {
                    TestUtil.logMsg((String)("getPortTypeName() passed - received expected value: " + value));
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("SetGetTargetEndpointAddressTest1 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("SetGetTargetEndpointAddressTest1 failed");
        }
    }

    public void AddGetRemoveAllParametersTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"AddGetRemoveAllParametersTest1");
        boolean pass = true;
        String expected = "passed";
        try {
            boolean b = this.call.isParameterAndReturnSpecRequired(new QName("http://helloservice.org/wsdl", "invokeTest1"));
            if (b) {
                QName name1 = new QName("http://schemas.xmlsoap.org/soap/encoding/", "boolean");
                QName name2 = new QName("http://schemas.xmlsoap.org/soap/encoding/", "byte");
                QName name3 = new QName("http://helloservice.org/types", "JavaBean");
                this.call.addParameter("Boolean_1", name1, ParameterMode.IN);
                this.call.addParameter("Byte_2", name2, ParameterMode.IN);
                this.call.addParameter("JavaBean_3", name3, ParameterMode.IN);
                TestUtil.logMsg((String)("QName1 = " + name1 + "\nQName2 = " + name2 + "\nQName3 = " + name3));
                QName name1cmp = this.call.getParameterTypeByName("Boolean_1");
                QName name2cmp = this.call.getParameterTypeByName("Byte_2");
                QName name3cmp = this.call.getParameterTypeByName("JavaBean_3");
                TestUtil.logMsg((String)("QName1cmp = " + name1cmp + "\nQName2cmp = " + name2cmp + "\nQName3cmp = " + name3cmp));
                if (!name1cmp.equals(name1)) {
                    TestUtil.logErr((String)"getParameterTypeByName returned wrong QName");
                    TestUtil.logErr((String)("Expected " + name1 + "\nGot " + name1cmp));
                    pass = false;
                }
                if (!name2cmp.equals(name2)) {
                    TestUtil.logErr((String)"getParameterTypeByName returned wrong QName");
                    TestUtil.logErr((String)("Expected " + name2 + "\nGot " + name2cmp));
                    pass = false;
                }
                if (!name3cmp.equals(name3)) {
                    TestUtil.logErr((String)"getParameterTypeByName returned wrong QName");
                    TestUtil.logErr((String)("Expected " + name3 + "\nGot " + name3cmp));
                    pass = false;
                }
            } else {
                TestUtil.logMsg((String)"Call object does not support setting paramters");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("AddGetRemoveAllParametersTest1 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("AddGetRemoveAllParametersTest1 failed");
        }
    }

    public void AddGetRemoveAllParametersTest2() throws EETest.Fault {
        TestUtil.logTrace((String)"AddGetRemoveAllParametersTest2");
        boolean pass = true;
        String expected = "passed";
        try {
            boolean b = this.call.isParameterAndReturnSpecRequired(new QName("http://helloservice.org/wsdl", "invokeTest1"));
            if (b) {
                QName name1 = new QName("http://schemas.xmlsoap.org/soap/encoding/", "boolean");
                QName name2 = new QName("http://schemas.xmlsoap.org/soap/encoding/", "byte");
                QName name3 = new QName("http://helloservice.org/types", "JavaBean");
                this.call.addParameter("Boolean_1", name1, ParameterMode.IN);
                this.call.addParameter("Byte_2", name2, ParameterMode.IN);
                this.call.addParameter("JavaBean_3", name3, ParameterMode.IN);
                TestUtil.logMsg((String)("QName1 = " + name1 + "\nQName2 = " + name2 + "\nQName3 = " + name3));
                this.call.removeAllParameters();
                QName name1cmp = this.call.getParameterTypeByName("Boolean_1");
                QName name2cmp = this.call.getParameterTypeByName("Byte_2");
                QName name3cmp = this.call.getParameterTypeByName("JavaBean_3");
                TestUtil.logMsg((String)("QName1cmp = " + name1cmp + "\nQName2cmp = " + name2cmp + "\nQName3cmp = " + name3cmp));
                if (name1cmp != null) {
                    TestUtil.logErr((String)"getParameterTypeByName returned removed parameter");
                    pass = false;
                }
                if (name2cmp != null) {
                    TestUtil.logErr((String)"getParameterTypeByName returned removed parameter");
                    pass = false;
                }
                if (name3cmp != null) {
                    TestUtil.logErr((String)"getParameterTypeByName returned removed parameter");
                    pass = false;
                }
            } else {
                TestUtil.logMsg((String)"Call object does not support setting paramters");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("AddGetRemoveAllParametersTest2 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("AddGetRemoveAllParametersTest2 failed");
        }
    }

    public void IsParameterAndReturnSpecRequiredTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"IsParameterAndReturnSpecRequiredTest1");
        boolean pass = true;
        String expected = "passed";
        try {
            TestUtil.logMsg((String)"Call isParameterAndReturnSpecRequired() on operation InvokeTest1");
            this.call.setTargetEndpointAddress(this.url);
            this.call.setOperationName(new QName("http://helloservice.org/wsdl", "invokeTest1"));
            boolean b = this.call.isParameterAndReturnSpecRequired(new QName("http://helloservice.org/wsdl", "invokeTest1"));
            if (b) {
                TestUtil.logMsg((String)"isParameterAndReturnSpecRequired() is required");
            } else {
                TestUtil.logMsg((String)"isParameterAndReturnSpecRequired() is not required");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("IsParameterAndReturnSpecRequiredTest1 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("IsParameterAndReturnSpecRequiredTest1 failed");
        }
    }

    public void IsParameterAndReturnSpecRequiredTest2() throws EETest.Fault {
        TestUtil.logTrace((String)"IsParameterAndReturnSpecRequiredTest2");
        boolean pass = true;
        String expected = "passed";
        try {
            TestUtil.logMsg((String)"Call isParameterAndReturnSpecRequired() on operation InvokeTest4");
            this.call.setTargetEndpointAddress(this.url);
            this.call.setOperationName(new QName("http://helloservice.org/wsdl", "invokeTest4"));
            boolean b = this.call.isParameterAndReturnSpecRequired(new QName("http://helloservice.org/wsdl", "invokeTest4"));
            if (b) {
                TestUtil.logMsg((String)"isParameterAndReturnSpecRequired() is required");
            } else {
                TestUtil.logMsg((String)"isParameterAndReturnSpecRequired() is not required");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("IsParameterAndReturnSpecRequiredTest2 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("IsParameterAndReturnSpecRequiredTest2 failed");
        }
    }

    public void GetPropertyNamesTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"GetPropertyNamesTest1");
        boolean pass = true;
        String expected = "passed";
        try {
            Iterator i = this.call.getPropertyNames();
            int k = 0;
            while (i.hasNext()) {
                TestUtil.logMsg((String)("Property #" + k++ + " = " + (String)i.next()));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("GetPropertyNamesTest1 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("GetPropertyNamesTest1 failed");
        }
    }

    public void GetOutputParamsTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"GetOutputParamsTest1");
        boolean pass = true;
        String expected = "passed";
        try {
            TestUtil.logMsg((String)"Initialize rest of Call object");
            this.call.setTargetEndpointAddress(this.url);
            boolean b = this.call.isParameterAndReturnSpecRequired(new QName("http://helloservice.org/wsdl", "invokeTest3"));
            if (b) {
                this.call.setReturnType(this.QNAME_TYPE_STRING);
            }
            this.call.setOperationName(new QName("http://helloservice.org/wsdl", "invokeTest3"));
            Map map = this.call.getOutputParams();
            TestUtil.logErr((String)"Did not catch expected JAXRPCException");
            pass = false;
        }
        catch (JAXRPCException e) {
            TestUtil.logMsg((String)"Caught expected JAXRPCException");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("GetOutputParamsTest1 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("GetOutputParamsTest1 failed");
        }
    }

    public void GetOutputParamsTest2() throws EETest.Fault {
        TestUtil.logTrace((String)"GetOutputParamsTest2");
        boolean pass = true;
        String expected = "passed";
        try {
            TestUtil.logMsg((String)"Initialize rest of Call object");
            this.call.setTargetEndpointAddress(this.url);
            boolean b = this.call.isParameterAndReturnSpecRequired(new QName("http://helloservice.org/wsdl", "invokeTest3"));
            if (b) {
                this.call.setReturnType(this.QNAME_TYPE_STRING);
            }
            this.call.setOperationName(new QName("http://helloservice.org/wsdl", "invokeTest3"));
            String response = (String)this.call.invoke(new Object[0]);
            Map map = this.call.getOutputParams();
            if (!map.isEmpty()) {
                TestUtil.logErr((String)"getOutputParams() did not return empty Map");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("GetOutputParamsTest2 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("GetOutputParamsTest2 failed");
        }
    }
}

