/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.enums;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.enums.Order;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.persistence.AccessType;
import javax.persistence.CacheRetrieveMode;
import javax.persistence.CacheStoreMode;
import javax.persistence.CascadeType;
import javax.persistence.DiscriminatorType;
import javax.persistence.EntityManager;
import javax.persistence.EnumType;
import javax.persistence.FetchType;
import javax.persistence.FlushModeType;
import javax.persistence.GenerationType;
import javax.persistence.InheritanceType;
import javax.persistence.LockModeType;
import javax.persistence.ParameterMode;
import javax.persistence.PersistenceContextType;
import javax.persistence.PessimisticLockScope;
import javax.persistence.Query;
import javax.persistence.SharedCacheMode;
import javax.persistence.SynchronizationType;
import javax.persistence.TemporalType;
import javax.persistence.TypedQuery;
import javax.persistence.ValidationMode;
import javax.persistence.criteria.JoinType;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.Bindable;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.Type;
import javax.persistence.spi.LoadState;
import javax.persistence.spi.PersistenceUnitTransactionType;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void accessTypeValueOfTest() throws EETest.Fault {
        boolean pass = true;
        try {
            AccessType at = AccessType.valueOf((String)AccessType.FIELD.name());
            if (!at.equals((Object)AccessType.FIELD)) {
                TestUtil.logErr((String)("expected:" + AccessType.FIELD.name() + ", actual:" + at.name()));
                pass = false;
            }
            if (!(at = AccessType.valueOf((String)AccessType.PROPERTY.name())).equals((Object)AccessType.PROPERTY)) {
                TestUtil.logErr((String)("expected:" + AccessType.PROPERTY.name() + ", actual:" + at.name()));
                pass = false;
            }
            try {
                AccessType.valueOf((String)"DOESNOTEXIST");
                TestUtil.logErr((String)"IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected IllegalArgumentException");
            }
            try {
                AccessType.valueOf(null);
                TestUtil.logErr((String)"NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                TestUtil.logTrace((String)"Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("accessTypeValueOfTest failed");
        }
    }

    public void accessTypeValuesTest() throws EETest.Fault {
        boolean pass = true;
        TestUtil.logTrace((String)"Begin accessTypeValuesTest");
        try {
            List<AccessType> at = Arrays.asList(AccessType.values());
            if (at.size() != 2) {
                TestUtil.logErr((String)("Number of AccessType expected:2, actual:" + at.size()));
                pass = false;
            }
            if (at.contains(AccessType.FIELD)) {
                TestUtil.logTrace((String)("received:" + AccessType.FIELD.name()));
            } else {
                TestUtil.logErr((String)("Expected value:" + AccessType.FIELD.name()));
                pass = false;
            }
            if (at.contains(AccessType.PROPERTY)) {
                TestUtil.logTrace((String)("received:" + AccessType.PROPERTY.name()));
            } else {
                TestUtil.logErr((String)("Expected value:" + AccessType.PROPERTY.name()));
                pass = false;
            }
            for (AccessType a : at) {
                try {
                    AccessType.valueOf((String)a.name());
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Received exception for valueOf", (Throwable)e);
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("accessTypeValuesTest failed");
        }
    }

    public void cacheRetrieveModeValueOfTest() throws EETest.Fault {
        boolean pass = true;
        TestUtil.logTrace((String)"Begin cacheRetrieveModeValueOfTest");
        try {
            CacheRetrieveMode crm = CacheRetrieveMode.valueOf((String)CacheRetrieveMode.USE.name());
            if (!crm.equals((Object)CacheRetrieveMode.USE)) {
                TestUtil.logErr((String)("expected:" + CacheRetrieveMode.USE.name() + ", actual:" + crm.name()));
                pass = false;
            }
            if (!(crm = CacheRetrieveMode.valueOf((String)CacheRetrieveMode.BYPASS.name())).equals((Object)CacheRetrieveMode.BYPASS)) {
                TestUtil.logErr((String)("expected:" + CacheRetrieveMode.BYPASS.name() + ", actual:" + crm.name()));
                pass = false;
            }
            try {
                CacheRetrieveMode.valueOf((String)"DOESNOTEXIST");
                TestUtil.logErr((String)"IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected IllegalArgumentException");
            }
            try {
                CacheRetrieveMode.valueOf(null);
                TestUtil.logErr((String)"NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                TestUtil.logTrace((String)"Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("cacheRetrieveModeValueOfTest failed");
        }
    }

    public void cacheRetrieveModeValuesTest() throws EETest.Fault {
        boolean pass = true;
        TestUtil.logTrace((String)"Begin cacheRetrieveModeValuesTest");
        try {
            List<CacheRetrieveMode> crm = Arrays.asList(CacheRetrieveMode.values());
            if (crm.size() != 2) {
                TestUtil.logErr((String)("Number of CacheRetrieveMode expected:2, actual:" + crm.size()));
                pass = false;
            }
            if (crm.contains(CacheRetrieveMode.USE)) {
                TestUtil.logTrace((String)("received:" + CacheRetrieveMode.USE));
            } else {
                TestUtil.logErr((String)("Expected value:" + CacheRetrieveMode.USE));
                pass = false;
            }
            if (crm.contains(CacheRetrieveMode.BYPASS)) {
                TestUtil.logTrace((String)("received:" + CacheRetrieveMode.BYPASS));
            } else {
                TestUtil.logErr((String)("Expected value:" + CacheRetrieveMode.BYPASS));
                pass = false;
            }
            for (CacheRetrieveMode c : crm) {
                try {
                    CacheRetrieveMode.valueOf((String)c.name());
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Received exception for valueOf", (Throwable)e);
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("cacheRetrieveModeValuesTest failed");
        }
    }

    public void cacheStoreModeValueOfTest() throws EETest.Fault {
        boolean pass = true;
        TestUtil.logTrace((String)"Begin cacheStoreModeValueOfTest");
        try {
            CacheStoreMode csm = CacheStoreMode.valueOf((String)CacheStoreMode.USE.name());
            if (!csm.equals((Object)CacheStoreMode.USE)) {
                TestUtil.logErr((String)("expected:" + CacheStoreMode.USE.name() + ", actual:" + csm.name()));
                pass = false;
            }
            if (!(csm = CacheStoreMode.valueOf((String)CacheStoreMode.BYPASS.name())).equals((Object)CacheStoreMode.BYPASS)) {
                TestUtil.logErr((String)("expected:" + CacheStoreMode.BYPASS.name() + ", actual:" + csm.name()));
                pass = false;
            }
            if (!(csm = CacheStoreMode.valueOf((String)CacheStoreMode.REFRESH.name())).equals((Object)CacheStoreMode.REFRESH)) {
                TestUtil.logErr((String)("expected:" + CacheStoreMode.REFRESH.name() + ", actual:" + csm.name()));
                pass = false;
            }
            try {
                CacheStoreMode.valueOf((String)"DOESNOTEXIST");
                TestUtil.logErr((String)"IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected IllegalArgumentException");
            }
            try {
                CacheStoreMode.valueOf(null);
                TestUtil.logErr((String)"NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                TestUtil.logTrace((String)"Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("cacheStoreModeValueOfTest failed");
        }
    }

    public void cacheStoreModeValuesTest() throws EETest.Fault {
        boolean pass = true;
        TestUtil.logTrace((String)"Begin cacheStoreModeValuesTest");
        try {
            List<CacheStoreMode> csm = Arrays.asList(CacheStoreMode.values());
            if (csm.size() != 3) {
                TestUtil.logErr((String)("Number of CacheStoreMode expected:3, actual:" + csm.size()));
                pass = false;
            }
            if (csm.contains(CacheStoreMode.USE)) {
                TestUtil.logTrace((String)("received:" + CacheStoreMode.USE));
            } else {
                TestUtil.logErr((String)("Expected value:" + CacheStoreMode.USE));
                pass = false;
            }
            if (csm.contains(CacheStoreMode.BYPASS)) {
                TestUtil.logTrace((String)("received:" + CacheStoreMode.BYPASS));
            } else {
                TestUtil.logErr((String)("Expected value:" + CacheStoreMode.BYPASS));
                pass = false;
            }
            if (csm.contains(CacheStoreMode.REFRESH)) {
                TestUtil.logTrace((String)("received:" + CacheStoreMode.REFRESH));
            } else {
                TestUtil.logErr((String)("Expected value:" + CacheStoreMode.REFRESH));
                pass = false;
            }
            for (CacheStoreMode c : csm) {
                try {
                    CacheStoreMode.valueOf((String)c.name());
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Received exception for valueOf", (Throwable)e);
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("cacheStoreModeValuesTest failed");
        }
    }

    public void cascadeTypeValueOfTest() throws EETest.Fault {
        boolean pass = true;
        TestUtil.logTrace((String)"Begin cascadeTypeValueOfTest");
        try {
            CascadeType ct = CascadeType.valueOf((String)CascadeType.ALL.name());
            if (!ct.equals((Object)CascadeType.ALL)) {
                TestUtil.logErr((String)("expected:" + CascadeType.ALL.name() + ", actual:" + ct.name()));
                pass = false;
            }
            if (!(ct = CascadeType.valueOf((String)CascadeType.DETACH.name())).equals((Object)CascadeType.DETACH)) {
                TestUtil.logErr((String)("expected:" + CascadeType.DETACH.name() + ", actual:" + ct.name()));
                pass = false;
            }
            if (!(ct = CascadeType.valueOf((String)CascadeType.MERGE.name())).equals((Object)CascadeType.MERGE)) {
                TestUtil.logErr((String)("expected:" + CascadeType.MERGE.name() + ", actual:" + ct.name()));
                pass = false;
            }
            if (!(ct = CascadeType.valueOf((String)CascadeType.PERSIST.name())).equals((Object)CascadeType.PERSIST)) {
                TestUtil.logErr((String)("expected:" + CascadeType.PERSIST.name() + ", actual:" + ct.name()));
                pass = false;
            }
            if (!(ct = CascadeType.valueOf((String)CascadeType.REFRESH.name())).equals((Object)CascadeType.REFRESH)) {
                TestUtil.logErr((String)("expected:" + CascadeType.REFRESH.name() + ", actual:" + ct.name()));
                pass = false;
            }
            if (!(ct = CascadeType.valueOf((String)CascadeType.REMOVE.name())).equals((Object)CascadeType.REMOVE)) {
                TestUtil.logErr((String)("expected:" + CascadeType.REMOVE.name() + ", actual:" + ct.name()));
                pass = false;
            }
            try {
                CascadeType.valueOf((String)"DOESNOTEXIST");
                TestUtil.logErr((String)"IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected IllegalArgumentException");
            }
            try {
                CascadeType.valueOf(null);
                TestUtil.logErr((String)"NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                TestUtil.logTrace((String)"Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("cascadeTypeValueOfTest failed");
        }
    }

    public void cascadeTypeValuesTest() throws EETest.Fault {
        boolean pass = true;
        TestUtil.logTrace((String)"Begin cascadeTypeValuesTest");
        try {
            List<CascadeType> ct = Arrays.asList(CascadeType.values());
            if (ct.size() != 6) {
                TestUtil.logErr((String)("Number of CascadeType expected:6, actual:" + ct.size()));
                pass = false;
            }
            if (ct.contains(CascadeType.ALL)) {
                TestUtil.logTrace((String)("received:" + CascadeType.ALL));
            } else {
                TestUtil.logErr((String)("Expected value:" + CascadeType.ALL));
                pass = false;
            }
            if (ct.contains(CascadeType.DETACH)) {
                TestUtil.logTrace((String)("received:" + CascadeType.DETACH));
            } else {
                TestUtil.logErr((String)("Expected value:" + CascadeType.DETACH));
                pass = false;
            }
            if (ct.contains(CascadeType.MERGE)) {
                TestUtil.logTrace((String)("received:" + CascadeType.MERGE));
            } else {
                TestUtil.logErr((String)("Expected value:" + CascadeType.MERGE));
                pass = false;
            }
            if (ct.contains(CascadeType.PERSIST)) {
                TestUtil.logTrace((String)("received:" + CascadeType.PERSIST));
            } else {
                TestUtil.logErr((String)("Expected value:" + CascadeType.PERSIST));
                pass = false;
            }
            if (ct.contains(CascadeType.REFRESH)) {
                TestUtil.logTrace((String)("received:" + CascadeType.REFRESH));
            } else {
                TestUtil.logErr((String)("Expected value:" + CascadeType.REFRESH));
                pass = false;
            }
            if (ct.contains(CascadeType.REMOVE)) {
                TestUtil.logTrace((String)("received:" + CascadeType.REMOVE));
            } else {
                TestUtil.logErr((String)("Expected value:" + CascadeType.REMOVE));
                pass = false;
            }
            for (CascadeType c : ct) {
                try {
                    CascadeType.valueOf((String)c.name());
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Received exception for valueOf", (Throwable)e);
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("cascadeTypeValuesTest failed");
        }
    }

    public void discriminatorTypeValueOfTest() throws EETest.Fault {
        boolean pass = true;
        TestUtil.logTrace((String)"Begin discriminatorTypeValueOfTest");
        try {
            DiscriminatorType dt = DiscriminatorType.valueOf((String)DiscriminatorType.CHAR.name());
            if (!dt.equals((Object)DiscriminatorType.CHAR)) {
                TestUtil.logErr((String)("expected:" + DiscriminatorType.CHAR.name() + ", actual:" + dt.name()));
                pass = false;
            }
            if (!(dt = DiscriminatorType.valueOf((String)DiscriminatorType.INTEGER.name())).equals((Object)DiscriminatorType.INTEGER)) {
                TestUtil.logErr((String)("expected:" + DiscriminatorType.INTEGER.name() + ", actual:" + dt.name()));
                pass = false;
            }
            if (!(dt = DiscriminatorType.valueOf((String)DiscriminatorType.STRING.name())).equals((Object)DiscriminatorType.STRING)) {
                TestUtil.logErr((String)("expected:" + DiscriminatorType.STRING.name() + ", actual:" + dt.name()));
                pass = false;
            }
            try {
                DiscriminatorType.valueOf((String)"DOESNOTEXIST");
                TestUtil.logErr((String)"IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected IllegalArgumentException");
            }
            try {
                DiscriminatorType.valueOf(null);
                TestUtil.logErr((String)"NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                TestUtil.logTrace((String)"Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("discriminatorTypeValueOfTest failed");
        }
    }

    public void discriminatorTypeValuesTest() throws EETest.Fault {
        boolean pass = true;
        TestUtil.logTrace((String)"Begin discriminatorTypeValuesTest");
        try {
            List<DiscriminatorType> dt = Arrays.asList(DiscriminatorType.values());
            if (dt.size() != 3) {
                TestUtil.logErr((String)("Number of DiscriminatorType expected:3, actual:" + dt.size()));
                pass = false;
            }
            if (dt.contains(DiscriminatorType.CHAR)) {
                TestUtil.logTrace((String)("received:" + DiscriminatorType.CHAR));
            } else {
                TestUtil.logErr((String)("Expected value:" + DiscriminatorType.CHAR));
                pass = false;
            }
            if (dt.contains(DiscriminatorType.INTEGER)) {
                TestUtil.logTrace((String)("received:" + DiscriminatorType.INTEGER));
            } else {
                TestUtil.logErr((String)("Expected value:" + DiscriminatorType.INTEGER));
                pass = false;
            }
            if (dt.contains(DiscriminatorType.STRING)) {
                TestUtil.logTrace((String)("received:" + DiscriminatorType.STRING));
            } else {
                TestUtil.logErr((String)("Expected value:" + DiscriminatorType.STRING));
                pass = false;
            }
            for (DiscriminatorType d : dt) {
                try {
                    DiscriminatorType.valueOf((String)d.name());
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Received exception for valueOf", (Throwable)e);
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("discriminatorTypeValuesTest failed");
        }
    }

    public void enumTypeValueOfTest() throws EETest.Fault {
        boolean pass = true;
        TestUtil.logTrace((String)"Begin enumTypeValueOfTest");
        try {
            EnumType et = EnumType.valueOf((String)EnumType.ORDINAL.name());
            if (!et.equals((Object)EnumType.ORDINAL)) {
                TestUtil.logErr((String)("expected:" + EnumType.ORDINAL.name() + ", actual:" + et.name()));
                pass = false;
            }
            if (!(et = EnumType.valueOf((String)EnumType.STRING.name())).equals((Object)EnumType.STRING)) {
                TestUtil.logErr((String)("expected:" + EnumType.STRING.name() + ", actual:" + et.name()));
                pass = false;
            }
            try {
                EnumType.valueOf((String)"DOESNOTEXIST");
                TestUtil.logErr((String)"IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected IllegalArgumentException");
            }
            try {
                EnumType.valueOf(null);
                TestUtil.logErr((String)"NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                TestUtil.logTrace((String)"Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("enumTypeValueOfTest failed");
        }
    }

    public void enumTypeValuesTest() throws EETest.Fault {
        boolean pass = true;
        TestUtil.logTrace((String)"Begin enumTypeValuesTest");
        try {
            List<EnumType> et = Arrays.asList(EnumType.values());
            if (et.size() != 2) {
                TestUtil.logErr((String)("Number of EnumType expected:2, actual:" + et.size()));
                pass = false;
            }
            if (et.contains(EnumType.ORDINAL)) {
                TestUtil.logTrace((String)("received:" + EnumType.ORDINAL));
            } else {
                TestUtil.logErr((String)("Expected value:" + EnumType.ORDINAL));
                pass = false;
            }
            if (et.contains(EnumType.STRING)) {
                TestUtil.logTrace((String)("received:" + EnumType.STRING));
            } else {
                TestUtil.logErr((String)("Expected value:" + EnumType.STRING));
                pass = false;
            }
            for (EnumType e : et) {
                try {
                    EnumType.valueOf((String)e.name());
                }
                catch (Exception ex) {
                    TestUtil.logErr((String)"Received exception for valueOf", (Throwable)ex);
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("enumTypeValuesTest failed");
        }
    }

    public void fetchTypeValueOfTest() throws EETest.Fault {
        boolean pass = true;
        TestUtil.logTrace((String)"Begin fetchTypeValueOfTest");
        try {
            FetchType ft = FetchType.valueOf((String)FetchType.EAGER.name());
            if (!ft.equals((Object)FetchType.EAGER)) {
                TestUtil.logErr((String)("expected:" + FetchType.EAGER.name() + ", actual:" + ft.name()));
                pass = false;
            }
            if (!(ft = FetchType.valueOf((String)FetchType.LAZY.name())).equals((Object)FetchType.LAZY)) {
                TestUtil.logErr((String)("expected:" + FetchType.LAZY.name() + ", actual:" + ft.name()));
                pass = false;
            }
            try {
                FetchType.valueOf((String)"DOESNOTEXIST");
                TestUtil.logErr((String)"IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected IllegalArgumentException");
            }
            try {
                FetchType.valueOf(null);
                TestUtil.logErr((String)"NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                TestUtil.logTrace((String)"Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("fetchTypeValueOfTest failed");
        }
    }

    public void fetchTypeValuesTest() throws EETest.Fault {
        boolean pass = true;
        TestUtil.logTrace((String)"Begin fetchTypeValuesTest");
        try {
            List<FetchType> ft = Arrays.asList(FetchType.values());
            if (ft.size() != 2) {
                TestUtil.logErr((String)("Number of FetchType expected:2, actual:" + ft.size()));
                pass = false;
            }
            if (ft.contains(FetchType.EAGER)) {
                TestUtil.logTrace((String)("received:" + FetchType.EAGER));
            } else {
                TestUtil.logErr((String)("Expected value:" + FetchType.EAGER));
                pass = false;
            }
            if (ft.contains(FetchType.LAZY)) {
                TestUtil.logTrace((String)("received:" + FetchType.LAZY));
            } else {
                TestUtil.logErr((String)("Expected value:" + FetchType.LAZY));
                pass = false;
            }
            for (FetchType f : ft) {
                try {
                    FetchType.valueOf((String)f.name());
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Received exception for valueOf", (Throwable)e);
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("fetchTypeValuesTest failed");
        }
    }

    public void flushModeTypeValueOfTest() throws EETest.Fault {
        boolean pass = true;
        try {
            FlushModeType fmt = FlushModeType.valueOf((String)FlushModeType.AUTO.name());
            if (!fmt.equals((Object)FlushModeType.AUTO)) {
                TestUtil.logErr((String)("expected:" + FlushModeType.AUTO.name() + ", actual:" + fmt.name()));
                pass = false;
            }
            if (!(fmt = FlushModeType.valueOf((String)FlushModeType.COMMIT.name())).equals((Object)FlushModeType.COMMIT)) {
                TestUtil.logErr((String)("expected:" + FlushModeType.COMMIT.name() + ", actual:" + fmt.name()));
                pass = false;
            }
            try {
                FlushModeType.valueOf((String)"DOESNOTEXIST");
                TestUtil.logErr((String)"IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected IllegalArgumentException");
            }
            try {
                FlushModeType.valueOf(null);
                TestUtil.logErr((String)"NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                TestUtil.logTrace((String)"Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception: ", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("flushModeTypeValueOfTest failed");
        }
    }

    public void flushModeTypeValuesTest() throws EETest.Fault {
        boolean pass = true;
        boolean count = false;
        try {
            List<FlushModeType> fmt = Arrays.asList(FlushModeType.values());
            if (fmt.size() != 2) {
                TestUtil.logErr((String)("Number of FlushModeType expected:2, actual:" + fmt.size()));
                pass = false;
            }
            if (fmt.contains(FlushModeType.COMMIT)) {
                TestUtil.logTrace((String)("received:" + FlushModeType.COMMIT));
            } else {
                TestUtil.logErr((String)("Expected value:" + FlushModeType.COMMIT));
                pass = false;
            }
            if (fmt.contains(FlushModeType.AUTO)) {
                TestUtil.logTrace((String)("received:" + FlushModeType.AUTO));
            } else {
                TestUtil.logErr((String)("Expected value:" + FlushModeType.AUTO));
                pass = false;
            }
            for (FlushModeType f : fmt) {
                try {
                    FlushModeType.valueOf((String)f.name());
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Received exception for valueOf", (Throwable)e);
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception: ", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("flushModeTypeValuesTest failed");
        }
    }

    public void setgetFlushModeEntityManagerTest() throws EETest.Fault {
        boolean pass = true;
        try {
            EntityManager em = this.getEntityManager();
            TestUtil.logTrace((String)"Checking Default mode");
            FlushModeType fmt = em.getFlushMode();
            if (fmt.equals((Object)FlushModeType.AUTO)) {
                TestUtil.logTrace((String)"Checking COMMIT");
                em.setFlushMode(FlushModeType.COMMIT);
                fmt = em.getFlushMode();
                if (fmt.equals((Object)FlushModeType.COMMIT)) {
                    TestUtil.logTrace((String)"Checking AUTO");
                    em.setFlushMode(FlushModeType.AUTO);
                    fmt = em.getFlushMode();
                    if (!fmt.equals((Object)FlushModeType.AUTO)) {
                        TestUtil.logErr((String)("Expected a value of:" + FlushModeType.AUTO.name() + ", actual:" + fmt.name()));
                        pass = false;
                    }
                } else {
                    TestUtil.logErr((String)("Expected a value of:" + FlushModeType.COMMIT.name() + ", actual:" + fmt.name()));
                    pass = false;
                }
            } else {
                TestUtil.logErr((String)("Expected a default value of:" + FlushModeType.AUTO.name() + ", actual:" + fmt.name()));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("setgetFlushModeEntityManagerTest failed");
        }
    }

    public void setgetFlushModeTest() throws EETest.Fault {
        boolean pass = true;
        try {
            EntityManager em = this.getEntityManager();
            Query q = em.createQuery("SELECT o FROM Order o WHERE o.id = 1");
            TestUtil.logTrace((String)"Getting mode from query");
            FlushModeType fmt = q.getFlushMode();
            if (fmt.equals((Object)em.getFlushMode())) {
                TestUtil.logTrace((String)"Setting mode to return default mode");
                q.setFlushMode(fmt);
                TestUtil.logTrace((String)"Setting mode to FlushModeType.COMMIT");
                q.setFlushMode(FlushModeType.COMMIT);
                fmt = q.getFlushMode();
                if (fmt.equals((Object)FlushModeType.COMMIT)) {
                    TestUtil.logTrace((String)"Setting mode to FlushModeType.AUTO");
                    q.setFlushMode(FlushModeType.AUTO);
                    fmt = q.getFlushMode();
                    if (fmt.equals((Object)FlushModeType.AUTO)) {
                        TestUtil.logTrace((String)("Received expected FlushModeType:" + fmt.name()));
                    } else {
                        TestUtil.logErr((String)("Expected a value of:" + FlushModeType.AUTO.name() + ", actual:" + fmt.name()));
                        pass = false;
                    }
                } else {
                    TestUtil.logErr((String)("Expected a default value of:" + FlushModeType.COMMIT.name() + ", actual:" + fmt.name()));
                    pass = false;
                }
            } else {
                TestUtil.logErr((String)("Expected EntityManager value of:" + em.getFlushMode() + ", actual:" + fmt.name()));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("setgetFlushModeTest failed");
        }
    }

    public void setgetFlushModeTQTest() throws EETest.Fault {
        boolean pass = true;
        try {
            EntityManager em = this.getEntityManager();
            TypedQuery q = em.createQuery("SELECT o FROM Order o WHERE o.id = 1", Order.class);
            FlushModeType fmt = q.getFlushMode();
            if (fmt.equals((Object)em.getFlushMode())) {
                TestUtil.logTrace((String)"Setting mode to returned default mode");
                q.setFlushMode(fmt);
                TestUtil.logTrace((String)"Setting mode to FlushModeType.COMMIT");
                q.setFlushMode(FlushModeType.COMMIT);
                fmt = q.getFlushMode();
                if (fmt.equals((Object)FlushModeType.COMMIT)) {
                    TestUtil.logTrace((String)"Setting mode to FlushModeType.AUTO");
                    q.setFlushMode(FlushModeType.AUTO);
                    fmt = q.getFlushMode();
                    if (!fmt.equals((Object)FlushModeType.AUTO)) {
                        TestUtil.logErr((String)("Expected a value of:" + FlushModeType.AUTO.name() + ", actual:" + fmt.name()));
                        pass = false;
                    }
                } else {
                    TestUtil.logErr((String)("Expected a default value of:" + FlushModeType.COMMIT.name() + ", actual:" + fmt.name()));
                    pass = false;
                }
            } else {
                TestUtil.logErr((String)("Expected EntityManager value of:" + em.getFlushMode().name() + ", actual:" + fmt.name()));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("setgetFlushModeTQTest failed");
        }
    }

    public void generationTypeValueOfTest() throws EETest.Fault {
        boolean pass = true;
        try {
            GenerationType ft = GenerationType.valueOf((String)GenerationType.AUTO.name());
            if (!ft.equals((Object)GenerationType.AUTO)) {
                TestUtil.logErr((String)("expected:" + GenerationType.AUTO.name() + ", actual:" + ft.name()));
                pass = false;
            }
            if (!(ft = GenerationType.valueOf((String)GenerationType.IDENTITY.name())).equals((Object)GenerationType.IDENTITY)) {
                TestUtil.logErr((String)("expected:" + GenerationType.IDENTITY.name() + ", actual:" + ft.name()));
                pass = false;
            }
            if (!(ft = GenerationType.valueOf((String)GenerationType.SEQUENCE.name())).equals((Object)GenerationType.SEQUENCE)) {
                TestUtil.logErr((String)("expected:" + GenerationType.SEQUENCE.name() + ", actual:" + ft.name()));
                pass = false;
            }
            if (!(ft = GenerationType.valueOf((String)GenerationType.TABLE.name())).equals((Object)GenerationType.TABLE)) {
                TestUtil.logErr((String)("expected:" + GenerationType.TABLE.name() + ", actual:" + ft.name()));
                pass = false;
            }
            try {
                GenerationType.valueOf((String)"DOESNOTEXIST");
                TestUtil.logErr((String)"IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected IllegalArgumentException");
            }
            try {
                GenerationType.valueOf(null);
                TestUtil.logErr((String)"NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                TestUtil.logTrace((String)"Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("generationTypeValueOfTest failed");
        }
    }

    public void generationTypeValuesTest() throws EETest.Fault {
        boolean pass = true;
        try {
            List<GenerationType> gt = Arrays.asList(GenerationType.values());
            if (gt.size() != 4) {
                TestUtil.logErr((String)("Number of GenerationType expected:4, actual:" + gt.size()));
                pass = false;
            }
            if (gt.contains(GenerationType.AUTO)) {
                TestUtil.logTrace((String)("received:" + GenerationType.AUTO));
            } else {
                TestUtil.logErr((String)("Expected value:" + GenerationType.AUTO));
                pass = false;
            }
            if (gt.contains(GenerationType.IDENTITY)) {
                TestUtil.logTrace((String)("received:" + GenerationType.IDENTITY));
            } else {
                TestUtil.logErr((String)("Expected value:" + GenerationType.IDENTITY));
                pass = false;
            }
            if (gt.contains(GenerationType.SEQUENCE)) {
                TestUtil.logTrace((String)("received:" + GenerationType.SEQUENCE));
            } else {
                TestUtil.logErr((String)("Expected value:" + GenerationType.SEQUENCE));
                pass = false;
            }
            if (gt.contains(GenerationType.TABLE)) {
                TestUtil.logTrace((String)("received:" + GenerationType.TABLE));
            } else {
                TestUtil.logErr((String)("Expected value:" + GenerationType.TABLE));
                pass = false;
            }
            for (GenerationType g : gt) {
                try {
                    GenerationType.valueOf((String)g.name());
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Received exception for valueOf", (Throwable)e);
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("generationTypeValuesTest failed");
        }
    }

    public void inheritanceTypeValueOfTest() throws EETest.Fault {
        boolean pass = true;
        try {
            InheritanceType ft = InheritanceType.valueOf((String)InheritanceType.JOINED.name());
            if (!ft.equals((Object)InheritanceType.JOINED)) {
                TestUtil.logErr((String)("expected:" + InheritanceType.JOINED.name() + ", actual:" + ft.name()));
                pass = false;
            }
            if (!(ft = InheritanceType.valueOf((String)InheritanceType.SINGLE_TABLE.name())).equals((Object)InheritanceType.SINGLE_TABLE)) {
                TestUtil.logErr((String)("expected:" + InheritanceType.SINGLE_TABLE.name() + ", actual:" + ft.name()));
                pass = false;
            }
            if (!(ft = InheritanceType.valueOf((String)InheritanceType.TABLE_PER_CLASS.name())).equals((Object)InheritanceType.TABLE_PER_CLASS)) {
                TestUtil.logErr((String)("expected:" + InheritanceType.TABLE_PER_CLASS.name() + ", actual:" + ft.name()));
                pass = false;
            }
            try {
                InheritanceType.valueOf((String)"DOESNOTEXIST");
                TestUtil.logErr((String)"IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected IllegalArgumentException");
            }
            try {
                InheritanceType.valueOf(null);
                TestUtil.logErr((String)"NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                TestUtil.logTrace((String)"Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("inheritanceTypeValueOfTest failed");
        }
    }

    public void inheritanceTypeValuesTest() throws EETest.Fault {
        boolean pass = true;
        try {
            List<InheritanceType> it = Arrays.asList(InheritanceType.values());
            if (it.size() != 3) {
                TestUtil.logErr((String)("Number of InheritanceType expected:3, actual:" + it.size()));
                pass = false;
            }
            if (it.contains(InheritanceType.JOINED)) {
                TestUtil.logTrace((String)("received:" + InheritanceType.JOINED));
            } else {
                TestUtil.logErr((String)("Expected value:" + InheritanceType.JOINED));
                pass = false;
            }
            if (it.contains(InheritanceType.SINGLE_TABLE)) {
                TestUtil.logTrace((String)("received:" + InheritanceType.SINGLE_TABLE));
            } else {
                TestUtil.logErr((String)("Expected value:" + InheritanceType.SINGLE_TABLE));
                pass = false;
            }
            if (it.contains(InheritanceType.TABLE_PER_CLASS)) {
                TestUtil.logTrace((String)("received:" + InheritanceType.TABLE_PER_CLASS));
            } else {
                TestUtil.logErr((String)("Expected value:" + InheritanceType.TABLE_PER_CLASS));
                pass = false;
            }
            for (InheritanceType i : it) {
                try {
                    InheritanceType.valueOf((String)i.name());
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Received exception for valueOf", (Throwable)e);
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("inheritanceTypeValuesTest failed");
        }
    }

    public void lockModeTypeValueOfTest() throws EETest.Fault {
        boolean pass = true;
        try {
            LockModeType lm = LockModeType.valueOf((String)LockModeType.NONE.name());
            if (!lm.equals((Object)LockModeType.NONE)) {
                TestUtil.logErr((String)("expected:" + LockModeType.NONE + ", actual:" + lm.name()));
                pass = false;
            }
            if (!(lm = LockModeType.valueOf((String)LockModeType.OPTIMISTIC.name())).equals((Object)LockModeType.OPTIMISTIC)) {
                TestUtil.logErr((String)("expected:" + LockModeType.OPTIMISTIC.name() + ", actual:" + lm.name()));
                pass = false;
            }
            if (!(lm = LockModeType.valueOf((String)LockModeType.OPTIMISTIC_FORCE_INCREMENT.name())).equals((Object)LockModeType.OPTIMISTIC_FORCE_INCREMENT)) {
                TestUtil.logErr((String)("expected:" + LockModeType.OPTIMISTIC_FORCE_INCREMENT.name() + ", actual:" + lm.name()));
                pass = false;
            }
            if (!(lm = LockModeType.valueOf((String)LockModeType.PESSIMISTIC_READ.name())).equals((Object)LockModeType.PESSIMISTIC_READ)) {
                TestUtil.logErr((String)("expected:" + LockModeType.PESSIMISTIC_READ.name() + ", actual:" + lm.name()));
                pass = false;
            }
            if (!(lm = LockModeType.valueOf((String)LockModeType.PESSIMISTIC_WRITE.name())).equals((Object)LockModeType.PESSIMISTIC_WRITE)) {
                TestUtil.logErr((String)("expected:" + LockModeType.PESSIMISTIC_WRITE.name() + ", actual:" + lm.name()));
                pass = false;
            }
            if (!(lm = LockModeType.valueOf((String)LockModeType.READ.name())).equals((Object)LockModeType.READ)) {
                TestUtil.logErr((String)("expected:" + LockModeType.READ.name() + ", actual:" + lm.name()));
                pass = false;
            }
            if (!(lm = LockModeType.valueOf((String)LockModeType.WRITE.name())).equals((Object)LockModeType.WRITE)) {
                TestUtil.logErr((String)("expected:" + LockModeType.WRITE.name() + ", actual:" + lm.name()));
                pass = false;
            }
            try {
                LockModeType.valueOf((String)"DOESNOTEXIST");
                TestUtil.logErr((String)"IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected IllegalArgumentException");
            }
            try {
                LockModeType.valueOf(null);
                TestUtil.logErr((String)"NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                TestUtil.logTrace((String)"Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("lockModeTypeValueOfTest failed");
        }
    }

    public void lockModeTypeValuesTest() throws EETest.Fault {
        boolean pass = true;
        try {
            List<LockModeType> lm = Arrays.asList(LockModeType.values());
            if (lm.size() != 8) {
                TestUtil.logErr((String)("Number of LockModeTypes expected:8, actual:" + lm.size()));
                pass = false;
            }
            if (lm.contains(LockModeType.NONE)) {
                TestUtil.logTrace((String)("received:" + LockModeType.NONE));
            } else {
                TestUtil.logErr((String)("Expected value:" + LockModeType.NONE));
                pass = false;
            }
            if (lm.contains(LockModeType.OPTIMISTIC)) {
                TestUtil.logTrace((String)("received:" + LockModeType.OPTIMISTIC));
            } else {
                TestUtil.logErr((String)("Expected value:" + LockModeType.OPTIMISTIC));
                pass = false;
            }
            if (lm.contains(LockModeType.OPTIMISTIC_FORCE_INCREMENT)) {
                TestUtil.logTrace((String)("received:" + LockModeType.OPTIMISTIC_FORCE_INCREMENT));
            } else {
                TestUtil.logErr((String)("Expected value:" + LockModeType.OPTIMISTIC_FORCE_INCREMENT));
                pass = false;
            }
            if (lm.contains(LockModeType.PESSIMISTIC_FORCE_INCREMENT)) {
                TestUtil.logTrace((String)("received:" + LockModeType.PESSIMISTIC_FORCE_INCREMENT));
            } else {
                TestUtil.logErr((String)("Expected value:" + LockModeType.PESSIMISTIC_FORCE_INCREMENT));
                pass = false;
            }
            if (lm.contains(LockModeType.PESSIMISTIC_READ)) {
                TestUtil.logTrace((String)("received:" + LockModeType.PESSIMISTIC_READ));
            } else {
                TestUtil.logErr((String)("Expected value:" + LockModeType.PESSIMISTIC_READ));
                pass = false;
            }
            if (lm.contains(LockModeType.PESSIMISTIC_WRITE)) {
                TestUtil.logTrace((String)("received:" + LockModeType.PESSIMISTIC_WRITE));
            } else {
                TestUtil.logErr((String)("Expected value:" + LockModeType.PESSIMISTIC_WRITE));
                pass = false;
            }
            if (lm.contains(LockModeType.READ)) {
                TestUtil.logTrace((String)("received:" + LockModeType.READ));
            } else {
                TestUtil.logErr((String)("Expected value:" + LockModeType.READ));
                pass = false;
            }
            if (lm.contains(LockModeType.WRITE)) {
                TestUtil.logTrace((String)("received:" + LockModeType.WRITE));
            } else {
                TestUtil.logErr((String)("Expected value:" + LockModeType.WRITE));
                pass = false;
            }
            for (LockModeType l : lm) {
                try {
                    LockModeType.valueOf((String)l.name());
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Received exception for valueOf", (Throwable)e);
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("lockModeTypeValuesTest failed");
        }
    }

    public void persistenceContextTypeValueOfTest() throws EETest.Fault {
        boolean pass = true;
        try {
            PersistenceContextType pct = PersistenceContextType.valueOf((String)PersistenceContextType.EXTENDED.name());
            if (!pct.equals((Object)PersistenceContextType.EXTENDED)) {
                TestUtil.logErr((String)("expected:" + PersistenceContextType.EXTENDED.name() + ", actual:" + pct.name()));
                pass = false;
            }
            if (!(pct = PersistenceContextType.valueOf((String)PersistenceContextType.TRANSACTION.name())).equals((Object)PersistenceContextType.TRANSACTION)) {
                TestUtil.logErr((String)("expected:" + PersistenceContextType.TRANSACTION.name() + ", actual:" + pct.name()));
                pass = false;
            }
            try {
                PersistenceContextType.valueOf((String)"DOESNOTEXIST");
                TestUtil.logErr((String)"IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected IllegalArgumentException");
            }
            try {
                PersistenceContextType.valueOf(null);
                TestUtil.logErr((String)"NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                TestUtil.logTrace((String)"Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("persistenceContextTypeValueOfTest failed");
        }
    }

    public void persistenceContextTypeValuesTest() throws EETest.Fault {
        boolean pass = true;
        try {
            List<PersistenceContextType> pct = Arrays.asList(PersistenceContextType.values());
            if (pct.size() != 2) {
                TestUtil.logErr((String)("Number of PersistenceContextType expected:2, actual:" + pct.size()));
                pass = false;
            }
            if (pct.contains(PersistenceContextType.EXTENDED)) {
                TestUtil.logTrace((String)("received:" + PersistenceContextType.EXTENDED));
            } else {
                TestUtil.logErr((String)("Expected value:" + PersistenceContextType.EXTENDED));
                pass = false;
            }
            if (pct.contains(PersistenceContextType.TRANSACTION)) {
                TestUtil.logTrace((String)("received:" + PersistenceContextType.TRANSACTION));
            } else {
                TestUtil.logErr((String)("Expected value:" + PersistenceContextType.TRANSACTION));
                pass = false;
            }
            for (PersistenceContextType p : pct) {
                try {
                    PersistenceContextType.valueOf((String)p.name());
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Received exception for valueOf", (Throwable)e);
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("persistenceContextTypeValuesTest failed");
        }
    }

    public void pessimisticLockScopeValueOfTest() throws EETest.Fault {
        boolean pass = true;
        try {
            PessimisticLockScope pls = PessimisticLockScope.valueOf((String)PessimisticLockScope.EXTENDED.name());
            if (!pls.equals((Object)PessimisticLockScope.EXTENDED)) {
                TestUtil.logErr((String)("expected:" + PessimisticLockScope.EXTENDED.name() + ", actual:" + pls.name()));
                pass = false;
            }
            if (!(pls = PessimisticLockScope.valueOf((String)PessimisticLockScope.NORMAL.name())).equals((Object)PessimisticLockScope.NORMAL)) {
                TestUtil.logErr((String)("expected:" + PessimisticLockScope.NORMAL.name() + ", actual:" + pls.name()));
                pass = false;
            }
            try {
                PessimisticLockScope.valueOf((String)"DOESNOTEXIST");
                TestUtil.logErr((String)"IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected IllegalArgumentException");
            }
            try {
                PessimisticLockScope.valueOf(null);
                TestUtil.logErr((String)"NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                TestUtil.logTrace((String)"Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("pessimisticLockScopeValueOfTest failed");
        }
    }

    public void pessimisticLockScopeValuesTest() throws EETest.Fault {
        boolean pass = true;
        try {
            List<PessimisticLockScope> pls = Arrays.asList(PessimisticLockScope.values());
            if (pls.size() != 2) {
                TestUtil.logErr((String)("Number of PessimisticLockScope expected:2, actual:" + pls.size()));
                pass = false;
            }
            if (pls.contains(PessimisticLockScope.EXTENDED)) {
                TestUtil.logTrace((String)("received:" + PessimisticLockScope.EXTENDED));
            } else {
                TestUtil.logErr((String)("Expected value:" + PessimisticLockScope.EXTENDED));
                pass = false;
            }
            if (pls.contains(PessimisticLockScope.NORMAL)) {
                TestUtil.logTrace((String)("received:" + PessimisticLockScope.NORMAL));
            } else {
                TestUtil.logErr((String)("Expected value:" + PessimisticLockScope.NORMAL));
                pass = false;
            }
            for (PessimisticLockScope p : pls) {
                try {
                    PessimisticLockScope.valueOf((String)p.name());
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Received exception for valueOf", (Throwable)e);
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("pessimisticLockScopeValuesTest failed");
        }
    }

    public void sharedCacheModeValueOfTest() throws EETest.Fault {
        boolean pass = true;
        try {
            SharedCacheMode scm = SharedCacheMode.valueOf((String)SharedCacheMode.ALL.name());
            if (!scm.equals((Object)SharedCacheMode.ALL)) {
                TestUtil.logErr((String)("expected:" + SharedCacheMode.ALL.name() + ", actual:" + scm.name()));
                pass = false;
            }
            if (!(scm = SharedCacheMode.valueOf((String)SharedCacheMode.DISABLE_SELECTIVE.name())).equals((Object)SharedCacheMode.DISABLE_SELECTIVE)) {
                TestUtil.logErr((String)("expected:" + SharedCacheMode.DISABLE_SELECTIVE.name() + ", actual:" + scm.name()));
                pass = false;
            }
            if (!(scm = SharedCacheMode.valueOf((String)SharedCacheMode.ENABLE_SELECTIVE.name())).equals((Object)SharedCacheMode.ENABLE_SELECTIVE)) {
                TestUtil.logErr((String)("expected:" + SharedCacheMode.ENABLE_SELECTIVE.name() + ", actual:" + scm.name()));
                pass = false;
            }
            if (!(scm = SharedCacheMode.valueOf((String)SharedCacheMode.NONE.name())).equals((Object)SharedCacheMode.NONE)) {
                TestUtil.logErr((String)("expected:" + SharedCacheMode.NONE.name() + ", actual:" + scm.name()));
                pass = false;
            }
            if (!(scm = SharedCacheMode.valueOf((String)SharedCacheMode.UNSPECIFIED.name())).equals((Object)SharedCacheMode.UNSPECIFIED)) {
                TestUtil.logErr((String)("expected:" + SharedCacheMode.UNSPECIFIED.name() + ", actual:" + scm.name()));
                pass = false;
            }
            try {
                SharedCacheMode.valueOf((String)"DOESNOTEXIST");
                TestUtil.logErr((String)"IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected IllegalArgumentException");
            }
            try {
                SharedCacheMode.valueOf(null);
                TestUtil.logErr((String)"NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                TestUtil.logTrace((String)"Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("sharedCacheModeValueOfTest failed");
        }
    }

    public void sharedCacheModeValuesTest() throws EETest.Fault {
        boolean pass = true;
        try {
            List<SharedCacheMode> scm = Arrays.asList(SharedCacheMode.values());
            if (scm.size() != 5) {
                TestUtil.logErr((String)("Number of SharedCacheMode expected:5, actual:" + scm.size()));
                pass = false;
            }
            if (scm.contains(SharedCacheMode.ALL)) {
                TestUtil.logTrace((String)("received:" + SharedCacheMode.ALL));
            } else {
                TestUtil.logErr((String)("Expected value:" + SharedCacheMode.ALL));
                pass = false;
            }
            if (scm.contains(SharedCacheMode.DISABLE_SELECTIVE)) {
                TestUtil.logTrace((String)("received:" + SharedCacheMode.DISABLE_SELECTIVE));
            } else {
                TestUtil.logErr((String)("Expected value:" + SharedCacheMode.DISABLE_SELECTIVE));
                pass = false;
            }
            if (scm.contains(SharedCacheMode.ENABLE_SELECTIVE)) {
                TestUtil.logTrace((String)("received:" + SharedCacheMode.ENABLE_SELECTIVE));
            } else {
                TestUtil.logErr((String)("Expected value:" + SharedCacheMode.ENABLE_SELECTIVE));
                pass = false;
            }
            if (scm.contains(SharedCacheMode.NONE)) {
                TestUtil.logTrace((String)("received:" + SharedCacheMode.NONE));
            } else {
                TestUtil.logErr((String)("Expected value:" + SharedCacheMode.NONE));
                pass = false;
            }
            if (scm.contains(SharedCacheMode.UNSPECIFIED)) {
                TestUtil.logTrace((String)("received:" + SharedCacheMode.UNSPECIFIED));
            } else {
                TestUtil.logErr((String)("Expected value:" + SharedCacheMode.UNSPECIFIED));
                pass = false;
            }
            for (SharedCacheMode s : scm) {
                try {
                    SharedCacheMode.valueOf((String)s.name());
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Received exception for valueOf", (Throwable)e);
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("sharedCacheModeValuesTest failed");
        }
    }

    public void validationModeValueOfTest() throws EETest.Fault {
        boolean pass = true;
        try {
            ValidationMode vm = ValidationMode.valueOf((String)ValidationMode.CALLBACK.name());
            if (!vm.equals((Object)ValidationMode.CALLBACK)) {
                TestUtil.logErr((String)("expected:" + ValidationMode.CALLBACK.name() + ", actual:" + vm.name()));
                pass = false;
            }
            if (!(vm = ValidationMode.valueOf((String)ValidationMode.AUTO.name())).equals((Object)ValidationMode.AUTO)) {
                TestUtil.logErr((String)("expected:" + ValidationMode.AUTO.name() + ", actual:" + vm.name()));
                pass = false;
            }
            if (!(vm = ValidationMode.valueOf((String)ValidationMode.NONE.name())).equals((Object)ValidationMode.NONE)) {
                TestUtil.logErr((String)("expected:" + ValidationMode.NONE.name() + ", actual:" + vm.name()));
                pass = false;
            }
            try {
                ValidationMode.valueOf((String)"DOESNOTEXIST");
                TestUtil.logErr((String)"IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected IllegalArgumentException");
            }
            try {
                ValidationMode.valueOf(null);
                TestUtil.logErr((String)"NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                TestUtil.logTrace((String)"Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("validationModeValueOfTest failed");
        }
    }

    public void validationModeValuesTest() throws EETest.Fault {
        boolean pass = true;
        try {
            List<ValidationMode> vm = Arrays.asList(ValidationMode.values());
            if (vm.size() != 3) {
                TestUtil.logErr((String)("Number of ValidationMode expected:3, actual:" + vm.size()));
                pass = false;
            }
            if (vm.contains(ValidationMode.CALLBACK)) {
                TestUtil.logTrace((String)("received:" + ValidationMode.CALLBACK));
            } else {
                TestUtil.logErr((String)("Expected value:" + ValidationMode.CALLBACK));
                pass = false;
            }
            if (vm.contains(ValidationMode.AUTO)) {
                TestUtil.logTrace((String)("received:" + ValidationMode.AUTO));
            } else {
                TestUtil.logErr((String)("Expected value:" + ValidationMode.AUTO));
                pass = false;
            }
            if (vm.contains(ValidationMode.NONE)) {
                TestUtil.logTrace((String)("received:" + ValidationMode.NONE));
            } else {
                TestUtil.logErr((String)("Expected value:" + ValidationMode.NONE));
                pass = false;
            }
            for (ValidationMode v : vm) {
                try {
                    ValidationMode.valueOf((String)v.name());
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Received exception for valueOf", (Throwable)e);
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("validationModeValuesTest failed");
        }
    }

    public void temporalTypeValuesTest() throws EETest.Fault {
        boolean pass = true;
        List<TemporalType> tt = Arrays.asList(TemporalType.values());
        if (tt.size() != 3) {
            TestUtil.logErr((String)("Number of TemporalType expected:3, actual:" + tt.size()));
            pass = false;
        }
        if (tt.contains(TemporalType.DATE)) {
            TestUtil.logTrace((String)("received:" + TemporalType.DATE));
        } else {
            TestUtil.logErr((String)("Expected value:" + TemporalType.DATE));
            pass = false;
        }
        if (tt.contains(TemporalType.TIME)) {
            TestUtil.logTrace((String)("received:" + TemporalType.TIME));
        } else {
            TestUtil.logErr((String)("Expected value:" + TemporalType.TIME));
            pass = false;
        }
        if (tt.contains(TemporalType.TIMESTAMP)) {
            TestUtil.logTrace((String)("received:" + TemporalType.TIMESTAMP));
        } else {
            TestUtil.logErr((String)("Expected value:" + TemporalType.TIMESTAMP));
            pass = false;
        }
        for (TemporalType t : tt) {
            try {
                TemporalType.valueOf((String)t.name());
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Received exception for valueOf", (Throwable)e);
                pass = false;
            }
        }
        if (!pass) {
            throw new EETest.Fault("temporalTypeValuesTest failed");
        }
    }

    public void temporalTypeValueOfTest() throws EETest.Fault {
        boolean pass = true;
        try {
            TemporalType tt = TemporalType.valueOf((String)TemporalType.DATE.name());
            if (!tt.equals((Object)TemporalType.DATE)) {
                TestUtil.logErr((String)("expected:" + TemporalType.DATE.name() + ", actual:" + tt.name()));
                pass = false;
            }
            if (!(tt = TemporalType.valueOf((String)TemporalType.TIME.name())).equals((Object)TemporalType.TIME)) {
                TestUtil.logErr((String)("expected:" + TemporalType.TIME.name() + ", actual:" + tt.name()));
                pass = false;
            }
            if (!(tt = TemporalType.valueOf((String)TemporalType.TIMESTAMP.name())).equals((Object)TemporalType.TIMESTAMP)) {
                TestUtil.logErr((String)("expected:" + TemporalType.TIMESTAMP.name() + ", actual:" + tt.name()));
                pass = false;
            }
            try {
                TemporalType.valueOf((String)"DOESNOTEXIST");
                TestUtil.logErr((String)"IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected IllegalArgumentException");
            }
            try {
                TemporalType.valueOf(null);
                TestUtil.logErr((String)"NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                TestUtil.logTrace((String)"Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("temporalTypeValueOfTest failed");
        }
    }

    public void joinTypeValuesTest() throws EETest.Fault {
        boolean pass = true;
        List<JoinType> jt = Arrays.asList(JoinType.values());
        if (jt.size() != 3) {
            TestUtil.logErr((String)("Number of TemporalType expected:3, actual:" + jt.size()));
            pass = false;
        }
        if (jt.contains(JoinType.LEFT)) {
            TestUtil.logTrace((String)("received:" + JoinType.LEFT));
        } else {
            TestUtil.logErr((String)("Expected value:" + JoinType.LEFT));
            pass = false;
        }
        if (jt.contains(JoinType.INNER)) {
            TestUtil.logTrace((String)("received:" + JoinType.INNER));
        } else {
            TestUtil.logErr((String)("Expected value:" + JoinType.INNER));
            pass = false;
        }
        if (jt.contains(JoinType.RIGHT)) {
            TestUtil.logTrace((String)("received:" + JoinType.RIGHT));
        } else {
            TestUtil.logErr((String)("Expected value:" + JoinType.RIGHT));
            pass = false;
        }
        for (JoinType j : jt) {
            try {
                JoinType.valueOf((String)j.name());
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Received exception for valueOf", (Throwable)e);
                pass = false;
            }
        }
        if (!pass) {
            throw new EETest.Fault("joinTypeValuesTest failed");
        }
    }

    public void joinTypeValueOfTest() throws EETest.Fault {
        boolean pass = true;
        try {
            JoinType jt = JoinType.valueOf((String)JoinType.LEFT.name());
            if (!jt.equals((Object)JoinType.LEFT)) {
                TestUtil.logErr((String)("expected:" + JoinType.LEFT.name() + ", actual:" + jt.name()));
                pass = false;
            }
            if (!(jt = JoinType.valueOf((String)JoinType.INNER.name())).equals((Object)JoinType.INNER)) {
                TestUtil.logErr((String)("expected:" + JoinType.INNER.name() + ", actual:" + jt.name()));
                pass = false;
            }
            if (!(jt = JoinType.valueOf((String)JoinType.RIGHT.name())).equals((Object)JoinType.RIGHT)) {
                TestUtil.logErr((String)("expected:" + JoinType.RIGHT.name() + ", actual:" + jt.name()));
                pass = false;
            }
            try {
                JoinType.valueOf((String)"DOESNOTEXIST");
                TestUtil.logErr((String)"IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected IllegalArgumentException");
            }
            try {
                JoinType.valueOf(null);
                TestUtil.logErr((String)"NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                TestUtil.logTrace((String)"Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("joinTypeValueOfTest failed");
        }
    }

    public void persistentAttributeTypeValuesTest() throws EETest.Fault {
        boolean pass = true;
        List<Attribute.PersistentAttributeType> pat = Arrays.asList(Attribute.PersistentAttributeType.values());
        if (pat.size() != 7) {
            TestUtil.logErr((String)("Number of TemporalType expected:7, actual:" + pat.size()));
            pass = false;
        }
        if (pat.contains(Attribute.PersistentAttributeType.BASIC)) {
            TestUtil.logTrace((String)("received:" + Attribute.PersistentAttributeType.BASIC));
        } else {
            TestUtil.logErr((String)("Expected value:" + Attribute.PersistentAttributeType.BASIC));
            pass = false;
        }
        if (pat.contains(Attribute.PersistentAttributeType.ELEMENT_COLLECTION)) {
            TestUtil.logTrace((String)("received:" + Attribute.PersistentAttributeType.ELEMENT_COLLECTION));
        } else {
            TestUtil.logErr((String)("Expected value:" + Attribute.PersistentAttributeType.ELEMENT_COLLECTION));
            pass = false;
        }
        if (pat.contains(Attribute.PersistentAttributeType.EMBEDDED)) {
            TestUtil.logTrace((String)("received:" + Attribute.PersistentAttributeType.EMBEDDED));
        } else {
            TestUtil.logErr((String)("Expected value:" + Attribute.PersistentAttributeType.EMBEDDED));
            pass = false;
        }
        if (pat.contains(Attribute.PersistentAttributeType.MANY_TO_MANY)) {
            TestUtil.logTrace((String)("received:" + Attribute.PersistentAttributeType.MANY_TO_MANY));
        } else {
            TestUtil.logErr((String)("Expected value:" + Attribute.PersistentAttributeType.MANY_TO_MANY));
            pass = false;
        }
        if (pat.contains(Attribute.PersistentAttributeType.MANY_TO_ONE)) {
            TestUtil.logTrace((String)("received:" + Attribute.PersistentAttributeType.MANY_TO_ONE));
        } else {
            TestUtil.logErr((String)("Expected value:" + Attribute.PersistentAttributeType.MANY_TO_ONE));
            pass = false;
        }
        if (pat.contains(Attribute.PersistentAttributeType.ONE_TO_MANY)) {
            TestUtil.logTrace((String)("received:" + Attribute.PersistentAttributeType.ONE_TO_MANY));
        } else {
            TestUtil.logErr((String)("Expected value:" + Attribute.PersistentAttributeType.ONE_TO_MANY));
            pass = false;
        }
        if (pat.contains(Attribute.PersistentAttributeType.ONE_TO_ONE)) {
            TestUtil.logTrace((String)("received:" + Attribute.PersistentAttributeType.ONE_TO_ONE));
        } else {
            TestUtil.logErr((String)("Expected value:" + Attribute.PersistentAttributeType.ONE_TO_ONE));
            pass = false;
        }
        for (Attribute.PersistentAttributeType p : pat) {
            try {
                Attribute.PersistentAttributeType.valueOf((String)p.name());
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Received exception for valueOf", (Throwable)e);
                pass = false;
            }
        }
        if (!pass) {
            throw new EETest.Fault("persistentAttributeTypeValuesTest failed");
        }
    }

    public void persistentAttributeTypeValueOfTest() throws EETest.Fault {
        boolean pass = true;
        try {
            Attribute.PersistentAttributeType pat = Attribute.PersistentAttributeType.valueOf((String)Attribute.PersistentAttributeType.BASIC.name());
            if (!pat.equals((Object)Attribute.PersistentAttributeType.BASIC)) {
                TestUtil.logErr((String)("expected:" + Attribute.PersistentAttributeType.BASIC.name() + ", actual:" + pat.name()));
                pass = false;
            }
            if (!(pat = Attribute.PersistentAttributeType.valueOf((String)Attribute.PersistentAttributeType.ELEMENT_COLLECTION.name())).equals((Object)Attribute.PersistentAttributeType.ELEMENT_COLLECTION)) {
                TestUtil.logErr((String)("expected:" + Attribute.PersistentAttributeType.ELEMENT_COLLECTION.name() + ", actual:" + pat.name()));
                pass = false;
            }
            if (!(pat = Attribute.PersistentAttributeType.valueOf((String)Attribute.PersistentAttributeType.EMBEDDED.name())).equals((Object)Attribute.PersistentAttributeType.EMBEDDED)) {
                TestUtil.logErr((String)("expected:" + Attribute.PersistentAttributeType.EMBEDDED.name() + ", actual:" + pat.name()));
                pass = false;
            }
            if (!(pat = Attribute.PersistentAttributeType.valueOf((String)Attribute.PersistentAttributeType.MANY_TO_MANY.name())).equals((Object)Attribute.PersistentAttributeType.MANY_TO_MANY)) {
                TestUtil.logErr((String)("expected:" + Attribute.PersistentAttributeType.MANY_TO_MANY.name() + ", actual:" + pat.name()));
                pass = false;
            }
            if (!(pat = Attribute.PersistentAttributeType.valueOf((String)Attribute.PersistentAttributeType.MANY_TO_ONE.name())).equals((Object)Attribute.PersistentAttributeType.MANY_TO_ONE)) {
                TestUtil.logErr((String)("expected:" + Attribute.PersistentAttributeType.MANY_TO_ONE.name() + ", actual:" + pat.name()));
                pass = false;
            }
            if (!(pat = Attribute.PersistentAttributeType.valueOf((String)Attribute.PersistentAttributeType.ONE_TO_MANY.name())).equals((Object)Attribute.PersistentAttributeType.ONE_TO_MANY)) {
                TestUtil.logErr((String)("expected:" + Attribute.PersistentAttributeType.ONE_TO_MANY.name() + ", actual:" + pat.name()));
                pass = false;
            }
            if (!(pat = Attribute.PersistentAttributeType.valueOf((String)Attribute.PersistentAttributeType.ONE_TO_ONE.name())).equals((Object)Attribute.PersistentAttributeType.ONE_TO_ONE)) {
                TestUtil.logErr((String)("expected:" + Attribute.PersistentAttributeType.ONE_TO_ONE.name() + ", actual:" + pat.name()));
                pass = false;
            }
            try {
                Attribute.PersistentAttributeType.valueOf((String)"DOESNOTEXIST");
                TestUtil.logErr((String)"IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected IllegalArgumentException");
            }
            try {
                Attribute.PersistentAttributeType.valueOf(null);
                TestUtil.logErr((String)"NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                TestUtil.logTrace((String)"Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("persistentAttributeTypeValueOfTest failed");
        }
    }

    public void bindableTypeValuesTest() throws EETest.Fault {
        boolean pass = true;
        List<Bindable.BindableType> bt = Arrays.asList(Bindable.BindableType.values());
        if (bt.size() != 3) {
            TestUtil.logErr((String)("Number of TemporalType expected:3, actual:" + bt.size()));
            pass = false;
        }
        if (bt.contains(Bindable.BindableType.ENTITY_TYPE)) {
            TestUtil.logTrace((String)("received:" + Bindable.BindableType.ENTITY_TYPE.name()));
        } else {
            TestUtil.logErr((String)("Expected value:" + Bindable.BindableType.ENTITY_TYPE.name()));
            pass = false;
        }
        if (bt.contains(Bindable.BindableType.PLURAL_ATTRIBUTE)) {
            TestUtil.logTrace((String)("received:" + Bindable.BindableType.PLURAL_ATTRIBUTE.name()));
        } else {
            TestUtil.logErr((String)("Expected value:" + Bindable.BindableType.PLURAL_ATTRIBUTE.name()));
            pass = false;
        }
        if (bt.contains(Bindable.BindableType.SINGULAR_ATTRIBUTE)) {
            TestUtil.logTrace((String)("received:" + Bindable.BindableType.SINGULAR_ATTRIBUTE.name()));
        } else {
            TestUtil.logErr((String)("Expected value:" + Bindable.BindableType.SINGULAR_ATTRIBUTE.name()));
            pass = false;
        }
        for (Bindable.BindableType b : bt) {
            try {
                Bindable.BindableType.valueOf((String)b.name());
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Received exception for valueOf", (Throwable)e);
                pass = false;
            }
        }
        if (!pass) {
            throw new EETest.Fault("bindableTypeValuesTest failed");
        }
    }

    public void bindableTypeValueOfTest() throws EETest.Fault {
        boolean pass = true;
        try {
            Bindable.BindableType bt = Bindable.BindableType.valueOf((String)Bindable.BindableType.ENTITY_TYPE.name());
            if (!bt.equals((Object)Bindable.BindableType.ENTITY_TYPE)) {
                TestUtil.logErr((String)("expected:" + Bindable.BindableType.ENTITY_TYPE.name() + ", actual:" + bt.name()));
                pass = false;
            }
            if (!(bt = Bindable.BindableType.valueOf((String)Bindable.BindableType.PLURAL_ATTRIBUTE.name())).equals((Object)Bindable.BindableType.PLURAL_ATTRIBUTE)) {
                TestUtil.logErr((String)("expected:" + Bindable.BindableType.PLURAL_ATTRIBUTE.name() + ", actual:" + bt.name()));
                pass = false;
            }
            if (!(bt = Bindable.BindableType.valueOf((String)Bindable.BindableType.SINGULAR_ATTRIBUTE.name())).equals((Object)Bindable.BindableType.SINGULAR_ATTRIBUTE)) {
                TestUtil.logErr((String)("expected:" + Bindable.BindableType.SINGULAR_ATTRIBUTE.name() + ", actual:" + bt.name()));
                pass = false;
            }
            try {
                Bindable.BindableType.valueOf((String)"DOESNOTEXIST");
                TestUtil.logErr((String)"IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected IllegalArgumentException");
            }
            try {
                Bindable.BindableType.valueOf(null);
                TestUtil.logErr((String)"NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                TestUtil.logTrace((String)"Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("bindableTypeValueOfTest failed");
        }
    }

    public void collectionTypeValuesTest() throws EETest.Fault {
        boolean pass = true;
        List<PluralAttribute.CollectionType> ct = Arrays.asList(PluralAttribute.CollectionType.values());
        if (ct.size() != 4) {
            TestUtil.logErr((String)("Number of TemporalType expected:4, actual:" + ct.size()));
            pass = false;
        }
        if (ct.contains(PluralAttribute.CollectionType.COLLECTION)) {
            TestUtil.logTrace((String)("received:" + PluralAttribute.CollectionType.COLLECTION));
        } else {
            TestUtil.logErr((String)("Expected value:" + PluralAttribute.CollectionType.COLLECTION));
            pass = false;
        }
        if (ct.contains(PluralAttribute.CollectionType.LIST)) {
            TestUtil.logTrace((String)("received:" + PluralAttribute.CollectionType.LIST));
        } else {
            TestUtil.logErr((String)("Expected value:" + PluralAttribute.CollectionType.LIST));
            pass = false;
        }
        if (ct.contains(PluralAttribute.CollectionType.MAP)) {
            TestUtil.logTrace((String)("received:" + PluralAttribute.CollectionType.MAP));
        } else {
            TestUtil.logErr((String)("Expected value:" + PluralAttribute.CollectionType.MAP));
            pass = false;
        }
        if (ct.contains(PluralAttribute.CollectionType.SET)) {
            TestUtil.logTrace((String)("received:" + PluralAttribute.CollectionType.SET));
        } else {
            TestUtil.logErr((String)("Expected value:" + PluralAttribute.CollectionType.SET));
            pass = false;
        }
        for (PluralAttribute.CollectionType c : ct) {
            try {
                PluralAttribute.CollectionType.valueOf((String)c.name());
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Received exception for valueOf", (Throwable)e);
                pass = false;
            }
        }
        if (!pass) {
            throw new EETest.Fault("collectionTypeValuesTest failed");
        }
    }

    public void collectionTypeValueOfTest() throws EETest.Fault {
        boolean pass = true;
        try {
            PluralAttribute.CollectionType ct = PluralAttribute.CollectionType.valueOf((String)PluralAttribute.CollectionType.COLLECTION.name());
            if (!ct.equals((Object)PluralAttribute.CollectionType.COLLECTION)) {
                TestUtil.logErr((String)("expected:" + PluralAttribute.CollectionType.COLLECTION.name() + ", actual:" + ct.name()));
                pass = false;
            }
            if (!(ct = PluralAttribute.CollectionType.valueOf((String)PluralAttribute.CollectionType.LIST.name())).equals((Object)PluralAttribute.CollectionType.LIST)) {
                TestUtil.logErr((String)("expected:" + PluralAttribute.CollectionType.LIST.name() + ", actual:" + ct.name()));
                pass = false;
            }
            if (!(ct = PluralAttribute.CollectionType.valueOf((String)PluralAttribute.CollectionType.MAP.name())).equals((Object)PluralAttribute.CollectionType.MAP)) {
                TestUtil.logErr((String)("expected:" + PluralAttribute.CollectionType.MAP.name() + ", actual:" + ct.name()));
                pass = false;
            }
            if (!(ct = PluralAttribute.CollectionType.valueOf((String)PluralAttribute.CollectionType.SET.name())).equals((Object)PluralAttribute.CollectionType.SET)) {
                TestUtil.logErr((String)("expected:" + PluralAttribute.CollectionType.SET.name() + ", actual:" + ct.name()));
                pass = false;
            }
            try {
                PluralAttribute.CollectionType.valueOf((String)"DOESNOTEXIST");
                TestUtil.logErr((String)"IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected IllegalArgumentException");
            }
            try {
                PluralAttribute.CollectionType.valueOf(null);
                TestUtil.logErr((String)"NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                TestUtil.logTrace((String)"Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("collectionTypeValueOfTest failed");
        }
    }

    public void persistenceTypeValuesTest() throws EETest.Fault {
        boolean pass = true;
        List<Type.PersistenceType> pt = Arrays.asList(Type.PersistenceType.values());
        if (pt.size() != 4) {
            TestUtil.logErr((String)("Number of TemporalType expected:4, actual:" + pt.size()));
            pass = false;
        }
        if (pt.contains(Type.PersistenceType.BASIC)) {
            TestUtil.logTrace((String)("received:" + Type.PersistenceType.BASIC));
        } else {
            TestUtil.logErr((String)("Expected value:" + Type.PersistenceType.BASIC));
            pass = false;
        }
        if (pt.contains(Type.PersistenceType.EMBEDDABLE)) {
            TestUtil.logTrace((String)("received:" + Type.PersistenceType.EMBEDDABLE));
        } else {
            TestUtil.logErr((String)("Expected value:" + Type.PersistenceType.EMBEDDABLE));
            pass = false;
        }
        if (pt.contains(Type.PersistenceType.ENTITY)) {
            TestUtil.logTrace((String)("received:" + Type.PersistenceType.ENTITY));
        } else {
            TestUtil.logErr((String)("Expected value:" + Type.PersistenceType.ENTITY));
            pass = false;
        }
        if (pt.contains(Type.PersistenceType.MAPPED_SUPERCLASS)) {
            TestUtil.logTrace((String)("received:" + Type.PersistenceType.MAPPED_SUPERCLASS));
        } else {
            TestUtil.logErr((String)("Expected value:" + Type.PersistenceType.MAPPED_SUPERCLASS));
            pass = false;
        }
        for (Type.PersistenceType p : pt) {
            try {
                Type.PersistenceType.valueOf((String)p.name());
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Received exception for valueOf", (Throwable)e);
                pass = false;
            }
        }
        if (!pass) {
            throw new EETest.Fault("persistenceTypeValuesTest failed");
        }
    }

    public void persistenceTypeValueOfTest() throws EETest.Fault {
        boolean pass = true;
        try {
            Type.PersistenceType pt = Type.PersistenceType.valueOf((String)Type.PersistenceType.BASIC.name());
            if (!pt.equals((Object)Type.PersistenceType.BASIC)) {
                TestUtil.logErr((String)("expected:" + Type.PersistenceType.BASIC.name() + ", actual:" + pt.name()));
                pass = false;
            }
            if (!(pt = Type.PersistenceType.valueOf((String)Type.PersistenceType.EMBEDDABLE.name())).equals((Object)Type.PersistenceType.EMBEDDABLE)) {
                TestUtil.logErr((String)("expected:" + Type.PersistenceType.EMBEDDABLE.name() + ", actual:" + pt.name()));
                pass = false;
            }
            if (!(pt = Type.PersistenceType.valueOf((String)Type.PersistenceType.ENTITY.name())).equals((Object)Type.PersistenceType.ENTITY)) {
                TestUtil.logErr((String)("expected:" + Type.PersistenceType.ENTITY.name() + ", actual:" + pt.name()));
                pass = false;
            }
            if (!(pt = Type.PersistenceType.valueOf((String)Type.PersistenceType.MAPPED_SUPERCLASS.name())).equals((Object)Type.PersistenceType.MAPPED_SUPERCLASS)) {
                TestUtil.logErr((String)("expected:" + Type.PersistenceType.MAPPED_SUPERCLASS.name() + ", actual:" + pt.name()));
                pass = false;
            }
            try {
                Type.PersistenceType.valueOf((String)"DOESNOTEXIST");
                TestUtil.logErr((String)"IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected IllegalArgumentException");
            }
            try {
                Type.PersistenceType.valueOf(null);
                TestUtil.logErr((String)"NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                TestUtil.logTrace((String)"Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("persistenceTypeValueOfTest failed");
        }
    }

    public void loadStateValuesTest() throws EETest.Fault {
        boolean pass = true;
        List<LoadState> ls = Arrays.asList(LoadState.values());
        if (ls.size() != 3) {
            TestUtil.logErr((String)("Number of TemporalType expected:3, actual:" + ls.size()));
            pass = false;
        }
        if (ls.contains(LoadState.LOADED)) {
            TestUtil.logTrace((String)("received:" + LoadState.LOADED));
        } else {
            TestUtil.logErr((String)("Expected value:" + LoadState.LOADED));
            pass = false;
        }
        if (ls.contains(LoadState.NOT_LOADED)) {
            TestUtil.logTrace((String)("received:" + LoadState.NOT_LOADED));
        } else {
            TestUtil.logErr((String)("Expected value:" + LoadState.NOT_LOADED));
            pass = false;
        }
        if (ls.contains(LoadState.UNKNOWN)) {
            TestUtil.logTrace((String)("received:" + LoadState.UNKNOWN));
        } else {
            TestUtil.logErr((String)("Expected value:" + LoadState.UNKNOWN));
            pass = false;
        }
        for (LoadState l : ls) {
            try {
                LoadState.valueOf((String)l.name());
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Received exception for valueOf", (Throwable)e);
                pass = false;
            }
        }
        if (!pass) {
            throw new EETest.Fault("loadStateValuesTest failed");
        }
    }

    public void loadStateValueOfTest() throws EETest.Fault {
        boolean pass = true;
        try {
            LoadState ls = LoadState.valueOf((String)LoadState.LOADED.name());
            if (!ls.equals((Object)LoadState.LOADED)) {
                TestUtil.logErr((String)("expected:" + LoadState.LOADED.name() + ", actual:" + ls.name()));
                pass = false;
            }
            if (!(ls = LoadState.valueOf((String)LoadState.NOT_LOADED.name())).equals((Object)LoadState.NOT_LOADED)) {
                TestUtil.logErr((String)("expected:" + LoadState.NOT_LOADED.name() + ", actual:" + ls.name()));
                pass = false;
            }
            if (!(ls = LoadState.valueOf((String)LoadState.UNKNOWN.name())).equals((Object)LoadState.UNKNOWN)) {
                TestUtil.logErr((String)("expected:" + LoadState.UNKNOWN.name() + ", actual:" + ls.name()));
                pass = false;
            }
            try {
                LoadState.valueOf((String)"DOESNOTEXIST");
                TestUtil.logErr((String)"IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected IllegalArgumentException");
            }
            try {
                LoadState.valueOf(null);
                TestUtil.logErr((String)"NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                TestUtil.logTrace((String)"Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"Unexpected Exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("loadStateValueOfTest failed");
        }
    }

    public void persistenceUnitTransactionTypeValuesTest() throws EETest.Fault {
        boolean pass = true;
        List<PersistenceUnitTransactionType> putt = Arrays.asList(PersistenceUnitTransactionType.values());
        if (putt.size() != 2) {
            TestUtil.logErr((String)("Number of TemporalType expected:2, actual:" + putt.size()));
            pass = false;
        }
        if (putt.contains(PersistenceUnitTransactionType.JTA)) {
            TestUtil.logTrace((String)("received:" + PersistenceUnitTransactionType.JTA));
        } else {
            TestUtil.logErr((String)("Expected value:" + PersistenceUnitTransactionType.JTA));
            pass = false;
        }
        if (putt.contains(PersistenceUnitTransactionType.RESOURCE_LOCAL)) {
            TestUtil.logTrace((String)("received:" + PersistenceUnitTransactionType.RESOURCE_LOCAL));
        } else {
            TestUtil.logErr((String)("Expected value:" + PersistenceUnitTransactionType.RESOURCE_LOCAL));
            pass = false;
        }
        for (PersistenceUnitTransactionType p : putt) {
            try {
                PersistenceUnitTransactionType.valueOf((String)p.name());
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Received exception for valueOf", (Throwable)e);
                pass = false;
            }
        }
        if (!pass) {
            throw new EETest.Fault("persistenceUnitTransactionTypeValuesTest failed");
        }
    }

    public void persistenceUnitTransactionTypeValueOfTest() throws EETest.Fault {
        boolean pass = true;
        try {
            PersistenceUnitTransactionType putt = PersistenceUnitTransactionType.valueOf((String)PersistenceUnitTransactionType.JTA.name());
            if (!putt.equals((Object)PersistenceUnitTransactionType.JTA)) {
                TestUtil.logErr((String)("expected:" + PersistenceUnitTransactionType.JTA.name() + ", actual:" + putt.name()));
                pass = false;
            }
            if (!(putt = PersistenceUnitTransactionType.valueOf((String)PersistenceUnitTransactionType.RESOURCE_LOCAL.name())).equals((Object)PersistenceUnitTransactionType.RESOURCE_LOCAL)) {
                TestUtil.logErr((String)("expected:" + PersistenceUnitTransactionType.RESOURCE_LOCAL.name() + ", actual:" + putt.name()));
                pass = false;
            }
            try {
                PersistenceUnitTransactionType.valueOf((String)"DOESNOTEXIST");
                TestUtil.logErr((String)"IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected IllegalArgumentException");
            }
            try {
                PersistenceUnitTransactionType.valueOf(null);
                TestUtil.logErr((String)"NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                TestUtil.logTrace((String)"Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"Unexpected Exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("persistenceUnitTransactionTypeValueOfTest failed");
        }
    }

    public void parameterModeValuesTest() throws EETest.Fault {
        boolean pass = true;
        List<ParameterMode> cpm = Arrays.asList(ParameterMode.values());
        if (cpm.size() != 4) {
            TestUtil.logErr((String)("Number of TemporalType expected:4, actual:" + cpm.size()));
            pass = false;
        }
        if (cpm.contains(ParameterMode.IN)) {
            TestUtil.logTrace((String)("received:" + ParameterMode.IN));
        } else {
            TestUtil.logErr((String)("Expected value:" + ParameterMode.IN));
            pass = false;
        }
        if (cpm.contains(ParameterMode.INOUT)) {
            TestUtil.logTrace((String)("received:" + ParameterMode.INOUT));
        } else {
            TestUtil.logErr((String)("Expected value:" + ParameterMode.INOUT));
            pass = false;
        }
        if (cpm.contains(ParameterMode.OUT)) {
            TestUtil.logTrace((String)("received:" + ParameterMode.OUT));
        } else {
            TestUtil.logErr((String)("Expected value:" + ParameterMode.OUT));
            pass = false;
        }
        if (cpm.contains(ParameterMode.REF_CURSOR)) {
            TestUtil.logTrace((String)("received:" + ParameterMode.REF_CURSOR));
        } else {
            TestUtil.logErr((String)("Expected value:" + ParameterMode.REF_CURSOR));
            pass = false;
        }
        for (ParameterMode pm : cpm) {
            try {
                ParameterMode.valueOf((String)pm.name());
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Received Exception for valueOf", (Throwable)e);
                pass = false;
            }
        }
        if (!pass) {
            throw new EETest.Fault("parameterModeValuesTest failed");
        }
    }

    public void parameterModeValueOfTest() throws EETest.Fault {
        boolean pass = true;
        try {
            ParameterMode pm = ParameterMode.valueOf((String)ParameterMode.IN.name());
            if (!pm.equals((Object)ParameterMode.IN)) {
                TestUtil.logErr((String)("expected:" + ParameterMode.IN.name() + ", actual:" + pm.name()));
                pass = false;
            }
            if (!(pm = ParameterMode.valueOf((String)ParameterMode.INOUT.name())).equals((Object)ParameterMode.INOUT)) {
                TestUtil.logErr((String)("expected:" + ParameterMode.INOUT.name() + ", actual:" + pm.name()));
                pass = false;
            }
            if (!(pm = ParameterMode.valueOf((String)ParameterMode.OUT.name())).equals((Object)ParameterMode.OUT)) {
                TestUtil.logErr((String)("expected:" + ParameterMode.OUT.name() + ", actual:" + pm.name()));
                pass = false;
            }
            if (!(pm = ParameterMode.valueOf((String)ParameterMode.REF_CURSOR.name())).equals((Object)ParameterMode.REF_CURSOR)) {
                TestUtil.logErr((String)("expected:" + ParameterMode.REF_CURSOR.name() + ", actual:" + pm.name()));
                pass = false;
            }
            try {
                ParameterMode.valueOf((String)"DOESNOTEXIST");
                TestUtil.logErr((String)"IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected IllegalArgumentException");
            }
            try {
                ParameterMode.valueOf(null);
                TestUtil.logErr((String)"NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException npe) {
                TestUtil.logTrace((String)"Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"Unexpected Exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("parameterModeValueOfTest failed");
        }
    }

    public void synchronizationTypeValueOfTest() throws EETest.Fault {
        boolean pass = true;
        try {
            SynchronizationType st = SynchronizationType.valueOf((String)SynchronizationType.SYNCHRONIZED.name());
            if (!st.equals((Object)SynchronizationType.SYNCHRONIZED)) {
                TestUtil.logErr((String)("expected:" + SynchronizationType.SYNCHRONIZED.name() + ", actual:" + st.name()));
                pass = false;
            }
            if (!(st = SynchronizationType.valueOf((String)SynchronizationType.UNSYNCHRONIZED.name())).equals((Object)SynchronizationType.UNSYNCHRONIZED)) {
                TestUtil.logErr((String)("expected:" + SynchronizationType.UNSYNCHRONIZED.name() + ", actual:" + st.name()));
                pass = false;
            }
            try {
                SynchronizationType.valueOf((String)"DOESNOTEXIST");
                TestUtil.logErr((String)"IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected IllegalArgumentException");
            }
            try {
                SynchronizationType.valueOf(null);
                TestUtil.logErr((String)"NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                TestUtil.logTrace((String)"Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("synchronizationTypeValueOfTest failed");
        }
    }

    public void synchronizationTypeValuesTest() throws EETest.Fault {
        boolean pass = true;
        try {
            List<SynchronizationType> st = Arrays.asList(SynchronizationType.values());
            if (st.size() != 2) {
                TestUtil.logErr((String)("Number of SynchronizationType expected:2, actual:" + st.size()));
                pass = false;
            }
            if (st.contains(SynchronizationType.SYNCHRONIZED)) {
                TestUtil.logTrace((String)("received:" + SynchronizationType.SYNCHRONIZED));
            } else {
                TestUtil.logErr((String)("Expected value:" + SynchronizationType.SYNCHRONIZED));
                pass = false;
            }
            if (st.contains(SynchronizationType.UNSYNCHRONIZED)) {
                TestUtil.logTrace((String)("received:" + SynchronizationType.UNSYNCHRONIZED));
            } else {
                TestUtil.logErr((String)("Expected value:" + SynchronizationType.UNSYNCHRONIZED));
                pass = false;
            }
            for (SynchronizationType s : st) {
                try {
                    SynchronizationType.valueOf((String)s.name());
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Received exception for valueOf", (Throwable)e);
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("synchronizationTypeValuesTest failed");
        }
    }
}

