/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.types.field;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.types.common.Grade;
import com.sun.ts.tests.jpa.core.types.field.DataTypes;
import com.sun.ts.tests.jpa.core.types.field.DataTypes2;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.persistence.Query;

public class Client
extends PMClientBase {
    private DataTypes d1;
    private DataTypes2 d2;
    private final Date dateId = this.getPKDate(2006, 4, 15);
    private final java.sql.Date dateValue = this.getSQLDate(2006, 4, 15);

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void fieldTypeTest1() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                if (!this.d1.getBooleanData()) {
                    this.d1.setBooleanData(true);
                }
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                if (this.d1.getBooleanData()) {
                    pass = true;
                }
                this.getEntityTransaction().commit();
            } else {
                TestUtil.logErr((String)"EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("fieldTypeTest1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fieldTypeTest2() throws EETest.Fault {
        boolean pass = false;
        int newByte = 111;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                if (this.d1.getByteData() == 100) {
                    this.d1.setByteData((byte)111);
                }
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                if (this.d1.getByteData() == 111) {
                    pass = true;
                }
                this.getEntityTransaction().commit();
            } else {
                TestUtil.logErr((String)"EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("fieldTypeTest2 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fieldTypeTest3() throws EETest.Fault {
        boolean pass = false;
        int newChar = 98;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                if (this.d1.getCharacterData() == 'a') {
                    this.d1.setCharacterData('b');
                }
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                if (this.d1.getCharacterData() == 'b') {
                    pass = true;
                }
                this.getEntityTransaction().commit();
            } else {
                TestUtil.logErr((String)"EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("fieldTypeTest3 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fieldTypeTest4() throws EETest.Fault {
        boolean pass = false;
        int newShort = 101;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                if (this.d1.getShortData() == 100) {
                    this.d1.setShortData((short)101);
                }
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                if (this.d1.getShortData() == 101) {
                    pass = true;
                }
                this.getEntityTransaction().commit();
            } else {
                TestUtil.logErr((String)"EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception during Rollback:", (Throwable)re);
                pass = false;
            }
        }
        if (!pass) {
            throw new EETest.Fault("fieldTypeTest4 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fieldTypeTest5() throws EETest.Fault {
        boolean pass = false;
        int newInt = 500;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                if (this.d1.getIntData() == 300) {
                    this.d1.setIntData(500);
                }
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                if (this.d1.getIntData() == 500) {
                    pass = true;
                }
                this.getEntityTransaction().commit();
            } else {
                TestUtil.logErr((String)"EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("fieldTypeTest5 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fieldTypeTest6() throws EETest.Fault {
        boolean pass = false;
        long newLong = 600L;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                if (this.d1.getLongData() == 600L) {
                    this.d1.setLongData(600L);
                }
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                if (this.d1.getLongData() == 600L) {
                    pass = true;
                }
                this.getEntityTransaction().commit();
            } else {
                TestUtil.logErr((String)"EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("fieldTypeTest6 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fieldTypeTest7() throws EETest.Fault {
        boolean pass = false;
        double newDbl = 80.0;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                if (this.d1.getDoubleData() == 50.0) {
                    this.d1.setDoubleData(80.0);
                }
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                if (this.d1.getDoubleData() == 80.0) {
                    pass = true;
                }
                this.getEntityTransaction().commit();
            } else {
                TestUtil.logErr((String)"EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("fieldTypeTest7 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fieldTypeTest8() throws EETest.Fault {
        boolean pass = false;
        float expFloat = 1.0f;
        float floatRange = 2.0f;
        float newFloat = 6.0f;
        float newfloatRange = 7.0f;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                TestUtil.logTrace((String)("float value is: " + this.d1.getFloatData()));
                if (this.d1.getFloatData() >= 1.0f && this.d1.getFloatData() < 2.0f) {
                    this.d1.setFloatData(6.0f);
                }
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                if (this.d1.getFloatData() >= 6.0f && this.d1.getFloatData() < 7.0f) {
                    pass = true;
                }
                this.getEntityTransaction().commit();
            } else {
                TestUtil.logErr((String)"EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("fieldTypeTest8 failed");
        }
    }

    public void fieldTypeTest9() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"FIND D1");
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                TestUtil.logTrace((String)"DataTypes is not null, setting enumData");
                this.d1.setEnumData(Grade.B);
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                TestUtil.logTrace((String)"Update performed, check results");
                if (this.d1.getEnumData().equals((Object)Grade.B)) {
                    TestUtil.logTrace((String)"Expected results received");
                    pass = true;
                } else {
                    TestUtil.logErr((String)"Did not get expected results received");
                }
                this.getEntityTransaction().commit();
            } else {
                TestUtil.logErr((String)"EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("fieldTypeTest9 failed");
        }
    }

    public void fieldTypeTest10() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"FIND D2");
            this.d2 = (DataTypes2)this.getEntityManager().find(DataTypes2.class, (Object)this.dateId);
            if (null != this.d2) {
                if (this.d2.getId().equals(this.dateId)) {
                    TestUtil.logTrace((String)("Got expected PK of:" + this.d2.getId() + "received"));
                    pass = true;
                } else {
                    TestUtil.logErr((String)("Did not get expected results. Expected " + this.dateId + ", got: " + this.d2.getId()));
                }
                this.getEntityTransaction().commit();
            } else {
                TestUtil.logErr((String)"EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("fieldTypeTest10 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fieldTypeTest11() throws EETest.Fault {
        boolean pass = false;
        byte[] b = new byte[]{31, 32, 33, 63, 64, 65};
        int bv = 5;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"FIND D1");
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                TestUtil.logTrace((String)"DataType Entity is not null, setting byteData ");
                this.d1.setByteArrayData(b);
                byte[] a = this.d1.getByteArrayData();
                a[0] = (byte)(a[0] + 5);
                this.d1.setByteArrayData(b);
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                if (Arrays.equals(this.d1.getByteArrayData(), a)) {
                    TestUtil.logTrace((String)"Expected results received");
                    pass = true;
                } else {
                    TestUtil.logErr((String)"Unexpected result in array comparison.");
                    for (byte aa : a) {
                        TestUtil.logTrace((String)("Array a in propertyTest9 equals: " + aa));
                    }
                    for (byte bb : b) {
                        TestUtil.logTrace((String)("Array b in propertyTest9 equals: " + bb));
                    }
                    pass = false;
                }
                this.getEntityTransaction().commit();
            } else {
                TestUtil.logErr((String)"EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("fieldTypeTest11 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fieldTypeTest12() throws EETest.Fault {
        boolean pass = false;
        char[] charData = new char[]{'c', 't', 's'};
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"FIND D1");
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                TestUtil.logTrace((String)"DataType Entity is not null, setting charData ");
                this.d1.setCharArrayData(charData);
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                if (Arrays.equals(this.d1.getCharArrayData(), charData)) {
                    TestUtil.logTrace((String)"Expected Results Received");
                    pass = true;
                } else {
                    TestUtil.logErr((String)("Did not get expected results. Expected " + Arrays.toString(charData) + ", got: " + Arrays.toString(this.d1.getCharArrayData())));
                }
                this.getEntityTransaction().commit();
            } else {
                TestUtil.logErr((String)"EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("fieldTypeTest12 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fieldTypeTest13() throws EETest.Fault {
        boolean pass = false;
        Time timeValue = this.getTimeData(18, 30, 15);
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"FIND D2");
            this.d2 = (DataTypes2)this.getEntityManager().find(DataTypes2.class, (Object)this.dateId);
            if (null != this.d2) {
                TestUtil.logTrace((String)"DataType Entity is not null, setting TimeData ");
                this.d2.setTimeData(timeValue);
                this.getEntityManager().merge((Object)this.d2);
                this.getEntityManager().flush();
                if (this.d2.getTimeData().equals(timeValue)) {
                    TestUtil.logTrace((String)"Expected Time Received");
                    pass = true;
                } else {
                    TestUtil.logErr((String)("Did not get expected results.  Expected " + timeValue + " , got: " + this.d2.getTimeData()));
                }
                this.getEntityTransaction().commit();
            } else {
                TestUtil.logErr((String)"EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("fieldTypeTest13 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fieldTypeTest14() throws EETest.Fault {
        boolean pass = false;
        Timestamp tsValue = this.getTimestampData(2006, 2, 11);
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"FIND D2");
            this.d2 = (DataTypes2)this.getEntityManager().find(DataTypes2.class, (Object)this.dateId);
            if (null != this.d2) {
                TestUtil.logTrace((String)"DataType Entity is not null, setting TimestampData ");
                this.d2.setTsData(tsValue);
                this.getEntityManager().merge((Object)this.d2);
                this.getEntityManager().flush();
                if (this.d2.getTsData().equals(tsValue)) {
                    TestUtil.logTrace((String)"Expected Timestamp Received");
                    pass = true;
                } else {
                    TestUtil.logErr((String)("Did not get expected results.  Expected " + tsValue + " , got: " + this.d2.getTsData()));
                }
                this.getEntityTransaction().commit();
            } else {
                TestUtil.logErr((String)"EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("fieldTypeTest14 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fieldTypeTest15() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                this.d1.setEnumData(Grade.A);
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                Query q = this.getEntityManager().createQuery("SELECT dt FROM DataTypes dt WHERE dt.enumData = com.sun.ts.tests.jpa.core.types.common.Grade.A");
                DataTypes result = (DataTypes)q.getSingleResult();
                if (this.d1 == result) {
                    pass = true;
                    TestUtil.logTrace((String)"Expected results received");
                } else {
                    TestUtil.logErr((String)"Did not get expected results.");
                    pass = false;
                }
                this.getEntityTransaction().commit();
            } else {
                TestUtil.logErr((String)"EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("fieldTypeTest15 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fieldTypeTest16() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                this.d1.setEnumData(Grade.A);
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                Query q = this.getEntityManager().createQuery("SELECT dt FROM DataTypes dt WHERE dt.enumData = :grade").setParameter("grade", (Object)Grade.A);
                DataTypes result = (DataTypes)q.getSingleResult();
                if (this.d1 == result) {
                    pass = true;
                    TestUtil.logTrace((String)"Expected results received");
                } else {
                    TestUtil.logErr((String)"Did not get expected results.");
                    pass = false;
                }
                this.getEntityTransaction().commit();
            } else {
                TestUtil.logErr((String)"EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("fieldTypeTest16 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fieldTypeTest17() throws EETest.Fault {
        boolean pass = false;
        Grade failingGrade = Grade.F;
        Grade incompleteGrade = Grade.INCOMPLETE;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                this.d1.setEnumData(Grade.C);
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                Query q = this.getEntityManager().createQuery("SELECT dt FROM DataTypes dt WHERE (dt.enumData <> ?1) OR (dt.enumData <> ?2) ").setParameter(1, (Object)failingGrade).setParameter(2, (Object)incompleteGrade);
                DataTypes result = (DataTypes)q.getSingleResult();
                if (this.d1 == result) {
                    pass = true;
                    TestUtil.logTrace((String)"Expected results received");
                } else {
                    TestUtil.logErr((String)"Did not get expected results.");
                    pass = false;
                }
                this.getEntityTransaction().commit();
            } else {
                TestUtil.logErr((String)"EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("fieldTypeTest17 failed");
        }
    }

    public void scalarExpressionsTest() throws EETest.Fault {
        DataTypes d;
        List p;
        char expected;
        boolean pass5 = false;
        boolean pass4 = false;
        boolean pass3 = false;
        boolean pass2 = false;
        boolean pass1 = false;
        try {
            this.getEntityTransaction().begin();
            expected = this.d1.getIntData() + 1;
            TestUtil.logTrace((String)"Testing arithmetic expression:");
            p = this.getEntityManager().createQuery("Select d From DataTypes d where ((d.intData + 1) = ?1)").setParameter(1, (Object)expected).getResultList();
            if (p.size() == 1) {
                d = (DataTypes)p.get(0);
                TestUtil.logTrace((String)("DataType:" + d.toString()));
                int actual = d.getIntData() + 1;
                if (actual == expected) {
                    TestUtil.logTrace((String)("Received expected Integer data:" + actual));
                    pass1 = true;
                } else {
                    TestUtil.logErr((String)("Did not get expected result, Expected: " + expected + ", actual:" + actual));
                }
            } else {
                TestUtil.logErr((String)("Did not get expected number of results, expected:1, actual:" + p.size()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            this.getEntityTransaction().begin();
            expected = 'a';
            TestUtil.logTrace((String)"Testing string expression:");
            p = this.getEntityManager().createQuery("Select d From DataTypes d where (d.characterData = ?1)").setParameter(1, (Object)Character.valueOf(expected)).getResultList();
            if (p.size() == 1) {
                d = (DataTypes)p.get(0);
                TestUtil.logTrace((String)("DataType:" + d.toString()));
                Character actual = Character.valueOf(d.getCharacterData());
                if (actual.equals(Character.valueOf(expected))) {
                    TestUtil.logTrace((String)("Received expected Character data:" + actual));
                    pass2 = true;
                } else {
                    TestUtil.logErr((String)("Did not get expected result, Expected: " + expected + ", actual:" + actual));
                }
            } else {
                TestUtil.logErr((String)("Did not get expected number of results, expected:1, actual:" + p.size()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            this.getEntityTransaction().begin();
            Grade expected2 = Grade.C;
            TestUtil.logTrace((String)"Testing enum expression:");
            p = this.getEntityManager().createQuery("Select d From DataTypes d where (d.enumData = ?1)").setParameter(1, (Object)expected2).getResultList();
            if (p.size() == 1) {
                d = (DataTypes)p.get(0);
                TestUtil.logTrace((String)("DataType:" + d.toString()));
                Grade actual = d.getEnumData();
                if (actual.equals((Object)expected2)) {
                    TestUtil.logTrace((String)("Received expected Enum data:" + actual));
                    pass3 = true;
                } else {
                    TestUtil.logErr((String)("Did not get expected result, Expected: " + expected2 + ", actual:" + actual));
                }
            } else {
                TestUtil.logErr((String)("Did not get expected number of results, expected:1, actual:" + p.size()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            Date dateValue = this.getPKDate(2006, 1, 1);
            Date expected3 = this.dateId;
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Testing datetime expression:");
            List pp = this.getEntityManager().createQuery("Select d From DataTypes2 d where (d.dateData > ?1)").setParameter(1, (Object)dateValue).getResultList();
            if (pp.size() == 1) {
                DataTypes2 d2 = (DataTypes2)pp.get(0);
                TestUtil.logTrace((String)("DataType2:" + d2.toString()));
                Date actual = d2.getDateData();
                if (actual.equals(expected3)) {
                    TestUtil.logTrace((String)("Received expected Date data:" + actual));
                    pass4 = true;
                } else {
                    TestUtil.logErr((String)("Did not get expected result, Expected: " + expected3 + ", actual:" + actual));
                }
            } else {
                TestUtil.logErr((String)("Did not get expected number of results, expected:1, actual:" + pp.size()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            this.getEntityTransaction().begin();
            boolean expected4 = false;
            TestUtil.logTrace((String)"Testing boolean expression:");
            p = this.getEntityManager().createQuery("Select d From DataTypes d where (d.booleanData = ?1)").setParameter(1, (Object)expected4).getResultList();
            if (p.size() > 0) {
                d = (DataTypes)p.get(0);
                TestUtil.logTrace((String)("DataType:" + d.toString()));
                Boolean actual = d.getBooleanData();
                if (actual.equals(expected4)) {
                    TestUtil.logTrace((String)("Received expected Boolean data:" + actual));
                    pass5 = true;
                } else {
                    TestUtil.logErr((String)("Did not get expected result, Expected: " + expected4 + ", actual:" + actual));
                }
            } else {
                TestUtil.logErr((String)("Did not get expected number of results, expected:1, actual:" + p.size()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!(pass1 && pass2 && pass3 && pass4 && pass5)) {
            throw new EETest.Fault("scalarExpressionsTest failed");
        }
    }

    public void createTestData() {
        try {
            this.getEntityTransaction().begin();
            char[] cArray = new char[]{'a'};
            byte[] bArray = new byte[]{100};
            this.d1 = new DataTypes(1, false, 100, 'a', 100, 300, 600L, 50.0, 1.0f, cArray, bArray);
            this.d1.setEnumData(Grade.C);
            TestUtil.logTrace((String)("dateId is: " + this.dateId));
            this.d2 = new DataTypes2(this.dateId);
            this.d2.setDateData((Date)this.dateValue);
            this.getEntityManager().persist((Object)this.d1);
            this.getEntityManager().persist((Object)this.d2);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception in createTestData:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"Cleanup data");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM DATATYPES").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM DATATYPES2").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

