/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxws.common;

import com.sun.ts.lib.util.TestUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.jws.HandlerChain;
import javax.jws.Oneway;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.ws.Action;
import javax.xml.ws.FaultAction;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;
import javax.xml.ws.WebEndpoint;
import javax.xml.ws.WebFault;
import javax.xml.ws.WebServiceClient;

public class AnnotationUtils {
    private AnnotationUtils() {
    }

    public static Method[] getMethods(Class c) {
        return c.getDeclaredMethods();
    }

    public static Method getMethod(Class c, String methodName) {
        Method[] methods = c.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!methodName.equals(method.getName())) continue;
            return method;
        }
        return null;
    }

    public static boolean verifyXmlElement(XmlElement element, String name, String namespace, boolean required, boolean nillable) {
        boolean pass = true;
        TestUtil.logMsg((String)("Verify XmlElement Params: " + element));
        if (element.name().equals(name)) {
            TestUtil.logMsg((String)("name match: " + name));
        } else {
            TestUtil.logErr((String)("name non-match: " + name));
            pass = false;
        }
        if (element.namespace().equals(namespace)) {
            TestUtil.logMsg((String)("namespace match: " + namespace));
        } else {
            TestUtil.logErr((String)("namespace non-match: " + namespace));
            pass = false;
        }
        if (element.required() == required) {
            TestUtil.logMsg((String)("required match: " + required));
        } else {
            TestUtil.logErr((String)("required non-match: " + required));
            pass = false;
        }
        if (element.nillable() == nillable) {
            TestUtil.logMsg((String)("nillable match: " + nillable));
        } else {
            TestUtil.logErr((String)("nillable non-match: " + nillable));
            pass = false;
        }
        return pass;
    }

    public static boolean verifyXmlType(XmlType type, String name, String namespace) {
        boolean pass = true;
        TestUtil.logMsg((String)("Verify XmlType Params: " + type));
        if (type.name().equals(name)) {
            TestUtil.logMsg((String)("name match: " + name));
        } else {
            TestUtil.logErr((String)("name non-match: " + name));
            pass = false;
        }
        if (type.namespace().equals(namespace)) {
            TestUtil.logMsg((String)("namespace match: " + namespace));
        } else {
            TestUtil.logErr((String)("namespace non-match: " + namespace));
            pass = false;
        }
        return pass;
    }

    public static Annotation getAnnotationOnClass(Class theClass, Class theAnnotationClass) {
        try {
            Object a = theClass.getAnnotation(theAnnotationClass);
            if (a != null) {
                System.out.println("Annotation on class (" + theClass + ") is present for annotation (" + a + ")");
                return a;
            }
            System.out.println("Annotation on class (" + theClass + ") is not present for annotation " + theAnnotationClass.getName());
            return a;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Annotation getAnnotationOnField(Class theClass, String theField, Class theAnnotationClass) {
        try {
            Field f = theClass.getDeclaredField(theField);
            Object a = f.getAnnotation(theAnnotationClass);
            if (a != null) {
                System.out.println("Annotation on field (" + theField + ") is present for annotation (" + a + ")");
                return a;
            }
            System.out.println("Annotation on field (" + theField + ") is not present for annotation " + theAnnotationClass.getName());
            return a;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isAnnotationOnFieldPresent(Class theClass, String theField, Class theAnnotationClass) {
        try {
            Field f = theClass.getDeclaredField(theField);
            Object a = f.getAnnotation(theAnnotationClass);
            if (a != null) {
                System.out.println("Annotation on field (" + theField + ") is present for annotation (" + a + ")");
                return true;
            }
            System.out.println("Annotation on field (" + theField + ") is not present for annotation " + theAnnotationClass.getName());
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String getWsdlLocation(Class c) {
        String wsdlLocation = null;
        if (c.isAnnotationPresent(WebService.class)) {
            WebService ws = c.getAnnotation(WebService.class);
            wsdlLocation = ws.wsdlLocation();
        }
        return wsdlLocation;
    }

    public static boolean verifyWebServiceAnnotation(Class c, String name, String targetNamespace, String serviceName, String wsdlLocation, String endpointInterface) {
        boolean result = true;
        if (c.isAnnotationPresent(WebService.class)) {
            WebService ws = c.getAnnotation(WebService.class);
            if (ws != null) {
                TestUtil.logTrace((String)"Annotation:");
                TestUtil.logTrace((String)ws.toString());
                if (ws.name() != null) {
                    if (!ws.name().equals("")) {
                        if (!name.equals(ws.name())) {
                            result = false;
                            TestUtil.logErr((String)"Error with name attribute:");
                            TestUtil.logErr((String)("Expected=" + name));
                            TestUtil.logErr((String)("Actual=" + ws.name()));
                        }
                    } else {
                        TestUtil.logTrace((String)"name attribute was empty");
                    }
                }
                if (ws.targetNamespace() != null) {
                    if (!ws.targetNamespace().equals("")) {
                        if (!targetNamespace.equals(ws.targetNamespace())) {
                            result = false;
                            TestUtil.logErr((String)"Error with targetNamespace attribute:");
                            TestUtil.logErr((String)("Expected=" + targetNamespace));
                            TestUtil.logErr((String)("Actual=" + ws.targetNamespace()));
                        }
                    } else {
                        TestUtil.logTrace((String)"targetNamespace attribute was empty");
                    }
                }
                if (ws.serviceName() != null) {
                    if (!ws.serviceName().equals("")) {
                        if (!serviceName.equals(ws.serviceName())) {
                            result = false;
                            TestUtil.logErr((String)"Error with serviceName attribute:");
                            TestUtil.logErr((String)("Expected=" + serviceName));
                            TestUtil.logErr((String)("Actual=" + ws.serviceName()));
                        }
                    } else {
                        TestUtil.logTrace((String)"serviceName attribute was empty");
                    }
                }
                if (ws.wsdlLocation() != null) {
                    if (!ws.wsdlLocation().equals("")) {
                        if (ws.wsdlLocation().indexOf(wsdlLocation) == -1) {
                            result = false;
                            TestUtil.logErr((String)"Error with wsdlLocation attribute:");
                            TestUtil.logErr((String)("Expected attribute to contain=" + wsdlLocation));
                            TestUtil.logErr((String)("Actual=" + ws.wsdlLocation()));
                        }
                    } else {
                        TestUtil.logTrace((String)"wsdlLocation attribute was empty");
                    }
                }
                if (ws.endpointInterface() != null) {
                    if (!ws.endpointInterface().equals("")) {
                        if (!endpointInterface.equals(ws.endpointInterface())) {
                            result = false;
                            TestUtil.logErr((String)"Error with endpointInterface attribute:");
                            TestUtil.logErr((String)("Expected=" + endpointInterface));
                            TestUtil.logErr((String)("Actual=" + ws.endpointInterface()));
                        }
                    } else {
                        TestUtil.logTrace((String)"endpointInterface attribute was empty");
                    }
                }
            } else {
                TestUtil.logErr((String)"WebService annotation returned was null");
                result = false;
            }
        } else {
            TestUtil.logErr((String)"WebService annotation for the class not found");
            result = false;
        }
        return result;
    }

    public static boolean verifySOAPBindingAnnotationPerMethod(Class c, String methodName, String style, String use, String parameterStyle) {
        boolean result = true;
        Method method = AnnotationUtils.getMethod(c, methodName);
        if (method == null) {
            TestUtil.logErr((String)("Method name not found for -> " + methodName));
            return false;
        }
        TestUtil.logMsg((String)("Method name found for -> " + methodName));
        if (method.isAnnotationPresent(SOAPBinding.class)) {
            SOAPBinding sb = method.getAnnotation(SOAPBinding.class);
            if (sb != null) {
                TestUtil.logTrace((String)"Annotation:");
                TestUtil.logTrace((String)sb.toString());
                if (sb.style().name() != null && !style.equals(sb.style().name())) {
                    result = false;
                    TestUtil.logErr((String)"Error with style attribute:");
                    TestUtil.logErr((String)("Expected=" + style));
                    TestUtil.logErr((String)("Actual=" + sb.style().name()));
                }
                if (sb.use().name() != null && !use.equals(sb.use().name())) {
                    result = false;
                    TestUtil.logErr((String)"Error with use attribute:");
                    TestUtil.logErr((String)("Expected=" + use));
                    TestUtil.logErr((String)("Actual=" + sb.use().name()));
                }
                if (sb.parameterStyle().name() != null && !parameterStyle.equals(sb.parameterStyle().name())) {
                    result = false;
                    TestUtil.logErr((String)"Error with parameterStyle attribute:");
                    TestUtil.logErr((String)("Expected=" + parameterStyle));
                    TestUtil.logErr((String)("Actual=" + sb.parameterStyle().name()));
                }
            } else {
                TestUtil.logErr((String)"SOAPBinding annotation for the method returned was null");
                result = false;
            }
        } else {
            TestUtil.logMsg((String)"SOAPBinding annotation for the method not found");
            TestUtil.logMsg((String)"Verify SOAPBinding annotation at the class level ...");
            result = AnnotationUtils.verifySOAPBindingAnnotation(c, style, use, parameterStyle);
            if (!result) {
                TestUtil.logMsg((String)"The operation must have the defaults DOCUMENT/LITERAL/WRAPPED ...");
                if (style.equals("DOCUMENT") && use.equals("LITERAL") && parameterStyle.equals("WRAPPED")) {
                    result = true;
                    TestUtil.logMsg((String)("Operation name -> " + methodName + " is the default case"));
                }
            }
        }
        return result;
    }

    public static boolean verifySOAPBindingAnnotation(Class c, String style, String use, String parameterStyle) {
        boolean result = true;
        if (c.isAnnotationPresent(SOAPBinding.class)) {
            SOAPBinding sb = c.getAnnotation(SOAPBinding.class);
            if (sb != null) {
                TestUtil.logTrace((String)"Annotation:");
                TestUtil.logTrace((String)sb.toString());
                if (sb.style().name() != null && !style.equals(sb.style().name())) {
                    result = false;
                    TestUtil.logErr((String)"Error with style attribute:");
                    TestUtil.logErr((String)("Expected=" + style));
                    TestUtil.logErr((String)("Actual=" + sb.style().name()));
                }
                if (sb.use().name() != null && !use.equals(sb.use().name())) {
                    result = false;
                    TestUtil.logErr((String)"Error with use attribute:");
                    TestUtil.logErr((String)("Expected=" + use));
                    TestUtil.logErr((String)("Actual=" + sb.use().name()));
                }
                if (sb.parameterStyle().name() != null && !parameterStyle.equals(sb.parameterStyle().name())) {
                    result = false;
                    TestUtil.logErr((String)"Error with parameterStyle attribute:");
                    TestUtil.logErr((String)("Expected=" + parameterStyle));
                    TestUtil.logErr((String)("Actual=" + sb.parameterStyle().name()));
                }
            } else {
                TestUtil.logErr((String)"SOAPBinding annotation returned was null");
                result = false;
            }
        } else {
            TestUtil.logMsg((String)"SOAPBinding annotation for the class not found");
            result = false;
        }
        return result;
    }

    public static boolean verifySOAPBindingAnnotation(Class c, String methodName, String style, String use, String parameterStyle) {
        boolean result = true;
        Method method = AnnotationUtils.getMethod(c, methodName);
        if (method == null) {
            TestUtil.logErr((String)("Method name not found for -> " + methodName));
            return false;
        }
        if (method.isAnnotationPresent(SOAPBinding.class)) {
            SOAPBinding sb = method.getAnnotation(SOAPBinding.class);
            if (sb != null) {
                TestUtil.logMsg((String)"Annotation:");
                TestUtil.logMsg((String)sb.toString());
                if (sb.style().name() != null && !style.equals(sb.style().name())) {
                    result = false;
                    TestUtil.logErr((String)"Error with style attribute:");
                    TestUtil.logErr((String)("Expected=" + style));
                    TestUtil.logErr((String)("Actual=" + sb.style().name()));
                }
                if (sb.use().name() != null && !use.equals(sb.use().name())) {
                    result = false;
                    TestUtil.logErr((String)"Error with use attribute:");
                    TestUtil.logErr((String)("Expected=" + use));
                    TestUtil.logErr((String)("Actual=" + sb.use().name()));
                }
                if (sb.parameterStyle().name() != null && !parameterStyle.equals(sb.parameterStyle().name())) {
                    result = false;
                    TestUtil.logErr((String)"Error with parameterStyle attribute:");
                    TestUtil.logErr((String)("Expected=" + parameterStyle));
                    TestUtil.logErr((String)("Actual=" + sb.parameterStyle().name()));
                }
            } else {
                result = false;
                TestUtil.logErr((String)("The SOAPBinding annotation returned was null for method" + methodName));
            }
        } else {
            result = false;
            TestUtil.logErr((String)"SOAPBinding annotation not found");
        }
        return result;
    }

    public static boolean verifyOnewayAnnotation(Class c, String methodName) {
        boolean result = true;
        Method method = AnnotationUtils.getMethod(c, methodName);
        if (method == null) {
            TestUtil.logErr((String)("Method name not found for -> " + methodName));
            return false;
        }
        if (methodName.equals(method.getName()) && !method.isAnnotationPresent(Oneway.class)) {
            result = false;
            TestUtil.logErr((String)"The Oneway annotation was not present");
        }
        return result;
    }

    public static boolean verifyWebResultAnnotation(Class c, String methodName, String name, String targetNamespace) {
        boolean result = true;
        Method method = AnnotationUtils.getMethod(c, methodName);
        if (method == null) {
            TestUtil.logErr((String)("Method name not found for -> " + methodName));
            return false;
        }
        if (methodName.equals(method.getName())) {
            if (method.isAnnotationPresent(WebResult.class)) {
                WebResult wr = method.getAnnotation(WebResult.class);
                if (wr != null) {
                    TestUtil.logTrace((String)"Annotation:");
                    TestUtil.logTrace((String)wr.toString());
                    if (wr.name() != null && !name.equals(wr.name())) {
                        result = false;
                        TestUtil.logErr((String)"Error with name attribute:");
                        TestUtil.logErr((String)("Expected=" + name));
                        TestUtil.logErr((String)("Actual=" + wr.name()));
                    }
                    if (wr.targetNamespace() != null) {
                        if (!wr.targetNamespace().equals("")) {
                            if (!targetNamespace.equals(wr.targetNamespace())) {
                                result = false;
                                TestUtil.logErr((String)"Error with targetNamespace attribute:");
                                TestUtil.logErr((String)("Expected=" + targetNamespace));
                                TestUtil.logErr((String)("Actual=" + wr.targetNamespace()));
                            }
                        } else {
                            TestUtil.logTrace((String)"targetNamespace attribute was empty");
                        }
                    }
                } else {
                    result = false;
                    TestUtil.logErr((String)"WebResult annotation returned was null");
                }
            } else {
                result = false;
                TestUtil.logErr((String)"WebResult annotation not found");
            }
        }
        return result;
    }

    public static boolean verifyWebParamAnnotation(Class c, int paramIndex, String methodName, String name, String targetNamespace, String mode, boolean header) {
        boolean result = true;
        Method method = AnnotationUtils.getMethod(c, methodName);
        if (method == null) {
            TestUtil.logErr((String)("Method name not found for -> " + methodName));
            return false;
        }
        if (methodName.equals(method.getName())) {
            Annotation[][] aArray = method.getParameterAnnotations();
            for (int j = 0; j < aArray[paramIndex].length; ++j) {
                Annotation annotation = aArray[paramIndex][j];
                if (annotation instanceof WebParam) {
                    WebParam wp = (WebParam)annotation;
                    TestUtil.logTrace((String)"Annotation:");
                    TestUtil.logTrace((String)wp.toString());
                    if (wp.name() != null) {
                        if (!wp.name().equals("")) {
                            if (!name.equals(wp.name())) {
                                result = false;
                                TestUtil.logErr((String)"Error with name attribute:");
                                TestUtil.logErr((String)("Expected=" + name));
                                TestUtil.logErr((String)("Actual=" + wp.name()));
                            }
                        } else {
                            TestUtil.logTrace((String)"name attribute was empty");
                        }
                    }
                    if (wp.targetNamespace() != null) {
                        if (!wp.targetNamespace().equals("")) {
                            if (!targetNamespace.equals(wp.targetNamespace())) {
                                result = false;
                                TestUtil.logErr((String)"Error with targetNamespace attribute:");
                                TestUtil.logErr((String)("Expected=" + targetNamespace));
                                TestUtil.logErr((String)("Actual=" + wp.targetNamespace()));
                            }
                        } else {
                            TestUtil.logTrace((String)"targetNamespace attribute was empty");
                        }
                    }
                    if (wp.mode() != null && !mode.equals(wp.mode().name())) {
                        result = false;
                        TestUtil.logErr((String)"Error with mode attribute:");
                        TestUtil.logErr((String)("Expected=" + mode));
                        TestUtil.logErr((String)("Actual=" + wp.mode()));
                    }
                    if (header == wp.header()) continue;
                    result = false;
                    TestUtil.logErr((String)"Error with header attribute:");
                    TestUtil.logErr((String)("Expected=" + header));
                    TestUtil.logErr((String)("Actual=" + wp.header()));
                    continue;
                }
                result = false;
                TestUtil.logErr((String)"WebParam annotation not found");
            }
        }
        return result;
    }

    public static boolean verifyWebMethodAnnotation(Class c, String methodName, String operationName, String action) {
        boolean result = true;
        Method method = AnnotationUtils.getMethod(c, methodName);
        if (method == null) {
            TestUtil.logErr((String)("Method name not found for -> " + methodName));
            return false;
        }
        if (methodName.equals(method.getName())) {
            if (method.isAnnotationPresent(WebMethod.class)) {
                WebMethod wm = method.getAnnotation(WebMethod.class);
                if (wm != null) {
                    TestUtil.logTrace((String)"Annotation:");
                    TestUtil.logTrace((String)wm.toString());
                    if (wm.operationName() != null) {
                        if (!wm.operationName().equals("")) {
                            if (!operationName.equals(wm.operationName())) {
                                result = false;
                                TestUtil.logErr((String)"Error with operationName attribute:");
                                TestUtil.logErr((String)("Expected=" + operationName));
                                TestUtil.logErr((String)("Actual=" + wm.operationName()));
                            }
                        } else {
                            TestUtil.logTrace((String)"operationName attribute was empty");
                        }
                    }
                    if (wm.action() != null) {
                        if (!wm.action().equals("")) {
                            if (!action.equals(wm.action())) {
                                result = false;
                                TestUtil.logErr((String)"Error with action attribute:");
                                TestUtil.logErr((String)("Expected=" + action));
                                TestUtil.logErr((String)("Actual=" + wm.action()));
                            }
                        } else {
                            TestUtil.logTrace((String)"action attribute was empty");
                        }
                    }
                } else {
                    result = false;
                    TestUtil.logErr((String)"WebMethod annotation returned was null");
                }
            } else {
                result = false;
                TestUtil.logErr((String)"WebMethod annotation not found");
            }
        }
        return result;
    }

    public static boolean verifyWebFaultAnnotation(Class c, String name, String targetNamespace, String faultBean) {
        boolean result = true;
        if (c.isAnnotationPresent(WebFault.class)) {
            WebFault wf = c.getAnnotation(WebFault.class);
            if (wf != null) {
                TestUtil.logTrace((String)"Annotation:");
                TestUtil.logTrace((String)wf.toString());
                if (wf.name() != null) {
                    if (!wf.name().equals("")) {
                        if (!name.equals(wf.name())) {
                            result = false;
                            TestUtil.logErr((String)"Error with name attribute:");
                            TestUtil.logErr((String)("Expected=" + name));
                            TestUtil.logErr((String)("Actual=" + wf.name()));
                        }
                    } else {
                        TestUtil.logTrace((String)"name attribute was empty");
                    }
                }
                if (wf.targetNamespace() != null) {
                    if (!wf.targetNamespace().equals("")) {
                        if (!targetNamespace.equals(wf.targetNamespace())) {
                            result = false;
                            TestUtil.logErr((String)"Error with targetNamespace attribute:");
                            TestUtil.logErr((String)("Expected=" + targetNamespace));
                            TestUtil.logErr((String)("Actual=" + wf.targetNamespace()));
                        }
                    } else {
                        TestUtil.logTrace((String)"targetNamespace attribute was empty");
                    }
                }
                if (wf.faultBean() != null) {
                    if (!wf.faultBean().equals("")) {
                        if (!faultBean.equals(wf.faultBean())) {
                            result = false;
                            TestUtil.logErr((String)"Error with faultBean attribute:");
                            TestUtil.logErr((String)("Expected=" + faultBean));
                            TestUtil.logErr((String)("Actual=" + wf.faultBean()));
                        }
                    } else {
                        TestUtil.logTrace((String)"faultBean attribute was empty");
                    }
                }
            } else {
                result = false;
                TestUtil.logErr((String)"WebFault annotation returned was null");
            }
        } else {
            result = false;
            TestUtil.logErr((String)"WebFault annotation for the class not found");
        }
        return result;
    }

    public static boolean verifyRequestWrapperAnnotation(Class c, String methodName, String localName, String targetNamespace, String className) {
        boolean result = true;
        Method method = AnnotationUtils.getMethod(c, methodName);
        if (method == null) {
            TestUtil.logErr((String)("Method name not found for -> " + methodName));
            return false;
        }
        if (method.isAnnotationPresent(RequestWrapper.class)) {
            RequestWrapper rw = method.getAnnotation(RequestWrapper.class);
            if (rw != null) {
                TestUtil.logTrace((String)"Annotation:");
                TestUtil.logTrace((String)rw.toString());
                if (rw.localName() != null) {
                    if (!rw.localName().equals("")) {
                        if (!localName.equals(rw.localName())) {
                            result = false;
                            TestUtil.logErr((String)"Error with localName attribute:");
                            TestUtil.logErr((String)("Expected=" + localName));
                            TestUtil.logErr((String)("Actual=" + rw.localName()));
                        }
                    } else {
                        TestUtil.logTrace((String)"localName attribute was empty");
                    }
                }
                if (rw.targetNamespace() != null) {
                    if (!rw.targetNamespace().equals("")) {
                        if (!targetNamespace.equals(rw.targetNamespace())) {
                            result = false;
                            TestUtil.logErr((String)"Error with targetNamespace attribute:");
                            TestUtil.logErr((String)("Expected=" + targetNamespace));
                            TestUtil.logErr((String)("Actual=" + rw.targetNamespace()));
                        }
                    } else {
                        TestUtil.logTrace((String)"targetNamespace attribute was empty");
                    }
                }
                if (rw.className() != null) {
                    if (!rw.className().equals("")) {
                        if (!className.equals(rw.className())) {
                            result = false;
                            TestUtil.logErr((String)"Error with className attribute:");
                            TestUtil.logErr((String)("Expected=" + className));
                            TestUtil.logErr((String)("Actual=" + rw.className()));
                        }
                    } else {
                        TestUtil.logTrace((String)"className attribute was empty");
                    }
                }
            } else {
                TestUtil.logErr((String)"RequestWrapper annotation returned was null");
                result = false;
            }
        } else {
            TestUtil.logErr((String)"RequestWrapper annotation for the class not found");
            result = false;
        }
        return result;
    }

    public static boolean verifyResponseWrapperAnnotation(Class c, String methodName, String localName, String targetNamespace, String className) {
        boolean result = true;
        Method method = AnnotationUtils.getMethod(c, methodName);
        if (method == null) {
            TestUtil.logErr((String)("Method name not found for -> " + methodName));
            return false;
        }
        if (method.isAnnotationPresent(ResponseWrapper.class)) {
            ResponseWrapper rw = method.getAnnotation(ResponseWrapper.class);
            if (rw != null) {
                TestUtil.logTrace((String)"Annotation:");
                TestUtil.logTrace((String)rw.toString());
                if (rw.localName() != null) {
                    if (!rw.localName().equals("")) {
                        if (!localName.equals(rw.localName())) {
                            result = false;
                            TestUtil.logErr((String)"Error with localName attribute:");
                            TestUtil.logErr((String)("Expected=" + localName));
                            TestUtil.logErr((String)("Actual=" + rw.localName()));
                        }
                    } else {
                        TestUtil.logTrace((String)"localName attribute was empty");
                    }
                }
                if (rw.targetNamespace() != null) {
                    if (!rw.targetNamespace().equals("")) {
                        if (!targetNamespace.equals(rw.targetNamespace())) {
                            result = false;
                            TestUtil.logErr((String)"Error with targetNamespace attribute:");
                            TestUtil.logErr((String)("Expected=" + targetNamespace));
                            TestUtil.logErr((String)("Actual=" + rw.targetNamespace()));
                        }
                    } else {
                        TestUtil.logTrace((String)"targetNamespace attribute was empty");
                    }
                }
                if (rw.className() != null) {
                    if (!rw.className().equals("")) {
                        if (!className.equals(rw.className())) {
                            result = false;
                            TestUtil.logErr((String)"Error with className attribute:");
                            TestUtil.logErr((String)("Expected=" + className));
                            TestUtil.logErr((String)("Actual=" + rw.className()));
                        }
                    } else {
                        TestUtil.logTrace((String)"className attribute was empty");
                    }
                }
            } else {
                TestUtil.logErr((String)"ResponseWrapper annotation returned was null");
                result = false;
            }
        } else {
            TestUtil.logErr((String)"ResponseWrapper annotation for the class not found");
            result = false;
        }
        return result;
    }

    public static boolean verifyWebServiceClientAnnotation(Class c, String name, String targetNamespace, String wsdlLocation) {
        boolean result = true;
        if (c.isAnnotationPresent(WebServiceClient.class)) {
            WebServiceClient wsc = c.getAnnotation(WebServiceClient.class);
            if (wsc != null) {
                TestUtil.logTrace((String)"Annotation:");
                TestUtil.logTrace((String)wsc.toString());
                if (wsc.name() != null) {
                    if (!wsc.name().equals("")) {
                        if (!name.equals(wsc.name())) {
                            result = false;
                            TestUtil.logErr((String)"Error with name attribute:");
                            TestUtil.logErr((String)("Expected=" + name));
                            TestUtil.logErr((String)("Actual=" + wsc.name()));
                        }
                    } else {
                        TestUtil.logTrace((String)"name attribute was empty");
                    }
                }
                if (wsc.targetNamespace() != null) {
                    if (!wsc.targetNamespace().equals("")) {
                        if (!targetNamespace.equals(wsc.targetNamespace())) {
                            result = false;
                            TestUtil.logErr((String)"Error with targetNamespace attribute:");
                            TestUtil.logErr((String)("Expected=" + targetNamespace));
                            TestUtil.logErr((String)("Actual=" + wsc.targetNamespace()));
                        }
                    } else {
                        TestUtil.logTrace((String)"targetNamespace attribute was empty");
                    }
                }
                if (wsc.wsdlLocation() != null) {
                    if (!wsc.wsdlLocation().equals("")) {
                        if (wsc.wsdlLocation().indexOf(wsdlLocation) == -1) {
                            result = false;
                            TestUtil.logErr((String)"Error with wsdlLocation attribute:");
                            TestUtil.logErr((String)("Expected attribute to contain=" + wsdlLocation));
                            TestUtil.logErr((String)("Actual=" + wsc.wsdlLocation()));
                        }
                    } else {
                        TestUtil.logTrace((String)"wsdlLocation attribute was empty");
                    }
                }
            } else {
                TestUtil.logErr((String)"WebServiceClient annotation returned was null");
                result = false;
            }
        } else {
            TestUtil.logErr((String)"WebServiceClient annotation for the class not found");
            result = false;
        }
        return result;
    }

    public static boolean verifyWebEndpointAnnotation(Class c, String methodName, String name) {
        boolean result = true;
        Method method = AnnotationUtils.getMethod(c, methodName);
        if (method == null) {
            TestUtil.logErr((String)("Method name not found for -> " + methodName));
            return false;
        }
        if (methodName.equals(method.getName())) {
            if (method.isAnnotationPresent(WebEndpoint.class)) {
                WebEndpoint wep = method.getAnnotation(WebEndpoint.class);
                if (wep != null) {
                    TestUtil.logTrace((String)"Annotation:");
                    TestUtil.logTrace((String)wep.toString());
                    if (wep.name() != null && !name.equals(wep.name())) {
                        result = false;
                        TestUtil.logErr((String)"Error with name attribute:");
                        TestUtil.logErr((String)("Expected=" + name));
                        TestUtil.logErr((String)("Actual=" + wep.name()));
                    }
                } else {
                    result = false;
                    TestUtil.logErr((String)"WebEndpoint annotation returned was null");
                }
            } else {
                result = false;
                TestUtil.logErr((String)"WebEndpoint annotation not found");
            }
        }
        return result;
    }

    public static boolean verifyHandlerChainAnnotation(Class c, String file) {
        boolean result = true;
        if (c.isAnnotationPresent(HandlerChain.class)) {
            HandlerChain hc = c.getAnnotation(HandlerChain.class);
            if (hc != null) {
                TestUtil.logTrace((String)"Annotation:");
                TestUtil.logTrace((String)hc.toString());
                if (hc.file() != null) {
                    if (file != null) {
                        if (!hc.file().equals(file)) {
                            result = false;
                            TestUtil.logErr((String)"Error with file attribute:");
                            TestUtil.logErr((String)("Expected=" + file));
                            TestUtil.logErr((String)("Actual=" + hc.file()));
                        }
                    } else if (hc.file().equals("")) {
                        result = false;
                        TestUtil.logErr((String)"Error with file attribute:");
                        TestUtil.logErr((String)"An empty string was returned and it should not be empty");
                    }
                } else {
                    TestUtil.logTrace((String)"file attribute returned a null");
                }
            } else {
                TestUtil.logErr((String)"HandlerChain annotation returned was null");
                result = false;
            }
        } else {
            TestUtil.logErr((String)"HandlerChain annotation for the class not found");
            result = false;
        }
        return result;
    }

    public static boolean verifyActionFaultActionAnnotation(Class c, String methodName, boolean shouldExist, String inputName, String outputName, String[][] faultArray) {
        boolean result = true;
        Method method = AnnotationUtils.getMethod(c, methodName);
        if (method == null) {
            TestUtil.logErr((String)("Method name not found for -> " + methodName));
            return false;
        }
        if (methodName.equals(method.getName())) {
            if (method.isAnnotationPresent(Action.class)) {
                if (shouldExist) {
                    Action action = method.getAnnotation(Action.class);
                    if (action != null) {
                        TestUtil.logTrace((String)"Annotation:");
                        TestUtil.logTrace((String)action.toString());
                        if (inputName != null) {
                            if (!action.input().equals("")) {
                                if (!inputName.equals(action.input())) {
                                    result = false;
                                    TestUtil.logErr((String)"Error with input attribute:");
                                    TestUtil.logErr((String)("Expected=" + inputName));
                                    TestUtil.logErr((String)("Actual=" + action.input()));
                                }
                            } else {
                                TestUtil.logTrace((String)"input attribute was empty");
                            }
                        }
                        if (outputName != null) {
                            if (!action.output().equals("")) {
                                if (!outputName.equals(action.output())) {
                                    result = false;
                                    TestUtil.logErr((String)"Error with output attribute:");
                                    TestUtil.logErr((String)("Expected=" + outputName));
                                    TestUtil.logErr((String)("Actual=" + action.output()));
                                }
                            } else {
                                TestUtil.logTrace((String)"output attribute was empty");
                            }
                        }
                        if (faultArray.length != 0 && !AnnotationUtils.verifyFaultActionAnnotation(action.fault(), faultArray)) {
                            result = false;
                        }
                    } else {
                        result = false;
                        TestUtil.logErr((String)"Action annotation returned was null");
                    }
                } else {
                    result = false;
                    TestUtil.logErr((String)("Action annotation should not exist but was found for method:" + methodName));
                }
            } else if (shouldExist) {
                result = false;
                TestUtil.logErr((String)("Action annotation should exist but was not found for method:" + methodName));
            } else {
                TestUtil.logTrace((String)("Action annotation should not exist and was not found for method:" + methodName));
            }
        }
        return result;
    }

    private static boolean verifyFaultActionAnnotation(FaultAction[] faArray, String[][] faultArray) {
        boolean result = true;
        if (faArray != null) {
            if (faArray.length != 0) {
                if (faArray.length == faultArray.length) {
                    for (int i = 0; i < faArray.length; ++i) {
                        FaultAction fAction = faArray[i];
                        TestUtil.logTrace((String)"Annotation:");
                        TestUtil.logTrace((String)fAction.toString());
                        if (fAction.className() != null) {
                            String className = fAction.className().getName();
                            TestUtil.logTrace((String)("className attribute=" + className));
                            boolean found = false;
                            for (int j = 0; j < faultArray.length; ++j) {
                                if (!faultArray[j][0].equals(className)) continue;
                                found = true;
                                TestUtil.logTrace((String)("className found:" + className));
                                if (!fAction.value().equals("")) {
                                    if (!faultArray[j][1].equals(fAction.value())) {
                                        result = false;
                                        TestUtil.logErr((String)"Error with value attribute:");
                                        TestUtil.logErr((String)("Expected=" + faultArray[j][1]));
                                        TestUtil.logErr((String)("Actual=" + fAction.value()));
                                        continue;
                                    }
                                    TestUtil.logTrace((String)"value passed");
                                    continue;
                                }
                                TestUtil.logTrace((String)"value attribute was empty");
                            }
                            if (found) continue;
                            result = false;
                            TestUtil.logErr((String)("The className:" + className + " was not found in the list of expected values"));
                            continue;
                        }
                        TestUtil.logTrace((String)"className attribute was null");
                    }
                } else {
                    result = false;
                    TestUtil.logErr((String)"Error with number of FaultAction annotations:");
                    TestUtil.logErr((String)("Expected=" + faultArray.length));
                    TestUtil.logErr((String)("Actual=" + faArray.length));
                }
            } else {
                result = false;
                TestUtil.logErr((String)"Error with number of FaultAction annotations:");
                TestUtil.logErr((String)("Expected=" + faultArray.length));
                TestUtil.logErr((String)("Actual=" + faArray.length));
            }
        } else {
            result = false;
            TestUtil.logErr((String)"FaultAction was null");
        }
        return result;
    }
}

