/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.jpa22.repeatable.namedstoredprocedurequery;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.CleanupMethod;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.SetupMethod;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.jpa22.repeatable.namedstoredprocedurequery.Employee;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.persistence.ParameterMode;
import javax.persistence.StoredProcedureQuery;

public class Client
extends PMClientBase {
    private static final long serialVersionUID = 22L;
    List<Employee> empRef = new ArrayList<Employee>();
    Employee emp0 = null;
    Properties props = null;
    Map<String, Object> map = new HashMap<String, Object>();
    String dataBaseName = null;
    static final String ORACLE = "oracle";
    static final String POSTGRESQL = "postgresql";

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        this.props = p;
        try {
            super.setup(args, p);
            this.map.putAll(this.getEntityManager().getProperties());
            this.map.put("foo", "bar");
            this.displayMap(this.map);
            this.dataBaseName = p.getProperty("jdbc.db");
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void setupEmployeeData(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setupOrderData");
        this.props = p;
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createEmployeeData();
            this.map.putAll(this.getEntityManager().getProperties());
            this.map.put("foo", "bar");
            this.displayMap(this.map);
            this.dataBaseName = p.getProperty("jdbc.db");
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    public void cleanupData() throws EETest.Fault {
        TestUtil.logTrace((String)"Cleanup data");
        this.removeTestData();
        this.cleanup();
    }

    @SetupMethod(name="setupEmployeeData")
    @CleanupMethod(name="cleanupData")
    public void createStoredProcedureQueryStringTest() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        try {
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpOneFirstNameFromOut");
            spq.registerStoredProcedureParameter(1, String.class, ParameterMode.OUT);
            spq.execute();
            Object oActual = spq.getOutputParameterValue(1);
            if (oActual instanceof String) {
                String actual = (String)oActual;
                if (actual.equals(this.emp0.getFirstName())) {
                    TestUtil.logTrace((String)("Received expected result:" + actual));
                    pass = true;
                } else {
                    TestUtil.logErr((String)("Expected result: " + this.emp0.getFirstName() + ", actual:" + actual));
                }
            } else {
                TestUtil.logErr((String)("Expected String to be returned, actual:" + oActual.getClass()));
            }
        }
        catch (Exception ex) {
            TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("createStoredProcedureQueryStringTest failed");
        }
    }

    @SetupMethod(name="setupEmployeeData")
    @CleanupMethod(name="cleanupData")
    public void createStoredProcedureQueryStringClassArrayTest() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        try {
            Class[] cArray = new Class[]{Employee.class};
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpASCFromRS", cArray);
            if (this.dataBaseName.equalsIgnoreCase(ORACLE) || this.dataBaseName.equalsIgnoreCase(POSTGRESQL)) {
                TestUtil.logTrace((String)"register refcursor parameter");
                spq.registerStoredProcedureParameter(1, Void.TYPE, ParameterMode.REF_CURSOR);
            }
            if (spq.execute()) {
                List<List<Employee>> listOfList = this.getResultSetsFromStoredProcedure(spq);
                if (listOfList.size() == 1) {
                    ArrayList<Integer> expected = new ArrayList<Integer>();
                    for (Employee e : this.empRef) {
                        expected.add(e.getId());
                    }
                    pass = this.verifyListOfListEmployeeIds(expected, listOfList);
                } else {
                    TestUtil.logErr((String)("Did not get the correct number of result sets returned, expected: 1, actual:" + listOfList.size()));
                }
            } else {
                TestUtil.logErr((String)"Expected execute() to return true, actual: false");
            }
        }
        catch (Exception ex) {
            TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("createStoredProcedureQueryStringClassArrayTest failed");
        }
    }

    @SetupMethod(name="setupEmployeeData")
    @CleanupMethod(name="cleanupData")
    public void createStoredProcedureQueryStringStringArrayTest() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        this.clearCache();
        try {
            String[] sArray = new String[]{"id-firstname-lastname"};
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpIdFNameLNameFromRS", sArray);
            spq.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
            if (this.dataBaseName.equalsIgnoreCase(ORACLE) || this.dataBaseName.equalsIgnoreCase(POSTGRESQL)) {
                TestUtil.logTrace((String)"register refcursor parameter");
                spq.registerStoredProcedureParameter(2, Void.TYPE, ParameterMode.REF_CURSOR);
            }
            spq.setParameter(1, (Object)1);
            if (spq.execute()) {
                List<List<Employee>> listOfList = this.getResultSetsFromStoredProcedure(spq);
                if (listOfList.size() == 1) {
                    ArrayList<Employee> expected = new ArrayList<Employee>();
                    expected.add(new Employee(this.emp0.getId(), this.emp0.getFirstName(), this.emp0.getLastName()));
                    pass = this.verifyListOfListEmployees(expected, listOfList);
                } else {
                    TestUtil.logErr((String)("Did not get the correct number of result sets returned, expected: 1, actual:" + listOfList.size()));
                }
            } else {
                TestUtil.logErr((String)"Expected execute() to return true, actual: false");
            }
        }
        catch (Exception ex) {
            TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("createStoredProcedureQueryStringStringArrayTest failed");
        }
    }

    @SetupMethod(name="setupEmployeeData")
    @CleanupMethod(name="cleanupData")
    public void createNamedStoredProcedureQueryStringTest() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        this.clearCache();
        try {
            StoredProcedureQuery spq = null;
            if (this.dataBaseName.equalsIgnoreCase(ORACLE) || this.dataBaseName.equalsIgnoreCase(POSTGRESQL)) {
                TestUtil.logTrace((String)"Calling refcursor specific named stored procedure query");
                spq = this.getEntityManager().createNamedStoredProcedureQuery("get-id-firstname-lastname-refcursor");
            } else {
                spq = this.getEntityManager().createNamedStoredProcedureQuery("get-id-firstname-lastname");
            }
            spq.setParameter(1, (Object)1);
            if (spq.execute()) {
                List<List<Employee>> listOfList = this.getResultSetsFromStoredProcedure(spq);
                if (listOfList.size() == 1) {
                    ArrayList<Employee> expected = new ArrayList<Employee>();
                    expected.add(new Employee(this.emp0.getId(), this.emp0.getFirstName(), this.emp0.getLastName()));
                    pass = this.verifyListOfListEmployees(expected, listOfList);
                } else {
                    TestUtil.logErr((String)("Did not get the correct number of result sets returned, expected: 1, actual:" + listOfList.size()));
                }
            } else {
                TestUtil.logErr((String)"Expected execute() to return true, actual: false");
            }
        }
        catch (Exception ex) {
            TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("createNamedStoredProcedureQueryStringTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createEmployeeData() {
        try {
            this.getEntityTransaction().begin();
            TestUtil.logMsg((String)"Creating Employees");
            Date d1 = this.getUtilDate("2000-02-14");
            Date d2 = this.getUtilDate("2001-06-27");
            Date d3 = this.getUtilDate("2002-07-07");
            Date d4 = this.getUtilDate("2003-03-03");
            Date d5 = this.getUtilDate();
            this.emp0 = new Employee(1, "Alan", "Frechette", d1, 35000.0f);
            this.empRef.add(this.emp0);
            this.empRef.add(new Employee(2, "Arthur", "Frechette", d2, 35000.0f));
            this.empRef.add(new Employee(3, "Shelly", "McGowan", d3, 50000.0f));
            this.empRef.add(new Employee(4, "Robert", "Bissett", d4, 55000.0f));
            this.empRef.add(new Employee(5, "Stephen", "DMilla", d5, 25000.0f));
            for (Employee e : this.empRef) {
                if (e == null) continue;
                this.getEntityManager().persist((Object)e);
                TestUtil.logTrace((String)("persisted employee:" + e));
            }
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM EMPLOYEE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM PURCHASE_ORDER").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }

    private List<List<Employee>> getResultSetsFromStoredProcedure(StoredProcedureQuery spq) {
        TestUtil.logTrace((String)"in getResultSetsFromStoredProcedure");
        boolean results = true;
        ArrayList<List<Employee>> listOfList = new ArrayList<List<Employee>>();
        int rsnum = 1;
        int rowsAffected = 0;
        do {
            if (results) {
                TestUtil.logTrace((String)("Processing set:" + rsnum));
                ArrayList<Employee> empList = new ArrayList<Employee>();
                List list = spq.getResultList();
                if (list != null) {
                    TestUtil.logTrace((String)("Getting result set: " + rsnum + ", size:" + list.size()));
                    for (Object o : list) {
                        if (o instanceof Employee) {
                            Employee e = (Employee)o;
                            TestUtil.logTrace((String)("Saving:" + e));
                            empList.add(e);
                            continue;
                        }
                        TestUtil.logErr((String)("Did not get instance of Employee, instead got:" + o.getClass().getName()));
                    }
                    if (empList.size() > 0) {
                        listOfList.add(empList);
                    }
                } else {
                    TestUtil.logErr((String)("Result set[" + rsnum + "] returned was null"));
                }
                ++rsnum;
            } else {
                rowsAffected = spq.getUpdateCount();
                if (rowsAffected >= 0) {
                    TestUtil.logTrace((String)("rowsAffected:" + rowsAffected));
                }
            }
            results = spq.hasMoreResults();
            TestUtil.logTrace((String)("Results:" + results));
        } while (results || rowsAffected != -1);
        return listOfList;
    }

    private boolean verifyListOfListEmployeeIds(List<Integer> expected, List<List<Employee>> listOfList) {
        boolean result = false;
        int count = 0;
        for (List<Employee> lEmp : listOfList) {
            if (lEmp.size() > 0) {
                ArrayList<Integer> actual = new ArrayList<Integer>();
                for (Employee employee : lEmp) {
                    actual.add(employee.getId());
                }
                if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                    TestUtil.logTrace((String)"Received expected result:");
                    for (Integer n : actual) {
                        TestUtil.logTrace((String)("id:" + n));
                    }
                    ++count;
                    continue;
                }
                TestUtil.logErr((String)"Did not receive expected result:");
                for (Integer n : expected) {
                    TestUtil.logErr((String)(" Expected id:" + n));
                }
                for (Integer n : actual) {
                    TestUtil.logErr((String)("Actual id:" + n));
                }
                continue;
            }
            TestUtil.logErr((String)"Result set that was returned had 0 length");
        }
        if (count == listOfList.size()) {
            result = true;
        }
        return result;
    }

    private boolean verifyListOfListEmployees(List<Employee> expected, List<List<Employee>> listOfList) {
        boolean result = false;
        int count = 0;
        for (List<Employee> lEmp : listOfList) {
            if (lEmp.size() > 0) {
                ArrayList<Employee> actual = new ArrayList<Employee>();
                for (Employee e : lEmp) {
                    actual.add(e);
                }
                if (!this.verifyListEmployees(expected, actual)) continue;
                ++count;
                continue;
            }
            TestUtil.logErr((String)"Result set that was returned had 0 length");
        }
        if (count == listOfList.size()) {
            result = true;
        }
        return result;
    }

    private boolean verifyListEmployees(List<Employee> expected, List<Employee> actual) {
        boolean result = false;
        if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
            for (Employee e : expected) {
                TestUtil.logTrace((String)("Received expected result:" + e));
            }
            result = true;
        } else {
            TestUtil.logErr((String)"Did not receive expected result:");
            for (Employee e : expected) {
                TestUtil.logErr((String)("expected employee:" + e));
            }
            for (Employee e : actual) {
                TestUtil.logErr((String)("actual employee :" + e));
            }
        }
        return result;
    }
}

