/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.criteriaapi.misc;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.SetupMethod;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.schema30.Customer;
import com.sun.ts.tests.jpa.common.schema30.Customer_;
import com.sun.ts.tests.jpa.common.schema30.Order;
import com.sun.ts.tests.jpa.common.schema30.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.persistence.Tuple;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CompoundSelection;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.PluralAttribute;

public class Client
extends Util {
    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.getEntityManager();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void predicateIsNegatedTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        TestUtil.logMsg((String)"Testing default");
        Predicate pred = cbuilder.equal(cbuilder.literal((Object)"1"), (Object)"1");
        Boolean result = pred.isNegated();
        if (!result.booleanValue()) {
            TestUtil.logTrace((String)("Received expected result:" + result));
            pass1 = true;
        } else {
            TestUtil.logErr((String)("Expected:false , actual:" + result));
        }
        pred = null;
        TestUtil.logMsg((String)"Testing when Predicate.not is present");
        pred = cbuilder.equal(cbuilder.literal((Object)"1"), (Object)"1").not();
        result = pred.isNegated();
        if (result.booleanValue()) {
            TestUtil.logTrace((String)("Received expected result:" + result));
            pass2 = true;
        } else {
            TestUtil.logErr((String)("Expected:true, actual:" + result));
        }
        pred = null;
        TestUtil.logMsg((String)"Testing when CriteriaBuilder.not is present");
        pred = cbuilder.not((Expression)cbuilder.equal(cbuilder.literal((Object)"1"), (Object)"1"));
        result = pred.isNegated();
        if (result.booleanValue()) {
            TestUtil.logTrace((String)("Received expected result:" + result));
            pass3 = true;
        } else {
            TestUtil.logErr((String)("Expected:true, actual:" + result));
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new EETest.Fault("predicateIsNegatedTest failed");
        }
    }

    public void predicateBooleanOperatorTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        if (cquery != null) {
            TestUtil.logMsg((String)"Testing values()");
            Predicate.BooleanOperator[] results = Predicate.BooleanOperator.values();
            if (results.length == 2) {
                if (results[0].equals((Object)Predicate.BooleanOperator.AND) && results[1].equals((Object)Predicate.BooleanOperator.OR) || results[0].equals((Object)Predicate.BooleanOperator.OR) && results[1].equals((Object)Predicate.BooleanOperator.AND)) {
                    TestUtil.logTrace((String)"Received expected values from values()");
                    pass1 = true;
                }
            } else {
                TestUtil.logErr((String)("Expected number of values: 2, actual:" + results.length));
            }
            TestUtil.logMsg((String)"Testing valueOf(...)");
            for (Predicate.BooleanOperator pb : Predicate.BooleanOperator.values()) {
                TestUtil.logTrace((String)("Testing:" + pb.name()));
                try {
                    Predicate.BooleanOperator.valueOf((String)pb.name());
                    pass2 = true;
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logTrace((String)"Received unexpected IllegalArgumentException exception");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
                }
            }
            TestUtil.logMsg((String)"Testing valueOf(Invalid_value)");
            try {
                Predicate.BooleanOperator.valueOf((String)"Invalid_value");
                TestUtil.logErr((String)"Did not received IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected exception");
                pass3 = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new EETest.Fault("predicateBooleanOperatorTest failed");
        }
    }

    public void predicateGetOperatorTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            TestUtil.logMsg((String)"Testing default");
            Predicate predicate = cbuilder.equal((Expression)customer.get(Customer_.getSingularAttribute("id", String.class)), (Object)"1");
            Predicate.BooleanOperator result = predicate.getOperator();
            if (!result.equals((Object)Predicate.BooleanOperator.AND)) {
                TestUtil.logErr((String)("Expected:" + Predicate.BooleanOperator.AND.name() + ", actual:" + result.name()));
            } else {
                pass1 = true;
            }
            TestUtil.logMsg((String)"Testing AND");
            predicate = cbuilder.and((Expression)cbuilder.equal((Expression)customer.get(Customer_.getSingularAttribute("id", String.class)), (Object)"1"), (Expression)cbuilder.equal((Expression)customer.get(Customer_.getSingularAttribute("id", String.class)), (Object)"1"));
            if (!predicate.getOperator().equals((Object)Predicate.BooleanOperator.AND)) {
                TestUtil.logErr((String)("Expected:" + Predicate.BooleanOperator.AND.name() + ", actual:" + result.name()));
            } else {
                pass2 = true;
            }
            TestUtil.logMsg((String)"Testing OR");
            predicate = cbuilder.or((Expression)cbuilder.equal((Expression)customer.get(Customer_.getSingularAttribute("id", String.class)), (Object)"1"), (Expression)cbuilder.equal((Expression)customer.get(Customer_.getSingularAttribute("id", String.class)), (Object)"1"));
            if (!predicate.getOperator().equals((Object)Predicate.BooleanOperator.OR)) {
                TestUtil.logErr((String)("Expected:" + Predicate.BooleanOperator.OR.name() + ", actual:" + result.name()));
            } else {
                pass3 = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new EETest.Fault("predicateGetOperatorTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void predicateGetExpressionsTest() throws EETest.Fault {
        boolean pass2 = false;
        boolean pass3 = false;
        boolean pass4 = false;
        boolean pass5 = false;
        CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            ArrayList<Integer> expected = new ArrayList<Integer>();
            expected.add(Integer.parseInt(this.customerRef[0].getId()));
            expected.add(Integer.parseInt(this.customerRef[1].getId()));
            TestUtil.logMsg((String)"Testing disjunction");
            this.getEntityTransaction().begin();
            Predicate expr1 = cbuilder.equal((Expression)customer.get(Customer_.getSingularAttribute("id", String.class)), (Object)"1");
            Predicate expr2 = cbuilder.equal((Expression)customer.get(Customer_.getSingularAttribute("id", String.class)), (Object)"2");
            Predicate predicate = cbuilder.or((Expression)expr1, (Expression)expr2);
            List c = predicate.getExpressions();
            if (c.size() != 2) {
                TestUtil.logErr((String)("Expected a predicate expression size of:2, actual:" + c.size()));
            } else {
                pass2 = true;
            }
            cquery.select((Selection)customer);
            cquery.where((Expression)cbuilder.or((Expression)c.get(0), (Expression)c.get(1)));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            for (Customer cust : result) {
                TestUtil.logTrace((String)("result:" + cust));
                actual.add(Integer.parseInt(cust.getId()));
            }
            Collections.sort(actual);
            if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                TestUtil.logTrace((String)"Received expected results");
                pass3 = true;
            } else {
                TestUtil.logErr((String)"Did not get expected results");
                for (Integer i : expected) {
                    TestUtil.logErr((String)("expected:" + i));
                }
                for (Integer i : actual) {
                    TestUtil.logErr((String)("actual:" + i));
                }
            }
            actual = new ArrayList();
            expected = new ArrayList();
            expected.add(Integer.parseInt(this.customerRef[0].getId()));
            cquery = null;
            cquery = cbuilder.createQuery(Customer.class);
            customer = cquery.from(Customer.class);
            TestUtil.logMsg((String)"Testing conjunction");
            expr1 = cbuilder.equal((Expression)customer.get(Customer_.getSingularAttribute("id", String.class)), (Object)"1");
            expr2 = cbuilder.equal((Expression)customer.get(Customer_.getSingularAttribute("name", String.class)), (Object)"Alan E. Frechette");
            predicate = cbuilder.and((Expression)expr1, (Expression)expr2);
            c = predicate.getExpressions();
            if (c.size() != 2) {
                TestUtil.logErr((String)("Expected a predicate expression size of:2, actual:" + c.size()));
            } else {
                pass4 = true;
            }
            cquery.select((Selection)customer);
            cquery.where((Expression)cbuilder.and((Expression)c.get(0), (Expression)c.get(1)));
            tquery = this.getEntityManager().createQuery(cquery);
            result = tquery.getResultList();
            for (Customer cust : result) {
                TestUtil.logTrace((String)("result:" + cust));
                actual.add(Integer.parseInt(cust.getId()));
            }
            Collections.sort(actual);
            if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                TestUtil.logTrace((String)"Received expected results");
                pass5 = true;
            } else {
                TestUtil.logErr((String)"Did not get expected results");
                for (Integer i : expected) {
                    TestUtil.logErr((String)("expected:" + i));
                }
                for (Integer i : actual) {
                    TestUtil.logErr((String)("actual:" + i));
                }
            }
            this.getEntityTransaction().commit();
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        if (!(pass2 && pass3 && pass4 && pass5)) {
            throw new EETest.Fault("predicateGetExpressionsTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void predicateIsNotNullTest() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{this.customerRef[0].getId(), this.customerRef[1].getId(), this.customerRef[2].getId(), this.customerRef[3].getId(), this.customerRef[4].getId(), this.customerRef[5].getId(), this.customerRef[6].getId(), this.customerRef[7].getId(), this.customerRef[8].getId(), this.customerRef[9].getId(), this.customerRef[10].getId(), this.customerRef[12].getId(), this.customerRef[13].getId(), this.customerRef[14].getId(), this.customerRef[15].getId(), this.customerRef[16].getId(), this.customerRef[17].getId(), this.customerRef[18].getId(), this.customerRef[19].getId()};
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            if (customer != null) {
                Predicate pred = customer.get("name").isNotNull();
                cquery.where((Expression)pred);
                cquery.select((Selection)customer);
                TypedQuery tquery = this.getEntityManager().createQuery(cquery);
                List clist = tquery.getResultList();
                if (!this.checkEntityPK(clist, expected)) {
                    TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + clist.size()));
                } else {
                    TestUtil.logTrace((String)"Expected results received");
                    pass = true;
                }
            } else {
                TestUtil.logErr((String)"Failed to get Non-null root");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("predicateIsNotNullTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void predicateIsNullTest() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{this.customerRef[11].getId()};
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            if (customer != null) {
                Predicate pred = customer.get("name").isNull();
                cquery.where((Expression)pred);
                cquery.select((Selection)customer);
                TypedQuery tquery = this.getEntityManager().createQuery(cquery);
                List clist = tquery.getResultList();
                if (!this.checkEntityPK(clist, expected)) {
                    TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + clist.size()));
                } else {
                    TestUtil.logTrace((String)"Expected results received");
                    pass = true;
                }
            } else {
                TestUtil.logErr((String)"Failed to get Non-null root");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("predicateIsNullTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void pathInObjectArrayTest() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{this.customerRef[0].getId(), this.customerRef[1].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        Root customer = cquery.from(Customer.class);
        if (customer != null) {
            EntityType Customer_ = customer.getModel();
            Path idPath = customer.get(Customer_.getSingularAttribute("id", String.class));
            Object[] o = new Object[]{"1", "2"};
            cquery.where((Expression)idPath.in(o));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            if (!this.checkEntityPK(clist, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null root");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("pathInObjectArrayTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void pathInExpressionTest() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{this.customerRef[0].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        Root customer = cquery.from(Customer.class);
        if (customer != null) {
            EntityType Customer_ = customer.getModel();
            Path idPath = customer.get(Customer_.getSingularAttribute("id", String.class));
            Expression e = cbuilder.literal((Object)"1");
            cquery.where((Expression)idPath.in(e));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            if (!this.checkEntityPK(clist, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null root");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("pathInExpressionTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void pathInExpressionArrayTest() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{this.customerRef[0].getId(), this.customerRef[1].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        Root customer = cquery.from(Customer.class);
        if (customer != null) {
            EntityType Customer_ = customer.getModel();
            Path idPath = customer.get(Customer_.getSingularAttribute("id", String.class));
            Expression[] e = new Expression[]{cbuilder.literal((Object)"1"), cbuilder.literal((Object)"2")};
            cquery.where((Expression)idPath.in(e));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            if (!this.checkEntityPK(clist, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null root");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("pathInExpressionArrayTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void pathInCollectionTest() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{this.customerRef[0].getId(), this.customerRef[1].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        Root customer = cquery.from(Customer.class);
        if (customer != null) {
            EntityType Customer_ = customer.getModel();
            Path idPath = customer.get(Customer_.getSingularAttribute("id", String.class));
            ArrayList<String> col = new ArrayList<String>();
            col.add("1");
            col.add("2");
            cquery.where((Expression)idPath.in(col));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            if (!this.checkEntityPK(clist, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null root");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("pathInCollectionTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void pathIsNotNullTest() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{this.customerRef[0].getId(), this.customerRef[1].getId(), this.customerRef[2].getId(), this.customerRef[3].getId(), this.customerRef[4].getId(), this.customerRef[5].getId(), this.customerRef[6].getId(), this.customerRef[7].getId(), this.customerRef[8].getId(), this.customerRef[9].getId(), this.customerRef[10].getId(), this.customerRef[12].getId(), this.customerRef[13].getId(), this.customerRef[14].getId(), this.customerRef[15].getId(), this.customerRef[16].getId(), this.customerRef[17].getId(), this.customerRef[18].getId(), this.customerRef[19].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        Root customer = cquery.from(Customer.class);
        if (customer != null) {
            EntityType Customer_ = customer.getModel();
            Path idPath = customer.get(Customer_.getSingularAttribute("name", String.class));
            cquery.where((Expression)idPath.isNotNull());
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            if (!this.checkEntityPK(clist, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null root");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("pathIsNotNullTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void pathIsNullTest() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{this.customerRef[11].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        Root customer = cquery.from(Customer.class);
        if (customer != null) {
            EntityType Customer_ = customer.getModel();
            Path idPath = customer.get(Customer_.getSingularAttribute("name", String.class));
            cquery.where((Expression)idPath.isNull());
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            if (!this.checkEntityPK(clist, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null root");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("pathIsNullTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void compoundSelectionGetCompoundSelectionItemsTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = true;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        Expression exp1 = cbuilder.literal((Object)"1");
        Expression exp2 = cbuilder.literal((Object)"2");
        CompoundSelection cs = cbuilder.tuple(new Selection[]{exp1, exp2});
        boolean bActual = cs.isCompoundSelection();
        if (bActual) {
            List lSel = cs.getCompoundSelectionItems();
            if (lSel.size() == 2) {
                CriteriaQuery cquery = cbuilder.createTupleQuery();
                Root order = cquery.from(Order.class);
                cquery.select((Selection)cs);
                cquery.where((Expression)cbuilder.equal((Expression)order.get("id"), (Object)"1"));
                TypedQuery tquery = this.getEntityManager().createQuery(cquery);
                List result = tquery.getResultList();
                if (result.size() == 1) {
                    int i = 0;
                    for (Tuple actual : result) {
                        pass1 = true;
                        TestUtil.logTrace((String)("first=" + actual.get(0) + ", second=" + actual.get(1)));
                        if (!actual.get(0).equals("1")) {
                            TestUtil.logErr((String)("Expected: 1, actual:" + actual.get(0)));
                            pass2 = false;
                        }
                        if (!actual.get(1).equals("2")) {
                            TestUtil.logErr((String)("Expected: 2, actual:" + actual.get(1)));
                            pass2 = false;
                        }
                        ++i;
                    }
                } else {
                    TestUtil.logErr((String)("Expected: 1 tuple, actual:" + result.size()));
                    for (Tuple actual : result) {
                        TestUtil.logErr((String)("first=" + actual.get(0) + ", second=" + actual.get(1)));
                    }
                }
            } else {
                TestUtil.logErr((String)("Expected: 2 compound selection item, actual:" + lSel.size()));
                for (Selection s : lSel) {
                    TestUtil.logErr((String)("selection:" + s.toString()));
                }
            }
        } else {
            TestUtil.logErr((String)("Expected isCompoundSelection() to return: true, actual:" + bActual));
        }
        this.getEntityTransaction().commit();
        if (!pass1 || !pass2) {
            throw new EETest.Fault("compoundSelectionGetCompoundSelectionItemsTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void selectionGetCompoundSelectionItemsTest() throws EETest.Fault {
        Expression exp2;
        Expression exp1;
        boolean pass1 = false;
        boolean pass2 = true;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        CompoundSelection sel = cbuilder.tuple(new Selection[]{exp1 = cbuilder.literal((Object)"1"), exp2 = cbuilder.literal((Object)"2")});
        boolean bActual = sel.isCompoundSelection();
        if (bActual) {
            List lSel = sel.getCompoundSelectionItems();
            if (lSel.size() == 2) {
                CriteriaQuery cquery = cbuilder.createTupleQuery();
                Root order = cquery.from(Order.class);
                cquery.select((Selection)sel);
                cquery.where((Expression)cbuilder.equal((Expression)order.get("id"), (Object)"1"));
                TypedQuery tquery = this.getEntityManager().createQuery(cquery);
                List result = tquery.getResultList();
                if (result.size() == 1) {
                    for (Tuple actual : result) {
                        pass1 = true;
                        TestUtil.logTrace((String)("first=" + actual.get(0) + ", second=" + actual.get(1)));
                        if (!actual.get(0).equals("1")) {
                            TestUtil.logErr((String)("Expected: 1, actual:" + actual.get(0)));
                            pass2 = false;
                        }
                        if (actual.get(1).equals("2")) continue;
                        TestUtil.logErr((String)("Expected: 2, actual:" + actual.get(1)));
                        pass2 = false;
                    }
                } else {
                    TestUtil.logErr((String)("Expected: 1 tuple, actual:" + result.size()));
                    for (Tuple actual : result) {
                        TestUtil.logErr((String)("first=" + actual.get(0) + ", second=" + actual.get(1)));
                    }
                }
            } else {
                TestUtil.logErr((String)("Expected: 2 compound selection item, actual:" + lSel.size()));
                for (Selection s : lSel) {
                    TestUtil.logErr((String)("selection:" + s.toString()));
                }
            }
        } else {
            TestUtil.logErr((String)("Expected isCompoundSelection() to return: true, actual:" + bActual));
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("selectionGetCompoundSelectionItemsTest failed");
        }
    }

    public void selectionGetCompoundSelectionItemsIllegalStateExceptionTest() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        Root customer = cquery.from(Customer.class);
        Expression sel = cbuilder.length((Expression)customer.get(Customer_.id));
        try {
            sel.getCompoundSelectionItems();
            TestUtil.logErr((String)"Did not throw IllegalStateException");
        }
        catch (IllegalStateException ise) {
            TestUtil.logTrace((String)"Received IllegalStateException");
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("selectionGetCompoundSelectionItemsIllegalStateExceptionTest failed");
        }
    }

    public void expressionIsCompoundSelectionTest() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Expression exp = cbuilder.literal((Object)"1");
        boolean actual = exp.isCompoundSelection();
        if (!actual) {
            TestUtil.logTrace((String)("Received expected result:" + actual));
            pass = true;
        } else {
            TestUtil.logErr((String)("Expected isCompoundSelection() to return: false, actual:" + actual));
        }
        if (!pass) {
            throw new EETest.Fault("expressionGetCompoundSelectionItemsTest failed");
        }
    }

    public void expressionGetCompoundSelectionItemsIllegalStateExceptionTest() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Expression exp = cbuilder.literal((Object)"1");
        try {
            exp.getCompoundSelectionItems();
            TestUtil.logErr((String)"Did not throw IllegalStateException");
        }
        catch (IllegalStateException ise) {
            TestUtil.logTrace((String)"Received IllegalStateException");
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("expressionGetCompoundSelectionItemsIllegalStateExceptionTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void subqueryInObjectArrayTest() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{this.customerRef[0].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        Root customer = cquery.from(Customer.class);
        if (customer != null) {
            cquery.select((Selection)customer);
            Subquery sq = cquery.subquery(String.class);
            Root sqc = sq.from(Customer.class);
            Object[] o = new Object[]{"1"};
            sq.where((Expression)sqc.get(Customer_.id).in(o));
            sq.select((Expression)sqc.get(Customer_.id));
            cquery.where((Expression)customer.get(Customer_.id).in(new Expression[]{sq}));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            if (!this.checkEntityPK(clist, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null root");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("subqueryInObjectArrayTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void subqueryInExpressionArrayTest() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{this.customerRef[0].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        Root customer = cquery.from(Customer.class);
        if (customer != null) {
            cquery.select((Selection)customer);
            Subquery sq = cquery.subquery(String.class);
            Root sqc = sq.from(Customer.class);
            Expression[] exp = new Expression[]{cbuilder.literal((Object)"1")};
            sq.where((Expression)sqc.get(Customer_.id).in(exp));
            sq.select((Expression)sqc.get(Customer_.id));
            cquery.where((Expression)customer.get(Customer_.id).in(new Expression[]{sq}));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            if (!this.checkEntityPK(clist, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null root");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("subqueryInExpressionArrayTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void subqueryInExpressionTest() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{this.customerRef[0].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        Root customer = cquery.from(Customer.class);
        if (customer != null) {
            cquery.select((Selection)customer);
            Subquery sq = cquery.subquery(String.class);
            Root sqc = sq.from(Customer.class);
            Expression exp = cbuilder.literal((Object)"1");
            sq.where((Expression)sqc.get(Customer_.id).in(exp));
            sq.select((Expression)sqc.get(Customer_.id));
            cquery.where((Expression)customer.get(Customer_.id).in(new Expression[]{sq}));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            if (!this.checkEntityPK(clist, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null root");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("subqueryInExpressionTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void subqueryInCollectionTest() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{this.customerRef[0].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        Root customer = cquery.from(Customer.class);
        if (customer != null) {
            cquery.select((Selection)customer);
            Subquery sq = cquery.subquery(String.class);
            Root sqc = sq.from(Customer.class);
            ArrayList<String> col = new ArrayList<String>();
            col.add("1");
            sq.where((Expression)sqc.get(Customer_.id).in(col));
            sq.select((Expression)sqc.get(Customer_.id));
            cquery.where((Expression)customer.get(Customer_.id).in(new Expression[]{sq}));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            if (!this.checkEntityPK(clist, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null root");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("subqueryInCollectionTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void subqueryIsNotNull() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{this.customerRef[0].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        Root customer = cquery.from(Customer.class);
        if (customer != null) {
            Subquery sq = cquery.subquery(String.class);
            Root sqc = sq.from(Customer.class);
            sq.where((Expression)cbuilder.and((Expression)cbuilder.isNotNull((Expression)sqc.get(Customer_.name)), (Expression)cbuilder.equal((Expression)sqc.get(Customer_.id), (Object)"1")));
            sq.select((Expression)sqc.get(Customer_.id));
            cquery.where((Expression)customer.get(Customer_.id).in(new Expression[]{sq}));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            if (!this.checkEntityPK(clist, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null root");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("subqueryIsNotNull test failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void subqueryIsNull() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{this.customerRef[11].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        Root customer = cquery.from(Customer.class);
        if (customer != null) {
            Subquery sq = cquery.subquery(String.class);
            Root sqc = sq.from(Customer.class);
            sq.where((Expression)cbuilder.isNull((Expression)sqc.get(Customer_.name)));
            sq.select((Expression)sqc.get(Customer_.id));
            cquery.where((Expression)customer.get(Customer_.id).in(new Expression[]{sq}));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            if (!this.checkEntityPK(clist, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null root");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("subqueryIsNull test failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void pathGetPluralAttributeTest() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{this.customerRef[3].getId(), this.customerRef[13].getId()};
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)cbuilder.gt(cbuilder.size(customer.get((PluralAttribute)Customer_.orders)), (Number)1)).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            if (!this.checkEntityPK(clist, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("pathGetPluralAttributeTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void subquery() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder qbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = qbuilder.createQuery(Order.class);
            Root order = cquery.from(Order.class);
            cquery.select((Selection)order);
            Subquery sq = cquery.subquery(Customer.class);
            Root sqo = sq.correlate(order);
            Join sqc = sqo.join("customer");
            sq.where((Expression)qbuilder.like((Expression)sqc.get("name"), "%Caruso")).select((Expression)sqc);
            cquery.where((Expression)qbuilder.exists(sq));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"7", "8"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("test_subquery_like:  Did not get expected  results.  Expected 2 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception subquery: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("subquery failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void subqueryGroupByExpressionTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        boolean pass4 = false;
        boolean pass5 = false;
        CriteriaBuilder qbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = qbuilder.createQuery(Order.class);
            Root order = cquery.from(Order.class);
            EntityType Order_ = order.getModel();
            cquery.select((Selection)order);
            Subquery subquery = cquery.subquery(String.class);
            List gList = subquery.getGroupList();
            if (gList.size() == 0) {
                TestUtil.logTrace((String)"Received expected empty list from getGroupList() when there is no groupBy expressions");
                pass1 = true;
            } else {
                TestUtil.logErr((String)"Did not received empty list from getGroupList() when there is no groupBy expressions");
                for (Expression e : gList) {
                    TestUtil.logErr((String)("Item:" + e.toString()));
                }
            }
            Expression sel = subquery.getSelection();
            if (sel == null) {
                TestUtil.logTrace((String)"Received expected null from getSelection() when there is no selection specified");
                pass2 = true;
            } else {
                TestUtil.logErr((String)("Did not received null from getSelection() when there is no selection specified:" + sel.toString()));
            }
            Root customer = subquery.from(Customer.class);
            EntityType Customer_2 = customer.getModel();
            subquery.select((Expression)customer.get(Customer_2.getSingularAttribute("name", String.class)));
            sel = subquery.getSelection();
            if (sel != null) {
                TestUtil.logTrace((String)"Received non-result from getSelection()");
                pass3 = true;
            } else {
                TestUtil.logErr((String)"Received null from getSelection() when there is a selection specified");
            }
            subquery.where((Expression)qbuilder.like((Expression)customer.get(Customer_2.getSingularAttribute("name", String.class)), "%Caruso"));
            Path exp = customer.get(Customer_2.getSingularAttribute("name", String.class));
            subquery.groupBy(new Expression[]{exp});
            gList = subquery.getGroupList();
            if (gList != null) {
                TestUtil.logTrace((String)"Received non-null from getGroupList() when there is groupBy expressions");
                if (gList.size() == 1) {
                    TestUtil.logTrace((String)"Received one groupBy expression");
                    pass4 = true;
                } else {
                    TestUtil.logErr((String)("Expected one groupBy expression, actual:" + gList.size()));
                    for (Expression e : gList) {
                        TestUtil.logErr((String)("Did not get expected result:" + e));
                    }
                }
            } else {
                TestUtil.logErr((String)"Received null from getGroupList() when there is groupBy expressions");
            }
            cquery.where((Expression)order.get(Order_.getSingularAttribute("customer", Customer.class)).get(Customer_2.getSingularAttribute("name", String.class)).in(new Expression[]{subquery}));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"7", "8"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected  results.  Expected 2 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass5 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception: ", (Throwable)e);
        }
        if (!(pass1 && pass2 && pass3 && pass4 && pass5)) {
            throw new EETest.Fault("subqueryGroupByExpressionTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void subqueryGroupByExpressionArrayTest() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder qbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = qbuilder.createQuery(Order.class);
            Root order = cquery.from(Order.class);
            EntityType Order_ = order.getModel();
            cquery.select((Selection)order);
            Subquery subquery = cquery.subquery(String.class);
            Root customer = subquery.from(Customer.class);
            EntityType Customer_2 = customer.getModel();
            subquery.select((Expression)customer.get(Customer_2.getSingularAttribute("id", String.class)));
            subquery.where((Expression)qbuilder.like((Expression)customer.get(Customer_2.getSingularAttribute("name", String.class)), "%Caruso"));
            Expression[] exp = new Expression[]{customer.get(Customer_2.getSingularAttribute("id", String.class))};
            subquery.groupBy(exp);
            cquery.where((Expression)order.get(Order_.getSingularAttribute("customer", Customer.class)).get(Customer_2.getSingularAttribute("id", String.class)).in(new Expression[]{subquery}));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"7", "8"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected  results.  Expected 2 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception subquery: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("subqueryGroupByExpressionArrayTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void subqueryGroupByListTest() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder qbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = qbuilder.createQuery(Order.class);
            Root order = cquery.from(Order.class);
            EntityType Order_ = order.getModel();
            cquery.select((Selection)order);
            Subquery subquery = cquery.subquery(String.class);
            Root customer = subquery.from(Customer.class);
            EntityType Customer_2 = customer.getModel();
            subquery.select((Expression)customer.get(Customer_2.getSingularAttribute("id", String.class)));
            subquery.where((Expression)qbuilder.like((Expression)customer.get(Customer_2.getSingularAttribute("name", String.class)), "%Caruso"));
            ArrayList<Path> list = new ArrayList<Path>();
            list.add(customer.get(Customer_2.getSingularAttribute("id", String.class)));
            subquery.groupBy(list);
            cquery.where((Expression)order.get(Order_.getSingularAttribute("customer", Customer.class)).get(Customer_2.getSingularAttribute("id", String.class)).in(new Expression[]{subquery}));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"7", "8"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected  results.  Expected 2 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception subquery: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("subqueryGroupByListTest failed");
        }
    }

    public void getRoots() throws EETest.Fault {
        boolean pass = false;
        try {
            CriteriaBuilder qbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            CriteriaQuery cquery = qbuilder.createTupleQuery();
            if (cquery != null) {
                cquery.from(Customer.class);
                cquery.from(Order.class);
                Set rootSet = cquery.getRoots();
                if (rootSet != null) {
                    if (rootSet.size() == 2) {
                        int count = 0;
                        boolean foundCustomer = false;
                        boolean foundOrder = false;
                        for (Root newRoot : rootSet) {
                            EntityType eType1 = newRoot.getModel();
                            String name = eType1.getName();
                            TestUtil.logTrace((String)("entityType Name = " + name));
                            if (name.equals("Customer")) {
                                TestUtil.logTrace((String)("Received expected name:" + name));
                                foundCustomer = true;
                                ++count;
                            }
                            if (!name.equals("Order")) continue;
                            TestUtil.logTrace((String)("Received expected name:" + name));
                            foundOrder = true;
                            ++count;
                        }
                        if (count == 2 && foundCustomer && foundOrder) {
                            pass = true;
                        } else {
                            TestUtil.logErr((String)"Did not get Customer and Order roots back from getRoot");
                        }
                    } else {
                        TestUtil.logErr((String)"getRoots did not return 2 entries in the set");
                    }
                } else {
                    TestUtil.logErr((String)"getRoots returned null");
                }
            } else {
                TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("getRoots test failed");
        }
    }

    public void getSelection() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        try {
            CriteriaBuilder qbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            TestUtil.logMsg((String)"Testing non-compound selection");
            CriteriaQuery cquery = qbuilder.createQuery(Customer.class);
            if (cquery != null) {
                Root customer = cquery.from(Customer.class);
                cquery.select((Selection)customer);
                Selection _select = cquery.getSelection();
                if (_select != null) {
                    if (!_select.isCompoundSelection()) {
                        TestUtil.logTrace((String)"isCompoundSelection returned expected false");
                        pass1 = true;
                    } else {
                        TestUtil.logErr((String)"isCompoundSelection returned true instead of false");
                    }
                    String javaName = _select.getJavaType().getName();
                    if (javaName.equals("com.sun.ts.tests.jpa.common.schema30.Customer")) {
                        pass2 = true;
                    } else {
                        TestUtil.logErr((String)("Expected: com.sun.ts.tests.jpa.common.schema30.Customer, actual:" + javaName));
                    }
                } else {
                    TestUtil.logErr((String)"get Selection returned null");
                }
                TestUtil.logMsg((String)"Testing compound selection");
                CriteriaQuery cquery1 = qbuilder.createQuery();
                customer = cquery1.from(Customer.class);
                EntityType CUSTOMER_ = customer.getModel();
                cquery1.multiselect(new Selection[]{customer.get(CUSTOMER_.getSingularAttribute("id", String.class)), customer.get(CUSTOMER_.getSingularAttribute("name", String.class))});
                Selection _select1 = cquery1.getSelection();
                if (_select1 != null) {
                    if (_select1.isCompoundSelection()) {
                        TestUtil.logTrace((String)"isCompoundSelection returned expected true");
                        pass3 = true;
                    } else {
                        TestUtil.logErr((String)"isCompoundSelection returned false");
                    }
                } else {
                    TestUtil.logErr((String)"get Selection returned null");
                }
            } else {
                TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception ", (Throwable)e);
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new EETest.Fault("getSelection failed");
        }
    }

    public void getGroupList() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            CriteriaBuilder qbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            CriteriaQuery cquery = qbuilder.createQuery(Customer.class);
            if (cquery != null) {
                Root customer = cquery.from(Customer.class);
                TestUtil.logMsg((String)"Testing with NO group expressions");
                List groupList = cquery.getGroupList();
                if (groupList != null) {
                    if (groupList.size() == 0) {
                        TestUtil.logTrace((String)"Received empty list from getGroupList");
                        pass1 = true;
                    } else {
                        TestUtil.logErr((String)("Expected : 0 Received :" + groupList.size()));
                        for (Expression strExpr : groupList) {
                            TestUtil.logErr((String)("Expression:" + strExpr.toString()));
                        }
                    }
                } else {
                    TestUtil.logErr((String)"getGroupList returned null instead of empty list when no groupby expressions have been specified");
                }
                TestUtil.logMsg((String)"Testing with group expressions");
                Path e = customer.get("name");
                cquery.groupBy(new Expression[]{e});
                groupList = cquery.getGroupList();
                if (groupList != null) {
                    if (groupList.size() == 1) {
                        for (Expression strExpr : groupList) {
                            String sType = strExpr.getJavaType().getName();
                            if (sType.equals("java.lang.String")) {
                                TestUtil.logTrace((String)("Received expected type:" + sType));
                                pass2 = true;
                                continue;
                            }
                            TestUtil.logErr((String)("Expected type: java.lang.String, actual:" + sType));
                        }
                    } else {
                        TestUtil.logErr((String)("Expected : 1 Received :" + groupList.size()));
                        for (Expression strExpr : groupList) {
                            TestUtil.logErr((String)("Actual expression:" + strExpr.toString()));
                        }
                    }
                } else {
                    TestUtil.logErr((String)"getGroupList returned null instead of a populated list when groupby expressions have been specified");
                }
            } else {
                TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception groupBy: " + e));
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("getGroupList failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void getGroupRestriction() throws EETest.Fault {
        boolean pass = false;
        try {
            CriteriaBuilder qbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            CriteriaQuery cquery = qbuilder.createQuery();
            if (cquery != null) {
                Root customer = cquery.from(Customer.class);
                Predicate[] pred = new Predicate[]{qbuilder.like((Expression)customer.get(Customer_.name), "K%")};
                cquery.having(pred);
                Predicate restriction = cquery.getGroupRestriction();
                if (restriction != null) {
                    cquery.groupBy(new Expression[]{customer.get("name")});
                    EntityType Customer_2 = customer.getModel();
                    cquery.select((Selection)customer.get(Customer_2.getSingularAttribute("name", String.class)));
                    List actual = this.getEntityManager().createQuery(cquery).getResultList();
                    ArrayList<String> expected = new ArrayList<String>();
                    expected.add(this.customerRef[5].getName());
                    expected.add(this.customerRef[9].getName());
                    expected.add(this.customerRef[13].getName());
                    if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                        TestUtil.logTrace((String)"Received expected results");
                        pass = true;
                    } else {
                        TestUtil.logErr((String)"Did not get expected results");
                        for (String s : expected) {
                            TestUtil.logErr((String)("expected:" + s));
                        }
                        for (String s : actual) {
                            TestUtil.logErr((String)("actual:" + s));
                        }
                    }
                } else {
                    TestUtil.logErr((String)"getGroupRestriction returned null instead of groupBy expressions");
                }
            } else {
                TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception getGroupRestriction: " + e));
        }
        if (!pass) {
            throw new EETest.Fault("getGroupRestriction failed");
        }
    }

    public void isDistinct() throws EETest.Fault {
        boolean pass = false;
        try {
            CriteriaBuilder qbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            CriteriaQuery cquery = qbuilder.createQuery();
            if (cquery != null) {
                cquery.from(Customer.class);
                cquery.distinct(true);
                Boolean isDistinct = cquery.isDistinct();
                if (isDistinct.booleanValue()) {
                    pass = true;
                }
            } else {
                TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected excetion: " + e));
        }
        if (!pass) {
            throw new EETest.Fault("isDistinct test failed");
        }
    }

    public void getResultType() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        try {
            Class resultType;
            CriteriaBuilder qbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            TestUtil.logMsg((String)"Testing specific class return type");
            String expected = "com.sun.ts.tests.jpa.common.schema30.Customer";
            CriteriaQuery cquery = qbuilder.createQuery(Customer.class);
            if (cquery != null) {
                resultType = cquery.getResultType();
                if (resultType != null) {
                    if (resultType.getName().equals(expected)) {
                        TestUtil.logTrace((String)"Got Expected Result Type");
                        pass1 = true;
                    } else {
                        TestUtil.logErr((String)("Received  UnExpected Result Type :" + resultType.getName()));
                    }
                } else {
                    TestUtil.logErr((String)("getResultType returned null instead of:" + expected));
                }
            } else {
                TestUtil.logErr((String)("Failed to get Non-null Criteria Query for:" + expected));
            }
            TestUtil.logMsg((String)"Testing Tuple return type");
            expected = "javax.persistence.Tuple";
            cquery = qbuilder.createQuery(Tuple.class);
            if (cquery != null) {
                resultType = cquery.getResultType();
                if (resultType != null) {
                    if (resultType.getName().equals(expected)) {
                        TestUtil.logTrace((String)"Got Expected Result Type");
                        pass2 = true;
                    } else {
                        TestUtil.logErr((String)("Received  UnExpected Result Type :" + resultType.getName()));
                    }
                } else {
                    TestUtil.logErr((String)("getResultType returned null instead of:" + expected));
                }
            } else {
                TestUtil.logErr((String)("getResultType returned null instead of:" + expected));
            }
            TestUtil.logMsg((String)"Testing Object return type");
            expected = "java.lang.Object";
            cquery = qbuilder.createQuery();
            if (cquery != null) {
                resultType = cquery.getResultType();
                if (resultType != null) {
                    if (resultType.getName().equals(expected)) {
                        TestUtil.logTrace((String)"Got Expected Result Type");
                        pass3 = true;
                    } else {
                        TestUtil.logErr((String)("Received  UnExpected Result Type :" + resultType.getName()));
                    }
                } else {
                    TestUtil.logErr((String)("getResultType returned null instead of:" + expected));
                }
            } else {
                TestUtil.logErr((String)("getResultType returned null instead of:" + expected));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception getGroupRestriction: " + e));
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new EETest.Fault("getResultType test failed");
        }
    }
}

