/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.rmiiiop.ee.objecttests;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.rmiiiop.ee.objecttests.HelloJAVAIDLObjectIntf;
import com.sun.ts.tests.rmiiiop.ee.objecttests.HelloRMIIIOPObjectIntf;
import java.util.Properties;
import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;

public class TestBeanEJB
implements SessionBean {
    private SessionContext sctx = null;
    private Properties harnessProps = null;

    public void ejbCreate(Properties p) throws CreateException {
        TestUtil.logTrace((String)"ejbCreate");
        this.harnessProps = p;
        try {
            TestUtil.logMsg((String)"Initialize remote logging");
            TestUtil.init((Properties)p);
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException(e.getMessage());
        }
    }

    public void setSessionContext(SessionContext sc) {
        TestUtil.logTrace((String)"setSessionContext");
        this.sctx = sc;
    }

    public void ejbRemove() {
        TestUtil.logTrace((String)"ejbRemove");
    }

    public void ejbActivate() {
        TestUtil.logTrace((String)"ejbActivate");
    }

    public void ejbPassivate() {
        TestUtil.logTrace((String)"ejbPassivate");
    }

    public boolean pass_a_rmiiiop_object(HelloRMIIIOPObjectIntf p1) {
        String methodName = "pass_a_rmiiiop_object";
        String expStr = "Hello from HelloRMIIIOPObjectImpl";
        TestUtil.logTrace((String)methodName);
        boolean pass = true;
        if (p1 == null) {
            TestUtil.logErr((String)"Could not receive a rmiiiop object (p1 is null)");
            pass = false;
        } else {
            try {
                TestUtil.logMsg((String)"Invoke methods on the rmiiiop object reference");
                String hello = p1.hello();
                if (!hello.equals(expStr)) {
                    TestUtil.logErr((String)("Wrong message, got [" + hello + "]"));
                    TestUtil.logErr((String)("Wrong message, expected [" + expStr + "]"));
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Unable to invoke the methods of the rmiiiop object");
                TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
                TestUtil.printStackTrace((Throwable)e);
                pass = false;
            }
        }
        return pass;
    }

    public HelloRMIIIOPObjectIntf return_a_rmiiiop_object(HelloRMIIIOPObjectIntf p1) {
        String methodName = "return_a_rmiiiop_object";
        TestUtil.logTrace((String)methodName);
        return p1;
    }

    public boolean pass_a_javaidl_object(HelloJAVAIDLObjectIntf p1) {
        boolean pass = false;
        String expStr = "Hello from HelloJAVAIDLObjectImpl";
        try {
            TestUtil.logTrace((String)"[TestBeanEJB] pass_a_javaidl_object");
            if (null == p1) {
                TestUtil.logErr((String)"Could not receive a javaidl object (p1 is null)");
                return false;
            }
            TestUtil.logMsg((String)"Invoke methods on the javaidl object reference");
            String hello = p1.hello();
            if (!hello.equals(expStr)) {
                TestUtil.logErr((String)("Wrong message, got [" + hello + "], expected [" + expStr + "]"));
                return false;
            }
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unable to invoke the methods of the javaidl object", (Throwable)e);
        }
        return pass;
    }

    public HelloJAVAIDLObjectIntf return_a_javaidl_object(HelloJAVAIDLObjectIntf p1) {
        TestUtil.logTrace((String)"[TestBeanEJB] return_a_javaidl_object()");
        return p1;
    }

    public String hello() {
        return "Hello from TestBeanEJB";
    }
}

