/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.lite.singleton.lifecycle.interceptor;

import com.sun.ts.tests.ejb30.common.helper.Helper;
import com.sun.ts.tests.ejb30.common.lite.EJBLiteClientBase;
import com.sun.ts.tests.ejb30.lite.singleton.lifecycle.interceptor.ASingletonBean;
import com.sun.ts.tests.ejb30.lite.singleton.lifecycle.interceptor.C2SingletonIF;
import com.sun.ts.tests.ejb30.lite.singleton.lifecycle.interceptor.CSingletonIF;
import com.sun.ts.tests.ejb30.lite.singleton.lifecycle.interceptor.CommonSingletonIF;
import com.sun.ts.tests.ejb30.lite.singleton.lifecycle.interceptor.Interceptor0;
import com.sun.ts.tests.ejb30.lite.singleton.lifecycle.interceptor.Interceptor1;
import com.sun.ts.tests.ejb30.lite.singleton.lifecycle.interceptor.Interceptor2;
import com.sun.ts.tests.ejb30.lite.singleton.lifecycle.interceptor.Interceptor3;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import javax.ejb.EJB;
import javax.ejb.EJBException;

public class Client
extends EJBLiteClientBase {
    private static final int NUM_OF_CONCURRENT_REQUESTS = 1000;
    private static final String[] INTERCEPTORS = new String[]{Interceptor0.class.getSimpleName(), Interceptor1.class.getSimpleName(), Interceptor2.class.getSimpleName(), Interceptor3.class.getSimpleName()};
    @EJB(name="ejb/aSingleton", beanName="ASingletonBean")
    private ASingletonBean aSingleton;
    @EJB(name="ejb/cSingleton", beanName="CSingletonBean")
    private CSingletonIF cSingleton;
    @EJB(name="ejb/c2Singleton", beanName="CSingletonBean")
    private C2SingletonIF c2Singleton;

    public void sameInterceptorInstanceA() {
        for (String i : INTERCEPTORS) {
            this.sameInterceptorInstance(this.aSingleton, i, new int[0]);
        }
    }

    public void sameInterceptorInstanceC() {
        for (String i : INTERCEPTORS) {
            this.sameInterceptorInstance(this.cSingleton, i, this.c2Singleton.identityHashCode(i));
        }
    }

    public void noDestructionAfterSystemExceptionA() {
        for (String i : INTERCEPTORS) {
            this.noDestructionAfterSystemException(this.aSingleton, i);
        }
    }

    public void noDestructionAfterSystemExceptionC() {
        for (CommonSingletonIF b : new CommonSingletonIF[]{this.c2Singleton, this.cSingleton}) {
            for (String i : INTERCEPTORS) {
                this.noDestructionAfterSystemException(b, i);
            }
        }
    }

    public void differentInterceptorInstance() {
        this.appendReason("Check different interceptor instances of the same type associated with different singletons.");
        for (String i : INTERCEPTORS) {
            this.assertNotEquals(null, this.aSingleton.identityHashCode(i), this.cSingleton.identityHashCode(i));
            this.assertNotEquals(null, this.aSingleton.identityHashCode(i), this.c2Singleton.identityHashCode(i));
        }
    }

    private void noDestructionAfterSystemException(CommonSingletonIF b, String interceptorName) {
        int id1 = b.identityHashCode(interceptorName);
        try {
            b.error(interceptorName);
        }
        catch (EJBException e) {
            Exception cause = e.getCausedByException();
            if (cause instanceof IllegalStateException) {
                throw new RuntimeException("Expecting a RuntimeException from one of the interceptors, but got IllegalStateException from bean class" + cause.getMessage());
            }
            this.appendReason("Got expected RuntimeException from one of the interceptors");
        }
        int id2 = b.identityHashCode(interceptorName);
        this.assertEquals("Check ids for interceptor " + interceptorName, id1, id2);
    }

    private void sameInterceptorInstance(final CommonSingletonIF b, final String interceptorName, int ... expectedVals) {
        Thread[] threads = new Thread[1000];
        final Vector ids = new Vector();
        for (int i = 0; i < 1000; ++i) {
            threads[i] = new Thread(new Runnable(){

                @Override
                public void run() {
                    ids.add(b.identityHashCode(interceptorName));
                }
            });
            threads[i].start();
        }
        for (Thread t : threads) {
            try {
                t.join();
            }
            catch (InterruptedException ex) {
                Helper.getLogger().log(Level.SEVERE, null, ex);
            }
        }
        this.assertEquals("Checking # of ids. ", 1000, ids.size());
        int expected = expectedVals.length == 0 ? b.identityHashCode(interceptorName) : expectedVals[0];
        Iterator iterator = ids.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            if (i == expected) continue;
            this.assertEquals("Compare id for interceptor " + interceptorName, expected, i);
        }
    }
}

