/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.interop.csiv2.common.validation;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.interop.csiv2.common.parser.CSIv2LogEntry;
import com.sun.ts.tests.interop.csiv2.common.parser.ParseException;
import com.sun.ts.tests.interop.csiv2.common.parser.Parser;
import com.sun.ts.tests.interop.csiv2.common.validation.CSIv2LogValidator;
import com.sun.ts.tests.interop.csiv2.common.validation.RequestValidationStrategy;
import com.sun.ts.tests.interop.csiv2.common.validation.ResponseValidationStrategy;
import com.sun.ts.tests.interop.csiv2.common.validation.ValidationException;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

public class ValidationTest {
    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Usage: java " + ValidationTest.class.getName() + "<log.xml> <assertion-name>");
            System.exit(1);
        }
        String filename = args[0];
        String assertionName = args[1];
        Parser p = new Parser();
        String data = "";
        try {
            BufferedReader in = new BufferedReader(new FileReader(filename));
            String line = "";
            while ((line = in.readLine()) != null) {
                data = data + line + "\n";
            }
            in.close();
            CSIv2LogEntry csiv2LogEntry = p.parse(data);
            CSIv2LogValidator validator = new CSIv2LogValidator(assertionName, csiv2LogEntry, null, new RequestValidationStrategy(false, true, true, 0), new ResponseValidationStrategy(true, false));
            boolean result = validator.validate();
            System.out.println("Validation Result: " + (result ? "PASS" : "FAIL"));
        }
        catch (IOException e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        catch (ParseException e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        catch (ValidationException e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }
}

