/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.concurrency.spec.ContextService.tx;

import com.sun.ts.lib.util.TestUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.enterprise.concurrent.ContextService;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.transaction.Transaction;

public class Util {
    private Util() {
    }

    public static ContextService lookupDefaultContextService() throws NamingException {
        InitialContext ctx = new InitialContext();
        ContextService cs = (ContextService)ctx.lookup("java:comp/DefaultContextService");
        return cs;
    }

    public static Transaction lookupUserTransaction() throws NamingException {
        InitialContext ctx = new InitialContext();
        Transaction tx = (Transaction)ctx.lookup("java:comp/UserTransaction");
        return tx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T lookup(String jndiName) {
        InitialContext ctx = null;
        Object targetObject = null;
        try {
            ctx = new InitialContext();
            targetObject = ctx.lookup(jndiName);
        }
        catch (Exception e) {
        }
        finally {
            try {
                ctx.close();
            }
            catch (NamingException e) {
                TestUtil.logErr((String)"failed to lookup resource.", (Throwable)e);
            }
        }
        return (T)targetObject;
    }

    public static Connection getConnection(DataSource ds, String user, String pwd, boolean autoCommit) {
        Connection conn = null;
        try {
            conn = ds.getConnection();
            if (conn == null) {
                conn = ds.getConnection(user, pwd);
            }
            if (null != conn) {
                conn.setAutoCommit(autoCommit);
            }
        }
        catch (SQLException e) {
            TestUtil.logErr((String)"failed to get connection.", (Throwable)e);
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCount(String tableName, String username, String password) {
        Connection conn = Util.getConnection(true, username, password);
        Statement stmt = null;
        try {
            String queryStr = "select count(*) from " + tableName;
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(queryStr);
            if (rs.next()) {
                int n = rs.getInt(1);
                return n;
            }
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCount(String tableName, Connection conn) {
        Statement stmt = null;
        try {
            String queryStr = "select count(*) from " + tableName;
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(queryStr);
            if (rs.next()) {
                int n = rs.getInt(1);
                return n;
            }
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getResults(String tableName, Connection conn) {
        Statement stmt = null;
        try {
            String queryStr = "select * from " + tableName;
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(queryStr);
            while (rs.next()) {
                System.out.println(rs.getString(1));
                System.out.println(rs.getString(2));
            }
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return -1;
    }

    public static Connection getConnection(boolean autoCommit, String username, String password) {
        DataSource ds = (DataSource)Util.lookup("jdbc/DB1");
        Connection conn = Util.getConnection(ds, username, password, autoCommit);
        return conn;
    }
}

