/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee.ejb.sessionQtests;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import com.sun.ts.tests.jms.commonee.Tests;
import java.util.Properties;
import javax.ejb.EJB;

public class Client
extends EETest {
    private static final String testName = "com.sun.ts.tests.jms.ee.ejb.sessionQtests.Client";
    private static final String testDir = System.getProperty("user.dir");
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    @EJB(name="ejb/SessionTestsQ")
    private static Tests beanRef;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            if (beanRef == null) {
                throw new EETest.Fault("@EJB injection failed");
            }
            this.props = p;
            this.timeout = Long.parseLong(p.getProperty("jms_timeout"));
            this.user = p.getProperty("user");
            this.password = p.getProperty("password");
            this.mode = p.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new EETest.Fault("'jms_timeout' (milliseconds) in ts.jte must be > 0");
            }
            if (this.user == null) {
                throw new EETest.Fault("'user' in ts.jte must not be null ");
            }
            if (this.password == null) {
                throw new EETest.Fault("'password' in ts.jte must not be null ");
            }
            if (this.mode == null) {
                throw new EETest.Fault("'platform.mode' in ts.jte must not be null");
            }
            beanRef.initLogging(this.props);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("Setup failed!", e);
        }
    }

    public void cleanup() throws EETest.Fault {
    }

    private void flushTheQueue() throws EETest.Fault {
        JmsTool tool = null;
        try {
            tool = new JmsTool(13, this.user, this.password, this.mode);
            TestUtil.logTrace((String)"Closing default Connection");
            tool.getDefaultConnection().close();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Error creating JmsTool and closing Connection", (Throwable)e);
        }
        finally {
            try {
                tool.flushDestination();
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error flush Destination: ", (Throwable)e);
            }
        }
    }

    public void simpleSendReceiveQueueTest() throws EETest.Fault {
        block12: {
            String testMessage = "Just a test";
            String messageReceived = null;
            try {
                beanRef.sendTextMessage_CQ(testName, testMessage);
                messageReceived = beanRef.receiveTextMessage_CQ();
                if (messageReceived != null) {
                    if (messageReceived.equals(testMessage)) {
                        this.logMsg("Message text: \"" + messageReceived + "\"");
                        this.logMsg("Received correct message");
                        break block12;
                    }
                    throw new Exception("didn't get the right message");
                }
                throw new Exception("didn't get any message");
            }
            catch (Exception e) {
                this.logErr("simpleSendReceiveQueueTest failed: ", e);
                throw new EETest.Fault("simpleSendReceiveQueueTest failed !", e);
            }
            finally {
                try {
                    this.flushTheQueue();
                    if (null != beanRef) {
                        beanRef.remove();
                    }
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"[Client] Ignoring Exception on bean remove", (Throwable)e);
                }
            }
        }
    }

    public void selectorAndBrowserTests() throws EETest.Fault {
        String testMessage = "Just a test: selectorAndBrowserTests";
        boolean pass = true;
        Object messageReceived = null;
        try {
            beanRef.sendMessageP_CQ(testName, testMessage, false);
            beanRef.sendMessagePP_CQ(testName, testMessage, true, "TEST", "test");
            int msgNum = beanRef.browseTextMessage_CQ(2, testMessage);
            TestUtil.logTrace((String)("Default browser found " + msgNum + " messages"));
            if (!beanRef.getQueue()) {
                TestUtil.logErr((String)"Error: QueueBrowser.getQueue test failed");
                pass = false;
            }
            msgNum = beanRef.browseMessageS_CQ(1, testMessage, "TEST = 'test'");
            TestUtil.logTrace((String)("Selective browser find " + msgNum + " messages"));
            if (!beanRef.getSelector("TEST = 'test'")) {
                TestUtil.logErr((String)"Error: QueueBrowser.getMessageSelector test failed");
                pass = false;
            }
            if (!pass) {
                throw new EETest.Fault("selectorAndBrowserTests Failed!");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("selectorAndBrowserTests");
        }
        finally {
            try {
                this.flushTheQueue();
                if (null != beanRef) {
                    beanRef.remove();
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"[Client] Ignoring Exception on bean remove", (Throwable)e);
            }
        }
    }
}

