/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.lite.interceptor.common.business;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb30.common.appexception.AtCheckedRollbackAppException;
import com.sun.ts.tests.ejb30.common.helper.ServiceLocator;
import com.sun.ts.tests.ejb30.lite.interceptor.common.business.InterceptorIF;
import javax.annotation.Resource;
import javax.ejb.Singleton;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.interceptor.ExcludeDefaultInterceptors;
import javax.naming.Context;
import javax.transaction.UserTransaction;

@Singleton
@ExcludeDefaultInterceptors
@TransactionManagement(value=TransactionManagementType.BEAN)
public class TestBean {
    @Resource
    private UserTransaction ut;

    public String applicationExceptionRollback() {
        StringBuilder sb = new StringBuilder();
        InterceptorIF interceptorBean = (InterceptorIF)ServiceLocator.lookupNoTry("java:module/InterceptorBean", new Context[0]);
        try {
            this.ut.begin();
            interceptorBean.applicationExceptionRollback();
            throw new RuntimeException("Expecting AtCheckedRollbackAppException, but got none");
        }
        catch (AtCheckedRollbackAppException e2) {
            int status;
            sb.append("Got expected " + e2);
            try {
                status = this.ut.getStatus();
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
            String statusDisplay = TestUtil.getTransactionStatus((int)status);
            if (status != 1 && status != 4 && status != 9) {
                throw new RuntimeException("Got unexpected transaction status code: " + statusDisplay);
            }
            sb.append("Got expected status code " + statusDisplay);
            try {
                this.ut.rollback();
            }
            catch (Exception e2) {}
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                try {
                    this.ut.rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return sb.toString();
    }
}

