/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonb.api.jsonbadapter;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.tests.jsonb.api.model.SimpleContainer;
import com.sun.ts.tests.jsonb.api.model.SimpleContainerContainer;
import com.sun.ts.tests.jsonb.api.model.SimpleStringAdapter;
import java.util.Properties;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import javax.json.bind.JsonbConfig;
import javax.json.bind.adapter.JsonbAdapter;

public class JsonbAdapterTest
extends ServiceEETest {
    private static final long serialVersionUID = 10L;

    public static void main(String[] args) {
        JsonbAdapterTest t = new JsonbAdapterTest();
        Status s = t.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public Status testAdaptFromJson() throws EETest.Fault {
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withAdapters(new JsonbAdapter[]{new SimpleStringAdapter()}));
        SimpleContainerContainer unmarshalledObject = (SimpleContainerContainer)jsonb.fromJson("{ \"instance\" : { \"instance\" : \"Test String Adapted\" } }", SimpleContainerContainer.class);
        if (!"Test String".equals(unmarshalledObject.getInstance().getInstance())) {
            throw new EETest.Fault("Failed to use JsonbAdapter.adaptFromJson method to provide conversion logic from adapted object to original during object deserialization.");
        }
        return Status.passed((String)"OK");
    }

    public Status testAdaptToJson() throws EETest.Fault {
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withAdapters(new JsonbAdapter[]{new SimpleStringAdapter()}));
        String jsonString = jsonb.toJson((Object)new SimpleContainerContainer(){
            {
                this.setInstance(new SimpleContainer(){
                    {
                        this.setInstance("Test String");
                    }
                });
            }
        });
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\\{\\s*\"instance\"\\s*:\\s*\"Test String Adapted\"\\s*}\\s*}")) {
            throw new EETest.Fault("Failed to use JsonbAdapter.adaptToJson method to provide conversion logic from original object to adapted during object serialization.");
        }
        return Status.passed((String)"OK");
    }
}

