/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonp.api.jsonreadertests;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jsonp.api.common.JsonAssert;
import com.sun.ts.tests.jsonp.api.common.JsonValueType;
import com.sun.ts.tests.jsonp.api.common.SimpleValues;
import com.sun.ts.tests.jsonp.api.common.TestResult;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import javax.json.Json;
import javax.json.JsonException;
import javax.json.JsonReader;
import javax.json.JsonValue;
import javax.json.stream.JsonParsingException;

public class Reader {
    private static final Object[] VALUES = new Object[]{SimpleValues.OBJ_VALUE, SimpleValues.createEmptyArrayWithStr(), "In a galaxy far far away", 42, 9223372036854775765L, 3.441073578556931E305, SimpleValues.BIN_VALUE, SimpleValues.BDC_VALUE, true, null};

    Reader() {
    }

    TestResult test() {
        TestResult result = new TestResult("JsonReader API methods added in JSON-P 1.1.");
        TestUtil.logMsg((String)"JsonReader API methods added in JSON-P 1.1.");
        this.testReadValue(result);
        this.testDoubleReadValue(result);
        this.testIOExceptionOnReadValue(result);
        this.testReadInvalidValue(result);
        return result;
    }

    private void testReadValue(TestResult result) {
        for (Object value : VALUES) {
            String typeName = JsonValueType.getType(value).name();
            TestUtil.logMsg((String)(" - readValue() for " + typeName + " in source data"));
            JsonValue jsonValue = SimpleValues.toJsonValue(value);
            String data = JsonValueType.toStringValue(value);
            TestUtil.logMsg((String)("    - Data: " + data));
            StringReader strReader = new StringReader(data);
            JsonValue outValue = null;
            try (JsonReader reader = Json.createReader((java.io.Reader)strReader);){
                outValue = reader.readValue();
            }
            catch (JsonException ex) {
                TestUtil.logMsg((String)("Caught JsonException: " + ex.getLocalizedMessage()));
                result.fail("readValue()", "Caught JsonException: " + ex.getLocalizedMessage());
            }
            if (!this.operationFailed(jsonValue, outValue)) continue;
            result.fail("readValue()", "Reader output " + JsonAssert.valueToString(outValue) + " value shall be " + JsonAssert.valueToString(jsonValue));
        }
    }

    private void testDoubleReadValue(TestResult result) {
        for (Object value : VALUES) {
            String typeName = JsonValueType.getType(value).name();
            TestUtil.logMsg((String)(" - duplicate readValue() for " + typeName + " in source data"));
            String data = JsonValueType.toStringValue(value);
            StringReader strReader = new StringReader(data);
            try (JsonReader reader = Json.createReader((java.io.Reader)strReader);){
                reader.readValue();
                try {
                    reader.readValue();
                    result.fail("readValue()", "Duplicate call of readValue() shall throw IllegalStateException");
                }
                catch (IllegalStateException ex) {
                    TestUtil.logMsg((String)("    - Expected exception: " + ex.getMessage()));
                }
                catch (Throwable t) {
                    result.fail("readValue()", "Duplicate call of readValue() shall throw IllegalStateException, not " + t.getClass().getSimpleName());
                }
            }
            catch (JsonException ex) {
                TestUtil.logMsg((String)("Caught JsonException: " + ex.getLocalizedMessage()));
                result.fail("readValue()", "Caught JsonException: " + ex.getLocalizedMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testIOExceptionOnReadValue(TestResult result) {
        JsonReader reader;
        TestUtil.logMsg((String)" - readValue() from already closed file reader");
        File temp = null;
        try {
            temp = File.createTempFile("testIOExceptionOnReadValue", ".txt");
            TestUtil.logMsg((String)("    - Temporary file: " + temp.getAbsolutePath()));
            try (FileWriter fileWriter = new FileWriter(temp);){
                fileWriter.write(JsonValueType.toStringValue("John Smith"));
            }
            FileReader fileReader = new FileReader(temp);
            reader = Json.createReader((java.io.Reader)fileReader);
            fileReader.close();
        }
        catch (IOException ex) {
            TestUtil.logMsg((String)("Caught IOException: " + ex.getLocalizedMessage()));
            result.fail("write(JsonValue)", "Caught IOException: " + ex.getLocalizedMessage());
            return;
        }
        finally {
            if (temp != null) {
                temp.delete();
            }
        }
        try {
            reader.readValue();
            result.fail("readValue()", "Call of readValue() on already closed file reader shall throw JsonException");
        }
        catch (JsonException ex) {
            TestUtil.logMsg((String)("    - Expected exception: " + ex.getMessage()));
        }
        catch (Throwable t) {
            result.fail("readValue()", "Call of readValue() on already closed file reader shall throw JsonException, not " + t.getClass().getSimpleName());
        }
    }

    private void testReadInvalidValue(TestResult result) {
        TestUtil.logMsg((String)" - readValue() on invalid JSON data");
        String data = "[" + SimpleValues.toJsonValue("John Smith") + "}";
        StringReader strReader = new StringReader(data);
        Object outValue = null;
        try (JsonReader reader = Json.createReader((java.io.Reader)strReader);){
            reader.readValue();
            result.fail("readValue()", "Call of readValue() on invalid data shall throw JsonParsingException");
        }
        catch (JsonParsingException ex) {
            TestUtil.logMsg((String)("    - Expected exception: " + ex.getMessage()));
        }
        catch (Throwable t) {
            result.fail("readValue()", "Call of readValue() on invalid data shall throw JsonParsingException, not " + t.getClass().getSimpleName());
        }
    }

    protected boolean operationFailed(JsonValue check, JsonValue out) {
        return out == null || !JsonAssert.assertEquals(check, out);
    }
}

