/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http.internal.websocket;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import jdk.incubator.http.internal.common.Log;
import jdk.incubator.http.internal.common.Utils;

final class UTF8AccumulatingDecoder {
    private final CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
    private ByteBuffer leftovers;

    UTF8AccumulatingDecoder() {
        this.decoder.onMalformedInput(CodingErrorAction.REPORT);
        this.decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        this.leftovers = Utils.EMPTY_BYTEBUFFER;
    }

    CharBuffer decode(ByteBuffer byteBuffer, boolean bl) throws CharacterCodingException {
        ByteBuffer byteBuffer2;
        int n = this.leftovers.remaining();
        if (n != 0) {
            byteBuffer2 = ByteBuffer.allocate(n + byteBuffer.remaining());
            byteBuffer2.put(this.leftovers).put(byteBuffer).flip();
        } else {
            byteBuffer2 = byteBuffer;
        }
        CharBuffer charBuffer = CharBuffer.allocate(byteBuffer2.remaining());
        CoderResult coderResult = this.decoder.decode(byteBuffer2, charBuffer, bl);
        if (coderResult.isError()) {
            coderResult.throwException();
        }
        this.leftovers = byteBuffer2.hasRemaining() ? (ByteBuffer)ByteBuffer.allocate(byteBuffer2.remaining()).put(byteBuffer2).flip() : Utils.EMPTY_BYTEBUFFER;
        if (this.leftovers.remaining() >= 4) {
            Log.logError("The size of decoding leftovers is greater than expected: {0}", this.leftovers.remaining());
        }
        byteBuffer2.position(byteBuffer2.limit());
        assert (!bl || !this.leftovers.hasRemaining()) : bl + ", " + this.leftovers;
        if (bl) {
            coderResult = this.decoder.flush(charBuffer);
            this.decoder.reset();
            if (coderResult.isOverflow()) {
                throw new InternalError("Not yet implemented");
            }
        }
        return (CharBuffer)charBuffer.flip();
    }
}

