/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonb.defaultmapping.jsonptypes;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.tests.jsonb.defaultmapping.jsonptypes.model.JsonArrayContainer;
import com.sun.ts.tests.jsonb.defaultmapping.jsonptypes.model.JsonNumberContainer;
import com.sun.ts.tests.jsonb.defaultmapping.jsonptypes.model.JsonObjectContainer;
import com.sun.ts.tests.jsonb.defaultmapping.jsonptypes.model.JsonStringContainer;
import com.sun.ts.tests.jsonb.defaultmapping.jsonptypes.model.JsonStructureContainer;
import com.sun.ts.tests.jsonb.defaultmapping.jsonptypes.model.JsonValueContainer;
import java.util.Properties;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;

public class JSONPTypesMappingTest
extends ServiceEETest {
    private static final long serialVersionUID = 10L;
    private final Jsonb jsonb = JsonbBuilder.create();

    public static void main(String[] args) {
        JSONPTypesMappingTest t = new JSONPTypesMappingTest();
        Status s = t.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public Status testJsonObjectMapping() throws EETest.Fault {
        final JsonObject instance = Json.createObjectBuilder().add("jsonObjectInstance", Json.createObjectBuilder().add("innerInstance", "Inner Test String")).add("jsonArrayInstance", Json.createArrayBuilder().add(Json.createObjectBuilder().add("arrayInstance1", "Array Test String 1")).add(Json.createObjectBuilder().add("arrayInstance2", "Array Test String 2"))).add("jsonStringInstance", "Test String").add("jsonNumberInstance", Integer.MAX_VALUE).add("jsonTrueInstance", JsonValue.TRUE).add("jsonFalseInstance", JsonValue.FALSE).add("jsonNullInstance", JsonValue.NULL).build();
        String jsonString = this.jsonb.toJson((Object)new JsonObjectContainer(){
            {
                this.setInstance(instance);
            }
        });
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\\{\\s*\"jsonObjectInstance\"\\s*:\\s*\\{\\s*\"innerInstance\"\\s*:\\s*\"Inner Test String\"\\s*\\}\\s*,\\s*\"jsonArrayInstance\"\\s*:\\s*\\[\\s*\\{\\s*\"arrayInstance1\"\\s*:\\s*\"Array Test String 1\"\\s*\\}\\s*,\\s*\\{\\s*\"arrayInstance2\"\\s*:\\s*\"Array Test String 2\"\\s*\\}\\s*\\]\\s*,\\s*\"jsonStringInstance\"\\s*:\\s*\"Test String\"\\s*,\\s*\"jsonNumberInstance\"\\s*:\\s*2147483647\\s*,\\s*\"jsonTrueInstance\"\\s*:\\s*true\\s*,\\s*\"jsonFalseInstance\"\\s*:\\s*false\\s*,\\s*\"jsonNullInstance\"\\s*:\\s*null\\s*\\}\\s*\\}")) {
            throw new EETest.Fault("Failed to marshal object with JsonObject attribute value.");
        }
        JsonObjectContainer unmarshalledObject = (JsonObjectContainer)this.jsonb.fromJson("{ \"instance\" : { \"jsonObjectInstance\" : { \"innerInstance\" : \"Inner Test String\" }, \"jsonArrayInstance\" : [ { \"arrayInstance1\" : \"Array Test String 1\" }, { \"arrayInstance2\" : \"Array Test String 2\" } ], \"jsonStringInstance\" : \"Test String\", \"jsonNumberInstance\" : 2147483647, \"jsonTrueInstance\" : true, \"jsonFalseInstance\" : false, \"jsonNullInstance\" : null } }", JsonObjectContainer.class);
        if (!instance.toString().equals(unmarshalledObject.getInstance().toString())) {
            throw new EETest.Fault("Failed to unmarshal object with JsonObject attribute value.");
        }
        return Status.passed((String)"OK");
    }

    public Status testEmptyJsonObjectMapping() throws EETest.Fault {
        final JsonObject instance = Json.createObjectBuilder().build();
        String jsonString = this.jsonb.toJson((Object)new JsonObjectContainer(){
            {
                this.setInstance(instance);
            }
        });
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\\{\\s*\\}\\s*\\}")) {
            throw new EETest.Fault("Failed to marshal object with empty JsonObject attribute value.");
        }
        JsonObjectContainer unmarshalledObject = (JsonObjectContainer)this.jsonb.fromJson("{ \"instance\" : { } }", JsonObjectContainer.class);
        if (!instance.toString().equals(unmarshalledObject.getInstance().toString())) {
            throw new EETest.Fault("Failed to unmarshal object with empty JsonObject attribute value.");
        }
        return Status.passed((String)"OK");
    }

    public Status testJsonArrayMapping() throws EETest.Fault {
        final JsonArray instance = Json.createArrayBuilder().add(Json.createObjectBuilder().add("arrayInstance1", "Array Test String 1")).add(Json.createObjectBuilder().add("arrayInstance2", "Array Test String 2")).build();
        String jsonString = this.jsonb.toJson((Object)new JsonArrayContainer(){
            {
                this.setInstance(instance);
            }
        });
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\\[\\s*\\{\\s*\"arrayInstance1\"\\s*:\\s*\"Array Test String 1\"\\s*\\}\\s*,\\s*\\{\\s*\"arrayInstance2\"\\s*:\\s*\"Array Test String 2\"\\s*\\}\\s*\\]\\s*\\}")) {
            throw new EETest.Fault("Failed to marshal object with JsonArray attribute value.");
        }
        JsonArrayContainer unmarshalledObject = (JsonArrayContainer)this.jsonb.fromJson("{ \"instance\" : [ { \"arrayInstance1\" : \"Array Test String 1\" }, { \"arrayInstance2\" : \"Array Test String 2\" } ] }", JsonArrayContainer.class);
        if (!instance.toString().equals(unmarshalledObject.getInstance().toString())) {
            throw new EETest.Fault("Failed to unmarshal object with JsonArray attribute value.");
        }
        return Status.passed((String)"OK");
    }

    public Status testEmptyJsonArrayMapping() throws EETest.Fault {
        final JsonArray instance = Json.createArrayBuilder().build();
        String jsonString = this.jsonb.toJson((Object)new JsonArrayContainer(){
            {
                this.setInstance(instance);
            }
        });
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\\[\\s*\\]\\s*\\}")) {
            throw new EETest.Fault("Failed to marshal object with empty JsonArray attribute value.");
        }
        JsonArrayContainer unmarshalledObject = (JsonArrayContainer)this.jsonb.fromJson("{ \"instance\" : [ ] }", JsonArrayContainer.class);
        if (!instance.toString().equals(unmarshalledObject.getInstance().toString())) {
            throw new EETest.Fault("Failed to unmarshal object with empty JsonArray attribute value.");
        }
        return Status.passed((String)"OK");
    }

    public Status testJsonObjectStructureMapping() throws EETest.Fault {
        JsonObject instance = Json.createObjectBuilder().add("jsonObjectInstance", Json.createObjectBuilder().add("innerInstance", "Inner Test String")).add("jsonArrayInstance", Json.createArrayBuilder().add(Json.createObjectBuilder().add("arrayInstance1", "Array Test String 1")).add(Json.createObjectBuilder().add("arrayInstance2", "Array Test String 2"))).add("jsonStringInstance", "Test String").add("jsonNumberInstance", Integer.MAX_VALUE).add("jsonTrueInstance", JsonValue.TRUE).add("jsonFalseInstance", JsonValue.FALSE).add("jsonNullInstance", JsonValue.NULL).build();
        String jsonString = this.jsonb.toJson((Object)new JsonStructureContainer((JsonStructure)instance){
            final /* synthetic */ JsonStructure val$instance;
            {
                this.val$instance = jsonStructure;
                this.setInstance(this.val$instance);
            }
        });
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\\{\\s*\"jsonObjectInstance\"\\s*:\\s*\\{\\s*\"innerInstance\"\\s*:\\s*\"Inner Test String\"\\s*\\}\\s*,\\s*\"jsonArrayInstance\"\\s*:\\s*\\[\\s*\\{\\s*\"arrayInstance1\"\\s*:\\s*\"Array Test String 1\"\\s*\\}\\s*,\\s*\\{\\s*\"arrayInstance2\"\\s*:\\s*\"Array Test String 2\"\\s*\\}\\s*\\]\\s*,\\s*\"jsonStringInstance\"\\s*:\\s*\"Test String\"\\s*,\\s*\"jsonNumberInstance\"\\s*:\\s*2147483647\\s*,\\s*\"jsonTrueInstance\"\\s*:\\s*true\\s*,\\s*\"jsonFalseInstance\"\\s*:\\s*false\\s*,\\s*\"jsonNullInstance\"\\s*:\\s*null\\s*\\}\\s*\\}")) {
            throw new EETest.Fault("Failed to marshal object with JsonObject JsonStructure attribute value.");
        }
        JsonStructureContainer unmarshalledObject = (JsonStructureContainer)this.jsonb.fromJson("{ \"instance\" : { \"jsonObjectInstance\" : { \"innerInstance\" : \"Inner Test String\" }, \"jsonArrayInstance\" : [ { \"arrayInstance1\" : \"Array Test String 1\" }, { \"arrayInstance2\" : \"Array Test String 2\" } ], \"jsonStringInstance\" : \"Test String\", \"jsonNumberInstance\" : 2147483647, \"jsonTrueInstance\" : true, \"jsonFalseInstance\" : false, \"jsonNullInstance\" : null } }", JsonStructureContainer.class);
        if (!instance.toString().equals(unmarshalledObject.getInstance().toString())) {
            throw new EETest.Fault("Failed to unmarshal object with JsonObject JsonStructure attribute value.");
        }
        return Status.passed((String)"OK");
    }

    public Status testJsonArrayStructureMapping() throws EETest.Fault {
        JsonArray instance = Json.createArrayBuilder().add(Json.createObjectBuilder().add("arrayInstance1", "Array Test String 1")).add(Json.createObjectBuilder().add("arrayInstance2", "Array Test String 2")).build();
        String jsonString = this.jsonb.toJson((Object)new JsonStructureContainer((JsonStructure)instance){
            final /* synthetic */ JsonStructure val$instance;
            {
                this.val$instance = jsonStructure;
                this.setInstance(this.val$instance);
            }
        });
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\\[\\s*\\{\\s*\"arrayInstance1\"\\s*:\\s*\"Array Test String 1\"\\s*\\}\\s*,\\s*\\{\\s*\"arrayInstance2\"\\s*:\\s*\"Array Test String 2\"\\s*\\}\\s*\\]\\s*\\}")) {
            throw new EETest.Fault("Failed to marshal object with JsonArray JsonStructure attribute value.");
        }
        JsonStructureContainer unmarshalledObject = (JsonStructureContainer)this.jsonb.fromJson("{ \"instance\" : [ { \"arrayInstance1\" : \"Array Test String 1\" }, { \"arrayInstance2\" : \"Array Test String 2\" } ] }", JsonStructureContainer.class);
        if (!instance.toString().equals(unmarshalledObject.getInstance().toString())) {
            throw new EETest.Fault("Failed to unmarshal object with JsonArray JsonStructure attribute value.");
        }
        return Status.passed((String)"OK");
    }

    public Status testJsonValueMapping() throws EETest.Fault {
        JsonObject instance = Json.createObjectBuilder().add("stringInstance", "Test String").build();
        String jsonString = this.jsonb.toJson((Object)new JsonValueContainer((JsonValue)instance){
            final /* synthetic */ JsonValue val$instance;
            {
                this.val$instance = jsonValue;
                this.setInstance(this.val$instance);
            }
        });
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\\{\\s*\"stringInstance\"\\s*:\\s*\"Test String\"\\s*\\}\\s*\\}")) {
            throw new EETest.Fault("Failed to marshal object with JsonValue attribute value.");
        }
        JsonValueContainer unmarshalledObject = (JsonValueContainer)this.jsonb.fromJson("{ \"instance\" : { \"stringInstance\" : \"Test String\" } }", JsonValueContainer.class);
        if (!instance.toString().equals(unmarshalledObject.getInstance().toString())) {
            throw new EETest.Fault("Failed to unmarshal object with JsonValue attribute value.");
        }
        return Status.passed((String)"OK");
    }

    public Status testJsonStringMapping() throws EETest.Fault {
        final JsonString instance = Json.createObjectBuilder().add("stringInstance", "Test String").build().getJsonString("stringInstance");
        String jsonString = this.jsonb.toJson((Object)new JsonStringContainer(){
            {
                this.setInstance(instance);
            }
        });
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\"Test String\"\\s*\\}")) {
            throw new EETest.Fault("Failed to marshal object with JsonString attribute value.");
        }
        JsonStringContainer unmarshalledObject = (JsonStringContainer)this.jsonb.fromJson("{ \"instance\" : \"Test String\" }", JsonStringContainer.class);
        if (!instance.toString().equals(unmarshalledObject.getInstance().toString())) {
            throw new EETest.Fault("Failed to unmarshal object with JsonString attribute value.");
        }
        return Status.passed((String)"OK");
    }

    public Status testJsonNumberMapping() throws EETest.Fault {
        final JsonNumber instance = Json.createObjectBuilder().add("intInstance", 0).build().getJsonNumber("intInstance");
        String jsonString = this.jsonb.toJson((Object)new JsonNumberContainer(){
            {
                this.setInstance(instance);
            }
        });
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*0\\s*\\}")) {
            throw new EETest.Fault("Failed to marshal object with JsonNumber attribute value.");
        }
        JsonNumberContainer unmarshalledObject = (JsonNumberContainer)this.jsonb.fromJson("{ \"instance\" : 0 }", JsonNumberContainer.class);
        if (!instance.toString().equals(unmarshalledObject.getInstance().toString())) {
            throw new EETest.Fault("Failed to unmarshal object with JsonNumber attribute value.");
        }
        return Status.passed((String)"OK");
    }
}

