/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.bb.session.stateful.sessionbeantest;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.tests.ejb.ee.bb.session.stateful.sessionbeantest.CallBack;
import com.sun.ts.tests.ejb.ee.bb.session.stateful.sessionbeantest.CallBackHome;
import com.sun.ts.tests.ejb.ee.bb.session.stateful.sessionbeantest.TestBean;
import com.sun.ts.tests.ejb.ee.bb.session.stateful.sessionbeantest.TestBeanHome;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.ejb.Handle;

public class Client
extends EETest {
    private static final String testName = "SessionBeanTest";
    private static final String tBean = "java:comp/env/ejb/TestBean";
    private static final String cBean = "java:comp/env/ejb/CallBack";
    private static final String testProps = "sessionbeantest.properties";
    private static final String testDir = System.getProperty("user.dir");
    private Properties props = null;
    private TestBean beanRef = null;
    private TestBeanHome beanHome = null;
    private TSNamingContext nctx = null;
    private CallBack cRef = null;
    private CallBackHome cHome = null;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        try {
            this.logMsg("Obtain naming context");
            this.nctx = new TSNamingContext();
            this.logMsg("Looking up home interface for EJB: java:comp/env/ejb/TestBean");
            this.beanHome = (TestBeanHome)this.nctx.lookup(tBean, TestBeanHome.class);
            this.logMsg("Looking up home interface for EJB: java:comp/env/ejb/CallBack");
            this.cHome = (CallBackHome)this.nctx.lookup(cBean, CallBackHome.class);
            this.logMsg("creating callback bean");
            this.cRef = this.cHome.create();
            this.logMsg("Setup ok");
        }
        catch (Exception e) {
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void test1() throws EETest.Fault {
        try {
            this.cRef.reset();
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create();
            this.logMsg("initialize remote logging");
            this.beanRef.initLogging(this.props);
            this.logMsg("check if proper lifecycle creation order was called in the bean");
            boolean pass = this.beanRef.isCreateLifeCycle1();
            this.beanRef.remove();
            if (!pass) {
                throw new EETest.Fault("test1 failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("test1 failed", e);
        }
    }

    public void test2() throws EETest.Fault {
        try {
            this.cRef.reset();
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create(this.cRef);
            this.logMsg("initialize remote logging");
            this.beanRef.initLogging(this.props);
            this.logMsg("check if proper lifecycle creation order was called in the bean");
            boolean pass = this.beanRef.isCreateLifeCycle2();
            this.beanRef.remove();
            if (!pass) {
                throw new EETest.Fault("test2 failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("test2 failed", e);
        }
    }

    public void test3() throws EETest.Fault {
        try {
            this.cRef.reset();
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create(this.cRef);
            this.logMsg("initialize remote logging");
            this.beanRef.initLogging(this.props);
            this.logMsg("Remove bean and check ejbRemove() was called in the bean");
            this.beanRef.remove();
            boolean pass = this.cRef.isRemove();
            if (!pass) {
                this.logMsg("ejbRemove was not called - unexpected");
                throw new EETest.Fault("test3 failed");
            }
            this.logMsg("ejbRemove was called - expected");
            this.logMsg("attempt to invoke bean after removal");
            try {
                this.beanRef.remove();
                this.logErr("object was not removed, was able to invoke object");
                throw new EETest.Fault("test3 failed");
            }
            catch (NoSuchObjectException e) {
                this.logMsg("object was removed as expected: " + e);
            }
            catch (RemoteException e) {
                this.logMsg("object was removed as expected: " + e);
            }
            catch (Exception e) {
                throw new EETest.Fault("test3 failed", e);
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("test3 failed", e);
        }
    }

    public void test3a() throws EETest.Fault {
        try {
            this.cRef.reset();
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create(this.cRef);
            this.logMsg("initialize remote logging");
            this.beanRef.initLogging(this.props);
            this.logMsg("Remove bean and check ejbRemove() was called in the bean");
            Handle handle = this.beanRef.getHandle();
            this.beanHome.remove(handle);
            boolean pass = this.cRef.isRemove();
            if (!pass) {
                this.logMsg("ejbRemove was not called - unexpected");
                throw new EETest.Fault("test3a failed");
            }
            this.logMsg("ejbRemove was called - expected");
            this.logMsg("attempt to invoke bean after removal");
            try {
                this.beanHome.remove(handle);
                this.logErr("object was not removed, was able to invoke object");
                throw new EETest.Fault("test3a failed");
            }
            catch (RemoteException e) {
                this.logMsg("a remote exception occurred as expected: " + e);
            }
            catch (Exception e) {
                throw new EETest.Fault("test3a failed", e);
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("test3a failed", e);
        }
    }

    public void test3b() throws EETest.Fault {
        try {
            this.cRef.reset();
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create(this.cRef);
            this.logMsg("initialize remote logging");
            this.beanRef.initLogging(this.props);
            this.logMsg("Remove bean and check ejbRemove() was called in the bean");
            this.beanRef.remove();
            boolean pass = this.cRef.isRemove();
            if (!pass) {
                this.logMsg("ejbRemove was not called - unexpected");
                throw new EETest.Fault("test3b failed");
            }
            this.logMsg("ejbRemove was called - expected");
            this.logMsg("attempt to invoke bean after removal");
            try {
                this.beanRef.ping();
                this.logErr("object was not removed, was able to invoke object");
                throw new EETest.Fault("test3b failed");
            }
            catch (NoSuchObjectException e) {
                this.logMsg("object was removed as expected: " + e);
            }
            catch (RemoteException e) {
                this.logMsg("object was removed as expected: " + e);
            }
            catch (Exception e) {
                throw new EETest.Fault("test3b failed", e);
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("test3b failed", e);
        }
    }

    public void test3c() throws EETest.Fault {
        try {
            this.cRef.reset();
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create(this.cRef);
            this.logMsg("initialize remote logging");
            this.beanRef.initLogging(this.props);
            this.logMsg("Remove bean and check ejbRemove() was called in the bean");
            Handle handle = this.beanRef.getHandle();
            this.beanHome.remove(handle);
            boolean pass = this.cRef.isRemove();
            if (!pass) {
                this.logMsg("ejbRemove was not called - unexpected");
                throw new EETest.Fault("test3c failed");
            }
            this.logMsg("ejbRemove was called - expected");
            this.logMsg("attempt to invoke bean after removal");
            try {
                this.beanRef.ping();
                this.logErr("object was not removed, was able to invoke object");
                throw new EETest.Fault("test3c failed");
            }
            catch (NoSuchObjectException e) {
                this.logMsg("object was removed as expected: " + e);
            }
            catch (RemoteException e) {
                this.logMsg("object was removed as expected: " + e);
            }
            catch (Exception e) {
                throw new EETest.Fault("test3c failed", e);
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("test3c failed", e);
        }
    }

    public void test6() throws EETest.Fault {
        try {
            this.cRef.reset();
            this.logMsg("Required: Testing transaction notification synchronization - commit");
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create(this.cRef);
            this.logMsg("initialize remote logging");
            this.beanRef.initLogging(this.props);
            this.logMsg("check for proper session synchronization lifecycle call order");
            boolean pass = this.beanRef.isSyncLifeCycle1("TxRequired");
            this.beanRef.remove();
            if (!pass) {
                throw new EETest.Fault("test6 failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("test6 failed", e);
        }
    }

    public void test7() throws EETest.Fault {
        try {
            this.cRef.reset();
            this.logMsg("Required: Testing transaction notification synchronization - rollback");
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create(this.cRef);
            this.logMsg("initialize remote logging");
            this.beanRef.initLogging(this.props);
            this.logMsg("check for proper session synchronization lifecycle call order");
            boolean pass = this.beanRef.isSyncLifeCycle3("TxRequired", true, true);
            this.beanRef.remove();
            if (!pass) {
                throw new EETest.Fault("test7 failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("test7 failed", e);
        }
    }

    public void test7a() throws EETest.Fault {
        try {
            this.cRef.reset();
            this.logMsg("Required: Testing transaction notification synchronization - rollback");
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create(this.cRef);
            this.logMsg("initialize remote logging");
            this.beanRef.initLogging(this.props);
            this.logMsg("check for proper session synchronization lifecycle call order");
            boolean pass = this.beanRef.isSyncLifeCycle2("TxRequired", true, false);
            this.beanRef.remove();
            if (!pass) {
                throw new EETest.Fault("test7a failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("test7a failed", e);
        }
    }

    public void test8() throws EETest.Fault {
        try {
            this.cRef.reset();
            this.logMsg("RequiresNew: Testing transaction notification synchronization - commit");
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create(this.cRef);
            this.logMsg("initialize remote logging");
            this.beanRef.initLogging(this.props);
            this.logMsg("check for proper session synchronization lifecycle call order");
            boolean pass = this.beanRef.isSyncLifeCycle1("TxRequiresNew");
            this.beanRef.remove();
            if (!pass) {
                throw new EETest.Fault("test8 failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("test8 failed", e);
        }
    }

    public void test9() throws EETest.Fault {
        try {
            this.cRef.reset();
            this.logMsg("RequiresNew: Testing transaction notification synchronization - rollback");
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create(this.cRef);
            this.logMsg("initialize remote logging");
            this.beanRef.initLogging(this.props);
            this.logMsg("check for proper session synchronization lifecycle call order");
            boolean pass = this.beanRef.isSyncLifeCycle3("TxRequiresNew", true, true);
            this.beanRef.remove();
            if (!pass) {
                throw new EETest.Fault("test9 failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("test9 failed", e);
        }
    }

    public void test9a() throws EETest.Fault {
        try {
            this.cRef.reset();
            this.logMsg("RequiresNew: Testing transaction notification synchronization - rollback");
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create(this.cRef);
            this.logMsg("initialize remote logging");
            this.beanRef.initLogging(this.props);
            this.logMsg("check for proper session synchronization lifecycle call order");
            boolean pass = this.beanRef.isSyncLifeCycle2("TxRequiresNew", true, false);
            this.beanRef.remove();
            if (!pass) {
                throw new EETest.Fault("test9a failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("test9a failed", e);
        }
    }

    public void test10() throws EETest.Fault {
        try {
            this.cRef.reset();
            this.logMsg("Supports: Testing transaction - commit");
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create(this.cRef);
            this.logMsg("initialize remote logging");
            this.beanRef.initLogging(this.props);
            this.logMsg("check for transaction commit");
            this.beanRef.beginTransaction();
            boolean pass = this.beanRef.okay("TxSupports");
            boolean status = this.beanRef.commitTransaction();
            this.beanRef.remove();
            if (!pass || !status) {
                throw new EETest.Fault("test10 failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("test10 failed", e);
        }
    }

    public void test11() throws EETest.Fault {
        try {
            this.cRef.reset();
            this.logMsg("Supports: transaction - rollback");
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create(this.cRef);
            this.logMsg("initialize remote logging");
            this.beanRef.initLogging(this.props);
            this.logMsg("check for transaction rollback");
            this.beanRef.beginTransaction();
            boolean pass = this.beanRef.not_okay("TxSupports");
            boolean status = this.beanRef.commitTransaction();
            this.beanRef.remove();
            if (!pass || status) {
                throw new EETest.Fault("test11 failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("test11 failed", e);
        }
    }

    public void test12() throws EETest.Fault {
        try {
            this.cRef.reset();
            this.logMsg("NotSupported: ensure no transaction");
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create(this.cRef);
            this.logMsg("initialize remote logging");
            this.beanRef.initLogging(this.props);
            this.logMsg("check to ensure no transaction");
            boolean pass = this.beanRef.okay("TxNotSupported");
            this.beanRef.remove();
            if (!pass) {
                throw new EETest.Fault("test12 failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("test12 failed", e);
        }
    }

    public void test13() throws EETest.Fault {
        try {
            this.cRef.reset();
            this.logMsg("Never: ensure no transaction");
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create(this.cRef);
            this.logMsg("initialize remote logging");
            this.beanRef.initLogging(this.props);
            this.logMsg("check to ensure no transaction");
            boolean pass = this.beanRef.okay("TxNever");
            this.beanRef.remove();
            if (!pass) {
                throw new EETest.Fault("test13 failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("test13 failed", e);
        }
    }

    public void test14() throws EETest.Fault {
        try {
            this.cRef.reset();
            this.logMsg("Mandatory: Testing transaction notification synchronization - commit");
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create(this.cRef);
            this.logMsg("initialize remote logging");
            this.beanRef.initLogging(this.props);
            this.logMsg("check for proper session synchronization lifecycle call order");
            this.beanRef.beginTransaction();
            boolean pass = this.beanRef.isSyncLifeCycle1("TxMandatory");
            this.beanRef.commitTransaction();
            this.beanRef.remove();
            if (!pass) {
                throw new EETest.Fault("test14 failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("test14 failed", e);
        }
    }

    public void test15() throws EETest.Fault {
        try {
            this.cRef.reset();
            this.logMsg("Mandatory: Testing transaction notification synchronization - rollback");
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create(this.cRef);
            this.logMsg("initialize remote logging");
            this.beanRef.initLogging(this.props);
            this.logMsg("check for proper session synchronization lifecycle call order");
            this.beanRef.beginTransaction();
            boolean pass = this.beanRef.isSyncLifeCycle2("TxMandatory", false, false);
            this.beanRef.commitTransaction();
            this.beanRef.remove();
            if (!pass) {
                throw new EETest.Fault("test15 failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("test15 failed", e);
        }
    }

    public void test16() throws EETest.Fault {
        try {
            this.cRef.reset();
            this.logMsg("Required: Testing transaction notification synchronization - commit");
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create(this.cRef);
            this.logMsg("initialize remote logging");
            this.beanRef.initLogging(this.props);
            this.logMsg("check for proper session synchronization lifecycle call order");
            this.beanRef.beginTransaction();
            boolean pass = this.beanRef.isSyncLifeCycle1("TxRequired");
            this.beanRef.commitTransaction();
            this.beanRef.remove();
            if (!pass) {
                throw new EETest.Fault("test16 failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("test16 failed", e);
        }
    }

    public void test17() throws EETest.Fault {
        try {
            this.cRef.reset();
            this.logMsg("Required: Testing transaction notification synchronization - rollback");
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create(this.cRef);
            this.logMsg("initialize remote logging");
            this.beanRef.initLogging(this.props);
            this.logMsg("check for proper session synchronization lifecycle call order");
            this.beanRef.beginTransaction();
            boolean pass = this.beanRef.isSyncLifeCycle2("TxRequired", false, false);
            this.beanRef.commitTransaction();
            this.beanRef.remove();
            if (!pass) {
                throw new EETest.Fault("test17 failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("test17 failed", e);
        }
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }
}

