/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee20.cditests.usecases;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.ee20.cditests.usecases.BMBean1IF;
import com.sun.ts.tests.jms.ee20.cditests.usecases.BMBean2IF;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.EJBException;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.inject.Inject;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSConnectionFactory;
import javax.jms.JMSConsumer;
import javax.jms.JMSContext;
import javax.jms.JMSProducer;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.transaction.UserTransaction;

@TransactionManagement(value=TransactionManagementType.BEAN)
@Stateless(name="CDIUseCasesBMBEAN1")
@Remote(value={BMBean1IF.class})
public class BMBean1
implements BMBean1IF {
    private static final long serialVersionUID = 1L;
    long timeout;
    @Inject
    @JMSConnectionFactory(value="jms/ConnectionFactory")
    JMSContext context;
    @Resource(name="jms/MyConnectionFactory")
    ConnectionFactory cfactory;
    @Resource(name="jms/MY_QUEUE")
    Queue queue;
    @Resource(name="jms/MY_TOPIC")
    Topic topic;
    @EJB(name="ejb/CDIUseCasesBMBEAN2")
    BMBean2IF bmbean2;
    @Inject
    UserTransaction ut;

    @PostConstruct
    public void postConstruct() {
        System.out.println("BMBean1:postConstruct()");
        System.out.println("queue=" + this.queue);
        System.out.println("topic=" + this.topic);
        System.out.println("cfactory=" + this.cfactory);
        System.out.println("bmbean2=" + this.bmbean2);
        System.out.println("ut=" + this.ut);
        if (this.queue == null || this.topic == null || this.context == null || this.cfactory == null || this.bmbean2 == null || this.ut == null) {
            throw new EJBException("postConstruct failed: injection failure");
        }
    }

    @Override
    public void init(Properties p) {
        TestUtil.logMsg((String)"BMBean1.init()");
        try {
            TestUtil.init((Properties)p);
            this.timeout = Long.parseLong(p.getProperty("jms_timeout"));
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("BMBean1.init: failed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("BMBean1.init: failed");
        }
    }

    @Override
    public boolean cleanupQueue(int numOfMsgs) {
        int count = 0;
        String message = null;
        TestUtil.logMsg((String)"BMBean1.cleanupQueue()");
        try {
            JMSConsumer consumer = this.context.createConsumer((Destination)this.queue);
            for (int i = 0; i < numOfMsgs; ++i) {
                message = (String)consumer.receiveBody(String.class, this.timeout);
                if (message == null) continue;
                TestUtil.logMsg((String)("Cleanup message: [" + message + "]"));
                ++count;
            }
            while ((message = (String)consumer.receiveBody(String.class, this.timeout)) != null) {
                TestUtil.logMsg((String)("Cleanup message: [" + message + "]"));
                ++count;
            }
            consumer.close();
            TestUtil.logMsg((String)("Cleaned up " + count + " messages from Queue (numOfMsgs=" + numOfMsgs + ")"));
            return count == numOfMsgs;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("CMBean1.cleanupQueue: failed");
        }
    }

    @Override
    public void method1() {
        TestUtil.logMsg((String)("BMBean1.method1(): JMSContext context=" + this.context));
        JMSProducer producer = this.context.createProducer();
        TestUtil.logMsg((String)"Sending message [Message 1]");
        producer.send((Destination)this.queue, "Message 1");
        TestUtil.logMsg((String)"Sending message [Message 2]");
        producer.send((Destination)this.queue, "Message 2");
    }

    @Override
    public void method2() {
        TestUtil.logMsg((String)("BMBean1.method2(): JMSContext context=" + this.context));
        TestUtil.logMsg((String)"Sending message [Message 1]");
        this.context.createProducer().send((Destination)this.queue, "Message 1");
        TestUtil.logMsg((String)"Calling BMBean2.method2()");
        this.bmbean2.method2();
    }

    @Override
    public void method3() {
        try {
            TestUtil.logMsg((String)"BMBean1.method3()");
            TestUtil.logMsg((String)"Begin First User Transaction");
            this.ut.begin();
            TestUtil.logMsg((String)("JMSContext context=" + this.context));
            JMSProducer producer = this.context.createProducer();
            TestUtil.logMsg((String)"Sending message [Message 1]");
            producer.send((Destination)this.queue, "Message 1");
            TestUtil.logMsg((String)"Sending message [Message 2]");
            producer.send((Destination)this.queue, "Message 2");
            TestUtil.logMsg((String)"Commit First User Transaction");
            this.ut.commit();
            TestUtil.logMsg((String)"Begin Second User Transaction");
            this.ut.begin();
            producer = this.context.createProducer();
            TestUtil.logMsg((String)"Sending message [Message 3]");
            producer.send((Destination)this.queue, "Message 3");
            TestUtil.logMsg((String)"Sending message [Message 4]");
            producer.send((Destination)this.queue, "Message 4");
            TestUtil.logMsg((String)"Commit Second User Transaction");
            this.ut.commit();
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    @Override
    public void method4() {
        TestUtil.logMsg((String)("BMBean1.method4(): JMSContext context=" + this.context));
        try {
            JMSProducer producer = this.context.createProducer();
            TestUtil.logMsg((String)"Sending message [Message 1]");
            producer.send((Destination)this.queue, "Message 1");
            TestUtil.logMsg((String)"Sending message [Message 2]");
            producer.send((Destination)this.queue, "Message 2");
            TestUtil.logMsg((String)"Begin User Transaction");
            this.ut.begin();
            producer = this.context.createProducer();
            TestUtil.logMsg((String)"Sending message [Message 3]");
            producer.send((Destination)this.queue, "Message 3");
            TestUtil.logMsg((String)"Commit User Transaction");
            this.ut.commit();
            producer = this.context.createProducer();
            TestUtil.logMsg((String)"Sending message [Message 4]");
            producer.send((Destination)this.queue, "Message 4");
            TestUtil.logMsg((String)"Sending message [Message 5]");
            producer.send((Destination)this.queue, "Message 5");
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }
}

