/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonb.defaultmapping.nullvalue;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.tests.jsonb.defaultmapping.nullvalue.model.NullArrayContainer;
import com.sun.ts.tests.jsonb.defaultmapping.nullvalue.model.NullValueContainer;
import java.util.Properties;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;

public class NullValueMappingTest
extends ServiceEETest {
    private static final long serialVersionUID = 10L;
    private final Jsonb jsonb = JsonbBuilder.create();

    public static void main(String[] args) {
        NullValueMappingTest t = new NullValueMappingTest();
        Status s = t.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public Status testNullAttributeValue() throws EETest.Fault {
        String jsonString = this.jsonb.toJson((Object)new NullValueContainer(){
            {
                this.setInstance(null);
            }
        });
        if (!jsonString.matches("\\{\\s*\\}")) {
            throw new EETest.Fault("Failed to ignore displaying property with null value.");
        }
        NullValueContainer unmarshalledObject = (NullValueContainer)this.jsonb.fromJson("{ }", NullValueContainer.class);
        if (!"Test String".equals(unmarshalledObject.getInstance())) {
            throw new EETest.Fault("Failed to ignore calling setter of absent property during unmarshalling.");
        }
        unmarshalledObject = (NullValueContainer)this.jsonb.fromJson("{ \"instance\" : null }", NullValueContainer.class);
        if (unmarshalledObject.getInstance() != null) {
            throw new EETest.Fault("Failed to set property to null.");
        }
        return Status.passed((String)"OK");
    }

    public Status testNullArrayValue() throws EETest.Fault {
        String jsonString = this.jsonb.toJson((Object)new NullArrayContainer(){
            {
                this.setInstance(new String[]{"Test 1", null, "Test 2"});
            }
        });
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\\[\\s*\"Test 1\"\\s*,\\s*null\\s*,\\s*\"Test 2\"\\s*\\]\\s*\\}")) {
            throw new EETest.Fault("Failed to correctly display null array value.");
        }
        NullArrayContainer unmarshalledObject = (NullArrayContainer)this.jsonb.fromJson("{ \"instance\" : [ \"Test 1\", null, \"Test 2\" ] }", NullArrayContainer.class);
        Object[] instance = unmarshalledObject.getInstance();
        if (instance.length != 3 || !"Test 1".equals(instance[0]) || instance[1] != null || !"Test 2".equals(instance[2])) {
            throw new EETest.Fault("Failed to correctly set null array value.");
        }
        return Status.passed((String)"OK");
    }
}

