/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.interop.ejb.entity.bmp.clientviewtest;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.bb.entity.util.DBSupport;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Properties;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.FinderException;
import javax.ejb.NoSuchEntityException;
import javax.ejb.RemoveException;

public class TestBeanEJB
implements EntityBean {
    private EntityContext ectx = null;
    private DBSupport db = null;
    private float cofPrice;

    public Integer ejbCreate(Properties p, boolean newTable, int cofID, String cofName, float cofPrice) throws CreateException {
        TestUtil.logTrace((String)"ejbCreate");
        try {
            TestUtil.logMsg((String)"Initialize remote logging");
            TestUtil.init((Properties)p);
            TestUtil.logMsg((String)"get DB connection");
            this.db.getDBConnection();
            if (newTable) {
                this.db.tableInit();
            }
            this.db.createNewRow(cofID, cofName, cofPrice);
            this.cofPrice = cofPrice;
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException(e.getMessage());
        }
        catch (SQLException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException("SQL Exception in create");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException("Exception occurred: " + e);
        }
        finally {
            try {
                this.db.closeDBConnection();
            }
            catch (SQLException e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        return new Integer(cofID);
    }

    public void ejbPostCreate(Properties p, boolean newTable, int cofID, String cofName, float cofPrice) {
        TestUtil.logTrace((String)"ejbPostCreate");
    }

    public void setEntityContext(EntityContext c) {
        TestUtil.logTrace((String)"setEntityContext");
        this.ectx = c;
        try {
            TestUtil.logMsg((String)"Initialize DBSupport");
            this.db = new DBSupport(this.ectx);
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception ... " + e), (Throwable)e);
            throw new EJBException("unable to initialize DBSupport");
        }
    }

    public void unsetEntityContext() {
        TestUtil.logTrace((String)"unsetEntityContext");
    }

    public void ejbRemove() throws RemoveException {
        TestUtil.logTrace((String)"ejbRemove");
        try {
            if (this.db == null) {
                TestUtil.logMsg((String)"Initialize DBSupport");
                this.db = new DBSupport(this.ectx);
            }
            this.db.getDBConnection();
            this.db.removeRow((Integer)this.ectx.getPrimaryKey());
        }
        catch (SQLException se) {
            TestUtil.printStackTrace((Throwable)se);
            throw new RemoveException("SQL Exception in remove");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new RemoveException("Unable to initialize DBSupport");
        }
        finally {
            try {
                this.db.closeDBConnection();
            }
            catch (SQLException e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
    }

    public void ejbActivate() {
        TestUtil.logTrace((String)"ejbActivate");
    }

    public void ejbPassivate() {
        TestUtil.logTrace((String)"ejbPassivate");
    }

    public void ejbLoad() {
        TestUtil.logTrace((String)"ejbLoad");
        try {
            if (this.db == null) {
                TestUtil.logMsg((String)"Initialize DBSupport");
                this.db = new DBSupport(this.ectx);
            }
            this.db.getDBConnection();
            this.cofPrice = this.db.loadPrice((Integer)this.ectx.getPrimaryKey());
        }
        catch (SQLException se) {
            TestUtil.logErr((String)"ejbLoad: No such entity exists", (Throwable)se);
            throw new NoSuchEntityException("SQL Exception in ejbLoad");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("Unable to initialize DBSupport");
        }
        finally {
            try {
                this.db.closeDBConnection();
            }
            catch (SQLException e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
    }

    public void ejbStore() {
        TestUtil.logTrace((String)"ejbStore");
        try {
            if (this.db == null) {
                TestUtil.logMsg((String)"Initialize DBSupport");
                this.db = new DBSupport(this.ectx);
            }
            this.db.getDBConnection();
            this.db.storePrice((Integer)this.ectx.getPrimaryKey(), this.cofPrice);
        }
        catch (SQLException se) {
            TestUtil.logErr((String)"ejbLoad: No such entity exists", (Throwable)se);
            throw new NoSuchEntityException("SQL Exception in ejbLoad");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("Unable to initialize DBSupport");
        }
        finally {
            try {
                this.db.closeDBConnection();
            }
            catch (SQLException e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
    }

    public Integer ejbFindTheBean(Properties p, Integer key) throws FinderException {
        TestUtil.logTrace((String)"ejbFindTheBean");
        try {
            TestUtil.logMsg((String)"Initialize remote logging");
            TestUtil.init((Properties)p);
            boolean foundKey = this.db.keyExists(key);
            if (foundKey) {
                Integer n = key;
                return n;
            }
            try {
                throw new FinderException("Key not found: " + key);
            }
            catch (SQLException se) {
                TestUtil.printStackTrace((Throwable)se);
                throw new FinderException("SQL Exception in primary key finder");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                throw new FinderException("Exception occurred: " + e);
            }
        }
        finally {
            try {
                this.db.closeDBConnection();
            }
            catch (SQLException e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
    }

    public Integer ejbFindByPrimaryKey(Integer key) throws FinderException {
        TestUtil.logTrace((String)"ejbFindByPrimaryKey");
        try {
            boolean foundKey = this.db.keyExists(key);
            if (foundKey) {
                Integer n = key;
                return n;
            }
            try {
                throw new FinderException("Key not found: " + key);
            }
            catch (SQLException se) {
                TestUtil.printStackTrace((Throwable)se);
                throw new FinderException("SQL Exception in primary key finder");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                throw new FinderException("Exception occurred: " + e);
            }
        }
        finally {
            try {
                this.db.closeDBConnection();
            }
            catch (SQLException e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
    }

    public Collection ejbFindByName(Properties p, String name) throws FinderException {
        TestUtil.logTrace((String)"ejbFindByName");
        try {
            TestUtil.logMsg((String)"Initialize remote logging");
            TestUtil.init((Properties)p);
            Collection c = this.db.nameToKeyCollection(name);
            if (c.size() > 0) {
                Collection collection = c;
                return collection;
            }
            try {
                throw new FinderException("Name not found: " + name);
            }
            catch (SQLException se) {
                TestUtil.printStackTrace((Throwable)se);
                throw new FinderException("SQL Exception in name finder");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                throw new FinderException("Exception occurred: " + e);
            }
        }
        finally {
            try {
                this.db.closeDBConnection();
            }
            catch (SQLException e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
    }

    public Collection ejbFindByPrice(Properties p, float price) throws FinderException {
        TestUtil.logTrace((String)"ejbFindByPrice");
        try {
            TestUtil.logMsg((String)"Initialize remote logging");
            TestUtil.init((Properties)p);
            Collection c = this.db.priceToKeyCollection(price);
            if (c.size() > 0) {
                Collection collection = c;
                return collection;
            }
            try {
                throw new FinderException("Price not found: " + price);
            }
            catch (SQLException se) {
                TestUtil.printStackTrace((Throwable)se);
                throw new FinderException("SQL Exception in price finder");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                throw new FinderException("Exception occurred: " + e);
            }
        }
        finally {
            try {
                this.db.closeDBConnection();
            }
            catch (SQLException e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
    }

    public Collection ejbFindWithinPriceRange(Properties p, float pmin, float pmax) throws FinderException {
        TestUtil.logTrace((String)"ejbFindWithinPriceRange");
        try {
            TestUtil.logMsg((String)"Initialize remote logging");
            TestUtil.init((Properties)p);
            Collection c = this.db.priceRangeToCollection(pmin, pmax);
            if (c.size() > 0) {
                Collection collection = c;
                return collection;
            }
            try {
                throw new FinderException("Price Range not found: [" + pmin + "-" + pmax + "]");
            }
            catch (SQLException se) {
                TestUtil.printStackTrace((Throwable)se);
                throw new FinderException("SQL Exception in price range finder");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                throw new FinderException("Exception occurred: " + e);
            }
        }
        finally {
            try {
                this.db.closeDBConnection();
            }
            catch (SQLException e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
    }

    public Collection ejbFindWithinPrimaryKeyRange(Properties p, Integer kmin, Integer kmax) throws FinderException {
        TestUtil.logTrace((String)"ejbFindWithinPrimaryKeyRange");
        try {
            TestUtil.logMsg((String)"Initialize remote logging");
            TestUtil.init((Properties)p);
            Collection c = this.db.primaryKeyRangeToCollection(kmin, kmax);
            if (c.size() > 0) {
                Collection collection = c;
                return collection;
            }
            try {
                throw new FinderException("Primary Key Range not found: [" + kmin + "-" + kmax + "]");
            }
            catch (SQLException se) {
                TestUtil.printStackTrace((Throwable)se);
                throw new FinderException("SQL Exception in primary key range finder");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                throw new FinderException("Exception occurred: " + e);
            }
        }
        finally {
            try {
                this.db.closeDBConnection();
            }
            catch (SQLException e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
    }

    public String ping(String s) {
        TestUtil.logTrace((String)("ping : " + s));
        return "ping: " + s;
    }

    public void initLogging(Properties p) {
        TestUtil.logTrace((String)"initLogging");
        try {
            TestUtil.init((Properties)p);
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }
}

