/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.bb.entity.bmp.allowedmethodstest;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.bb.entity.bmp.allowedmethodstest.Helper;
import com.sun.ts.tests.ejb.ee.bb.entity.bmp.allowedmethodstest.TestBean;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.TimedObject;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class TestBeanEJB
implements EntityBean,
TimedObject {
    private EntityContext ectx = null;
    private TSNamingContext nctx = null;
    private Helper helperRef = null;
    private String role = "Administrator";
    private Hashtable table = new Hashtable();
    private static final String testLookup = "java:comp/env/ejb/Helper";
    private static final String DATASOURCE = "java:comp/env/jdbc/DBTimer";
    private transient Connection dbConnection = null;
    private String dsname = null;
    private DataSource ds = null;
    private int cofID = 0;
    private String cofName = null;
    private float cofPrice = 0.0f;
    private static final String[] tests = new String[]{"ejbCreate", "ejbPostCreate", "ejbFindTheBean", "ejbLoad", "ejbStore", "setEntityContext", "businessMethod", "ejbHomeDoTest"};
    private static final Properties[] methodList = new Properties[]{new Properties(), new Properties(), new Properties(), new Properties(), new Properties(), new Properties(), new Properties(), new Properties()};
    private boolean ejbLoadCalled = false;
    private boolean ejbStoreCalled = false;

    public Integer ejbCreate(Properties p, Helper ref, int coffeeID, String coffeName, float coffeePrice, int flag) throws CreateException {
        TestUtil.logTrace((String)"ejbCreate");
        try {
            TestUtil.logMsg((String)"Initialize remote logging");
            TestUtil.init((Properties)p);
            this.tableInit();
            this.createNewRow(coffeeID, coffeName, coffeePrice);
        }
        catch (RemoteLoggingInitException e) {
            throw new CreateException(e.getMessage());
        }
        catch (Exception e) {
            throw new CreateException("Unexpected Exception occurred in ejbCreate: " + e);
        }
        if (flag == 1) {
            this.doOperationTests("ejbCreate");
        }
        try {
            ref.setData(this.table);
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught Unexpected Exception in ejbCreate");
            throw new CreateException("Exception occurred: " + e);
        }
        return new Integer(coffeeID);
    }

    public void ejbPostCreate(Properties p, Helper ref, int coffeeID, String coffeName, float coffeePrice, int flag) {
        TestUtil.logTrace((String)"ejbPostCreate");
        if (flag == 2) {
            this.doOperationTests("ejbPostCreate");
        }
        try {
            ref.setData(this.table);
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught Unexpected Exception in ejbPostCreate");
            throw new EJBException("Exception occurred: " + e);
        }
    }

    public Integer ejbCreate(Properties p, int coffeeID, String coffeName, float coffeePrice) throws CreateException {
        TestUtil.logTrace((String)"ejbCreate");
        try {
            TestUtil.logMsg((String)"Initialize remote logging");
            TestUtil.init((Properties)p);
            this.tableInit();
            this.createNewRow(coffeeID, coffeName, coffeePrice);
        }
        catch (RemoteLoggingInitException e) {
            throw new CreateException(e.getMessage());
        }
        catch (Exception e) {
            throw new CreateException("Unexpected Exception occurred in ejbCreate: " + e);
        }
        return new Integer(coffeeID);
    }

    public void ejbPostCreate(Properties p, int coffeeID, String coffeName, float coffeePrice) {
        TestUtil.logTrace((String)"ejbPostCreate");
    }

    public void setEntityContext(EntityContext c) {
        TestUtil.logTrace((String)"setEntityContext");
        this.ectx = c;
        try {
            TestUtil.logMsg((String)"Obtain naming context");
            this.nctx = new TSNamingContext();
            TestUtil.logMsg((String)"Lookup DataSource from JNDI : java:comp/env/jdbc/DBTimer");
            this.dsname = DATASOURCE;
            this.ds = (DataSource)this.nctx.lookup(this.dsname);
            TestUtil.logMsg((String)("dsname=" + this.dsname + "ds=" + this.ds));
        }
        catch (NamingException e) {
            TestUtil.logErr((String)"Unexpected NamingException ... ");
            throw new EJBException("Unable to obtain naming context:" + e);
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception ... ");
            throw new EJBException("Unexpected Exception occurred in setEntityContext" + e);
        }
        this.doOperationTests("setEntityContext");
    }

    public void unsetEntityContext() {
        TestUtil.logTrace((String)"unsetEntityContext");
    }

    public void ejbLoad() {
        TestUtil.logTrace((String)"ejbLoad");
        if (this.ejbLoadCalled) {
            return;
        }
        this.doOperationTests("ejbLoad");
        this.ejbLoadCalled = true;
        this.ejbStoreCalled = false;
    }

    public void ejbStore() {
        TestUtil.logTrace((String)"ejbStore");
        if (this.ejbStoreCalled) {
            return;
        }
        this.doOperationTests("ejbStore");
        this.ejbStoreCalled = true;
        this.ejbLoadCalled = false;
    }

    public Integer ejbFindTheBean(Properties p, Integer key, Helper ref) throws FinderException {
        TestUtil.logTrace((String)"ejbFindTheBean");
        try {
            this.doOperationTests("ejbFindTheBean");
            ref.setData(this.table);
        }
        catch (Exception e) {
            throw new EJBException(e.getMessage());
        }
        return new Integer(10);
    }

    public Integer ejbFindByPrimaryKey(Integer key) throws FinderException {
        TestUtil.logTrace((String)"ejbFindByPrimaryKey");
        try {
            TestUtil.logMsg((String)"Check if Primary Key Exists");
            boolean foundKey = this.keyExists(key);
            if (foundKey) {
                return key;
            }
            throw new FinderException("Key not found: " + key);
        }
        catch (Exception e) {
            throw new FinderException("Exception occurred: " + e);
        }
    }

    public void ejbRemove() throws RemoveException {
        TestUtil.logTrace((String)"ejbRemove");
        TestUtil.logMsg((String)("PrimaryKey=" + this.ectx.getPrimaryKey()));
        try {
            this.removeRow((Integer)this.ectx.getPrimaryKey());
        }
        catch (Exception e) {
            throw new RemoveException("Unexpected Exception occurred in ejbRemove");
        }
    }

    public void ejbActivate() {
        TestUtil.logTrace((String)"ejbActivate");
    }

    public void ejbPassivate() {
        TestUtil.logTrace((String)"ejbPassivate");
    }

    public void ejbTimeout(Timer timer) {
        TestUtil.logTrace((String)"ejbTimeout");
    }

    public TestBean ejbHomeDoTest(Helper ref) {
        TestUtil.logTrace((String)"ejbHomeDoTest");
        try {
            this.doOperationTests("ejbHomeDoTest");
            ref.setData(this.table);
        }
        catch (Exception e) {
            throw new EJBException(e.getMessage());
        }
        return null;
    }

    public Hashtable getResults() {
        TestUtil.logTrace((String)"getResults");
        return this.table;
    }

    public void businessMethod(Helper ref) {
        TestUtil.logTrace((String)"businessMethod");
        try {
            this.doOperationTests("businessMethod");
            ref.setData(this.table);
        }
        catch (Exception e) {
            throw new EJBException(e.getMessage());
        }
    }

    private int testIndex(String s) {
        TestUtil.logTrace((String)"testIndex");
        for (int i = 0; i < tests.length; ++i) {
            if (!s.equals(tests[i])) continue;
            return i;
        }
        return -1;
    }

    private void setTestList(int i) {
        TestUtil.logTrace((String)"setTestList");
        methodList[i].setProperty("getEJBHome", "true");
        methodList[i].setProperty("getCallerPrincipal", "true");
        methodList[i].setProperty("isCallerInRole", "true");
        methodList[i].setProperty("getEJBObject", "true");
        methodList[i].setProperty("JNDI_Access", "true");
        methodList[i].setProperty("getPrimaryKey", "true");
        methodList[i].setProperty("getEJBLocalHome", "true");
        methodList[i].setProperty("getEJBLocalObject", "true");
        methodList[i].setProperty("getTimerService", "true");
        methodList[i].setProperty("TimerService_Methods_Test1", "true");
        methodList[i].setProperty("TimerService_Methods_Test2", "true");
        methodList[i].setProperty("TimerService_Methods_Test3", "true");
        methodList[i].setProperty("TimerService_Methods_Test4", "true");
        methodList[i].setProperty("TimerService_Methods_Test5", "true");
        methodList[i].setProperty("TimerService_Methods_Test6", "true");
        methodList[i].setProperty("TimerService_Methods_Test7", "true");
        methodList[i].setProperty("getRollbackOnly", "true");
    }

    private void doOperationTests(String s) {
        Date d;
        TestUtil.logTrace((String)"doOperationTests");
        int i = this.testIndex(s);
        TestUtil.logMsg((String)("index for " + s + " is " + i));
        TestUtil.logMsg((String)("methodList length=" + methodList.length));
        TestUtil.logMsg((String)("tests length=" + tests.length));
        this.setTestList(i);
        TestUtil.logMsg((String)("Operations testing for " + s + " method ..."));
        try {
            this.ectx.getEJBHome();
            TestUtil.logMsg((String)"Operations test: getEJBHome() - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("getEJBHome", "false");
            TestUtil.logMsg((String)"Operations test: getEJBHome() - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("getEJBHome", "unexpected");
            TestUtil.logMsg((String)("Operations test: getEJBHome() - not allowed (Unexpected Exception) - " + e));
        }
        try {
            this.ectx.getCallerPrincipal();
            TestUtil.logMsg((String)"Operations test: getCallerPrincipal() - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("getCallerPrincipal", "false");
            TestUtil.logMsg((String)"Operations test: getCallerPrincipal() - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("getCallerPrincipal", "unexpected");
            TestUtil.logMsg((String)("Operations test: getCallerPrincipal() - not allowed (Unexpected Exception) - " + e));
        }
        try {
            this.ectx.isCallerInRole(this.role);
            TestUtil.logMsg((String)"Operations test: isCallerInRole() - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("isCallerInRole", "false");
            TestUtil.logMsg((String)"Operations test: isCallerInRole() - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("isCallerInRole", "unexpected");
            TestUtil.logMsg((String)("Operations test: isCallerInRole() - not allowed (Unexpected Exception) - " + e));
        }
        try {
            this.ectx.getEJBObject();
            TestUtil.logMsg((String)"Operations test: getEJBObject() - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("getEJBObject", "false");
            TestUtil.logMsg((String)"Operations test: getEJBObject() - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("getEJBObject", "unexpected");
            TestUtil.logMsg((String)("Operations test: getEJBObject() - not allowed (Unexpected Exception) - " + e));
        }
        try {
            Context ctx = (Context)this.nctx.lookup("java:comp/env");
            TestUtil.logMsg((String)"Operations test: JNDI_Access - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("JNDI_Access", "false");
            TestUtil.logMsg((String)"Operations test: JNDI_Access() - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("JNDI_Access", "unexpected");
            TestUtil.logMsg((String)("Operations test: JNDI_Access() - not allowed (Unexpected Exception) - " + e));
        }
        try {
            this.ectx.getPrimaryKey();
            TestUtil.logMsg((String)"Operations test: getPrimaryKey() - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("getPrimaryKey", "false");
            TestUtil.logMsg((String)"Operations test: getPrimaryKey() - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("getPrimaryKey", "unexpected");
            TestUtil.logMsg((String)("Operations test: getPrimaryKey() - not allowed (Unexpected Exception) - " + e));
        }
        try {
            this.ectx.getEJBLocalHome();
            TestUtil.logMsg((String)"Operations test: getEJBLocalHome() - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("getEJBLocalHome", "false");
            TestUtil.logMsg((String)"Operations test: getEJBLocalHome() - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("getEJBLocalHome", "unexpected");
            TestUtil.logMsg((String)("Operations test: getEJBLocalHome() - not allowed (Unexpected Exception) - " + e));
        }
        try {
            this.ectx.getEJBLocalObject();
            TestUtil.logMsg((String)"Operations test: getEJBLocalObject() - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("getEJBLocalObject", "false");
            TestUtil.logMsg((String)"Operations test: getEJBLocalObject() - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("getEJBLocalObject", "unexpected");
            TestUtil.logMsg((String)("Operations test: getEJBLocalObject() - not allowed (Unexpected Exception) - " + e));
        }
        try {
            this.ectx.getTimerService();
            TestUtil.logMsg((String)"Operations test: getTimerService() - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("getTimerService", "false");
            TestUtil.logMsg((String)"Operations test: getTimerService() - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("getTimerService", "unexpected");
            TestUtil.logMsg((String)("Operations test: getTimerService() - not allowed (Unexpected Exception) - " + e));
        }
        try {
            TimerService timesrv = this.ectx.getTimerService();
            Timer tt = timesrv.createTimer(10000L, (Serializable)((Object)"test1"));
            tt.cancel();
            TestUtil.logMsg((String)"Operations test: TimerService_Methods_Test1() - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("TimerService_Methods_Test1", "false");
            TestUtil.logMsg((String)"Operations test: TimerService_Methods_Test1() - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("TimerService_Methods_Test1", "unexpected");
            TestUtil.logMsg((String)("Operations test: TimerService_Methods_Test1() - not allowed (Unexpected Exception) - " + e));
        }
        try {
            TimerService timesrv2 = this.ectx.getTimerService();
            Timer t2 = timesrv2.createTimer(10000L, 10000L, (Serializable)((Object)"test2"));
            t2.cancel();
            TestUtil.logMsg((String)"Operations test: TimerService_Methods_Test2() - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("TimerService_Methods_Test2", "false");
            TestUtil.logMsg((String)"Operations test: TimerService_Methods_Test2() - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("TimerService_Methods_Test2", "unexpected");
            TestUtil.logMsg((String)("Operations test: TimerService_Methods_Test2() - not allowed (Unexpected Exception) - " + e));
        }
        try {
            long expiration = System.currentTimeMillis() + 900000L;
            d = new Date(expiration);
            TimerService timesrv3 = this.ectx.getTimerService();
            Timer t3 = timesrv3.createTimer(d, (Serializable)((Object)"test3"));
            t3.cancel();
            TestUtil.logMsg((String)"Operations test: TimerService_Methods_Test3() - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("TimerService_Methods_Test3", "false");
            TestUtil.logMsg((String)"Operations test: TimerService_Methods_Test3() - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("TimerService_Methods_Test3", "unexpected");
            TestUtil.logMsg((String)("Operations test: TimerService_Methods_Test3() - not allowed (Unexpected Exception) - " + e));
        }
        try {
            long expiration = System.currentTimeMillis() + 900000L;
            d = new Date(expiration);
            TimerService timesrv4 = this.ectx.getTimerService();
            Timer t4 = timesrv4.createTimer(d, 10000L, (Serializable)((Object)"test4"));
            t4.cancel();
            TestUtil.logMsg((String)"Operations test: TimerService_Methods_Test4() - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("TimerService_Methods_Test4", "false");
            TestUtil.logMsg((String)"Operations test: TimerService_Methods_Test4() - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("TimerService_Methods_Test4", "unexpected");
            TestUtil.logMsg((String)("Operations test: TimerService_Methods_Test4() - not allowed (Unexpected Exception) - " + e));
        }
        try {
            TimerService ts = this.ectx.getTimerService();
            Collection ccol = ts.getTimers();
            TestUtil.logMsg((String)"Operations test: TimerService_Methods_Test5() - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("TimerService_Methods_Test5", "false");
            TestUtil.logMsg((String)"Operations test: TimerService_Methods_Test5() - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("TimerService_Methods_Test5", "unexpected");
            TestUtil.logMsg((String)("Operations test: TimerService_Methods_Test5() - not allowed (Unexpected Exception) - " + e));
        }
        try {
            TimerService timesrv6 = this.ectx.getTimerService();
            Timer t6 = timesrv6.createTimer(10000L, (Serializable)((Object)"test6"));
            t6.getHandle();
            t6.cancel();
            TestUtil.logMsg((String)"Operations test: TimerService_Methods_Test6() - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("TimerService_Methods_Test6", "false");
            TestUtil.logMsg((String)"Operations test: TimerService_Methods_Test6() - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("TimerService_Methods_Test6", "unexpected");
            TestUtil.logMsg((String)("Operations test: TimerService_Methods_Test6() - not allowed (Unexpected Exception) - " + e));
        }
        try {
            TimerService timesrv7 = this.ectx.getTimerService();
            Timer t7 = timesrv7.createTimer(10000L, (Serializable)((Object)"test7"));
            t7.cancel();
            TestUtil.logMsg((String)"Operations test: TimerService_Methods_Test7() - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("TimerService_Methods_Test7", "false");
            TestUtil.logMsg((String)"Operations test: TimerService_Methods_Test7() - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("TimerService_Methods_Test7", "unexpected");
            TestUtil.logMsg((String)("Operations test: TimerService_Methods_Test7() - not allowed (Unexpected Exception) - " + e));
        }
        try {
            this.ectx.getRollbackOnly();
            TestUtil.logMsg((String)"Operations test: getRollbackOnly() - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("getRollbackOnly", "false");
            TestUtil.logMsg((String)"Operations test: getRollbackOnly() - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("getRollbackOnly", "unexpected");
            TestUtil.logMsg((String)("Operations test: getRollbackOnly() - not allowed (Unexpected Exception) - " + e));
        }
        this.table.put(s, methodList[i]);
    }

    public void doTimer(long duration, String info) {
        TestUtil.logTrace((String)"doTimer");
        TimerService ts = this.ectx.getTimerService();
        TestUtil.logTrace((String)"create Timer");
        Timer t = ts.createTimer(duration, (Serializable)((Object)info));
    }

    public void findAndCancelTimer() {
        Collection ccol = null;
        try {
            TestUtil.logTrace((String)"findAndCancelTimer method entered");
            TimerService ts = this.ectx.getTimerService();
            TestUtil.logTrace((String)"Get Timers");
            ccol = ts.getTimers();
            if (ccol.size() != 0) {
                TestUtil.logTrace((String)("Collection size is: " + ccol.size()));
                Iterator i = ccol.iterator();
                while (i.hasNext()) {
                    TestUtil.logTrace((String)"Get next timer");
                    Timer t = (Timer)i.next();
                    TestUtil.logTrace((String)("Next timer to Cancel: " + t.getInfo()));
                    t.cancel();
                }
            } else {
                TestUtil.logTrace((String)"Timer Collection is null");
            }
        }
        catch (Exception e) {
            throw new EJBException("findAndCancelTimer: " + e);
        }
    }

    private void getDBConnection() throws SQLException {
        TestUtil.logTrace((String)"getDBConnection");
        if (this.dbConnection != null) {
            try {
                this.closeDBConnection();
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Exception occurred trying to close DB Connection", (Throwable)e);
            }
        }
        this.dbConnection = this.ds.getConnection();
    }

    private void closeDBConnection() throws SQLException {
        TestUtil.logTrace((String)"closeDBConnection");
        if (this.dbConnection != null) {
            this.dbConnection.close();
            this.dbConnection = null;
        }
    }

    private void tableInit() throws SQLException {
        Statement stmt = null;
        TestUtil.logTrace((String)"tableInit");
        this.getDBConnection();
        try {
            stmt = this.dbConnection.createStatement();
            String sqlStr = TestUtil.getProperty((String)"BB_Tab_Delete");
            stmt.executeUpdate(sqlStr);
            TestUtil.logMsg((String)("Deleted all rows from table " + TestUtil.getTableName((String)sqlStr)));
        }
        catch (SQLException s) {
            throw new SQLException("SQL Exception in tableInit:" + s.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                this.closeDBConnection();
            }
            catch (SQLException e) {
                TestUtil.logErr((String)"SQLException occurred closing DB Connection", (Throwable)e);
            }
        }
    }

    private void createNewRow(int cofID, String cofName, float cofPrice) throws CreateException, SQLException {
        Statement pStmt = null;
        TestUtil.logTrace((String)"createNewRow");
        this.getDBConnection();
        try {
            String sqlStr = TestUtil.getProperty((String)"BB_Insert1");
            TestUtil.logMsg((String)sqlStr);
            pStmt = this.dbConnection.prepareStatement(sqlStr);
            pStmt.setInt(1, cofID);
            pStmt.setString(2, cofName);
            pStmt.setFloat(3, cofPrice);
            if (pStmt.executeUpdate() != 1) {
                throw new CreateException("SQL INSERT failed in createNewRow");
            }
            this.cofID = cofID;
            this.cofName = cofName;
            this.cofPrice = cofPrice;
        }
        catch (SQLException e) {
            throw new SQLException("SQL Exception in createNewRow" + e.getMessage());
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
                this.closeDBConnection();
            }
            catch (SQLException e) {
                TestUtil.logErr((String)"SQLException occurred in createNewRow", (Throwable)e);
            }
        }
    }

    private boolean keyExists(int pkey) throws SQLException {
        Statement pStmt = null;
        ResultSet result = null;
        TestUtil.logTrace((String)"keyExists");
        this.getDBConnection();
        try {
            String sqlStr = TestUtil.getProperty((String)"BB_Select1");
            TestUtil.logMsg((String)sqlStr);
            pStmt = this.dbConnection.prepareStatement(sqlStr);
            pStmt.setInt(1, pkey);
            result = pStmt.executeQuery();
            if (!result.next()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            throw new SQLException("Caught SQL Exception in keyExists" + e.getMessage());
        }
        finally {
            try {
                if (result != null) {
                    result.close();
                }
                if (pStmt != null) {
                    pStmt.close();
                }
                this.closeDBConnection();
            }
            catch (SQLException e) {
                TestUtil.logErr((String)"SQLException occurred in keyExists", (Throwable)e);
            }
        }
    }

    private void removeRow(int pkey) throws SQLException {
        Statement pStmt = null;
        TestUtil.logTrace((String)"removeRow");
        this.getDBConnection();
        try {
            String sqlStr = TestUtil.getProperty((String)"BB_Delete1");
            TestUtil.logMsg((String)sqlStr);
            pStmt = this.dbConnection.prepareStatement(sqlStr);
            pStmt.setInt(1, pkey);
            if (pStmt.executeUpdate() != 1) {
                throw new SQLException("SQL DELETE failed in removeRow");
            }
        }
        catch (SQLException e) {
            throw new SQLException("SQL Exception in removeRow:" + e.getMessage());
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
                this.closeDBConnection();
            }
            catch (SQLException e) {
                TestUtil.logErr((String)"SQLException occurred in removeRow", (Throwable)e);
            }
        }
    }
}

