/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxr.api.javax_xml_registry_infomodel.ExtrinsicObject;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxr.common.JAXRCommonClient;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.xml.registry.BusinessQueryManager;
import javax.xml.registry.UnsupportedCapabilityException;
import javax.xml.registry.infomodel.ExtrinsicObject;
import javax.xml.registry.infomodel.Key;

public class JAXRClient
extends JAXRCommonClient {
    BusinessQueryManager bqm = null;

    public static void main(String[] args) {
        JAXRClient theTests = new JAXRClient();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            super.setup(args, p);
            super.cleanUpRegistry();
            this.debug.clear();
            this.bqm = this.rs.getBusinessQueryManager();
        }
        catch (Exception e) {
            throw new EETest.Fault("setup failed:", e);
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        try {
            super.cleanup();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Cleanup error: " + e.toString()));
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            if (this.debug != null) {
                TestUtil.logTrace((String)this.debug.toString());
            }
        }
    }

    public void extrinsicObjectTest() throws EETest.Fault {
        String testName = "extrinsicObjectTest";
        int providerlevel = 0;
        String mimeType = "text/html";
        int failcount = 0;
        try {
            String externalURI = this.baseuri + "jaxrTestPage1.html";
            providerlevel = this.rs.getCapabilityProfile().getCapabilityLevel();
            URL myUrl = new URL(externalURI);
            DataHandler repositoryItem = new DataHandler(myUrl);
            providerlevel = this.rs.getCapabilityProfile().getCapabilityLevel();
            this.debug.add("The capability level for this JAXR provider is: " + providerlevel + "\n");
            ExtrinsicObject eo = null;
            eo = (ExtrinsicObject)this.blm.createObject("ExtrinsicObject");
            if (providerlevel == 0) {
                throw new EETest.Fault(testName + " level 0 providers should throw an UnsupportedCapabilityException");
            }
            eo.setRepositoryItem(repositoryItem);
            DataHandler handler = eo.getRepositoryItem();
            if (handler.getContentType().equals(mimeType)) {
                this.debug.add("good -  repository item returned correct mimeType \n");
            } else {
                this.debug.add("not good - unexpected result from getRepositoryItem \n");
                ++failcount;
            }
            eo.setMimeType(mimeType);
            if (eo.getMimeType().equals(mimeType)) {
                this.debug.add("good mime type returned  " + mimeType + " as expected\n");
            } else {
                this.debug.add("getMimeType did not return expected value, method returned: " + eo.getMimeType() + "\n");
                ++failcount;
            }
            eo.setOpaque(true);
            if (eo.isOpaque()) {
                this.debug.add("good -  getOpaque returned true as expected \n");
            } else {
                this.debug.add("not good - unexpected result from getOpaque \n");
                ++failcount;
            }
            eo.setOpaque(false);
            if (!eo.isOpaque()) {
                this.debug.add("good -  getOpaque returned false as expected \n");
            } else {
                this.debug.add("not good - unexpected result from getOpaque \n");
                ++failcount;
            }
            eo.setOpaque(true);
            Key eoKey = eo.getKey();
            ArrayList<ExtrinsicObject> l = new ArrayList<ExtrinsicObject>();
            l.add(eo);
            this.blm.saveObjects(l);
            ExtrinsicObject retEo = (ExtrinsicObject)this.bqm.getRegistryObject(eoKey.getId());
            DataHandler dh = retEo.getRepositoryItem();
            if (dh.getContentType().equals(mimeType)) {
                this.debug.add("good -  repository item returned correct mimeType \n");
            } else {
                this.debug.add("not good - unexpected result from getRepositoryItem \n");
                ++failcount;
            }
            this.debug.add(" Now test eo returned from the registry. \n");
            if (retEo.isOpaque()) {
                this.debug.add("good -  getOpaque returned true as expected \n");
            } else {
                this.debug.add("not good - unexpected result from getOpaque \n");
                ++failcount;
            }
            if (retEo.getMimeType().equals(mimeType)) {
                this.debug.add("good mime type returned  " + mimeType + " as expected\n");
            } else {
                this.debug.add("getMimeType did not return expected value, method returned: " + retEo.getMimeType() + "\n");
                ++failcount;
            }
            ArrayList<Key> eoKeys = new ArrayList<Key>();
            eoKeys.add(eoKey);
            this.blm.deleteObjects(eoKeys);
            if (failcount > 0) {
                throw new EETest.Fault(testName + " failed \n");
            }
        }
        catch (UnsupportedCapabilityException uce) {
            TestUtil.printStackTrace((Throwable)uce);
            if (providerlevel == 0) {
                this.debug.add("UnsupportedCapabilityException was thrown as expected!!\n");
            }
            throw new EETest.Fault(testName + " failed - level 1 providers should support createExtrinsicObject");
        }
        catch (Exception e) {
            if (providerlevel == 0) {
                TestUtil.logErr((String)"Expected level 0 provider to throw UnsupportedCapabilityException");
            }
            TestUtil.logErr((String)("Cleanup error: " + e.toString()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }
}

