/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.httpd.JThttpProvider;
import com.sun.javatest.httpd.PageGenerator;
import com.sun.javatest.httpd.httpURL;
import com.sun.javatest.util.Debug;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.PrintWriter;

class TRT_HttpHandler
extends JThttpProvider {
    private TestResultTable trt;
    private int instanceNum;
    private String file;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(TRT_HttpHandler.class);
    private static boolean debug = Debug.getBoolean(TRT_HttpHandler.class);

    TRT_HttpHandler(TestResultTable trt, String url, int instanceNum) {
        this.instanceNum = instanceNum;
        this.trt = trt;
    }

    @Override
    public void serviceRequest(httpURL requestURL, PrintWriter out) {
        String nf = requestURL.getNextFile();
        if (nf == null) {
            this.beginGood(out);
            PageGenerator.writeBeginDoc(out);
            this.printIndex(out);
        } else if (nf.equals("tests")) {
            this.beginGood(out);
            PageGenerator.writeBeginDoc(out);
            this.printTests(requestURL, out);
        } else {
            if (debug) {
                Debug.println("TRT.HH-remainder of URL unknown (" + nf + ")");
            }
            this.beginBad(out);
            this.printIndex(out);
        }
        out.println("<br><hr>");
        PageGenerator.writeFooter(out);
        PageGenerator.endBody(out);
        PageGenerator.writeEndDoc(out);
        out.close();
    }

    public String getRegistredURL() {
        return this.file;
    }

    private void beginGood(PrintWriter out) {
        PageGenerator.generateOkHttp(out);
        PageGenerator.generateDocType(out, 0);
    }

    private void beginBad(PrintWriter out) {
        PageGenerator.generateBadHttp(out);
        PageGenerator.generateDocType(out, 0);
    }

    private void printIndex(PrintWriter out) {
        PageGenerator.writeHeader(out, i18n.getString("trtHttp.index.title"));
        PageGenerator.startBody(out);
        out.print("<h2>");
        TRT_HttpHandler.print(out, i18n.getString("trtHttp.index.hdr"));
        out.println("</h2>");
        out.println("<hr Width=\"40%\" Align=left>");
        out.println("<p>");
        this.printStats(out);
    }

    private void printTests(httpURL url, PrintWriter out) {
        PageGenerator.writeHeader(out, i18n.getString("trtHttp.tests.title"));
        PageGenerator.startBody(out);
        out.print("<h2>");
        TRT_HttpHandler.print(out, i18n.getString("trtHttp.tests.hdr"));
        out.println("</h2>");
        out.println("<hr Width=\"40%\" Align=left>");
        out.println("<p>");
        this.writeTests(out, i18n.getString("trtHttp.tests.name"), i18n.getString("trtHttp.tests.status"));
    }

    public void writeTests(PrintWriter out, String keyHeader, String valHeader) {
        out.println("<Table Border>");
        StringBuffer buf = new StringBuffer(50);
        buf.append("<tr><th>");
        buf.append(keyHeader);
        buf.append("<th>");
        buf.append(valHeader);
        buf.append("</tr>");
        out.println(buf.toString());
        TestResultTable.TreeIterator it = this.trt.getIterator();
        while (it.hasNext()) {
            String url;
            TestResult tr = (TestResult)it.next();
            try {
                url = tr.getDescription().getRootRelativeURL();
            }
            catch (TestResult.Fault f) {
                out.println("<tr><td>Unable to get TestResult info, aborting.</tr>");
                if (!debug) break;
                f.printStackTrace();
                break;
            }
            out.println("<tr>");
            buf.setLength(0);
            buf.append("<td>");
            buf.append(url);
            buf.append("<td>");
            buf.append(tr.getStatus().toString());
            out.println(buf.toString());
            out.println("</tr>");
        }
        out.println("</Table>");
    }

    private void printStats(PrintWriter out) {
        out.print("<b>");
        TRT_HttpHandler.print(out, i18n.getString("trtHttp.stats.hdr"));
        out.println("</b><br>");
        PageGenerator.startTable(out, false);
        out.println("<tr>");
        out.print("   <td>");
        TRT_HttpHandler.print(out, i18n.getString("trtHttp.wd.hdr"));
        out.println("</td>");
        out.print("   <td>");
        TRT_HttpHandler.print(out, this.trt.getWorkDir() != null ? this.trt.getWorkDir().getPath() : i18n.getString("trtHttp.wd.unset"));
        out.println("</td>");
        out.println("<tr>");
        out.print("   <td>");
        TRT_HttpHandler.print(out, i18n.getString("trtHttp.size.hdr"));
        out.println("</td>");
        out.print("   <td><a href=\"/trt/");
        out.print(Integer.toString(this.instanceNum));
        out.print("/tests\">");
        out.print(Integer.toString(this.trt.size()));
        out.println("</a></td>");
        out.println("</tr>");
        PageGenerator.endTable(out);
    }
}

