/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonp.api.common;

import com.sun.ts.tests.jsonp.api.common.JsonAssert;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.json.JsonValue;

public enum JsonValueType {
    String,
    Integer,
    Long,
    BigInteger,
    Double,
    BigDecimal,
    Boolean,
    JsonValue,
    Null;

    private static final int SIZE;
    private static final Map<String, JsonValueType> VALUES;

    public static JsonValueType getType(Class c) {
        JsonValueType type = VALUES.get(c.getSimpleName());
        if (type != null) {
            return type;
        }
        LinkedList stack = new LinkedList();
        for (Class<?> i : c.getInterfaces()) {
            stack.push(i);
        }
        while (!stack.isEmpty()) {
            Class i = (Class)stack.pop();
            type = VALUES.get(i.getSimpleName());
            if (type != null) {
                return type;
            }
            for (Class<?> j : i.getInterfaces()) {
                stack.push(j);
            }
        }
        throw new IllegalArgumentException("Unsupported JSON value type: " + c.getSimpleName());
    }

    public static JsonValueType getType(Object value) {
        return value != null ? JsonValueType.getType(value.getClass()) : Null;
    }

    public static String toStringValue(Object value) {
        switch (JsonValueType.getType(value)) {
            case String: {
                return '\"' + (String)value + '\"';
            }
            case Integer: {
                return ((Integer)value).toString();
            }
            case Long: {
                return ((Long)value).toString();
            }
            case BigInteger: {
                return ((BigInteger)value).toString();
            }
            case Double: {
                return ((Double)value).toString();
            }
            case BigDecimal: {
                return ((BigDecimal)value).toString();
            }
            case Boolean: {
                return ((Boolean)value).toString();
            }
            case JsonValue: {
                return JsonAssert.valueToString((JsonValue)value);
            }
            case Null: {
                return "null";
            }
        }
        throw new IllegalArgumentException("Unsupported JSON value type: " + value.getClass().getSimpleName());
    }

    static {
        SIZE = JsonValueType.values().length;
        VALUES = new HashMap<String, JsonValueType>(SIZE);
        for (int i = 0; i < SIZE; ++i) {
            VALUES.put(JsonValueType.values()[i].name(), JsonValueType.values()[i]);
        }
    }
}

