/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.closedTopicSubscriber;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import java.util.ArrayList;
import java.util.Properties;
import javax.jms.IllegalStateException;
import javax.jms.Message;
import javax.jms.Topic;

public class ClosedTopicSubscriberTests
extends ServiceEETest {
    private static final String testName = "com.sun.ts.tests.jms.core.closedTopicSubscriber.ClosedTopicSubscriberTests";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private Properties props = null;
    private transient JmsTool tool = null;
    long timeout;
    private String jmsUser;
    private String jmsPassword;
    private String mode;
    ArrayList connections = null;

    public static void main(String[] args) {
        ClosedTopicSubscriberTests theTests = new ClosedTopicSubscriberTests();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    private void checkExceptionPass(boolean passed) throws Exception {
        if (!passed) {
            this.logMsg("Didn't get expected exception");
            throw new Exception("Didn't catch expected exception");
        }
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            this.jmsUser = p.getProperty("user");
            this.jmsPassword = p.getProperty("password");
            this.mode = p.getProperty("platform.mode");
            this.timeout = Long.parseLong(p.getProperty("jms_timeout"));
            if (this.timeout < 1L) {
                throw new Exception("'timeout' (milliseconds) in ts.jte must be > 0");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("Setup failed!", e);
        }
    }

    private void createAndCloseSubscriber() throws Exception {
        this.tool = new JmsTool(1, this.jmsUser, this.jmsPassword, this.mode);
        this.tool.getDefaultTopicConnection().start();
        this.logTrace("Closing topic subscriber");
        this.tool.getDefaultTopicSubscriber().close();
        this.logTrace("Subscriber closed");
    }

    public void cleanup() throws EETest.Fault {
        try {
            if (this.tool != null) {
                this.logMsg("Cleanup: Closing Queue and Topic Connections");
                this.tool.closeAllConnections(this.connections);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            this.logErr("An error occurred while cleaning");
            throw new EETest.Fault("Cleanup failed!", e);
        }
    }

    public void closedTopicSubscriberCloseTest() throws EETest.Fault {
        try {
            this.createAndCloseSubscriber();
            this.logTrace("Try to call close again");
            this.tool.getDefaultTopicSubscriber().close();
        }
        catch (Exception e) {
            throw new EETest.Fault("closedTopicSubscriberCloseTest", e);
        }
    }

    public void closedTopicSubscriberGetMessageSelectorTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseSubscriber();
            this.logTrace("Try to call getMessageSelector");
            try {
                String foo = this.tool.getDefaultTopicSubscriber().getMessageSelector();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedTopicSubscriberGetMessageSelectorTest", e);
        }
    }

    public void closedTopicSubscriberReceiveTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseSubscriber();
            this.logTrace("Try to call receive");
            try {
                Message foo = this.tool.getDefaultTopicSubscriber().receive();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedTopicSubscriberReceiveTest", e);
        }
    }

    public void closedTopicSubscriberReceiveTimeoutTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseSubscriber();
            this.logTrace("Try to call receive(timeout)");
            try {
                Message foo = this.tool.getDefaultTopicSubscriber().receive(this.timeout);
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedTopicSubscriberReceiveTimeoutTest", e);
        }
    }

    public void closedTopicSubscriberReceiveNoWaitTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseSubscriber();
            this.logTrace("Try to call receiveNoWait");
            try {
                Message foo = this.tool.getDefaultTopicSubscriber().receiveNoWait();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedTopicSubscriberReceiveNoWaitTest", e);
        }
    }

    public void closedTopicSubscriberGetNoLocalTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseSubscriber();
            this.logTrace("Try to call getNoLocal");
            try {
                boolean foo = this.tool.getDefaultTopicSubscriber().getNoLocal();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedTopicSubscriberGetNoLocalTest", e);
        }
    }

    public void closedTopicSubscriberGetTopicTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseSubscriber();
            this.logTrace("Try to call getTopic");
            try {
                Topic foo = this.tool.getDefaultTopicSubscriber().getTopic();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedTopicSubscriberGetTopicTest", e);
        }
    }
}

