/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxrpc.ee.j2w.multiservicetest;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.porting.TSURL;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxrpc.common.JAXRPC_Util;
import com.sun.ts.tests.jaxrpc.ee.j2w.multiservicetest.MultiServiceTest1;
import com.sun.ts.tests.jaxrpc.ee.j2w.multiservicetest.MultiServiceTest2;
import java.net.URL;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.xml.rpc.Service;
import javax.xml.rpc.Stub;

public class Client
extends ServiceEETest {
    private static final String PROTOCOL = "http";
    private static final String HOSTNAME = "localhost";
    private static final int PORTNUM = 8000;
    private static final String WEBSERVERHOSTPROP = "webServerHost";
    private static final String WEBSERVERPORTPROP = "webServerPort";
    private static final String MODEPROP = "platform.mode";
    private static final String PKG_NAME = "com.sun.ts.tests.jaxrpc.ee.j2w.multiservicetest.";
    private TSURL ctsurl = new TSURL();
    private Properties props = null;
    private String hostname = "localhost";
    private int portnum = 8000;
    private static final String ENDPOINT1_URL = "multiservicetest.endpoint.1";
    private static final String WSDLLOC1_URL = "multiservicetest.wsdlloc.1";
    private static final String ENDPOINT2_URL = "multiservicetest.endpoint.2";
    private static final String WSDLLOC2_URL = "multiservicetest.wsdlloc.2";
    private String url1 = null;
    private URL wsdlurl1 = null;
    private String url2 = null;
    private URL wsdlurl2 = null;
    private static final String SERVICE_NAME1 = "multiservicetest.servicename.1";
    private static final String PORT_NAME1 = "multiservicetest.portname.1";
    private static final String SERVICE_NAME2 = "multiservicetest.servicename.2";
    private static final String PORT_NAME2 = "multiservicetest.portname.2";
    private String serviceName1 = null;
    private String portName1 = null;
    private String serviceName2 = null;
    private String portName2 = null;
    String modeProperty = null;
    MultiServiceTest1 port1 = null;
    Stub stub1 = null;
    MultiServiceTest2 port2 = null;
    Stub stub2 = null;

    private void getTestURLs() throws Exception {
        TestUtil.logMsg((String)"Get URL's used by the test");
        String file = JAXRPC_Util.getURLFromProp(ENDPOINT1_URL);
        this.url1 = this.ctsurl.getURLString(PROTOCOL, this.hostname, this.portnum, file);
        file = JAXRPC_Util.getURLFromProp(WSDLLOC1_URL);
        this.wsdlurl1 = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, file);
        file = JAXRPC_Util.getURLFromProp(ENDPOINT2_URL);
        this.url2 = this.ctsurl.getURLString(PROTOCOL, this.hostname, this.portnum, file);
        file = JAXRPC_Util.getURLFromProp(WSDLLOC2_URL);
        this.wsdlurl2 = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, file);
        TestUtil.logMsg((String)("Service Endpoint1 URL: " + this.url1));
        TestUtil.logMsg((String)("WSDL1 Location URL:    " + this.wsdlurl1));
        TestUtil.logMsg((String)("Service Endpoint2 URL: " + this.url2));
        TestUtil.logMsg((String)("WSDL2 Location URL:    " + this.wsdlurl2));
    }

    private void getStubStandalone() throws Exception {
        this.serviceName1 = PKG_NAME + JAXRPC_Util.getURLFromProp(SERVICE_NAME1);
        this.portName1 = JAXRPC_Util.getURLFromProp(PORT_NAME1);
        this.serviceName2 = PKG_NAME + JAXRPC_Util.getURLFromProp(SERVICE_NAME2);
        this.portName2 = JAXRPC_Util.getURLFromProp(PORT_NAME2);
        this.port1 = (MultiServiceTest1)JAXRPC_Util.getStub(this.serviceName1, "get" + this.portName1);
        TestUtil.logMsg((String)"Cast stub to base Stub class ...");
        this.stub1 = (Stub)this.port1;
        this.port2 = (MultiServiceTest2)JAXRPC_Util.getStub(this.serviceName2, "get" + this.portName2);
        TestUtil.logMsg((String)"Cast stub to base Stub class ...");
        this.stub2 = (Stub)this.port2;
    }

    private void getStub() throws Exception {
        try {
            InitialContext ic = new InitialContext();
            Service service1 = (Service)ic.lookup("java:comp/env/service/multiserviceTest1");
            Service service2 = (Service)ic.lookup("java:comp/env/service/multiserviceTest2");
            this.port1 = (MultiServiceTest1)service1.getPort(MultiServiceTest1.class);
            this.port2 = (MultiServiceTest2)service2.getPort(MultiServiceTest2.class);
        }
        catch (Throwable t) {
            TestUtil.printStackTrace((Throwable)t);
            throw new EETest.Fault(t.toString());
        }
    }

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        boolean pass = true;
        try {
            this.hostname = p.getProperty(WEBSERVERHOSTPROP);
            if (this.hostname == null) {
                pass = false;
            } else if (this.hostname.equals("")) {
                pass = false;
            }
            try {
                this.portnum = Integer.parseInt(p.getProperty(WEBSERVERPORTPROP));
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                pass = false;
            }
            this.modeProperty = p.getProperty(MODEPROP);
            if (this.modeProperty.equals("standalone")) {
                this.getTestURLs();
                this.getStubStandalone();
                TestUtil.logMsg((String)("Setting target endpoint to " + this.url1 + " ..."));
                this.stub1._setProperty("javax.xml.rpc.service.endpoint.address", (Object)this.url1);
                TestUtil.logMsg((String)("Setting target endpoint to " + this.url2 + " ..."));
                this.stub2._setProperty("javax.xml.rpc.service.endpoint.address", (Object)this.url2);
            } else {
                this.getStub();
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("setup failed:", e);
        }
        if (!pass) {
            TestUtil.logErr((String)"Please specify host & port of web server in config properties: webServerHost, webServerPort");
            throw new EETest.Fault("setup failed:");
        }
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public void multiserviceTest() throws EETest.Fault {
        TestUtil.logTrace((String)"multiserviceTest");
        boolean pass = true;
        TestUtil.logMsg((String)"Invoking method on service 1 ...");
        if (this.multiservice1Test()) {
            TestUtil.logMsg((String)"service 1 test PASSED ...");
        } else {
            pass = false;
            TestUtil.logErr((String)"service 1 test FAILED ...");
        }
        TestUtil.logMsg((String)"Invoking method on service 2 ...");
        if (this.multiservice2Test()) {
            TestUtil.logMsg((String)"service 2 test PASSED ...");
        } else {
            pass = false;
            TestUtil.logErr((String)"service 2 test FAILED ...");
        }
        if (!pass) {
            throw new EETest.Fault("multiserviceTest failed");
        }
    }

    private boolean multiservice1Test() throws EETest.Fault {
        TestUtil.logTrace((String)"multiservice1Test");
        boolean pass = true;
        String exp = "service1:interface1:hello, world";
        try {
            String rec = this.port1.hello1("hello, world");
            TestUtil.logMsg((String)("Invoking RPC method port1.hello1(\"hello, world\")=" + rec));
            if (rec.equals(exp)) {
                TestUtil.logMsg((String)("Result match - " + exp));
            } else {
                TestUtil.logErr((String)("Result mismatch - expected: " + exp + ", received: " + rec));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        return pass;
    }

    private boolean multiservice2Test() throws EETest.Fault {
        TestUtil.logTrace((String)"multiservice2Test");
        boolean pass = true;
        String exp = "service2:interface1:hello, world";
        try {
            String rec = this.port2.hello2("hello, world");
            TestUtil.logMsg((String)("Invoking RPC method port2.hello2(\"hello, world\")=" + rec));
            if (rec.equals(exp)) {
                TestUtil.logMsg((String)("Result match - " + exp));
            } else {
                TestUtil.logErr((String)("Result mismatch - expected: " + exp + ", received: " + rec));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        return pass;
    }
}

