/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxr.api.javax_xml_registry_infomodel.Organization;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxr.common.JAXRCommonClient;
import com.sun.ts.tests.jaxr.common.JAXR_Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.BusinessQueryManager;
import javax.xml.registry.UnsupportedCapabilityException;
import javax.xml.registry.infomodel.InternationalString;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.PersonName;
import javax.xml.registry.infomodel.PostalAddress;
import javax.xml.registry.infomodel.Service;
import javax.xml.registry.infomodel.TelephoneNumber;
import javax.xml.registry.infomodel.User;

public class JAXRClient
extends JAXRCommonClient {
    Locale tsLocale = new Locale("en", "US");

    public static void main(String[] args) {
        JAXRClient theTests = new JAXRClient();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            super.setup(args, p);
            this.debug.clear();
        }
        catch (Exception e) {
            throw new EETest.Fault("setup failed:", e);
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        try {
            super.cleanup();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Cleanup error: " + e.toString()));
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            if (this.debug != null) {
                TestUtil.logTrace((String)this.debug.toString());
            }
        }
    }

    public void organization_addChildOrganization_Test() throws EETest.Fault {
        int failcount;
        boolean pass;
        String testName;
        block10: {
            boolean index = false;
            testName = "organization_addChildOrganization_Test";
            pass = false;
            String orgName = "TS Default Organization";
            String childOrgName = "TS Test Child Organization";
            Organization childOrg = null;
            failcount = 0;
            try {
                int providerlevel = this.rs.getCapabilityProfile().getCapabilityLevel();
                InternationalString iorgName = this.blm.createInternationalString(this.tsLocale, orgName);
                Organization org = this.blm.createOrganization(iorgName);
                try {
                    InternationalString ichildOrgName = this.blm.createInternationalString(this.tsLocale, childOrgName);
                    childOrg = this.blm.createOrganization(ichildOrgName);
                    org.addChildOrganization(childOrg);
                    this.debug.add("Level 0 providers should not get here!\n");
                    if (providerlevel <= 0) {
                        this.debug.add("Error: expected addChildOrganization to throw UnsupportedCapabilityException \n");
                        ++failcount;
                    }
                    this.debug.add("Added one child organization,  verify the collection size\n");
                    this.debug.add("count of child orgs is " + org.getChildOrganizations().size() + "\n");
                    if (org.getChildOrganizations().size() != 1) {
                        ++failcount;
                        this.debug.add("count of child orgs is not valid \n");
                    }
                }
                catch (UnsupportedCapabilityException uc) {
                    TestUtil.printStackTrace((Throwable)uc);
                    if (providerlevel == 0) {
                        this.debug.add("Success! addChildOrganization threw UnsupportedCapabilityException as expected\n");
                        break block10;
                    }
                    this.debug.add("Error: UnsupportedCapabilityException not expected for this provider\n");
                    ++failcount;
                }
                catch (Exception e0) {
                    TestUtil.printStackTrace((Throwable)e0);
                    ++failcount;
                    this.debug.add("Error: addChildOrganization threw an unexpected exception \n");
                    this.debug.add("Exception: " + e0.toString() + "\n");
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
                TestUtil.printStackTrace((Throwable)e);
                pass = false;
            }
        }
        if (failcount == 0) {
            pass = true;
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void organization_add_removeChildOrganizations_Test() throws EETest.Fault {
        int failcount;
        boolean pass;
        String testName;
        block17: {
            testName = "organization_add_removeChildOrganizations_Test";
            pass = false;
            String orgName = "TS Default Organization";
            String childOrgName1 = "TS Test Child Organization1";
            String childOrgName2 = "TS Test Child Organization2";
            ArrayList<Organization> myChildOrgs = null;
            failcount = 0;
            try {
                int providerlevel = this.rs.getCapabilityProfile().getCapabilityLevel();
                InternationalString iorgName = this.blm.createInternationalString(this.tsLocale, orgName);
                Organization org = this.blm.createOrganization(iorgName);
                try {
                    InternationalString ichildOrgName1 = this.blm.createInternationalString(this.tsLocale, childOrgName1);
                    InternationalString ichildOrgName2 = this.blm.createInternationalString(this.tsLocale, childOrgName2);
                    Organization childOrg1 = this.blm.createOrganization(ichildOrgName1);
                    Organization childOrg2 = this.blm.createOrganization(ichildOrgName2);
                    myChildOrgs = new ArrayList<Organization>();
                    myChildOrgs.add(childOrg1);
                    myChildOrgs.add(childOrg2);
                    org.addChildOrganizations(myChildOrgs);
                    this.debug.add("Level 0 providers should not get here!\n");
                    if (providerlevel <= 0) {
                        this.debug.add("Error: expected addChildOrganization to throw UnsupportedCapabilityException \n");
                        ++failcount;
                    }
                    this.debug.add("Added 2 child organizations,  verify the collection size\n");
                    this.debug.add("count of child orgs is " + org.getChildOrganizations().size() + "\n");
                    if (org.getChildOrganizations().size() != 2) {
                        ++failcount;
                        this.debug.add("count of child orgs is not valid \n");
                    }
                }
                catch (UnsupportedCapabilityException uc) {
                    TestUtil.printStackTrace((Throwable)uc);
                    if (providerlevel == 0) {
                        this.debug.add("Success! addChildOrganization threw UnsupportedCapabilityException as expected\n");
                    } else {
                        this.debug.add("Error: UnsupportedCapabilityException not expected for this provider\n");
                        ++failcount;
                    }
                }
                catch (Exception e0) {
                    TestUtil.printStackTrace((Throwable)e0);
                    ++failcount;
                    this.debug.add("Error: addChildOrganization threw an unexpected exception \n");
                    this.debug.add("Exception: " + e0.toString() + "\n");
                }
                try {
                    org.removeChildOrganizations(myChildOrgs);
                    this.debug.add("Level 0 providers should not get here!\n");
                    if (providerlevel <= 0) {
                        this.debug.add("Error: expected removeChildOrganizations to throw UnsupportedCapabilityException \n");
                        ++failcount;
                    }
                    this.debug.add("Removed child organizations,  verify the collection size\n");
                    this.debug.add("count of child orgs is " + org.getChildOrganizations().size() + "\n");
                    if (org.getChildOrganizations().size() != 0) {
                        ++failcount;
                        this.debug.add("count of child orgs is not valid \n");
                    }
                }
                catch (UnsupportedCapabilityException uc) {
                    TestUtil.printStackTrace((Throwable)uc);
                    if (providerlevel == 0) {
                        this.debug.add("Success! removeChildOrganizations threw UnsupportedCapabilityException as expected\n");
                        break block17;
                    }
                    this.debug.add("Error: UnsupportedCapabilityException not expected for this provider\n");
                    ++failcount;
                }
                catch (Exception e0) {
                    TestUtil.printStackTrace((Throwable)e0);
                    ++failcount;
                    this.debug.add("Error: removeChildOrganizations threw an unexpected exception \n");
                    this.debug.add("Exception: " + e0.toString() + "\n");
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
                TestUtil.printStackTrace((Throwable)e);
                pass = false;
            }
        }
        if (failcount == 0) {
            pass = true;
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void organization_add_getService_Test() throws EETest.Fault {
        String testName = "organization_add_getService_Test";
        boolean pass = false;
        String orgName = "TS Default Organization";
        String serviceName = "TS Test Service organization_addService_Test";
        try {
            this.debug.add("Adding service name: " + serviceName + " to test organization \n");
            InternationalString iorgName = this.blm.createInternationalString(this.tsLocale, orgName);
            Organization org = this.blm.createOrganization(iorgName);
            Service myService = this.blm.createService(this.blm.createInternationalString(this.tsLocale, serviceName));
            org.addService(myService);
            Service retService2 = null;
            Collection services = org.getServices();
            for (Service retService2 : services) {
                this.debug.add("Retrieved service name: " + retService2.getName().getValue(this.tsLocale) + " from organization\n");
                if (!retService2.getName().getValue(this.tsLocale).equals(serviceName)) continue;
                pass = true;
                break;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void organization_addServices_Test() throws EETest.Fault {
        String testName = "organization_addServices_Test";
        boolean pass = false;
        String orgName = "TS Default Organization";
        String serviceName1 = "TS Test Service1 organization_addService_Test";
        String serviceName2 = "TS Test Service2 organization_addService_Test";
        try {
            this.debug.add("Adding service name: " + serviceName1 + " to test organization \n");
            this.debug.add("Adding service name: " + serviceName2 + " to test organization \n");
            ArrayList<String> myServiceNames = new ArrayList<String>();
            myServiceNames.add(serviceName1);
            myServiceNames.add(serviceName2);
            InternationalString iorgName = this.blm.createInternationalString(this.tsLocale, orgName);
            Organization org = this.blm.createOrganization(iorgName);
            ArrayList<Service> services = new ArrayList<Service>();
            services.add(this.blm.createService(this.blm.createInternationalString(this.tsLocale, serviceName1)));
            services.add(this.blm.createService(this.blm.createInternationalString(this.tsLocale, serviceName2)));
            org.addServices(services);
            Service retService = null;
            Collection retServices = org.getServices();
            Iterator iter = retServices.iterator();
            int passcount = 0;
            while (iter.hasNext()) {
                retService = (Service)iter.next();
                this.debug.add("Retrieved service name: " + retService.getName().getValue(this.tsLocale) + " from organization\n");
                if (myServiceNames.contains(retService.getName().getValue(this.tsLocale))) {
                    ++passcount;
                    this.debug.add("Found expected service, name is: " + retService.getName().getValue(this.tsLocale) + "\n");
                    continue;
                }
                this.debug.add("Found service, name is: " + retService.getName().getValue(this.tsLocale) + "\n");
            }
            if (passcount == retServices.size()) {
                pass = true;
            } else {
                this.debug.add("Something is not right: ");
                this.debug.add("Found " + retServices.size() + " services");
                this.debug.add("Found " + passcount + " services passed");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void organization_set_getPrimaryContact() throws EETest.Fault {
        String testName = "organization_set_getPrimaryContact";
        boolean pass = false;
        String orgName = "TS Default Organization";
        String userName1 = "TS Test Primary Contact";
        try {
            InternationalString iorgName = this.blm.createInternationalString(this.tsLocale, orgName);
            Organization org = this.blm.createOrganization(iorgName);
            User primaryContactUser = this.blm.createUser();
            PersonName primaryPersonName = this.blm.createPersonName(userName1);
            this.debug.add("Created PersonName for primary contact.  Name: " + userName1 + "\n");
            User user = this.blm.createUser();
            user.setPersonName(primaryPersonName);
            this.debug.add("Added person name to user. Name: " + user.getPersonName().getFullName() + "\n");
            org.setPrimaryContact(user);
            this.debug.add("getPrimaryContact returned " + org.getPrimaryContact().getPersonName().getFullName() + "\n");
            if (org.getPrimaryContact().getPersonName().getFullName().equals(userName1)) {
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void organization_set_getTelephoneNumbers() throws EETest.Fault {
        String testName = "organization_set_getTelephoneNumbers";
        String orgName = "TS Default Organization";
        String number1 = "111-1234";
        String number2 = "222-1234";
        String number3 = "333-1234";
        try {
            InternationalString iorgName = this.blm.createInternationalString(this.tsLocale, orgName);
            Organization org = this.blm.createOrganization(iorgName);
            ArrayList<String> numbers = new ArrayList<String>();
            numbers.add(number1);
            numbers.add(number2);
            numbers.add(number3);
            TelephoneNumber tn1 = this.blm.createTelephoneNumber();
            TelephoneNumber tn2 = this.blm.createTelephoneNumber();
            TelephoneNumber tn3 = this.blm.createTelephoneNumber();
            tn1.setNumber(number1);
            tn2.setNumber(number2);
            tn3.setNumber(number3);
            ArrayList<TelephoneNumber> phoneNumbers = new ArrayList<TelephoneNumber>();
            phoneNumbers.add(tn1);
            phoneNumbers.add(tn2);
            phoneNumbers.add(tn3);
            org.setTelephoneNumbers(phoneNumbers);
            this.debug.add("get all telephone numbers \n");
            Collection retNumbers = org.getTelephoneNumbers(null);
            Iterator iter = retNumbers.iterator();
            TelephoneNumber number = null;
            while (iter.hasNext()) {
                number = (TelephoneNumber)iter.next();
                this.debug.add("Retrieved this number: " + number.getNumber() + "\n");
                if (!numbers.contains(number.getNumber())) {
                    throw new EETest.Fault(testName + " failed ");
                }
                this.debug.add("Found number in my number list!\n");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            super.cleanUpRegistry(orgName);
        }
    }

    public void organization_set_getUsers() throws EETest.Fault {
        String testName = "organization_set_getUsers";
        boolean pass = false;
        String orgName = "TS Default Organization";
        String userName1 = "TS Test Primary Contact";
        User user2 = null;
        PersonName person = null;
        int count = 6;
        try {
            ArrayList<String> userNames = new ArrayList<String>();
            for (int i = 0; i < count; ++i) {
                userNames.add("TS Test Person" + i);
            }
            Collection users = new ArrayList<User>();
            this.debug.add("Setting up collection of users \n");
            Iterator iter = userNames.iterator();
            while (iter.hasNext()) {
                user2 = this.blm.createUser();
                person = this.blm.createPersonName((String)iter.next());
                user2.setPersonName(person);
                users.add(user2);
                this.debug.add("Adding this person to user collection: " + user2.getPersonName().getFullName() + "\n");
            }
            InternationalString iorgName = this.blm.createInternationalString(this.tsLocale, orgName);
            Organization org = this.blm.createOrganization(iorgName);
            this.debug.add("Invoke addUsers on organization \n");
            org.addUsers(users);
            this.debug.add("getUsers and verify users returned from the organization \n");
            users.clear();
            users = org.getUsers();
            int passcount = 0;
            for (User user2 : users) {
                this.debug.add("Found user: " + user2.getPersonName().getFullName() + "\n");
                if (!userNames.contains(user2.getPersonName().getFullName())) continue;
                ++passcount;
            }
            if (passcount == userNames.size()) {
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void organization_removeService_Test() throws EETest.Fault {
        String testName = "organization_removeService_Test";
        boolean pass = false;
        boolean found = false;
        String orgName = "TS Default Organization";
        String serviceName = "TS Test Service organization_removeService_Test";
        String serviceName1 = "TS Test Service organization_removeService_Test1";
        try {
            this.debug.add("\nAdding following services: \n");
            this.debug.add("                " + serviceName + "  \n");
            this.debug.add("                " + serviceName1 + " \n");
            InternationalString iorgName = this.blm.createInternationalString(this.tsLocale, orgName);
            Organization org = this.blm.createOrganization(iorgName);
            Service myService = this.blm.createService(this.blm.createInternationalString(this.tsLocale, serviceName));
            Service anotherService = this.blm.createService(this.blm.createInternationalString(this.tsLocale, serviceName1));
            org.addService(myService);
            org.addService(anotherService);
            Service retService2 = null;
            Collection services = org.getServices();
            for (Service retService2 : services) {
                this.debug.add("Retrieved service name: " + retService2.getName().getValue(this.tsLocale) + " from organization\n");
                if (!retService2.getName().getValue(this.tsLocale).equals(serviceName)) continue;
                found = true;
            }
            if (!found) {
                throw new EETest.Fault(testName + "Error: failed to find added service - test did not complete!");
            }
            this.debug.add("Added and verified service.  Will now remove the service");
            org.removeService(myService);
            this.debug.add("Verify that one service has been removed\n");
            services.clear();
            retService2 = null;
            services = org.getServices();
            found = false;
            if (services.size() > 0) {
                for (Service retService2 : services) {
                    this.debug.add("Retrieved service name: " + retService2.getName().getValue(this.tsLocale) + " from organization\n");
                    if (!retService2.getName().getValue(this.tsLocale).equals(serviceName)) continue;
                    found = true;
                    break;
                }
            }
            if (!found) {
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void organization_removeServices_Test() throws EETest.Fault {
        String testName = "organization_removeServices_Test";
        boolean pass = false;
        boolean found = false;
        String orgName = "TS Default Organization";
        String serviceName = "TS Test Service organization_removeService_Test";
        String serviceName1 = "TS Test Service organization_removeService_Test1";
        try {
            this.debug.add("\nAdding following services: \n");
            this.debug.add("                " + serviceName + "  \n");
            this.debug.add("                " + serviceName1 + " \n");
            InternationalString iorgName = this.blm.createInternationalString(this.tsLocale, orgName);
            Organization org = this.blm.createOrganization(iorgName);
            Service myService = this.blm.createService(this.blm.createInternationalString(this.tsLocale, serviceName));
            Service anotherService = this.blm.createService(this.blm.createInternationalString(this.tsLocale, serviceName1));
            ArrayList<String> myServiceNames = new ArrayList<String>();
            myServiceNames.add(serviceName);
            myServiceNames.add(serviceName1);
            ArrayList<Service> ctsServices = new ArrayList<Service>();
            ctsServices.add(myService);
            ctsServices.add(anotherService);
            org.addServices(ctsServices);
            Service retService2 = null;
            Collection services = org.getServices();
            Iterator iter = services.iterator();
            int passcount = 0;
            while (iter.hasNext()) {
                retService2 = (Service)iter.next();
                this.debug.add("Retrieved service name: " + retService2.getName().getValue(this.tsLocale) + " from organization\n");
                if (!myServiceNames.contains(retService2.getName().getValue(this.tsLocale))) continue;
                ++passcount;
            }
            if (passcount != myServiceNames.size()) {
                throw new EETest.Fault(testName + "Error test did not complete !");
            }
            this.debug.add("Added and verified services   Will now remove the services");
            org.removeServices(ctsServices);
            this.debug.add("Verify that both services has been removed\n");
            services.clear();
            retService2 = null;
            services = org.getServices();
            found = false;
            if (services.size() > 0) {
                for (Service retService2 : services) {
                    this.debug.add("Retrieved service name: " + retService2.getName().getValue(this.tsLocale) + " from organization\n");
                    if (!myServiceNames.contains(retService2.getName().getValue(this.tsLocale))) continue;
                    found = true;
                }
            }
            if (!found) {
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void organization_getChildOrganizationCount_Test() throws EETest.Fault {
        int failcount;
        boolean pass;
        String testName;
        block11: {
            testName = "organization_getChildOrganizationCount_Test";
            pass = false;
            String orgName = "TS Default Organization";
            failcount = 0;
            try {
                int providerlevel = this.rs.getCapabilityProfile().getCapabilityLevel();
                InternationalString iorgName = this.blm.createInternationalString(this.tsLocale, orgName);
                Organization org = this.blm.createOrganization(iorgName);
                try {
                    int childCount = org.getChildOrganizationCount();
                    this.debug.add("Level 0 providers should not get here!\n");
                    if (providerlevel <= 0) {
                        this.debug.add("Error: expected removeChildOrganization to throw UnsupportedCapabilityException \n");
                        ++failcount;
                    }
                    this.debug.add("No children were added \n");
                    this.debug.add("Child count is: " + childCount + "\n");
                    if (childCount != 0) {
                        ++failcount;
                    }
                    String childOrgName1 = "TS Test Child Organization1";
                    String childOrgName2 = "TS Test Child Organization2";
                    InternationalString ichildOrgName1 = this.blm.createInternationalString(this.tsLocale, childOrgName1);
                    InternationalString ichildOrgName2 = this.blm.createInternationalString(this.tsLocale, childOrgName2);
                    Organization childOrg1 = this.blm.createOrganization(ichildOrgName1);
                    Organization childOrg2 = this.blm.createOrganization(ichildOrgName2);
                    ArrayList<Organization> myChildOrgs = new ArrayList<Organization>();
                    myChildOrgs.add(childOrg1);
                    myChildOrgs.add(childOrg2);
                    org.addChildOrganizations(myChildOrgs);
                    this.debug.add("Two children were added \n");
                    this.debug.add("Child count is: " + org.getChildOrganizationCount() + "\n");
                    if (org.getChildOrganizationCount() != 2) {
                        ++failcount;
                        this.debug.add("count of child orgs is not valid \n");
                    }
                }
                catch (UnsupportedCapabilityException uc) {
                    TestUtil.printStackTrace((Throwable)uc);
                    if (providerlevel == 0) {
                        this.debug.add("Success! removeChildOrganization threw UnsupportedCapabilityException as expected\n");
                        break block11;
                    }
                    this.debug.add("Error: UnsupportedCapabilityException not expected for this provider\n");
                    ++failcount;
                }
                catch (Exception e0) {
                    TestUtil.printStackTrace((Throwable)e0);
                    ++failcount;
                    this.debug.add("Error: removeChildOrganization threw an unexpected exception \n");
                    this.debug.add("Exception: " + e0.toString() + "\n");
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
                TestUtil.printStackTrace((Throwable)e);
                pass = false;
            }
        }
        if (failcount == 0) {
            pass = true;
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void organization_getChildOrganizations_Test() throws EETest.Fault {
        int failcount;
        boolean pass;
        String testName;
        block10: {
            testName = "organization_getChildOrganizations_Test";
            pass = false;
            String orgName = "TS Default Organization";
            failcount = 0;
            try {
                int providerlevel = this.rs.getCapabilityProfile().getCapabilityLevel();
                InternationalString iorgName = this.blm.createInternationalString(this.tsLocale, orgName);
                Organization org = this.blm.createOrganization(iorgName);
                try {
                    Collection children = org.getChildOrganizations();
                    this.debug.add("Level 0 providers should not get here!\n");
                    if (providerlevel <= 0) {
                        this.debug.add("Error: expected removeChildOrganization to throw UnsupportedCapabilityException \n");
                        ++failcount;
                    }
                    this.debug.add("count of child orgs is " + org.getChildOrganizations().size() + "\n");
                    if (org.getChildOrganizations().size() != 0) {
                        ++failcount;
                        this.debug.add("count of child orgs is not valid \n");
                    }
                }
                catch (UnsupportedCapabilityException uc) {
                    TestUtil.printStackTrace((Throwable)uc);
                    if (providerlevel == 0) {
                        this.debug.add("Success! removeChildOrganization threw UnsupportedCapabilityException as expected\n");
                        break block10;
                    }
                    this.debug.add("Error: UnsupportedCapabilityException not expected for this provider\n");
                    ++failcount;
                }
                catch (Exception e0) {
                    TestUtil.printStackTrace((Throwable)e0);
                    ++failcount;
                    this.debug.add("Error: removeChildOrganization threw an unexpected exception \n");
                    this.debug.add("Exception: " + e0.toString() + "\n");
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
                TestUtil.printStackTrace((Throwable)e);
                pass = false;
            }
        }
        if (failcount == 0) {
            pass = true;
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void removeChildOrganization_Test() throws EETest.Fault {
        int failcount;
        boolean pass;
        String testName;
        block11: {
            testName = "removeChildOrganization_Test";
            pass = false;
            String orgName = "TS Default Organization";
            String childOrgName = "TS Test Child Organization";
            Organization childOrg = null;
            failcount = 0;
            try {
                int providerlevel = this.rs.getCapabilityProfile().getCapabilityLevel();
                InternationalString iorgName = this.blm.createInternationalString(this.tsLocale, orgName);
                Organization org = this.blm.createOrganization(iorgName);
                try {
                    InternationalString ichildOrgName = this.blm.createInternationalString(this.tsLocale, childOrgName);
                    childOrg = this.blm.createOrganization(ichildOrgName);
                    org.removeChildOrganization(childOrg);
                    this.debug.add("Level 0 providers should not get here!\n");
                    if (providerlevel <= 0) {
                        this.debug.add("Error: expected removeChildOrganization to throw UnsupportedCapabilityException \n");
                        ++failcount;
                    }
                    childOrg = this.blm.createOrganization(ichildOrgName);
                    org.addChildOrganization(childOrg);
                    this.debug.add("Added one child organization,  verify the collection size\n");
                    this.debug.add("count of child orgs is " + org.getChildOrganizations().size() + "\n");
                    if (org.getChildOrganizations().size() != 1) {
                        ++failcount;
                        this.debug.add("count of child orgs is not valid \n");
                    }
                    org.removeChildOrganization(childOrg);
                    this.debug.add("Removed the one child organization,  verify the collection size\n");
                    this.debug.add("count of child orgs is " + org.getChildOrganizations().size() + "\n");
                    if (org.getChildOrganizations().size() != 0) {
                        ++failcount;
                        this.debug.add("count of child orgs is not valid \n");
                    }
                }
                catch (UnsupportedCapabilityException uc) {
                    TestUtil.printStackTrace((Throwable)uc);
                    if (providerlevel == 0) {
                        this.debug.add("Success! removeChildOrganization threw UnsupportedCapabilityException as expected\n");
                        break block11;
                    }
                    this.debug.add("Error: UnsupportedCapabilityException not expected for this provider\n");
                    ++failcount;
                }
                catch (Exception e0) {
                    TestUtil.printStackTrace((Throwable)e0);
                    ++failcount;
                    this.debug.add("Error: removeChildOrganization threw an unexpected exception \n");
                    this.debug.add("Exception: " + e0.toString() + "\n");
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
                TestUtil.printStackTrace((Throwable)e);
                pass = false;
            }
        }
        if (failcount == 0) {
            pass = true;
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void organization_getDescendantOrganizations_Test() throws EETest.Fault {
        int failcount;
        boolean pass;
        String testName;
        block11: {
            testName = "organization_getDescendantOrganizations_Test";
            pass = false;
            String orgName = "TS Default Organization";
            failcount = 0;
            try {
                int providerlevel = this.rs.getCapabilityProfile().getCapabilityLevel();
                InternationalString iorgName = this.blm.createInternationalString(this.tsLocale, orgName);
                Organization org = this.blm.createOrganization(iorgName);
                try {
                    Collection descendants = org.getDescendantOrganizations();
                    this.debug.add("Level 0 providers should not get here!\n");
                    if (providerlevel <= 0) {
                        this.debug.add("Error: expected removeChildOrganization to throw UnsupportedCapabilityException \n");
                        ++failcount;
                    }
                    this.debug.add("no descendants yet - getDescendantOrganizations size should be 0 \n");
                    this.debug.add("descendants.size() is: " + descendants.size() + "\n");
                    if (descendants.size() != 0) {
                        ++failcount;
                        this.debug.add("count of descendant orgs is not valid \n");
                    }
                    String childOrgName = testName + "_childOrganization";
                    InternationalString ichildOrgName = this.blm.createInternationalString(this.tsLocale, childOrgName);
                    Organization childOrg = this.blm.createOrganization(ichildOrgName);
                    org.addChildOrganization(childOrg);
                    this.debug.add("Added a child organization, call org.getDescendantOrganizations\n");
                    Collection mydescendants = org.getDescendantOrganizations();
                    this.debug.add("now there is a descendant - getDescendantOrganizations size should be 1  \n");
                    this.debug.add("descendants.size() is: " + mydescendants.size() + "\n");
                    if (mydescendants.size() != 1) {
                        ++failcount;
                        this.debug.add("count of descendant orgs is not valid \n");
                    }
                }
                catch (UnsupportedCapabilityException uc) {
                    TestUtil.printStackTrace((Throwable)uc);
                    if (providerlevel == 0) {
                        this.debug.add("Success! removeChildOrganization threw UnsupportedCapabilityException as expected\n");
                        break block11;
                    }
                    this.debug.add("Error: UnsupportedCapabilityException not expected for this provider\n");
                    ++failcount;
                }
                catch (Exception e0) {
                    TestUtil.printStackTrace((Throwable)e0);
                    ++failcount;
                    this.debug.add("Error: removeChildOrganization threw an unexpected exception \n");
                    this.debug.add("Exception: " + e0.toString() + "\n");
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
                TestUtil.printStackTrace((Throwable)e);
                pass = false;
            }
        }
        if (failcount == 0) {
            pass = true;
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void organization_getParentOrganization_Test() throws EETest.Fault {
        int failcount;
        boolean pass;
        String testName;
        block13: {
            testName = "organization_getParentOrganization_Test";
            pass = false;
            String orgName = "TS Default Organization";
            failcount = 0;
            try {
                int providerlevel = this.rs.getCapabilityProfile().getCapabilityLevel();
                InternationalString iorgName = this.blm.createInternationalString(this.tsLocale, orgName);
                Organization org = this.blm.createOrganization(iorgName);
                try {
                    Organization parent = org.getParentOrganization();
                    this.debug.add("Level 0 providers should not get here!\n");
                    if (providerlevel <= 0) {
                        this.debug.add("Error: expected removeChildOrganization to throw UnsupportedCapabilityException \n");
                        ++failcount;
                    }
                    if (parent != null) {
                        this.debug.add("Error - there is no parent, so parent org returned should be null \n");
                        ++failcount;
                    } else {
                        this.debug.add("org.getParentOrganization() returned null as expected \n");
                    }
                    String parentName = testName + "_ParentOrganization";
                    InternationalString iname = this.blm.createInternationalString(this.tsLocale, parentName);
                    Organization theParentOrg = this.blm.createOrganization(iname);
                    theParentOrg.addChildOrganization(org);
                    Organization myParentOrg = org.getParentOrganization();
                    if (myParentOrg == null) {
                        this.debug.add("Error - there is a parent, so parent org returned should not be null \n");
                        ++failcount;
                        break block13;
                    }
                    if (myParentOrg.getKey().getId().equals(theParentOrg.getKey().getId())) {
                        this.debug.add("Verified the parent org returned - success \n");
                        break block13;
                    }
                    this.debug.add("Error - parent key does not match returned parent key \n");
                    ++failcount;
                }
                catch (UnsupportedCapabilityException uc) {
                    TestUtil.printStackTrace((Throwable)uc);
                    if (providerlevel == 0) {
                        this.debug.add("Success! removeChildOrganization threw UnsupportedCapabilityException as expected\n");
                        break block13;
                    }
                    this.debug.add("Error: UnsupportedCapabilityException not expected for this provider\n");
                    ++failcount;
                }
                catch (Exception e0) {
                    TestUtil.printStackTrace((Throwable)e0);
                    ++failcount;
                    this.debug.add("Error: removeChildOrganization threw an unexpected exception \n");
                    this.debug.add("Exception: " + e0.toString() + "\n");
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
                TestUtil.printStackTrace((Throwable)e);
                pass = false;
            }
        }
        if (failcount == 0) {
            pass = true;
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void organization_getPostalAddress_Test() throws EETest.Fault {
        int failcount;
        boolean pass;
        String testName;
        block9: {
            testName = "organization_getPostalAddress_Test";
            pass = false;
            String orgName = "TS Default Organization";
            failcount = 0;
            try {
                int providerlevel = this.rs.getCapabilityProfile().getCapabilityLevel();
                InternationalString iorgName = this.blm.createInternationalString(this.tsLocale, orgName);
                Organization org = this.blm.createOrganization(iorgName);
                try {
                    PostalAddress pa = org.getPostalAddress();
                    this.debug.add("Level 0 providers should not get here!\n");
                    if (providerlevel <= 0) {
                        this.debug.add("Error: expected removeChildOrganization to throw UnsupportedCapabilityException \n");
                        ++failcount;
                    }
                }
                catch (UnsupportedCapabilityException uc) {
                    TestUtil.printStackTrace((Throwable)uc);
                    if (providerlevel == 0) {
                        this.debug.add("Success! removeChildOrganization threw UnsupportedCapabilityException as expected\n");
                        break block9;
                    }
                    this.debug.add("Error: UnsupportedCapabilityException not expected for this provider\n");
                    ++failcount;
                }
                catch (Exception e0) {
                    TestUtil.printStackTrace((Throwable)e0);
                    ++failcount;
                    this.debug.add("Error: removeChildOrganization threw an unexpected exception \n");
                    this.debug.add("Exception: " + e0.toString() + "\n");
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
                TestUtil.printStackTrace((Throwable)e);
                pass = false;
            }
        }
        if (failcount == 0) {
            pass = true;
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void organization_setPostalAddress_Test() throws EETest.Fault {
        int failcount;
        boolean pass;
        String testName;
        block16: {
            testName = "organization_setPostalAddress_Test";
            pass = false;
            String orgName = "TS Default Organization";
            String streetNumber = "1";
            String street = "Amsden";
            String city = "Arlington";
            String stateOrProvince = "MA";
            String country = "US";
            String postalCode = "02174";
            String type = "homebase";
            failcount = 0;
            try {
                int providerlevel = this.rs.getCapabilityProfile().getCapabilityLevel();
                InternationalString iorgName = this.blm.createInternationalString(this.tsLocale, orgName);
                Organization org = this.blm.createOrganization(iorgName);
                try {
                    PostalAddress pa = this.blm.createPostalAddress(streetNumber, street, city, stateOrProvince, country, postalCode, type);
                    org.setPostalAddress(pa);
                    this.debug.add("Level 0 providers should not get here!\n");
                    if (providerlevel <= 0) {
                        this.debug.add("Error: expected removeChildOrganization to throw UnsupportedCapabilityException \n");
                        ++failcount;
                    }
                    PostalAddress retPa = org.getPostalAddress();
                    this.debug.add("Verify postal address \n");
                    this.debug.add("StreetNumber: " + retPa.getStreetNumber() + "\n");
                    if (!retPa.getStreetNumber().equals(streetNumber)) {
                        this.debug.add("incorrect street number \n");
                        ++failcount;
                    }
                    this.debug.add("Street : " + retPa.getStreet() + "\n");
                    if (!retPa.getStreet().equals(street)) {
                        this.debug.add("incorrect street \n");
                        ++failcount;
                    }
                    this.debug.add("city: " + retPa.getCity() + "\n");
                    if (!retPa.getCity().equals(city)) {
                        this.debug.add("incorrect city\n");
                        ++failcount;
                    }
                    this.debug.add("stateorprovince: " + retPa.getStateOrProvince() + "\n");
                    if (!retPa.getStateOrProvince().equals(stateOrProvince)) {
                        this.debug.add("incorrect stateOrProvince\n");
                        ++failcount;
                    }
                    this.debug.add("country: " + retPa.getCountry() + "\n");
                    if (!retPa.getCountry().equals(country)) {
                        this.debug.add("incorrect country\n");
                        ++failcount;
                    }
                    this.debug.add("postalCode: " + retPa.getPostalCode() + "\n");
                    if (!retPa.getPostalCode().equals(postalCode)) {
                        this.debug.add("incorrect postal code\n");
                        ++failcount;
                    }
                    this.debug.add("type: " + retPa.getType() + "\n");
                    if (!retPa.getType().equals(type)) {
                        this.debug.add("incorrect type code\n");
                        ++failcount;
                    }
                }
                catch (UnsupportedCapabilityException uc) {
                    TestUtil.printStackTrace((Throwable)uc);
                    if (providerlevel == 0) {
                        this.debug.add("Success! removeChildOrganization threw UnsupportedCapabilityException as expected\n");
                        break block16;
                    }
                    this.debug.add("Error: UnsupportedCapabilityException not expected for this provider\n");
                    ++failcount;
                }
                catch (Exception e0) {
                    TestUtil.printStackTrace((Throwable)e0);
                    ++failcount;
                    this.debug.add("Error: removeChildOrganization threw an unexpected exception \n");
                    this.debug.add("Exception: " + e0.toString() + "\n");
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
                TestUtil.printStackTrace((Throwable)e);
                pass = false;
            }
        }
        if (failcount == 0) {
            pass = true;
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void organization_getRootOrganization_Test() throws EETest.Fault {
        int failcount;
        boolean pass;
        String testName;
        block15: {
            testName = "organization_getRootOrganization_Test";
            pass = false;
            String orgName = "TS Default Organization";
            failcount = 0;
            String childOrgName = testName + "_ChildOrganization";
            try {
                int providerlevel = this.rs.getCapabilityProfile().getCapabilityLevel();
                InternationalString iorgName = this.blm.createInternationalString(this.tsLocale, orgName);
                Organization org = this.blm.createOrganization(iorgName);
                try {
                    Organization root = org.getRootOrganization();
                    this.debug.add("Level 0 providers should not get here!\n");
                    if (providerlevel <= 0) {
                        this.debug.add("Error: expected removeChildOrganization to throw UnsupportedCapabilityException \n");
                        ++failcount;
                    }
                    if (root != null) {
                        if (org.getKey().getId().equals(root.getKey().getId())) {
                            this.debug.add(" Good - root id was verified \n");
                        }
                    } else {
                        ++failcount;
                        this.debug.add(" root should be the highest level node. In this case, \n");
                        this.debug.add(" it should be the org itself,  since there is no parent \n");
                    }
                    InternationalString ichildOrgName = this.blm.createInternationalString(this.tsLocale, childOrgName);
                    Organization childOrg = this.blm.createOrganization(ichildOrgName);
                    org.addChildOrganization(childOrg);
                    this.debug.add("Added a child organization, call getRootOrganization on the child \n");
                    Organization myRoot = childOrg.getRootOrganization();
                    if (root != null) {
                        this.debug.add(" root is not null.  There is a parent.  This is expected  \n");
                        if (org.getKey().getId().equals(myRoot.getKey().getId())) {
                            this.debug.add(" Good - root id was verified \n");
                        } else {
                            this.debug.add(" Error - root id was not verifier \n");
                            ++failcount;
                        }
                        break block15;
                    }
                    ++failcount;
                    this.debug.add(" root is null - this is an error\n");
                }
                catch (UnsupportedCapabilityException uc) {
                    TestUtil.printStackTrace((Throwable)uc);
                    if (providerlevel == 0) {
                        this.debug.add("Success! removeChildOrganization threw UnsupportedCapabilityException as expected\n");
                        break block15;
                    }
                    this.debug.add("Error: UnsupportedCapabilityException not expected for this provider\n");
                    ++failcount;
                }
                catch (Exception e0) {
                    TestUtil.printStackTrace((Throwable)e0);
                    ++failcount;
                    this.debug.add("Error: removeChildOrganization threw an unexpected exception \n");
                    this.debug.add("Exception: " + e0.toString() + "\n");
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
                TestUtil.printStackTrace((Throwable)e);
                pass = false;
            }
        }
        if (failcount == 0) {
            pass = true;
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void organization_Test() throws EETest.Fault {
        boolean pass;
        String testName;
        block28: {
            boolean index = false;
            testName = "organization_Test";
            pass = false;
            String orgName = "TS Default Organization";
            int failcount = 0;
            Service ctsService = null;
            Object ctsUser = null;
            Object ctsPersonName = null;
            Object ctsTelephoneNumber = null;
            int serviceCount = 3;
            String serviceName = "TS Test Service";
            String serviceNames = "TS Test Services";
            String primaryContactPersonFullName = "TS Test PrimaryContactPerson";
            Collection orgKeys = null;
            try {
                InternationalString iorgName = this.blm.createInternationalString(this.tsLocale, orgName);
                Organization org = this.blm.createOrganization(iorgName);
                this.debug.add("\n==========================addservice(service) \n");
                ctsService = this.blm.createService(this.blm.createInternationalString(this.tsLocale, serviceName));
                org.addService(ctsService);
                this.debug.add("==========================addservices(services) \n");
                ArrayList<String> myServiceNames = new ArrayList<String>();
                for (int i = 0; i < serviceCount; ++i) {
                    myServiceNames.add(serviceNames + i);
                    this.debug.add("Adding service name: " + serviceNames + i + " to test organization \n");
                }
                ArrayList<Service> ctsServices = new ArrayList<Service>();
                for (int i = 0; i < serviceCount; ++i) {
                    ctsServices.add(this.blm.createService(this.blm.createInternationalString(this.tsLocale, serviceNames + i)));
                }
                org.addServices(ctsServices);
                this.debug.add("================================================\n");
                User primaryContactUser = this.blm.createUser();
                PersonName primaryContactPerson = this.blm.createPersonName(primaryContactPersonFullName);
                primaryContactUser.setPersonName(primaryContactPerson);
                org.setPrimaryContact(primaryContactUser);
                this.debug.add("================================================\n");
                int count = 10;
                User user = null;
                PersonName person = null;
                ArrayList<String> userNames = new ArrayList<String>();
                for (int i = 0; i < count; ++i) {
                    userNames.add("TS Test Person" + i);
                }
                Collection users = new ArrayList<User>();
                this.debug.add("Setting up collection of users \n");
                Iterator iter = userNames.iterator();
                while (iter.hasNext()) {
                    user = this.blm.createUser();
                    person = this.blm.createPersonName((String)iter.next());
                    user.setPersonName(person);
                    users.add(user);
                    this.debug.add("Adding this person to user collection: " + user.getPersonName().getFullName() + "\n");
                }
                org.addUsers(users);
                orgKeys = this.publishOrg(org);
                if (orgKeys == null) {
                    this.debug.add("Error: could not publish the  organization\n");
                    throw new EETest.Fault(testName + "test did not complete!");
                }
                iter = orgKeys.iterator();
                Key orgKey = null;
                while (iter.hasNext()) {
                    orgKey = (Key)iter.next();
                }
                BusinessQueryManager bqm = this.rs.getBusinessQueryManager();
                org = (Organization)bqm.getRegistryObject(orgKey.getId(), "Organization");
                if (org == null) {
                    this.debug.add("Error: could not find the just published organization\n");
                    throw new EETest.Fault(testName + "test did not complete!");
                }
                this.debug.add("================================================\n");
                this.debug.add("Find all the services that were added to the organization\n");
                ArrayList<String> allServiceNames = new ArrayList<String>();
                allServiceNames.addAll(myServiceNames);
                allServiceNames.add(serviceName);
                Collection retServices = org.getServices();
                Service retService = null;
                iter = retServices.iterator();
                int servicesFound = 0;
                ctsService = null;
                ctsServices.clear();
                while (iter.hasNext()) {
                    retService = (Service)iter.next();
                    this.debug.add("Retrieved service name: " + retService.getName().getValue(this.tsLocale) + " from organization\n");
                    if (allServiceNames.contains(retService.getName().getValue(this.tsLocale))) {
                        ++servicesFound;
                    }
                    if (!retService.getName().getValue(this.tsLocale).equals(serviceName)) continue;
                    this.debug.add("Setting ctsService for removeService \n");
                    ctsService = retService;
                }
                if (servicesFound == allServiceNames.size()) {
                    this.debug.add("Success: found all my services! \n");
                } else {
                    ++failcount;
                    this.debug.add("Error: failed to find added services\n");
                }
                org.removeService(ctsService);
                retServices = org.getServices();
                retService = null;
                iter = retServices.iterator();
                servicesFound = 0;
                this.debug.add("==============================================\n");
                this.debug.add("Verify all added services have been removed: \n");
                while (iter.hasNext()) {
                    retService = (Service)iter.next();
                    this.debug.add("Retrieve service name to verify removal: " + retService.getName().getValue(this.tsLocale) + " from organization\n");
                    if (retService.getName().getValue(this.tsLocale).equals(serviceName)) {
                        ++failcount;
                        this.debug.add("Error: found removed Service: " + serviceName + "\n");
                        continue;
                    }
                    this.debug.add("Adding retService to ctsServices for removeServices \n");
                    ctsServices.add(retService);
                }
                org.removeServices(ctsServices);
                retServices = org.getServices();
                retService = null;
                this.debug.add("==============================================\n");
                this.debug.add("removing  services:  \n");
                iter = retServices.iterator();
                servicesFound = 0;
                while (iter.hasNext()) {
                    retService = (Service)iter.next();
                    this.debug.add("Retrieved service name: " + retService.getName().getValue(this.tsLocale) + " from organization\n");
                    if (!myServiceNames.contains(retService.getName().getValue(this.tsLocale))) continue;
                    failcount = 1;
                    failcount = 1;
                    this.debug.add("Error: found a removed service!\n");
                }
                User pc = org.getPrimaryContact();
                this.debug.add("==============================================\n");
                this.debug.add("The primary contact returned from the organization was: " + pc.getPersonName().getFullName() + "\n");
                if (!pc.getPersonName().getFullName().equals(primaryContactPersonFullName)) {
                    this.debug.add("Error: PrimaryContact returned from organization is not valid \n");
                    ++failcount;
                }
                users.clear();
                this.debug.add("==============================================\n");
                users = org.getUsers();
                iter = users.iterator();
                int found = 0;
                this.debug.add("Adding the primary contact to the list of users to be returned\n");
                userNames.add(primaryContactPersonFullName);
                while (iter.hasNext()) {
                    user = (User)iter.next();
                    this.debug.add("Found user: " + user.getPersonName().getFullName() + "\n");
                    if (userNames.contains(user.getPersonName().getFullName())) {
                        ++found;
                        continue;
                    }
                    if (!user.getPersonName().getFullName().equals(primaryContactPersonFullName)) continue;
                    ++found;
                }
                if (found == userNames.size()) {
                    this.debug.add("Success: found all my Users! \n");
                } else {
                    ++failcount;
                    this.debug.add("Failed to find all my Users! Bug# 4532179 \n");
                }
                if (failcount == 0) {
                    pass = true;
                } else {
                    this.debug.add("Failure count for this test: " + failcount + "\n");
                }
                if (failcount == 0) {
                    pass = true;
                }
                this.debug.add("cleanup registry - remove test organization\n");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
                TestUtil.printStackTrace((Throwable)e);
                pass = false;
                break block28;
            }
            finally {
                this.debug.add("cleanup registry - remove test organization\n");
                super.cleanUpRegistry(orgKeys, "Organization");
            }
            super.cleanUpRegistry(orgKeys, "Organization");
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    private Collection publishOrg(Organization org) {
        Collection keys = null;
        try {
            ArrayList<Organization> orgs = new ArrayList<Organization>();
            orgs.add(org);
            BulkResponse br = this.blm.saveOrganizations(orgs);
            if (!JAXR_Util.checkBulkResponse("saveOrganizations", br, this.debug)) {
                return keys;
            }
            keys = br.getCollection();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
        }
        return keys;
    }

    private int checkServices(ArrayList myServiceNames, Organization org) {
        int failcount = 0;
        try {
            Collection retServices = org.getServices();
            Service retService = null;
            Iterator iter = retServices.iterator();
            int servicesFound = 0;
            while (iter.hasNext()) {
                retService = (Service)iter.next();
                this.debug.add("Retrieved service name: " + retService.getName().getValue(this.tsLocale) + " from organization\n");
                if (!myServiceNames.contains(retService.getName().getValue(this.tsLocale))) continue;
                ++servicesFound;
                this.debug.add("Found expected service, name is: " + retService.getName().getValue(this.tsLocale) + "\n");
            }
            if (servicesFound == myServiceNames.size()) {
                this.debug.add("Success: found all my services! \n");
            } else {
                ++failcount;
                this.debug.add("Failed to find added services\n");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return failcount;
    }

    public void organization_addUserTest() throws EETest.Fault {
        String testName = "organization_addUserTest";
        boolean pass = false;
        String orgName = "TS Default Organization";
        User user2 = null;
        PersonName person = null;
        int count = 20;
        try {
            ArrayList<String> userNames = new ArrayList<String>();
            for (int i = 0; i < count; ++i) {
                userNames.add("TS Test Person" + i);
            }
            InternationalString iorgName = this.blm.createInternationalString(this.tsLocale, orgName);
            Organization org = this.blm.createOrganization(iorgName);
            this.debug.add("Adding users one at a time with addUser method.\n");
            Iterator iter = userNames.iterator();
            while (iter.hasNext()) {
                user2 = this.blm.createUser();
                person = this.blm.createPersonName((String)iter.next());
                user2.setPersonName(person);
                org.addUser(user2);
            }
            this.debug.add("getUsers and verify all of the users were returned from the organization \n");
            Collection users = org.getUsers();
            int passcount = 0;
            for (User user2 : users) {
                this.debug.add("Found user: " + user2.getPersonName().getFullName() + "\n");
                if (!userNames.contains(user2.getPersonName().getFullName())) continue;
                ++passcount;
            }
            if (passcount == userNames.size()) {
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void organization_removeUsersTest() throws EETest.Fault {
        String testName = "organization_removeUsersTest";
        String orgName = "TS Default Organization";
        User user2 = null;
        PersonName person = null;
        int count = 20;
        try {
            ArrayList<String> userNames = new ArrayList<String>();
            for (int i = 0; i < count; ++i) {
                userNames.add("TS Test Person" + i);
            }
            InternationalString iorgName = this.blm.createInternationalString(this.tsLocale, orgName);
            Organization org = this.blm.createOrganization(iorgName);
            this.debug.add("Invoke addUser on organization \n");
            Iterator iter = userNames.iterator();
            while (iter.hasNext()) {
                user2 = this.blm.createUser();
                person = this.blm.createPersonName((String)iter.next());
                user2.setPersonName(person);
                org.addUser(user2);
            }
            Collection users = org.getUsers();
            int passcount = 0;
            for (User user2 : users) {
                if (!userNames.contains(user2.getPersonName().getFullName())) continue;
                ++passcount;
            }
            if (passcount != userNames.size()) {
                throw new EETest.Fault(testName + "Error: test didnot complete");
            }
            org.removeUsers(users);
            users.clear();
            users = org.getUsers();
            if (users.size() != 0) {
                this.debug.add("Error: all users not removed!\n");
                throw new EETest.Fault(testName + " failed ");
            }
            this.debug.add("good! all users were removed\n");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void organization_removeUserTest() throws EETest.Fault {
        String testName = "organization_removeUserTest";
        String orgName = "TS Default Organization";
        User user = null;
        PersonName person = null;
        String personName = "TS User 1";
        try {
            InternationalString iorgName = this.blm.createInternationalString(this.tsLocale, orgName);
            Organization org = this.blm.createOrganization(iorgName);
            this.debug.add("Add one user to an organization \n");
            user = this.blm.createUser();
            person = this.blm.createPersonName(personName);
            user.setPersonName(person);
            org.addUser(user);
            Collection users = org.getUsers();
            if (!users.contains(user)) {
                this.debug.add("Error: expected organization to contain my user \n");
                this.debug.add("Test did not complete \n");
                throw new EETest.Fault(testName + " failed ");
            }
            this.debug.add("Remove the user");
            org.removeUser(user);
            users = org.getUsers();
            if (users.contains(user)) {
                this.debug.add("Error: expected user to be removed from organization\n");
                throw new EETest.Fault(testName + " failed ");
            }
            this.debug.add("Good - user was removed");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
        finally {
            super.cleanUpRegistry(orgName);
        }
    }
}

