/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.pm.oneXmany.bi.btob;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.pm.oneXmany.bi.btob.ADVC;
import com.sun.ts.tests.ejb.ee.pm.oneXmany.bi.btob.ALocal;
import com.sun.ts.tests.ejb.ee.pm.oneXmany.bi.btob.ALocalHome;
import com.sun.ts.tests.ejb.ee.pm.oneXmany.bi.btob.BDVC;
import com.sun.ts.tests.ejb.ee.pm.oneXmany.bi.btob.BLocal;
import com.sun.ts.tests.ejb.ee.pm.oneXmany.bi.btob.BLocalHome;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

public abstract class BeanEJB
implements EntityBean {
    private static final int NO_RELATION_SET = 0;
    private static final int NULL_RELATION_SET = 1;
    private static final int RELATION_SET = 2;
    private static final String ALocal = "java:comp/env/ejb/AEJBLocal";
    private static final String BLocal = "java:comp/env/ejb/BEJBLocal";
    private EntityContext context = null;
    private TSNamingContext nctx = null;

    public abstract String getId();

    public abstract void setId(String var1);

    public abstract String getName();

    public abstract void setName(String var1);

    public abstract int getValue();

    public abstract void setValue(int var1);

    public abstract ALocal getA1();

    public abstract void setA1(ALocal var1);

    public abstract ALocal getA2();

    public abstract void setA2(ALocal var1);

    public abstract BLocal getB1();

    public abstract void setB1(BLocal var1);

    public abstract BLocal getB2();

    public abstract void setB2(BLocal var1);

    public abstract BLocal getB3();

    public abstract void setB3(BLocal var1);

    public abstract BLocal getB4();

    public abstract void setB4(BLocal var1);

    public void init(Properties p) {
        TestUtil.logTrace((String)"init");
        try {
            TestUtil.init((Properties)p);
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    private boolean nullTest() {
        TestUtil.logTrace((String)"nullTest");
        ALocal aOne = this.getA1();
        BLocal bOne = this.getB1();
        ALocal a1 = bOne.getA();
        Collection b1 = aOne.getB();
        return a1 == null && b1.isEmpty();
    }

    public boolean test0() {
        TestUtil.logTrace((String)"test0");
        return this.nullTest();
    }

    public Collection getBInfoFromA() {
        TestUtil.logTrace((String)"getBInfoFromA");
        Vector<BDVC> v = new Vector<BDVC>();
        if (this.getA1() != null) {
            Collection bcol = this.getA1().getB();
            for (BLocal b : bcol) {
                BDVC bDVC = new BDVC(b.getId(), b.getName(), b.getValue());
                v.add(bDVC);
            }
        }
        return v;
    }

    public Collection getAInfoFromB() {
        TestUtil.logTrace((String)"getAInfoFromB");
        Vector<ADVC> v = new Vector<ADVC>();
        if (this.getA1() != null) {
            Collection bcol = this.getA1().getB();
            for (BLocal b : bcol) {
                ALocal a = b.getA();
                ADVC aDVC = new ADVC(a.getId(), a.getName(), a.getValue());
                v.add(aDVC);
            }
        }
        return v;
    }

    private boolean checkReassignment(Collection c, ALocal theA) {
        TestUtil.logMsg((String)"checkReassignment");
        for (BLocal b : c) {
            ALocal a = b.getA();
            if (!(theA == null ? a != null : !a.isIdentical(theA))) continue;
            return false;
        }
        return true;
    }

    private Collection copyCollection(Collection c) {
        Vector copy = new Vector();
        Iterator iterator = c.iterator();
        while (iterator.hasNext()) {
            copy.add(iterator.next());
        }
        return copy;
    }

    private void dumpCollectionData(Collection c) {
        TestUtil.logMsg((String)"Collection Data");
        TestUtil.logMsg((String)"---------------");
        TestUtil.logMsg((String)("- size=" + c.size()));
        Iterator i = c.iterator();
        int elem = 1;
        while (i.hasNext()) {
            BLocal v = (BLocal)i.next();
            TestUtil.logMsg((String)("- Element #" + elem++));
            TestUtil.logMsg((String)("  id=" + v.getId() + ", name=" + v.getName() + ", value=" + v.getValue()));
        }
    }

    public boolean doAssignmentTest1() {
        TestUtil.logMsg((String)"doAssignmentTest1");
        ALocal aOne = this.getA1();
        ALocal aTwo = this.getA2();
        Collection bOne = aOne.getB();
        Collection bTwo = aTwo.getB();
        Collection b1col = this.copyCollection(aOne.getB());
        Collection b2col = this.copyCollection(aTwo.getB());
        try {
            TestUtil.logMsg((String)"Dumping collection data for a1.getB() ...");
            this.dumpCollectionData(this.getA1().getB());
            TestUtil.logMsg((String)"Dumping collection data for a2.getB() ...");
            this.dumpCollectionData(this.getA2().getB());
            TestUtil.logMsg((String)"Performing assignment test ...");
            aOne.setB(aTwo.getB());
            TestUtil.logMsg((String)"Getting assignment test results ...");
            Collection b1 = aOne.getB();
            TestUtil.logMsg((String)"Dumping collection data for a1.getB() ...");
            this.dumpCollectionData(b1);
            Collection b2 = aTwo.getB();
            TestUtil.logMsg((String)"Dumping collection data for a2.getB() ...");
            this.dumpCollectionData(b2);
            TestUtil.logMsg((String)"Comparing assignment test results ...");
            if (b1.containsAll(b2col) && b1.size() == b2col.size() && b2.isEmpty() && b1 == bOne && b2 == bTwo && this.checkReassignment(b1col, null) && this.checkReassignment(b2col, aOne)) {
                TestUtil.logMsg((String)"Relationship assignment passed");
                return true;
            }
            TestUtil.logMsg((String)"Relationship assignment failed");
            if (!b1.containsAll(b2col)) {
                TestUtil.logErr((String)"b1 collection results unexpected");
            }
            if (b1.size() != b2col.size()) {
                TestUtil.logErr((String)("collection size mismatch, expected: " + b2col.size() + ", received: " + b1.size()));
            }
            if (!b2.isEmpty()) {
                TestUtil.logErr((String)"b2 is not empty");
            }
            if (b1 != bOne) {
                TestUtil.logErr((String)"b1 is not same collection reference");
            }
            if (b2 != bTwo) {
                TestUtil.logErr((String)"b2 is not same collection reference");
            }
            return false;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception occurred: " + e), (Throwable)e);
            return false;
        }
    }

    public boolean doAssignmentTest2() {
        TestUtil.logMsg((String)"doAssignmentTest2");
        ALocal aOne = this.getA1();
        ALocal aTwo = this.getA2();
        BLocal b11 = this.getB1();
        BLocal b12 = this.getB2();
        BLocal b21 = this.getB3();
        BLocal b22 = this.getB4();
        Collection b1 = aOne.getB();
        Collection b2 = aTwo.getB();
        try {
            TestUtil.logMsg((String)"Dumping collection data for a1.getB() ...");
            this.dumpCollectionData(this.getA1().getB());
            TestUtil.logMsg((String)"Dumping collection data for a2.getB() ...");
            this.dumpCollectionData(this.getA2().getB());
            TestUtil.logMsg((String)"Performing assignment test ...");
            b22.setA(b12.getA());
            TestUtil.logMsg((String)"Getting assignment test results ...");
            TestUtil.logMsg((String)"Dumping collection data for a1.getB() ...");
            this.dumpCollectionData(b1);
            TestUtil.logMsg((String)"Dumping collection data for a2.getB() ...");
            this.dumpCollectionData(b2);
            TestUtil.logMsg((String)"Comparing assignment test results ...");
            if (b1.contains(b11) && b1.contains(b12) && b1.contains(b22) && b2.contains(b21) && aOne.isIdentical(b11.getA()) && aOne.isIdentical(b12.getA()) && aOne.isIdentical(b22.getA()) && aTwo.isIdentical(b21.getA())) {
                TestUtil.logMsg((String)"Relationship assignment passed");
                return true;
            }
            TestUtil.logMsg((String)"Relationship assignment failed");
            return false;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception occurred: " + e), (Throwable)e);
            return false;
        }
    }

    public boolean doAssignmentTest3() {
        TestUtil.logMsg((String)"doAssignmentTest3");
        ALocal aOne = this.getA1();
        ALocal aTwo = this.getA2();
        BLocal b11 = this.getB1();
        BLocal b12 = this.getB2();
        BLocal b21 = this.getB3();
        BLocal b22 = this.getB4();
        Collection b1 = aOne.getB();
        Collection b2 = aTwo.getB();
        try {
            TestUtil.logMsg((String)"Dumping collection data for a1.getB() ...");
            this.dumpCollectionData(this.getA1().getB());
            TestUtil.logMsg((String)"Dumping collection data for a2.getB() ...");
            this.dumpCollectionData(this.getA2().getB());
            TestUtil.logMsg((String)"Performing assignment test ...");
            aOne.getB().add(b22);
            TestUtil.logMsg((String)"Getting assignment test results ...");
            TestUtil.logMsg((String)"Dumping collection data for a1.getB() ...");
            this.dumpCollectionData(b1);
            TestUtil.logMsg((String)"Dumping collection data for a2.getB() ...");
            this.dumpCollectionData(b2);
            TestUtil.logMsg((String)"Comparing assignment test results ...");
            if (b1.contains(b11) && b1.contains(b12) && b1.contains(b22) && b2.contains(b21) && aOne.isIdentical(b11.getA()) && aOne.isIdentical(b12.getA()) && aOne.isIdentical(b22.getA()) && aTwo.isIdentical(b21.getA())) {
                return true;
            }
            TestUtil.logMsg((String)"Relationship assignment failed");
            return false;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception occurred: " + e), (Throwable)e);
            return false;
        }
    }

    public boolean doAssignmentTest4() {
        TestUtil.logMsg((String)"doAssignmentTest4");
        ALocal a1 = this.getA1();
        BLocal b12 = this.getB2();
        BLocal b11 = this.getB1();
        Collection bOne = a1.getB();
        Vector<BLocal> b = new Vector<BLocal>();
        b.add(b11);
        try {
            TestUtil.logMsg((String)"Dumping collection data for a1.getB() ...");
            this.dumpCollectionData(this.getA1().getB());
            TestUtil.logMsg((String)"Dumping collection data for a2.getB() ...");
            this.dumpCollectionData(this.getA2().getB());
            TestUtil.logMsg((String)"Performing assignment test ...");
            a1.getB().remove(b12);
            TestUtil.logMsg((String)"Getting assignment test results ...");
            ALocal a2 = b12.getA();
            Collection b1 = a1.getB();
            TestUtil.logMsg((String)"Dumping collection data for a1.getB() ...");
            this.dumpCollectionData(b1);
            TestUtil.logMsg((String)"Comparing assignment test results ...");
            if (b1.containsAll(b) && b1.size() == b.size() && bOne == b1 && a2 == null) {
                TestUtil.logMsg((String)"Relationship assignment passed");
                return true;
            }
            TestUtil.logMsg((String)"Relationship assignment failed");
            return false;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception occurred: " + e), (Throwable)e);
            return false;
        }
    }

    public boolean setCmrFieldToNull() {
        TestUtil.logTrace((String)"setCmrFieldToNull");
        try {
            ALocal a1 = this.getA1();
            return a1.setCmrFieldToNull();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception occurred: " + e), (Throwable)e);
            return false;
        }
    }

    public boolean setCmrFieldToWrongType(int i) {
        TestUtil.logTrace((String)"setCmrFieldToWrongType");
        boolean pass = false;
        TestUtil.logMsg((String)"Attempting to set collection cmr-field of type B to A");
        try {
            ALocal a1 = this.getA1();
            if (i == 1) {
                TestUtil.logMsg((String)"Use setter method to add to collection");
                Vector<ALocal> v = new Vector<ALocal>();
                v.add(a1);
                return a1.setCmrFieldToWrongType(v);
            }
            if (i == 2) {
                TestUtil.logMsg((String)"Use Collection API add(Object 0) method to add to collection");
                a1.getB().add(a1);
            }
            TestUtil.logErr((String)"no exception when setting collection cmr-field to wrong type");
            pass = false;
        }
        catch (IllegalArgumentException e) {
            TestUtil.logMsg((String)"IllegalArgumentException caught as expected");
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Expected IllegalArgumentException, received " + e));
            pass = false;
        }
        return pass;
    }

    private ALocal createALocal(String id, String name, int value) throws Exception {
        TestUtil.logTrace((String)"createALocal");
        this.nctx = new TSNamingContext();
        ALocalHome aLocalHome = (ALocalHome)this.nctx.lookup(ALocal);
        ALocal aLocal = aLocalHome.create(id, name, value);
        return aLocal;
    }

    private BLocal createBLocal(String id, String name, int value) throws Exception {
        TestUtil.logTrace((String)"createBLocal");
        this.nctx = new TSNamingContext();
        BLocalHome bLocalHome = (BLocalHome)this.nctx.lookup(BLocal);
        BLocal bLocal = bLocalHome.create(id, name, value);
        return bLocal;
    }

    public String ejbCreate(String id, String name, int value, ADVC aOne, BDVC bOne, int flag) throws CreateException {
        TestUtil.logTrace((String)"ejbCreate");
        try {
            this.setId(id);
            this.setName(name);
            this.setValue(value);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException("Exception occurred: " + e);
        }
        return null;
    }

    public void ejbPostCreate(String id, String name, int value, ADVC aOne, BDVC bOne, int flag) throws CreateException {
        TestUtil.logTrace((String)"ejbPostCreate");
        try {
            ALocal a1 = this.createALocal(aOne.getId(), aOne.getName(), aOne.getValue());
            this.setA1(a1);
            BLocal b1 = this.createBLocal(bOne.getId(), bOne.getName(), bOne.getValue());
            this.setB1(b1);
            switch (flag) {
                case 0: {
                    break;
                }
                case 1: {
                    b1.setA(null);
                    break;
                }
                case 2: {
                    Collection c = a1.getB();
                    c.add(b1);
                }
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException("Exception occurred: " + e);
        }
    }

    public String ejbCreate(String id, String name, int value, ADVC aOne, BDVC bOne, BDVC bTwo, ADVC aTwo, BDVC bThree, BDVC bFour) throws CreateException {
        TestUtil.logTrace((String)"ejbCreate");
        try {
            this.setId(id);
            this.setName(name);
            this.setValue(value);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException("Exception occurred: " + e);
        }
        return null;
    }

    public void ejbPostCreate(String id, String name, int value, ADVC aOne, BDVC bOne, BDVC bTwo, ADVC aTwo, BDVC bThree, BDVC bFour) throws CreateException {
        TestUtil.logTrace((String)"ejbPostCreate");
        try {
            ALocal a1 = this.createALocal(aOne.getId(), aOne.getName(), aOne.getValue());
            this.setA1(a1);
            Collection bcol1 = a1.getB();
            BLocal b1 = this.createBLocal(bOne.getId(), bOne.getName(), bOne.getValue());
            this.setB1(b1);
            bcol1.add(b1);
            BLocal b2 = this.createBLocal(bTwo.getId(), bTwo.getName(), bTwo.getValue());
            this.setB2(b2);
            bcol1.add(b2);
            if (aTwo == null) {
                return;
            }
            ALocal a2 = this.createALocal(aTwo.getId(), aTwo.getName(), aTwo.getValue());
            this.setA2(a2);
            Collection bcol2 = a2.getB();
            BLocal b3 = this.createBLocal(bThree.getId(), bThree.getName(), bThree.getValue());
            this.setB3(b3);
            bcol2.add(b3);
            BLocal b4 = this.createBLocal(bFour.getId(), bFour.getName(), bFour.getValue());
            this.setB4(b4);
            bcol2.add(b4);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException("Exception occurred: " + e);
        }
    }

    public void setEntityContext(EntityContext c) {
        TestUtil.logTrace((String)"setEntityContext");
        this.context = c;
        try {
            TestUtil.logMsg((String)"Obtain naming context");
            this.nctx = new TSNamingContext();
        }
        catch (NamingException e) {
            TestUtil.logErr((String)("NamingException ... " + e), (Throwable)e);
            throw new EJBException("unable to obtain naming context");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception ... " + e), (Throwable)e);
            throw new EJBException("Exception occurred: " + e);
        }
    }

    public void unsetEntityContext() {
        TestUtil.logTrace((String)"unsetEntityContext");
    }

    public void ejbRemove() throws RemoveException {
        TestUtil.logTrace((String)"ejbRemove");
        if (this.getA1() != null) {
            TestUtil.logMsg((String)"deleting entity object a1 ...");
            this.getA1().remove();
        }
        if (this.getA2() != null) {
            TestUtil.logMsg((String)"deleting entity object a2 ...");
            this.getA2().remove();
        }
        if (this.getB1() != null) {
            TestUtil.logMsg((String)"deleting entity object b1 ...");
            this.getB1().remove();
        }
        if (this.getB2() != null) {
            TestUtil.logMsg((String)"deleting entity object b2 ...");
            this.getB2().remove();
        }
        if (this.getB3() != null) {
            TestUtil.logMsg((String)"deleting entity object b3 ...");
            this.getB3().remove();
        }
        if (this.getB4() != null) {
            TestUtil.logMsg((String)"deleting entity object b4 ...");
            this.getB4().remove();
        }
    }

    public void ejbActivate() {
        TestUtil.logTrace((String)"ejbActivate");
    }

    public void ejbPassivate() {
        TestUtil.logTrace((String)"ejbPassivate");
    }

    public void ejbLoad() {
        TestUtil.logTrace((String)"ejbLoad");
    }

    public void ejbStore() {
        TestUtil.logTrace((String)"ejbStore");
    }
}

