/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.common.allowed.stateful;

import com.sun.ts.tests.ejb30.common.allowed.Constants;
import com.sun.ts.tests.ejb30.common.allowed.Operations;
import com.sun.ts.tests.ejb30.common.allowed.stateful.TimerLocalIF;
import com.sun.ts.tests.ejb30.common.helper.ServiceLocator;
import com.sun.ts.tests.ejb30.common.helper.TLogger;
import com.sun.ts.tests.ejb30.common.helper.TestFailedException;
import java.util.Date;
import java.util.Properties;
import javax.ejb.EJBException;
import javax.ejb.ScheduleExpression;
import javax.ejb.SessionContext;
import javax.ejb.Timer;
import javax.ejb.TimerHandle;
import javax.naming.Context;

public class StatefulOperations
extends Operations
implements Constants {
    private static StatefulOperations instance = new StatefulOperations();

    protected StatefulOperations() {
    }

    public static StatefulOperations getInstance() {
        return instance;
    }

    @Override
    public void runMessageContext(SessionContext sctx, Properties results) {
    }

    @Override
    public void runRollbackOnly(SessionContext sctx, Properties results) {
        try {
            sctx.getRollbackOnly();
            results.setProperty("getRollbackOnly", "allowed");
        }
        catch (IllegalStateException e) {
            results.setProperty("getRollbackOnly", "disallowed");
        }
        catch (Exception e) {
            results.setProperty("getRollbackOnly", e.toString());
        }
    }

    public TimerLocalIF getTimerBean() {
        try {
            TimerLocalIF timerRef = (TimerLocalIF)ServiceLocator.lookup("java:comp/env/ejb/TimerEJB", TimerLocalIF.class, new Context[0]);
            return timerRef;
        }
        catch (Exception e) {
            throw new EJBException("Failed to get timer bean:", e);
        }
    }

    public TimerHandle getTimeHandle() throws Exception {
        TimerLocalIF timerBean = this.getTimerBean();
        return timerBean.startTimer(60000L, "info");
    }

    @Override
    public void runTimers(SessionContext sctx, Properties results) {
        try {
            TimerHandle th = this.getTimeHandle();
            Timer t = th.getTimer();
            TLogger.logMsg("Got timer: " + t.toString() + "; hashCode: " + t.hashCode());
            th = t.getHandle();
            TLogger.logMsg("Got timer handle: " + th.toString() + "; hashCode: " + th.hashCode());
            long tRemaining = t.getTimeRemaining();
            TLogger.logMsg("Time remaining is " + tRemaining);
            Date tNextTimeout = t.getNextTimeout();
            TLogger.logMsg("Next timeout is " + tNextTimeout);
            String tInfo = (String)((Object)t.getInfo());
            TLogger.logMsg("Timer info is " + tInfo);
            if (t.isCalendarTimer()) {
                ScheduleExpression exp = t.getSchedule();
                TLogger.logMsg("ScheduleExpression is " + exp);
            }
            TLogger.logMsg("Timer isPersistent: " + t.isPersistent());
            results.setProperty("Timer_Methods", "allowed");
        }
        catch (IllegalStateException e) {
            results.setProperty("Timer_Methods", "disallowed");
        }
        catch (Exception e) {
            results.setProperty("Timer_Methods", e.toString());
        }
    }

    @Override
    public void tryRollback(SessionContext sctx) throws TestFailedException {
        super.tryRollback(sctx);
        try {
            sctx.setRollbackOnly();
            throw new TestFailedException("Expecting IllegalStateException from setRollbackOnly(), but got no exception.");
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (Exception e) {
            throw new TestFailedException("Expecting IllegalStateException from setRollbackOnly(),  but got " + e);
        }
    }
}

