/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.bb.session.stateful.sessioncontexttest;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.bb.session.stateful.sessioncontexttest.TestBean2;
import com.sun.ts.tests.ejb.ee.bb.session.stateful.sessioncontexttest.TestBeanHome;
import java.security.Principal;
import java.util.Properties;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EJBObject;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.transaction.UserTransaction;

public class TestBeanEJB
implements SessionBean {
    private static final String[] dataPropKey = new String[]{"user", "password", "server", "jdbcPoolName"};
    private static final String[] dataPropVal = new String[]{"cts1", "cts1", "JDBCTEST", "sessionContextPool"};
    private SessionContext sctx = null;
    private Properties harnessProps = null;
    private UserTransaction ut = null;
    private TSNamingContext nctx = null;

    public TestBeanEJB() {
        TestUtil.logTrace((String)"newInstance() => default constructor called");
    }

    public void ejbCreate(Properties p) throws CreateException {
        TestUtil.logTrace((String)"ejbCreate");
        this.harnessProps = p;
        try {
            TestUtil.logMsg((String)"initialize remote logging");
            TestUtil.init((Properties)p);
            TestUtil.logMsg((String)"obtain naming context");
            this.nctx = new TSNamingContext();
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException(e.getMessage());
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException("unable to obtain naming context");
        }
    }

    public void setSessionContext(SessionContext sc) {
        TestUtil.logTrace((String)"setSessionContext");
        this.sctx = sc;
    }

    public void ejbRemove() {
        TestUtil.logTrace((String)"ejbRemove");
    }

    public void ejbActivate() {
        TestUtil.logTrace((String)"ejbActivate");
    }

    public void ejbPassivate() {
        TestUtil.logTrace((String)"ejbPassivate");
    }

    public boolean getEJBObjectTest() {
        TestUtil.logTrace((String)"getEJBObjectTest");
        try {
            EJBObject object = this.sctx.getEJBObject();
            if (object != null) {
                TestUtil.logMsg((String)"getEJBObject() returned EJBObject reference");
                return true;
            }
            TestUtil.logErr((String)"getEJBObject() returned null reference");
            return false;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
    }

    public boolean getEJBHomeTest() {
        TestUtil.logTrace((String)"getEJBHomeTest");
        try {
            TestBeanHome home = (TestBeanHome)this.sctx.getEJBHome();
            if (home != null) {
                TestUtil.logMsg((String)"getEJBHome() returned EJBHome reference");
                return true;
            }
            TestUtil.logErr((String)"getEJBHome() returned null reference");
            return false;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
    }

    public boolean getEnvironmentTest() {
        TestUtil.logTrace((String)"getEnvironmentTest");
        int failures = 0;
        try {
            for (int i = 0; i < dataPropKey.length; ++i) {
                String envProp = "java:comp/env/" + dataPropKey[i];
                TestUtil.logMsg((String)("lookup: " + envProp));
                String propVal = (String)this.nctx.lookup(envProp);
                TestUtil.logMsg((String)("propVal=" + propVal));
                if (propVal == null) {
                    TestUtil.logErr((String)("property name " + dataPropKey[i] + " not found in environment"));
                    ++failures;
                    continue;
                }
                if (!propVal.equals(dataPropVal[i])) {
                    TestUtil.logErr((String)("property value " + propVal + " not equal to " + dataPropVal[i]));
                    ++failures;
                    continue;
                }
                TestUtil.logMsg((String)"property values are equal");
            }
            return failures <= 0;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
    }

    public boolean getCallerPrincipalTest(String s) {
        TestUtil.logTrace((String)"getCallerPrincipalTest");
        try {
            Principal principal = this.sctx.getCallerPrincipal();
            if (principal != null) {
                TestUtil.logMsg((String)("getCallerPrincipal() returned Principal: " + principal));
                String name = principal.getName();
                if (name.indexOf(s) < 0) {
                    TestUtil.logErr((String)("principal - expected: " + s + ", received: " + name));
                    return false;
                }
                return true;
            }
            TestUtil.logErr((String)"getCallerPrincipal() returned null reference");
            return false;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    public boolean isCallerInRoleTest(String s) {
        TestUtil.logTrace((String)"isCallerInRoleTest");
        String role = s;
        try {
            boolean inRole = this.sctx.isCallerInRole(role);
            if (inRole) {
                TestUtil.logMsg((String)("isCallerInRole(" + role + ") is true"));
            } else {
                TestUtil.logMsg((String)("isCallerInRole(" + role + ") is false"));
            }
            return inRole;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    public boolean setRollbackOnlyTest() {
        TestUtil.logTrace((String)"setRollbackOnlyTest");
        boolean pass = true;
        TestUtil.logMsg((String)"set rollback status - IllegalStateException");
        try {
            this.sctx.setRollbackOnly();
            TestUtil.logErr((String)"no IllegalStateException occurred - unexpected");
            pass = false;
        }
        catch (IllegalStateException e) {
            TestUtil.logMsg((String)"IllegalStateException occurred - expected");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Unexpected exception: " + e), (Throwable)e);
            pass = false;
        }
        return pass;
    }

    public boolean getRollbackOnlyTest() {
        TestUtil.logTrace((String)"getRollbackOnlyTest");
        boolean pass = true;
        TestUtil.logMsg((String)"get rollback status - IllegalStateException");
        try {
            boolean status = this.sctx.getRollbackOnly();
            TestUtil.logErr((String)"no IllegalStateException occurred - unexpected");
            pass = false;
        }
        catch (IllegalStateException e) {
            TestUtil.logMsg((String)"IllegalStateException occurred - expected");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Unexpected exception: " + e), (Throwable)e);
            pass = false;
        }
        return pass;
    }

    public boolean getUserTransactionTest() {
        TestUtil.logTrace((String)"getUserTransactionTest");
        try {
            UserTransaction ut = this.sctx.getUserTransaction();
            return ut != null;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
    }

    public boolean getUserTransactionTest(TestBean2 ref) {
        TestUtil.logTrace((String)"getUserTransactionTest");
        try {
            boolean pass = ref.getUserTransactionTest();
            return pass;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
    }

    public boolean beginTransaction() {
        TestUtil.logTrace((String)"beginTransaction");
        try {
            this.ut = this.sctx.getUserTransaction();
            this.ut.begin();
            return true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
    }

    public boolean commitTransaction() {
        TestUtil.logTrace((String)"commitTransaction");
        try {
            this.ut.commit();
            return true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
    }
}

