/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.bb.entity.bmp.entitybeantest;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.dao.DAOException;
import com.sun.ts.tests.common.dao.DAOFactory;
import com.sun.ts.tests.common.dao.coffee.CoffeeBean;
import com.sun.ts.tests.common.dao.coffee.CoffeeDAO;
import com.sun.ts.tests.ejb.ee.bb.entity.bmp.entitybeantest.Helper;
import java.util.Properties;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.FinderException;
import javax.ejb.NoSuchEntityException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

public class TestBeanEJB
implements EntityBean {
    private CoffeeBean cache;
    private CoffeeDAO dao = null;
    private EntityContext ectx = null;
    private TSNamingContext nctx = null;
    private Helper ref = null;
    private boolean ejbNewInstanceFlag = false;
    private boolean ejbEntityContextFlag = false;
    private boolean ejbCreateFlag = false;
    private boolean ejbPostCreateFlag = false;
    private boolean ejbLoadFlag = false;
    private boolean ejbStoreFlag = false;
    private boolean iAmDestroyed = false;
    private boolean createLifeCycleFlag = true;
    float cofPrice = 0.0f;

    public TestBeanEJB() {
        TestUtil.logTrace((String)"newInstance => default constructor called");
        this.ejbNewInstanceFlag = true;
        if (this.ejbEntityContextFlag || this.ejbCreateFlag || this.ejbPostCreateFlag) {
            this.createLifeCycleFlag = false;
        }
    }

    public Integer ejbCreate(Properties p, int cofID, String cofName, float cofPrice, Helper r) throws CreateException, DuplicateKeyException {
        this.ref = r;
        TestUtil.logTrace((String)"ejbCreate");
        TestUtil.logTrace((String)("ejbNewInstanceFlag=" + this.ejbNewInstanceFlag + "\nejbEntityContextFlag=" + this.ejbEntityContextFlag + "\nejbCreateFlag=" + this.ejbCreateFlag + "\nejbPostCreateFlag=" + this.ejbPostCreateFlag));
        this.ejbCreateFlag = true;
        if (!this.ejbNewInstanceFlag || !this.ejbEntityContextFlag || this.ejbPostCreateFlag) {
            this.createLifeCycleFlag = false;
        }
        try {
            TestUtil.logMsg((String)"Initialize remote logging");
            TestUtil.init((Properties)p);
            TestUtil.logMsg((String)"DAO Init");
            if (null == this.dao) {
                this.dao = DAOFactory.getInstance().getCoffeeDAO();
            }
            TestUtil.logMsg((String)"Get DB Connection");
            this.dao.startSession();
            if (this.dao.exists(cofID)) {
                TestUtil.logErr((String)"key exists - duplicate");
                throw new DuplicateKeyException();
            }
            TestUtil.logMsg((String)"key does not exist - create entity");
            TestUtil.logTrace((String)"DAO: Create new row...");
            this.dao.create(cofID, cofName, cofPrice);
            this.cache = new CoffeeBean(cofID, cofName, cofPrice);
        }
        catch (DuplicateKeyException de) {
            TestUtil.printStackTrace((Throwable)de);
            throw new DuplicateKeyException();
        }
        catch (RemoteLoggingInitException re) {
            TestUtil.printStackTrace((Throwable)re);
            throw new CreateException(re.getMessage());
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException("Exception occurred: " + e);
        }
        finally {
            if (null != this.dao) {
                this.dao.stopSession();
            }
        }
        try {
            this.ref.setCreateLifeCycle(this.createLifeCycleFlag);
            this.ref.setCreateMethodCalled(1);
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught Exception: " + e), (Throwable)e);
            throw new CreateException("Exception occurred: " + e);
        }
        return new Integer(cofID);
    }

    public void ejbPostCreate(Properties p, int cofID, String cofName, float cofPrice, Helper r) {
        TestUtil.logTrace((String)"ejbPostCreate");
        this.ejbPostCreateFlag = true;
        if (!(this.ejbNewInstanceFlag && this.ejbEntityContextFlag && this.ejbCreateFlag)) {
            this.createLifeCycleFlag = false;
        }
    }

    public Integer ejbCreate(Properties p, int cofID, Helper r) throws CreateException, DuplicateKeyException {
        this.ref = r;
        TestUtil.logTrace((String)"ejbCreate");
        TestUtil.logTrace((String)("ejbNewInstanceFlag=" + this.ejbNewInstanceFlag + "\nejbEntityContextFlag=" + this.ejbEntityContextFlag + "\nejbCreateFlag=" + this.ejbCreateFlag + "\nejbPostCreateFlag=" + this.ejbPostCreateFlag));
        this.ejbCreateFlag = true;
        if (!this.ejbNewInstanceFlag || !this.ejbEntityContextFlag || this.ejbPostCreateFlag) {
            this.createLifeCycleFlag = false;
        }
        try {
            TestUtil.logMsg((String)"initialize remote logging");
            TestUtil.init((Properties)p);
            TestUtil.logMsg((String)"DAO Init");
            if (null == this.dao) {
                this.dao = DAOFactory.getInstance().getCoffeeDAO();
            }
            this.dao.startSession();
            TestUtil.logMsg((String)"Get DB Connection");
            if (this.dao.exists(cofID)) {
                TestUtil.logErr((String)"key exists - duplicate");
                throw new DuplicateKeyException();
            }
            TestUtil.logMsg((String)"key does not exist - create entity");
            TestUtil.logTrace((String)"DAO: Create new row...");
            this.dao.create(cofID, "unknown", 0.0f);
            this.cache = new CoffeeBean(cofID, "unknown", 0.0f);
        }
        catch (DuplicateKeyException de) {
            TestUtil.printStackTrace((Throwable)de);
            throw new DuplicateKeyException();
        }
        catch (RemoteLoggingInitException re) {
            TestUtil.printStackTrace((Throwable)re);
            throw new CreateException(re.getMessage());
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException("Exception occurred: " + e);
        }
        finally {
            if (null != this.dao) {
                this.dao.stopSession();
            }
        }
        try {
            this.ref.setCreateLifeCycle(this.createLifeCycleFlag);
            this.ref.setCreateMethodCalled(2);
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught Exception: " + e), (Throwable)e);
            throw new CreateException("Exception occurred: " + e);
        }
        return new Integer(cofID);
    }

    public void ejbPostCreate(Properties p, int n, Helper r) {
        TestUtil.logTrace((String)"ejbPostCreate");
        this.ejbPostCreateFlag = true;
        if (!(this.ejbNewInstanceFlag && this.ejbEntityContextFlag && this.ejbCreateFlag)) {
            this.createLifeCycleFlag = false;
        }
    }

    public void setEntityContext(EntityContext c) {
        TestUtil.logTrace((String)"setEntityContext");
        this.ectx = c;
        this.ejbEntityContextFlag = true;
        if (!this.ejbNewInstanceFlag || this.ejbCreateFlag || this.ejbPostCreateFlag) {
            this.createLifeCycleFlag = false;
        }
        try {
            TestUtil.logMsg((String)"Obtain naming context");
            this.nctx = new TSNamingContext();
        }
        catch (NamingException e) {
            TestUtil.logErr((String)("NamingException ... " + e), (Throwable)e);
            throw new EJBException("unable to obtain naming context");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception ... " + e), (Throwable)e);
            throw new EJBException("Exception in setEntityContext");
        }
    }

    public void unsetEntityContext() {
        TestUtil.logTrace((String)"unsetEntityContext");
    }

    public void ejbRemove() throws RemoveException {
        TestUtil.logTrace((String)"ejbRemove");
        try {
            if (this.ref != null) {
                this.ref.setRemove(true);
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception occurred contacting callback bean", (Throwable)e);
            throw new RemoveException("callback not notified");
        }
        this.ref = null;
        this.reset();
        try {
            if (null == this.dao) {
                TestUtil.logMsg((String)"get DAO...");
                this.dao = DAOFactory.getInstance().getCoffeeDAO();
            }
            TestUtil.logTrace((String)"Start DAO session...");
            this.dao.startSession();
            TestUtil.logTrace((String)"Remove row...");
            this.dao.delete((Integer)this.ectx.getPrimaryKey());
        }
        catch (DAOException e) {
            throw new RemoveException("Caught DAOException" + e);
        }
        catch (Exception e) {
            throw new RemoveException("Caught exception: " + e);
        }
        finally {
            if (null != this.dao) {
                this.dao.stopSession();
            }
        }
    }

    public void ejbActivate() {
        TestUtil.logTrace((String)"ejbActivate");
        this.ejbStoreFlag = false;
    }

    public void ejbPassivate() {
        TestUtil.logTrace((String)"ejbPassivate");
        this.reset();
    }

    public void ejbStore() {
        TestUtil.logTrace((String)"ejbStore");
        this.ejbStoreFlag = true;
        try {
            if (null == this.dao) {
                TestUtil.logMsg((String)"Get DAO...");
                this.dao = DAOFactory.getInstance().getCoffeeDAO();
            }
            TestUtil.logTrace((String)"Start DAO session...");
            this.dao.startSession();
            TestUtil.logTrace((String)"Store row...");
            this.dao.store(this.cache);
        }
        catch (DAOException de) {
            TestUtil.logErr((String)("No such entity: " + de));
            throw new NoSuchEntityException("[ejbStore] DAOException" + de);
        }
        catch (Exception e) {
            throw new EJBException("[ejbStore] Unable to init DAO");
        }
        finally {
            if (null != this.dao) {
                this.dao.stopSession();
            }
            this.dao = null;
        }
        try {
            if (this.ref != null) {
                this.ref.setStore(true);
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"exception occurred contacting callback bean", (Throwable)e);
            throw new EJBException("callback not notified");
        }
    }

    public void ejbLoad() {
        TestUtil.logTrace((String)"ejbLoad");
        this.ejbLoadFlag = true;
        try {
            if (null == this.dao) {
                TestUtil.logMsg((String)"Get DAO");
                this.dao = DAOFactory.getInstance().getCoffeeDAO();
            }
            TestUtil.logTrace((String)"Start DAO session...");
            this.dao.startSession();
            TestUtil.logTrace((String)"Load row...");
            this.cache = this.dao.load((Integer)this.ectx.getPrimaryKey());
        }
        catch (DAOException e) {
            TestUtil.logErr((String)("No such entity exists: " + e));
            throw new NoSuchEntityException("[ejbload] DAOException" + e);
        }
        catch (Exception e) {
            throw new EJBException("[ejbload] Unable to init DAO " + e);
        }
        finally {
            if (null != this.dao) {
                this.dao.stopSession();
            }
        }
        try {
            if (this.ref != null) {
                this.ref.setLoad(true);
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"exception occurred contacting callback bean", (Throwable)e);
            throw new EJBException("callback not notified");
        }
    }

    public Integer ejbFindTheBean(Properties p, Integer key) throws FinderException {
        TestUtil.logTrace((String)"ejbFindTheBean");
        try {
            if (null == this.dao) {
                TestUtil.logMsg((String)"Get DAO...");
                this.dao = DAOFactory.getInstance().getCoffeeDAO();
            }
            this.dao.startSession();
            if (this.dao.exists(key)) {
                Integer n = key;
                return n;
            }
            try {
                throw new FinderException("Key not found: " + key);
            }
            catch (DAOException de) {
                throw new FinderException("DAOException " + de);
            }
            catch (Exception e) {
                throw new FinderException("Exception occurred: " + e);
            }
        }
        finally {
            if (null != this.dao) {
                this.dao.stopSession();
            }
        }
    }

    public Integer ejbFindByPrimaryKey(Integer key) throws FinderException {
        TestUtil.logTrace((String)"ejbFindByPrimaryKey");
        try {
            if (null == this.dao) {
                TestUtil.logMsg((String)"Get DAO...");
                this.dao = DAOFactory.getInstance().getCoffeeDAO();
            }
            this.dao.startSession();
            if (this.dao.exists(key)) {
                Integer n = key;
                return n;
            }
            try {
                throw new FinderException("Key not found: " + key);
            }
            catch (DAOException de) {
                throw new FinderException("DAOException " + de);
            }
            catch (Exception e) {
                throw new FinderException("Exception occurred: " + e);
            }
        }
        finally {
            if (null != this.dao) {
                this.dao.stopSession();
            }
        }
    }

    public void ping() {
        TestUtil.logTrace((String)"ping");
    }

    public void throwEJBException() {
        TestUtil.logTrace((String)"throwEJBException");
        this.iAmDestroyed = true;
        throw new EJBException("throwing EJBException");
    }

    public void throwError() {
        TestUtil.logTrace((String)"throwError");
        this.iAmDestroyed = true;
        throw new Error("throwing Error");
    }

    public void reset() {
        this.ejbCreateFlag = false;
        this.ejbPostCreateFlag = false;
        this.ejbLoadFlag = false;
        this.ejbStoreFlag = false;
        this.createLifeCycleFlag = true;
    }

    public void setHelper(Helper r) {
        TestUtil.logTrace((String)"setHelper");
        this.ref = r;
    }

    public void loadOrStoreTest(Helper r) {
        TestUtil.logTrace((String)"loadOrStoreTest");
        try {
            r.setLoad(this.ejbLoadFlag);
            this.ref = r;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            TestUtil.logMsg((String)("Caught Exception: " + e));
            throw new EJBException(e.getMessage());
        }
    }

    public boolean iAmDestroyed() {
        return this.iAmDestroyed;
    }
}

