/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.interop.csiv2.common.validation;

import com.sun.ts.tests.interop.csiv2.common.parser.IORASContextEntry;
import com.sun.ts.tests.interop.csiv2.common.parser.IORSASContextEntry;
import com.sun.ts.tests.interop.csiv2.common.parser.IORTransportMechEntry;
import com.sun.ts.tests.interop.csiv2.common.parser.TLSTransEntry;
import com.sun.ts.tests.interop.csiv2.common.validation.IORValidationStrategy;
import com.sun.ts.tests.interop.csiv2.common.validation.ValidationException;
import java.util.Vector;

public class IOR0ValidationStrategy
extends IORValidationStrategy {
    private boolean nonzeroPort;

    public IOR0ValidationStrategy(boolean nonzeroPort) {
        this.nonzeroPort = nonzeroPort;
    }

    @Override
    public String getName() {
        return "IOR.0";
    }

    @Override
    public boolean verifyIIOPProfilePort(int port) {
        boolean result = false;
        boolean bl = result = !(port != 0 ^ this.nonzeroPort);
        if (!result) {
            this.log.logInfo("IIOPProfilePort : Expected : 0 : received : " + port);
        }
        return result;
    }

    @Override
    public boolean verifyTargetRequires(int targetRequires) {
        boolean result = false;
        boolean bl = result = targetRequires == 70;
        if (!result) {
            this.log.logInfo("TargetRequires : Expected : ( INTEGRITY  CONFIDENTIALITY  ESTABLISH_TRUST_IN_CLIENT ) : received : " + this.getTargetOptions(targetRequires));
        }
        return result;
    }

    @Override
    public boolean verifyIORTransportMech(IORTransportMechEntry iorTransportMech) throws ValidationException {
        boolean result = true;
        this.log.logInfo("Validating IORTransportMech...");
        TLSTransEntry tlsTrans = iorTransportMech.getTlsTrans();
        if (tlsTrans == null) {
            this.log.logMismatch("Expecting TLS transport.");
            result = false;
        } else {
            int targetSupports = tlsTrans.getTargetSupports();
            int targetRequires = tlsTrans.getTargetRequires();
            boolean bl = result = result && (targetSupports & 0x66) == 102;
            if (!result) {
                this.log.logInfo("TargetSupports : Expected : ( INTEGRITY  CONFIDENTIALITY  ESTABLISH_TRUST_IN_CLIENT  ESTABLISH_TRUST_IN_TARGET ) : received : " + this.getTargetOptions(targetSupports));
            }
            boolean bl2 = result = result && targetRequires == 70;
            if (!result) {
                this.log.logInfo("TargetRequires : Expected : ( INTEGRITY  CONFIDENTIALITY  ESTABLISH_TRUST_IN_CLIENT ) : received : " + this.getTargetOptions(targetRequires));
            }
            Vector transAddrs = tlsTrans.getTransAddrs();
            result = result && this.atLeastOneValidAddr(transAddrs);
        }
        this.log.logInfo("IORTransportMech " + (result ? "Valid." : "Invalid."));
        return result;
    }

    @Override
    public boolean verifyASContext(IORASContextEntry asContext) {
        boolean result = true;
        this.log.logInfo("Validating ASContext...");
        int targetSupports = asContext.getTargetSupports();
        boolean bl = result = result && targetSupports == 0;
        if (!result) {
            this.log.logInfo("TargetSupports : Expected : None : received : " + this.getTargetOptions(targetSupports));
        }
        this.log.logInfo("ASContext " + (result ? "Valid." : "Invalid."));
        return result;
    }

    @Override
    public boolean verifySASContext(IORSASContextEntry sasContext) {
        boolean result = true;
        this.log.logInfo("Validating SASContext...");
        int targetSupports = sasContext.getTargetSupports();
        Vector supportedNamingMechanisms = sasContext.getSupportedNamingMechanisms();
        int supportedIdentityTypes = sasContext.getSupportedIdentityTypes();
        boolean bl = result = result && targetSupports == 0;
        if (!result) {
            this.log.logInfo("TargetSupports : Expected : None : received : " + this.getTargetOptions(targetSupports));
        }
        boolean bl2 = result = result && supportedNamingMechanisms.size() == 0;
        if (!result) {
            this.log.logInfo("SupportedNamingMechanisms size : Expected : 0 : received : " + supportedNamingMechanisms.size());
        }
        boolean bl3 = result = result && supportedIdentityTypes == 0;
        if (!result) {
            this.log.logInfo("SupportedIdentityTypes : Expected : ITTAbsent : " + this.getSupportedIdentityTypes(supportedIdentityTypes));
        }
        this.log.logInfo("SASContext " + (result ? "Valid." : "Invalid."));
        return result;
    }
}

